/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class ShowBizBillHelper {
    public static void showForms(Map<String, Set<Object>> map, IFormView view, Map<String, String> entityId2BillnoMap) {
        if (map == null || map.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CostRecordListPlugin_1", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
        for (Map.Entry<String, Set<Object>> entry : map.entrySet()) {
            String entity = entry.getKey();
            Set<Object> ids = entry.getValue();
            if (ids == null || ids.isEmpty()) {
                map.remove(entity);
                continue;
            }
            OrmInput input = new OrmInput(ShowBizBillHelper.class.getName(), entity, "id,'" + entity + "' as entity", new QFilter("id", "in", ids).toArray());
            inputs.add(input);
        }
        if (inputs.isEmpty()) {
            return;
        }
        DataSet ds = Algo.create((String)ShowBizBillHelper.class.getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        HashMap<String, Set> existIdMap = new HashMap<String, Set>(16);
        for (Row row : ds) {
            Object id = row.get("id");
            String entity = row.getString("entity");
            entityId2BillnoMap.remove(entity + "#" + id);
            Set existIds = existIdMap.computeIfAbsent(entity, k -> new HashSet(16));
            existIds.add(id);
        }
        for (Map.Entry entry : existIdMap.entrySet()) {
            String entity = (String)entry.getKey();
            Set ids = (Set)entry.getValue();
            if (ids.size() == 1) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setPkId(ids.iterator().next());
                showParameter.setFormId(entity);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                view.showForm((FormShowParameter)showParameter);
                continue;
            }
            if (ids.size() <= 1) continue;
            ListShowParameter listParameter = new ListShowParameter();
            listParameter.setBillFormId(entity);
            listParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            QFilter listQ = new QFilter("id", "in", (Object)ids);
            listParameter.getListFilterParameter().setFilter(listQ);
            for (Object id : ids) {
                listParameter.addLinkQueryPkId(id);
            }
            listParameter.setShowFilter(false);
            listParameter.setShowQuickFilter(false);
            view.showForm((FormShowParameter)listParameter);
        }
        if (!entityId2BillnoMap.isEmpty()) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"ShowBizBillHelper_1", (String)"fi-cal-common", (Object[])new Object[0]), String.join((CharSequence)",", entityId2BillnoMap.values())));
        }
    }
}

