/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class StandardCostHelper {
    private static final Log logger = LogFactory.getLog(StandardCostHelper.class);

    public DataSet getStandardCost(Map<String, List<Map<String, Object>>> paramsMap, boolean isCheck) {
        RowMeta rowMeta = null;
        rowMeta = isCheck ? new RowMeta(new Field[]{new Field("entryid", (DataType)DateType.LongType), new Field("costtype", (DataType)DateType.LongType), new Field("material", (DataType)DateType.LongType), new Field("effectdate", (DataType)DateType.TimestampType), new Field("expdate", (DataType)DateType.TimestampType)}) : new RowMeta(new Field[]{new Field("entryid", (DataType)DateType.LongType), new Field("costtype", (DataType)DateType.LongType), new Field("material", (DataType)DateType.LongType), new Field("effectdate", (DataType)DateType.TimestampType), new Field("expdate", (DataType)DateType.TimestampType), new Field("id", (DataType)DateType.LongType), new Field("standardprice", (DataType)DateType.BigDecimalType), new Field("element", (DataType)DateType.LongType), new Field("subelement", (DataType)DateType.LongType)});
        if (null == paramsMap || paramsMap.size() == 0) {
            DataSet emptyDs = Algo.create((String)this.getClass().getName()).createDataSet(new ArrayList(16), rowMeta);
            return emptyDs;
        }
        DataSetBuilder standardCostDataSetBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        int partitionSize = CalDbParamServiceHelper.getInteger(CalDbParamConstant.COMMON_SPLITBATCHNUM);
        for (Map.Entry<String, List<Map<String, Object>>> params : paramsMap.entrySet()) {
            String paramkey = params.getKey();
            if (StringUtils.isEmpty((String)paramkey)) continue;
            String[] keySplits = paramkey.split("_");
            Long calorgId = Long.parseLong(keySplits[0]);
            Long costAccountId = Long.parseLong(keySplits[1]);
            List<Map<String, Object>> param = params.getValue();
            if (null == param || param.isEmpty()) continue;
            Lists.partition(param, (int)partitionSize).forEach(list -> {
                Map resultsMap = null;
                try {
                    resultsMap = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"MatCostInfoPriceService", (String)"getMatCost", (Object[])new Object[]{list, calorgId, costAccountId, "1", "cal"});
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
                if (resultsMap != null && resultsMap.size() > 0) {
                    for (Map.Entry results : resultsMap.entrySet()) {
                        Long entryid = Long.parseLong((String)results.getKey());
                        List resultList = (List)results.getValue();
                        if (resultList == null || resultList.isEmpty()) continue;
                        for (Map result : resultList) {
                            long costtype = Long.parseLong(String.valueOf(result.get("costtype")));
                            long material = Long.parseLong(String.valueOf(result.get("material")));
                            Date effectdate = (Date)result.get("effectdate");
                            Date expdate = (Date)result.get("expdate");
                            if (isCheck) {
                                standardCostDataSetBuilder.append(new Object[]{entryid, costtype, material, effectdate, expdate});
                                continue;
                            }
                            BigDecimal standardcost = (BigDecimal)result.get("standardcost");
                            long matcostinfoid = Long.parseLong(String.valueOf(result.get("matcostinfoid")));
                            long element = Long.parseLong(String.valueOf(result.get("element")));
                            long subelement = Long.parseLong(String.valueOf(result.get("subelement")));
                            standardCostDataSetBuilder.append(new Object[]{entryid, costtype, material, effectdate, expdate, matcostinfoid, standardcost, element, subelement});
                        }
                    }
                }
            });
        }
        DataSet standardCostDataSet = standardCostDataSetBuilder.build();
        return standardCostDataSet;
    }

    public static Set<String> getCalDimensionSet(String caldimensionFields) {
        HashSet<String> calDimensionSet = new HashSet<String>(16);
        if (!StringUtils.isEmpty((String)caldimensionFields)) {
            String[] caldimensions;
            for (String caldimension : caldimensions = caldimensionFields.split(",")) {
                if (StringUtils.isEmpty((String)caldimension)) continue;
                calDimensionSet.add(caldimension);
            }
        }
        return calDimensionSet;
    }
}

