/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.model.SynBillErrInfo;
import kd.fi.cal.common.util.CommonUtils;

public class StopSyncBizBillHelper {
    private static final Log logger = LogFactory.getLog(StopSyncBizBillHelper.class);
    private Map<Long, Long> invOrg2SettingIds = null;
    private Map<Long, Map<Date, Long>> invOrg2BookDate2SettingIdMaps = null;
    private Map<Long, String> setting2failbill_tagMap = null;

    public StopSyncBizBillHelper() {
    }

    public StopSyncBizBillHelper(String stopType) {
        if ("inv".equals(stopType)) {
            this.init4InvStop();
        }
    }

    private void init4InvStop() {
        this.invOrg2SettingIds = new HashMap<Long, Long>(16);
        this.invOrg2BookDate2SettingIdMaps = new HashMap<Long, Map<Date, Long>>(16);
        this.setting2failbill_tagMap = new HashMap<Long, String>(16);
        QFilter filter = new QFilter("stoptype", "=", (Object)"inv");
        filter.and("isfinish", "=", (Object)"0");
        try (DataSet invDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stopsyncbillset", (String)"id,storageorgunit,bookdate,failbill_tag", (QFilter[])filter.toArray(), null);){
            for (Row row : invDS) {
                Long settingid = row.getLong("id");
                Long storageorgunitid = row.getLong("storageorgunit");
                Date bookDate = row.getDate("bookdate");
                String failbill_tag = row.getString("failbill_tag");
                if (bookDate == null) {
                    this.invOrg2SettingIds.put(storageorgunitid, settingid);
                } else {
                    HashMap<Date, Long> map = new HashMap<Date, Long>(4);
                    map.put(bookDate, settingid);
                    this.invOrg2BookDate2SettingIdMaps.put(storageorgunitid, map);
                }
                this.setting2failbill_tagMap.put(settingid, failbill_tag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, SynBillErrInfo> doStop(Set<Long> bizBillIds, Set<Long> calOrgIds) {
        DataSet settingDataSet = null;
        DataSet costRecordDataSet = null;
        Map<Long, Set<Long>> settingIdBizBillIdMap = null;
        try {
            settingDataSet = this.getStopSyncBizBillSetting(calOrgIds);
            costRecordDataSet = this.getCostRecord(bizBillIds);
            settingIdBizBillIdMap = this.joinSettingDatasSet(settingDataSet, costRecordDataSet);
        }
        finally {
            if (settingDataSet != null) {
                settingDataSet.close();
            }
            if (costRecordDataSet != null) {
                costRecordDataSet.close();
            }
        }
        Map<Long, SynBillErrInfo> stopBizBillMap = new HashMap<Long, SynBillErrInfo>(16);
        if (settingIdBizBillIdMap != null && !settingIdBizBillIdMap.isEmpty()) {
            this.stopSyncBizBill(settingIdBizBillIdMap);
            stopBizBillMap = this.getStopBizBillIdMap(settingIdBizBillIdMap);
        }
        return stopBizBillMap;
    }

    public Map<Long, SynBillErrInfo> doStopSync(Map<Long, Set<DynamicObject>> costRecordMap) {
        long currtime = System.currentTimeMillis();
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashSet<Long> calOrgIds = new HashSet<Long>(16);
        if (costRecordMap != null && !costRecordMap.isEmpty()) {
            for (Map.Entry<Long, Set<DynamicObject>> entryMap : costRecordMap.entrySet()) {
                Long bizBillId = entryMap.getKey();
                bizBillIds.add(bizBillId);
                Set<DynamicObject> infos = entryMap.getValue();
                if (infos == null || infos.isEmpty()) continue;
                for (DynamicObject info : infos) {
                    Long orgId = info.getLong("calorg_id");
                    if (orgId == null) continue;
                    calOrgIds.add(orgId);
                }
            }
        }
        if (!bizBillIds.isEmpty()) {
            return this.doStop(bizBillIds, calOrgIds);
        }
        logger.info("StopSyncBizBillHelper-doStopSync-\u505c\u6b62\u5355\u636e\u5904\u7406\uff1a" + (currtime - System.currentTimeMillis()));
        return null;
    }

    public Map<Long, SynBillErrInfo> getStopSynMap4InitCal(DynamicObject[] billarr, boolean isAudit) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("bizbillid", (DataType)DateType.LongType), new Field("calorg", (DataType)DateType.LongType), new Field("storageorgunit", (DataType)DateType.LongType), new Field("bookdate", (DataType)DateType.TimestampType), new Field("accounttype", (DataType)DateType.StringType), new Field("warehouse", (DataType)DateType.LongType), new Field("material", (DataType)DateType.LongType)});
        DataSetBuilder initCalDataSetBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        HashSet<Long> calorgSet = new HashSet<Long>(16);
        for (DynamicObject bill : billarr) {
            long calOrgId = isAudit ? bill.getLong("calorg") : bill.getLong("calorg_id");
            long bizbillid = bill.getLong("bizbillid");
            calorgSet.add(calOrgId);
            Date bookDate = bill.getDate("bookdate");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                long storageorgunit = entry.getLong("storageorgunit_id");
                String accounttype = entry.getString("accounttype");
                long warehouse = entry.getLong("warehouse_id");
                long material = entry.getLong("material_id");
                initCalDataSetBuilder.append(new Object[]{bizbillid, calOrgId, storageorgunit, bookDate, accounttype, warehouse, material});
            }
        }
        StopSyncBizBillHelper stopSyncHelper = new StopSyncBizBillHelper();
        return stopSyncHelper.doStop4InitCal(calorgSet, initCalDataSetBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, SynBillErrInfo> doStop4InitCal(Set<Long> calOrgIds, DataSet initCalDataSet) {
        DataSet settingDataSet = null;
        Map<Long, Set<Long>> settingIdBizBillIdMap = null;
        try {
            settingDataSet = this.getStopSyncBizBillSetting(calOrgIds);
            settingIdBizBillIdMap = this.joinSettingDatasSet(settingDataSet, initCalDataSet);
        }
        finally {
            if (settingDataSet != null) {
                settingDataSet.close();
            }
            if (initCalDataSet != null) {
                initCalDataSet.close();
            }
        }
        Map<Long, SynBillErrInfo> stopBizBillMap = new HashMap<Long, SynBillErrInfo>(16);
        if (settingIdBizBillIdMap != null && !settingIdBizBillIdMap.isEmpty()) {
            this.stopSyncBizBill(settingIdBizBillIdMap);
            stopBizBillMap = this.getStopBizBillIdMap(settingIdBizBillIdMap);
        }
        return stopBizBillMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, SynBillErrInfo> doStop(DynamicObject[] costRecordSet) {
        if (costRecordSet == null || costRecordSet.length == 0) {
            return null;
        }
        Set<Long> calOrgSet = this.getAllCalOrgIds(costRecordSet);
        DataSet costRecordDS = null;
        DataSet settingDataSet = null;
        Map<Long, Set<Long>> settingIdBizBillIdMap = null;
        try {
            costRecordDS = this.buildCostRecordDS(costRecordSet);
            settingDataSet = this.getStopSyncBizBillSetting(calOrgSet);
            settingIdBizBillIdMap = this.joinSettingDatasSet(settingDataSet, costRecordDS);
        }
        finally {
            if (costRecordDS != null) {
                costRecordDS.close();
            }
            if (settingDataSet != null) {
                settingDataSet.close();
            }
        }
        Map<Long, SynBillErrInfo> stopBizBillMap = new HashMap<Long, SynBillErrInfo>(16);
        if (settingIdBizBillIdMap != null && !settingIdBizBillIdMap.isEmpty()) {
            this.stopSyncBizBill(settingIdBizBillIdMap);
            stopBizBillMap = this.getStopBizBillIdMap(settingIdBizBillIdMap);
        }
        return stopBizBillMap;
    }

    private DataSet buildCostRecordDS(DynamicObject[] costRecordSet) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("bizbillid", (DataType)DateType.LongType), new Field("calorg", (DataType)DateType.LongType), new Field("storageorgunit", (DataType)DateType.LongType), new Field("bookdate", (DataType)DateType.TimestampType), new Field("accounttype", (DataType)DateType.StringType), new Field("warehouse", (DataType)DateType.LongType), new Field("material", (DataType)DateType.LongType)});
        DataSetBuilder costRecordDsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        for (DynamicObject info : costRecordSet) {
            Long bizbillid = info.getLong("bizbillid");
            Long calOrgId = info.getLong("calorg_id");
            Long storageorgunit = info.getLong("storageorgunit_id");
            Date bookDate = info.getDate("bookdate");
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : entry) {
                String accounttype = dynamicObject.getString("accounttype");
                Long warehouse = dynamicObject.getLong("warehouse_id");
                Long material = dynamicObject.getLong("material_id");
                costRecordDsBuilder.append(new Object[]{bizbillid, calOrgId, storageorgunit, bookDate, accounttype, warehouse, material});
            }
        }
        DataSet dataSet = costRecordDsBuilder.build().groupBy(new String[]{"bizbillid", "calorg", "storageorgunit", "accounttype", "warehouse", "material", "bookdate"}).finish();
        return dataSet;
    }

    private Set<Long> getAllCalOrgIds(DynamicObject[] costRecordSet) {
        HashSet<Long> calOrgIds = new HashSet<Long>(16);
        for (DynamicObject info : costRecordSet) {
            calOrgIds.add(info.getLong("calorg_id"));
        }
        return calOrgIds;
    }

    private Map<Long, SynBillErrInfo> getStopBizBillIdMap(Map<Long, Set<Long>> settingIdBizBillIdMap) {
        HashMap<Long, SynBillErrInfo> stopBizBillMap = new HashMap<Long, SynBillErrInfo>(16);
        String msg = ResManager.loadKDString((String)"\u540c\u6b65\u5355\u636e\u670d\u52a1\u5df2\u505c\u6b62\u3002", (String)"StopSyncBizBillHelper_0", (String)"fi-cal-common", (Object[])new Object[0]);
        for (Set<Long> bizBillIds : settingIdBizBillIdMap.values()) {
            for (Long bizBillId : bizBillIds) {
                stopBizBillMap.put(bizBillId, new SynBillErrInfo("4", msg));
            }
        }
        return stopBizBillMap;
    }

    private void stopSyncBizBill(Map<Long, Set<Long>> settingIdBizBillIdMap) {
        if (settingIdBizBillIdMap.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
            for (Map.Entry<Long, Set<Long>> longSetEntry : settingIdBizBillIdMap.entrySet()) {
                Long settingid = longSetEntry.getKey();
                Set<Long> failBillIds = longSetEntry.getValue();
                StringBuilder failtag = new StringBuilder();
                for (Long failBillId : failBillIds) {
                    failtag.append(",");
                    failtag.append(failBillId);
                }
                updateList.add(new Object[]{failtag.toString(), failtag.toString(), settingid});
            }
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"UPDATE T_CAL_STOPSYNCSET SET FFAILBILL_TAG = CASE WHEN FFAILBILL_TAG IS NULL THEN ? ELSE CONCAT(FFAILBILL_TAG,?) END WHERE FID = ?", updateList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Set<Long>> joinSettingDatasSet(DataSet settingDataSet, DataSet costRecordDataSet) {
        HashMap<Long, Set<Long>> settingIdBizBillIdMap = new HashMap<Long, Set<Long>>(16);
        try (DataSet dataSet = null;){
            dataSet = costRecordDataSet.join(settingDataSet, JoinType.INNER).on("calorg", "calorg").select(new String[]{"bizbillid", "storageorgunit", "accounttype", "warehouse", "material", "bookdate"}, new String[]{"settingid"}).finish();
            dataSet = dataSet.join(settingDataSet.where("storageorgunit<>0"), JoinType.INNER).on("settingid", "settingid").on("storageorgunit", "storageorgunit").select(new String[]{"bizbillid", "settingid", "accounttype", "warehouse", "material", "bookdate"}, null).finish().union(dataSet.join(settingDataSet.where("storageorgunit==0"), JoinType.INNER).on("settingid", "settingid").select(new String[]{"bizbillid", "settingid", "accounttype", "warehouse", "material", "bookdate"}, null).finish());
            dataSet = dataSet.join(settingDataSet.where("bookdate<>null"), JoinType.INNER).on("settingid", "settingid").select(new String[]{"bizbillid", "settingid", "accounttype", "warehouse", "material", "bookdate as billbizdate"}, new String[]{"bookdate"}).finish().where("billbizdate >= bookdate").select("bizbillid,settingid,accounttype,warehouse,material").union(dataSet.join(settingDataSet.where("bookdate==null"), JoinType.INNER).on("settingid", "settingid").select(new String[]{"bizbillid", "settingid", "accounttype", "warehouse", "material"}, null).finish());
            dataSet = dataSet.join(settingDataSet.where("accounttype<>'' and accounttype<>' '"), JoinType.INNER).on("settingid", "settingid").on("accounttype", "accounttype").select(new String[]{"bizbillid", "settingid", "warehouse", "material"}, null).finish().union(dataSet.join(settingDataSet.where("accounttype=='' or accounttype==' '"), JoinType.INNER).on("settingid", "settingid").select(new String[]{"bizbillid", "settingid", "warehouse", "material"}, null).finish());
            dataSet = dataSet.join(settingDataSet.where("warehouse<>0"), JoinType.INNER).on("settingid", "settingid").on("warehouse", "warehouse").select(new String[]{"bizbillid", "settingid", "material"}, null).finish().union(dataSet.join(settingDataSet.where("warehouse==0"), JoinType.INNER).on("settingid", "settingid").select(new String[]{"bizbillid", "settingid", "material"}, null).finish());
            dataSet = dataSet.join(settingDataSet.where("material<>0"), JoinType.INNER).on("settingid", "settingid").on("material", "material").select(new String[]{"bizbillid", "settingid"}, null).finish().union(dataSet.join(settingDataSet.where("material==0"), JoinType.INNER).on("settingid", "settingid").select(new String[]{"bizbillid", "settingid"}, null).finish());
            dataSet = dataSet.groupBy(new String[]{"bizbillid", "settingid"}).finish();
            for (Row row : dataSet) {
                Long bizbillid = row.getLong("bizbillid");
                Long settingid = row.getLong("settingid");
                HashSet<Long> bizbillIds = (HashSet<Long>)settingIdBizBillIdMap.get(settingid);
                if (bizbillIds == null) {
                    bizbillIds = new HashSet<Long>(16);
                    settingIdBizBillIdMap.put(settingid, bizbillIds);
                }
                bizbillIds.add(bizbillid);
            }
        }
        return settingIdBizBillIdMap;
    }

    private DataSet getCostRecord(Set<Long> bizBillIds) {
        QFilter q = new QFilter("bizbillid", "in", bizBillIds);
        new CalGroupAccountHelper().addNotGroupAcctFilter4Bill(q);
        DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"bizbillid,calorg,storageorgunit,bookdate,entry.accounttype as accounttype,entry.warehouse as warehouse,entry.material as material", (QFilter[])q.toArray(), null);
        costRecordDataSet = costRecordDataSet.groupBy(new String[]{"bizbillid", "calorg", "storageorgunit", "accounttype", "warehouse", "material", "bookdate"}).finish();
        return costRecordDataSet;
    }

    private DataSet getStopSyncBizBillSetting(Set<Long> calOrgIds) {
        QFilter q = new QFilter("isfinish", "=", (Object)"0");
        q.and("stoptype", "=", (Object)"cal");
        if (calOrgIds != null && !calOrgIds.isEmpty()) {
            q.and("calorg", "in", calOrgIds);
        }
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stopsyncbillset", (String)"id as settingid,calorg,storageorgunit,accounttype,warehouse,material,bookdate", (QFilter[])q.toArray(), null);
    }

    public DynamicObject[] doStop4Inv(String actionName, Map params, DynamicObject[] infos, String serviceType) {
        if (infos == null || infos.length == 0) {
            return infos;
        }
        if (!(ActionEnum.AUDIT.getValue().equals(actionName) || ActionEnum.UN_AUDIT.getValue().equals(actionName) || ActionEnum.SUBMIT.getValue().equals(actionName) || ActionEnum.UN_SUBMIT.getValue().equals(actionName))) {
            return infos;
        }
        if (this.invOrg2SettingIds == null || this.invOrg2BookDate2SettingIdMaps == null) {
            this.init4InvStop();
        }
        if (this.invOrg2SettingIds.isEmpty() && this.invOrg2BookDate2SettingIdMaps.isEmpty()) {
            return infos;
        }
        return this.getValidateBizBill4Inv(params, infos, serviceType, actionName);
    }

    private DynamicObject[] getValidateBizBill4Inv(Map params, DynamicObject[] infos, String serviceType, String actionName) {
        TXHandle h;
        String paramMap = SerializationUtils.toJsonString((Object)params);
        HashMap<Long, DynamicObject> id2BizbillMap = new HashMap<Long, DynamicObject>(infos.length);
        HashSet<Long> bizbillids = new HashSet<Long>(infos.length);
        String bizentityobject = infos[0].getDataEntityType().getName();
        HashMap<Long, HashSet<String>> settingid2Bizbillids = new HashMap<Long, HashSet<String>>(16);
        for (DynamicObject info : infos) {
            Long bizBillid = info.getLong("id");
            bizbillids.add(bizBillid);
            id2BizbillMap.put(bizBillid, info);
        }
        DynamicObjectCollection records = this.getBillInfos(bizbillids, bizentityobject, actionName);
        HashSet<DynamicObject> newServiceLogs = new HashSet<DynamicObject>(16);
        HashSet<DynamicObject> saveServiceLogs = new HashSet<DynamicObject>(16);
        HashSet<Long> existLogBizbillids = new HashSet<Long>(16);
        for (DynamicObject record : records) {
            existLogBizbillids.add(record.getLong("bizbillid"));
        }
        QFilter f = new QFilter("bizbillid", "in", existLogBizbillids);
        f.and("actionname", "=", (Object)actionName);
        String selectProperties = "id,actionname,parammap_tag,parammap,success,exetime,bizentityobject,bizbillid,bizbillnumber,org,log,log_tag,servicetype,isclose,closereason";
        DynamicObject[] logs = null;
        logs = ActionEnum.AUDIT.getValue().equals(actionName) || ActionEnum.UN_AUDIT.getValue().equals(actionName) ? BusinessDataServiceHelper.load((String)"cal_businesslog", (String)selectProperties, (QFilter[])new QFilter[]{f}) : BusinessDataServiceHelper.load((String)"cal_syncbizbillrecord", (String)selectProperties, (QFilter[])new QFilter[]{f});
        HashMap<Long, Object> logMap = new HashMap<Long, Object>(logs.length);
        if (logs != null && logs.length > 0) {
            for (DynamicObject log : logs) {
                logMap.put(log.getLong("bizbillid"), log);
            }
        }
        existLogBizbillids.clear();
        for (DynamicObject record : records) {
            Map<Date, Long> map;
            boolean isFail = false;
            Long bizbillid = record.getLong("bizbillid");
            Date bookDate = record.getDate("bookdate");
            Long invorg = record.getLong("storageorgunit");
            Long settingId = this.invOrg2SettingIds.get(invorg);
            if (settingId != null) {
                isFail = true;
                id2BizbillMap.remove(bizbillid);
                HashSet<String> failbillids = (HashSet<String>)settingid2Bizbillids.get(settingId);
                if (failbillids == null) {
                    failbillids = new HashSet<String>(16);
                    settingid2Bizbillids.put(settingId, failbillids);
                }
                failbillids.add(bizbillid.toString());
            }
            if ((map = this.invOrg2BookDate2SettingIdMaps.get(invorg)) != null) {
                for (Map.Entry<Date, Long> dateLongEntry : map.entrySet()) {
                    Date date = dateLongEntry.getKey();
                    settingId = dateLongEntry.getValue();
                    if (date.compareTo(bookDate) > 0) continue;
                    isFail = true;
                    id2BizbillMap.remove(bizbillid);
                    HashSet<String> failbillids = (HashSet<String>)settingid2Bizbillids.get(settingId);
                    if (failbillids == null) {
                        failbillids = new HashSet<String>(16);
                        settingid2Bizbillids.put(settingId, failbillids);
                    }
                    failbillids.add(bizbillid.toString());
                }
            }
            if (!isFail || !existLogBizbillids.add(bizbillid)) continue;
            DynamicObject logInfo = (DynamicObject)logMap.get(bizbillid);
            if (logInfo != null) {
                saveServiceLogs.add(this.updateFailServiceLog(paramMap, actionName, serviceType, bizentityobject, record, logInfo));
                continue;
            }
            newServiceLogs.add(this.createFailServiceLog(paramMap, actionName, serviceType, bizentityobject, record));
        }
        if (!newServiceLogs.isEmpty()) {
            try {
                h = TX.required();
                Throwable throwable = null;
                try {
                    SaveServiceHelper.save((DynamicObject[])newServiceLogs.toArray(new DynamicObject[0]));
                }
                catch (Throwable isFail) {
                    throwable = isFail;
                    throw isFail;
                }
                finally {
                    if (h != null) {
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable isFail) {
                                throwable.addSuppressed(isFail);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("StopSyncBizBillHelper getValidateBizBill4Inv", (Throwable)e);
            }
        }
        if (!saveServiceLogs.isEmpty()) {
            h = TX.required();
            Throwable throwable = null;
            try {
                SaveServiceHelper.save((DynamicObject[])saveServiceLogs.toArray(new DynamicObject[0]));
            }
            catch (Throwable isFail) {
                throwable = isFail;
                throw isFail;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable isFail) {
                            throwable.addSuppressed(isFail);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        if (!settingid2Bizbillids.isEmpty()) {
            ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
            for (Map.Entry longSetEntry : settingid2Bizbillids.entrySet()) {
                Long settingid = (Long)longSetEntry.getKey();
                Set failBillIds = (Set)longSetEntry.getValue();
                String failtag = "," + String.join((CharSequence)",", failBillIds);
                updateList.add(new Object[]{failtag, failtag, settingid});
            }
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"UPDATE T_CAL_STOPSYNCSET SET FFAILBILL_TAG = CASE WHEN FFAILBILL_TAG IS NULL THEN ? ELSE CONCAT(FFAILBILL_TAG,?) END WHERE FID = ?", updateList);
        }
        return id2BizbillMap.values().toArray(new DynamicObject[0]);
    }

    private DynamicObject updateFailServiceLog(String paramMap, String actionName, String serviceType, String bizentityobject, DynamicObject record, DynamicObject log) {
        log.set("servicetype", (Object)serviceType);
        log.set("actionname", (Object)actionName);
        log.set("parammap_tag", (Object)paramMap);
        log.set("parammap", (Object)paramMap);
        log.set("success", (Object)"4");
        log.set("exetime", (Object)new Date());
        log.set("bizentityobject", (Object)bizentityobject);
        log.set("bizbillid", record.get("bizbillid"));
        log.set("bizbillnumber", record.get("billnumber"));
        log.set("org", record.get("storageorgunit"));
        String msg = ResManager.loadKDString((String)"\u540c\u6b65\u5355\u636e\u670d\u52a1\u5df2\u505c\u6b62\u3002", (String)"StopSyncBizBillHelper_0", (String)"fi-cal-common", (Object[])new Object[0]);
        log.set("log", (Object)msg);
        log.set("log_tag", (Object)msg);
        log.set("isclose", (Object)Character.valueOf('0'));
        log.set("closereason", null);
        return log;
    }

    private DynamicObjectCollection getBillInfos(Set<Long> bizbillids, String bizentityobject, String actionName) {
        IDataEntityProperty bookDate;
        MainEntityType type;
        String mainOrgName;
        if (ActionEnum.UN_AUDIT.getValue().equals(actionName)) {
            QFilter filter = new QFilter("bizbillid", "in", bizbillids);
            filter.and("bizentityobject", "=", (Object)bizentityobject);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_costrecord", (String)"bizbillid,bookdate,billnumber,storageorgunit", (QFilter[])filter.toArray(), null);
            if (coll != null && !coll.isEmpty()) {
                return coll;
            }
        }
        if (StringUtils.isEmpty((String)(mainOrgName = (type = MetadataServiceHelper.getDataEntityType((String)bizentityobject)).getMainOrg()))) {
            mainOrgName = "org";
        }
        String bookDateField = null;
        QFilter filter = new QFilter("sourcebill", "=", (Object)bizentityobject);
        filter.and("enable", "=", (Object)Boolean.TRUE);
        filter.and("fieldmap.calfield", "=", (Object)"bookdate");
        DynamicObject calBillSyncSetting = QueryServiceHelper.queryOne((String)"cal_calbillrule", (String)"fieldmap.sourcefield", (QFilter[])filter.toArray());
        if (calBillSyncSetting != null) {
            bookDateField = calBillSyncSetting.getString("fieldmap.sourcefield");
        }
        if (StringUtils.isEmpty(bookDateField) && (bookDate = type.findProperty("bookdate")) != null) {
            bookDateField = "bookdate";
        }
        String selectFields = "id as bizbillid,billno  as billnumber," + mainOrgName + " as storageorgunit," + bookDateField + " as bookdate";
        QFilter billFilter = new QFilter("id", "in", bizbillids);
        return QueryServiceHelper.query((String)bizentityobject, (String)selectFields, (QFilter[])billFilter.toArray(), null);
    }

    private DynamicObject createFailServiceLog(String paramMap, String actionName, String serviceType, String bizentityobject, DynamicObject record) {
        DynamicObject log = null;
        log = ActionEnum.AUDIT.getValue().equals(actionName) || ActionEnum.UN_AUDIT.getValue().equals(actionName) ? BusinessDataServiceHelper.newDynamicObject((String)"cal_businesslog") : BusinessDataServiceHelper.newDynamicObject((String)"cal_syncbizbillrecord");
        log.set("servicetype", (Object)serviceType);
        log.set("actionname", (Object)actionName);
        log.set("parammap_tag", (Object)paramMap);
        log.set("parammap", (Object)paramMap);
        log.set("success", (Object)"4");
        log.set("exetime", (Object)new Date());
        log.set("bookdate", record.get("bookdate"));
        log.set("bizentityobject", (Object)bizentityobject);
        log.set("bizbillid", record.get("bizbillid"));
        log.set("bizbillnumber", record.get("billnumber"));
        log.set("org", record.get("storageorgunit"));
        String msg = ResManager.loadKDString((String)"\u540c\u6b65\u5355\u636e\u670d\u52a1\u5df2\u505c\u6b62\u3002", (String)"StopSyncBizBillHelper_0", (String)"fi-cal-common", (Object[])new Object[0]);
        log.set("log", (Object)msg);
        log.set("log_tag", (Object)msg);
        return log;
    }
}

