/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.log.CalLogUtils;
import kd.fi.cal.common.util.CommonUtils;

public class StopSyncSettingModifyHelper {
    private static final Log logger = LogFactory.getLog(StopSyncSettingModifyHelper.class);
    public static final int BATCH_SIZE = 7000;
    private static final String settingStopOpSql = "update t_cal_stopsyncset set fisfinish = ?,fstoperid=?,fstoptime = ?, fstarterid = ?,fstarttime =?,ffailbill_tag=? where fid = ?";
    private static final String settingStartOpSql = "update t_cal_stopsyncset set fisfinish = ?, fstarterid = ?,fstarttime =?,ffailbill_tag=? where fid = ?";
    private Set<String> currentSettingStr = new HashSet<String>();
    private Map<String, Object> currentSettingIdMap = new HashMap<String, Object>();
    private Map<String, String> finishMap = new HashMap<String, String>();
    private Set<String> newSettingStr = new HashSet<String>();
    private Map<String, Object> materialMap = new HashMap<String, Object>();
    private Map<String, Object> calOrgMap = new HashMap<String, Object>();
    private Set<Long> calOrgSet = null;
    private Long storageorgunit = null;
    private String accountType = null;
    private Long warehouse = null;
    private Set<Long> materialIdSet = null;
    private Date bookDate = null;

    public void modifySetting(Set<Long> calOrgSet, Long storageorgunit, String accountType, Long warehouse, Set<Long> materialIdSet, Date bookDate, boolean isstopsync, Date nowTime) {
        this.calOrgSet = calOrgSet;
        this.accountType = accountType;
        this.storageorgunit = storageorgunit;
        this.warehouse = warehouse;
        this.materialIdSet = materialIdSet;
        this.bookDate = bookDate;
        if (calOrgSet == null || calOrgSet.isEmpty()) {
            return;
        }
        if (isstopsync) {
            this.getCurrentSetting();
            this.getNewSetting(calOrgSet, storageorgunit, accountType, warehouse, materialIdSet, bookDate);
            this.stopSynceService(nowTime);
        } else {
            this.canStartSyncService();
            this.startSyncService();
        }
    }

    public void modifySetting(Set<Long> calOrgSet, Long storageorgunit, String accountType, Long warehouse, Set<Long> materialIdSet, boolean isstopsync, Date nowTime) {
        this.modifySetting(calOrgSet, storageorgunit, accountType, warehouse, materialIdSet, null, isstopsync, nowTime);
    }

    public Map<String, Set<String>> startSyncServiceOp(Set<Object> settingIds) {
        HashMap<String, Set<String>> stopTypeReExeBillIdsMap = new HashMap<String, Set<String>>(16);
        String userId = RequestContext.get().getUserId();
        if (settingIds.isEmpty()) {
            return stopTypeReExeBillIdsMap;
        }
        DynamicObjectCollection modifySets = QueryServiceHelper.query((String)"cal_stopsyncbillset", (String)"stoptype,starter.name,bookdate,calorg.name,storageorgunit.name,warehouse.name,accounttype,material.name,failbill_tag", (QFilter[])new QFilter("id", "in", settingIds).toArray());
        this.addLogs(modifySets, false);
        for (DynamicObject dynamicObject : modifySets) {
            String failbillids = dynamicObject.getString("failbill_tag");
            Set set = stopTypeReExeBillIdsMap.computeIfAbsent(dynamicObject.getString("stoptype"), k -> new HashSet(16));
            if (!StringUtils.isNotEmpty((String)failbillids)) continue;
            set.addAll(Arrays.asList(failbillids.split(",")));
        }
        String startSql = "update t_cal_stopsyncset set fisfinish = '1', ffailbill_tag = null,fstarterid = " + userId + ",fstarttime =? where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        for (Object e : settingIds) {
            paramList.add(new Object[]{TimeServiceHelper.now(), e});
        }
        Throwable throwable = null;
        try (TXHandle handler = TX.requiresNew();){
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)startSql, paramList);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        return stopTypeReExeBillIdsMap;
    }

    public void stopSyncServiceOp(Set<Object> needFinishSettingIds) {
        if (needFinishSettingIds.isEmpty()) {
            return;
        }
        DynamicObject[] needModifySettings = null;
        HashSet<Object> stopSetIds = new HashSet<Object>(16);
        QFilter q = new QFilter("id", "in", needFinishSettingIds);
        needModifySettings = BusinessDataServiceHelper.load((String)"cal_stopsyncbillset", (String)"id,stoptime,stoper,starter,starttime,isfinish,failbill_tag", (QFilter[])q.toArray());
        if (needModifySettings != null) {
            ArrayList list = new ArrayList(10);
            ArrayList<Object> subList = null;
            for (DynamicObject dynamicObject : needModifySettings) {
                stopSetIds.add(dynamicObject.getPkValue());
                dynamicObject.set("stoptime", (Object)TimeServiceHelper.now());
                dynamicObject.set("stoper", (Object)RequestContext.get().getUserId());
                dynamicObject.set("starter", null);
                dynamicObject.set("starttime", null);
                dynamicObject.set("isfinish", (Object)"0");
                dynamicObject.set("failbill_tag", (Object)"");
                if (subList == null || subList.size() >= 7000) {
                    subList = new ArrayList<Object>(7000);
                    list.add(subList);
                }
                subList.add(dynamicObject);
            }
            if (list.isEmpty()) {
                return;
            }
            long time1 = System.currentTimeMillis();
            logger.info("------------\u505c\u6b62\u540c\u6b65\u670d\u52a1\uff1a\u5206\u6279\uff1a" + list.size() + "*" + 7000 + ".\u5f00\u59cb\uff1a" + time1);
            final CountDownLatch latch = new CountDownLatch(list.size());
            for (final List list2 : list) {
                ThreadPools.executeOnce((String)this.getClass().getName(), (Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        long batchStartTime = System.currentTimeMillis();
                        try (TXHandle h = TX.requiresNew();){
                            SaveServiceHelper.save((DynamicObject[])list2.toArray(new DynamicObject[list2.size()]));
                        }
                        catch (Throwable e) {
                            logger.error("\u505c\u6b62\u670d\u52a1\u5931\u8d25\uff1a", e);
                        }
                        finally {
                            latch.countDown();
                            long batchEndTime = System.currentTimeMillis();
                            logger.info("------------\u505c\u6b62\u540c\u6b65\u670d\u52a1\uff1a\u4fdd\u5b58\u542f\u505c\u670d\u52a1\u914d\u7f6e\u5355\u6279\u7528\u65f6:" + (batchEndTime - batchStartTime));
                        }
                    }
                });
            }
            try {
                latch.await();
                long time2 = System.currentTimeMillis();
                logger.info("------------\u505c\u6b62\u540c\u6b65\u670d\u52a1\uff1a\u7ed3\u675f\uff1a" + (time2 - time1));
            }
            catch (InterruptedException e) {
                logger.error("StopSyncSettingModifyHelper stopSyncServiceOp", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        if (!stopSetIds.isEmpty()) {
            DynamicObjectCollection modifySets = QueryServiceHelper.query((String)"cal_stopsyncbillset", (String)"stoper.name,calorg.name,storageorgunit.name,warehouse.name,accounttype,material.name,bookdate", (QFilter[])new QFilter("id", "in", stopSetIds).toArray());
            this.addLogs(modifySets, true);
        }
    }

    private void startSyncService() {
        QFilter q = new QFilter("calorg", "in", this.calOrgSet);
        if (this.storageorgunit != null && this.storageorgunit != 0L) {
            q.and("storageorgunit", "=", (Object)this.storageorgunit);
        }
        if (this.warehouse != null && this.warehouse != 0L) {
            q.and("warehouse", "=", (Object)this.warehouse);
        }
        if (StringUtils.isNotEmpty((String)this.accountType)) {
            q.and("accounttype", "=", (Object)this.accountType);
        }
        if (this.materialIdSet != null && !this.materialIdSet.isEmpty()) {
            q.and("material", "in", this.materialIdSet);
        }
        if (this.bookDate != null) {
            q.and("bookdate", ">=", (Object)this.bookDate);
        }
        q.and("isfinish", "=", (Object)Character.valueOf('0'));
        q.and("stoptype", "=", (Object)"cal");
        DynamicObjectCollection settingLogs = QueryServiceHelper.query((String)"cal_stopsyncbillset", (String)"id", (QFilter[])q.toArray());
        HashSet<Object> settingIds = new HashSet<Object>(16);
        for (DynamicObject settingLog : settingLogs) {
            settingIds.add(settingLog.get("id"));
        }
        if (settingIds.isEmpty()) {
            return;
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("ishasright", "true");
        OperationServiceHelper.executeOperate((String)"startservice", (String)"cal_stopsyncbillset", (Object[])settingIds.toArray(), (OperateOption)op);
    }

    private Set<String> loadAndSaveSettings(QFilter q) {
        HashSet<String> reExeBillIds = new HashSet<String>(16);
        DynamicObject[] needModifySettings = BusinessDataServiceHelper.load((String)"cal_stopsyncbillset", (String)"id,starter,starttime,isfinish", (QFilter[])q.toArray());
        String userId = RequestContext.get().getUserId();
        HashSet<Object> startSetIdsSetIds = new HashSet<Object>(64);
        ArrayList list = new ArrayList(10);
        ArrayList<DynamicObject> subList = null;
        if (needModifySettings == null || needModifySettings.length <= 0) {
            return reExeBillIds;
        }
        for (DynamicObject dynamicObject : needModifySettings) {
            startSetIdsSetIds.add(dynamicObject.getPkValue());
            dynamicObject.set("starter", (Object)userId);
            dynamicObject.set("starttime", (Object)TimeServiceHelper.now());
            dynamicObject.set("isfinish", (Object)"1");
            if (subList == null || subList.size() >= 7000) {
                subList = new ArrayList<DynamicObject>(7000);
                list.add(subList);
            }
            subList.add(dynamicObject);
        }
        if (list.isEmpty()) {
            return reExeBillIds;
        }
        long time1 = System.currentTimeMillis();
        logger.info("------------\u542f\u52a8\u540c\u6b65\u670d\u52a1\uff1a\u83b7\u53d6\u5355\u636e\u540c\u6b65\u5206\u5e03\u5f0f\u9501\u5f00\u59cb:" + time1);
        long time2 = System.currentTimeMillis();
        logger.info("------------\u542f\u52a8\u540c\u6b65\u670d\u52a1\uff1a\u83b7\u53d6\u5355\u636e\u540c\u6b65\u5206\u5e03\u5f0f\u9501\u7ed3\u675f:" + time2 + "\u7528\u65f6:" + (time2 - time1));
        logger.info("------------\u542f\u52a8\u540c\u6b65\u670d\u52a1\uff1a\u4fdd\u5b58\u542f\u505c\u670d\u52a1\u914d\u7f6e\u5f00\u59cb:" + time2 + "\u5171:" + list.size() + "*" + 7000 + "\u6279");
        final CountDownLatch latch = new CountDownLatch(list.size());
        for (final List list2 : list) {
            ThreadPools.executeOnce((String)this.getClass().getName(), (Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long batchStartTime = System.currentTimeMillis();
                    try (TXHandle h = TX.requiresNew();){
                        SaveServiceHelper.save((DynamicObject[])list2.toArray(new DynamicObject[list2.size()]));
                    }
                    catch (Throwable e) {
                        logger.error("\u542f\u52a8\u670d\u52a1\u5931\u8d25\uff1a", e);
                    }
                    finally {
                        latch.countDown();
                        long batchEndTime = System.currentTimeMillis();
                        logger.info("------------\u542f\u52a8\u540c\u6b65\u670d\u52a1\uff1a\u4fdd\u5b58\u542f\u505c\u670d\u52a1\u914d\u7f6e\u5355\u6279\u7528\u65f6:" + (batchEndTime - batchStartTime));
                    }
                }
            });
        }
        try {
            latch.await();
            long time3 = System.currentTimeMillis();
            logger.info("------------\u542f\u52a8\u540c\u6b65\u670d\u52a1\uff1a\u4fdd\u5b58\u542f\u505c\u670d\u52a1\u914d\u7f6e\u7ed3\u675f:" + time3 + "\u3002\u4fdd\u5b58\u7528\u65f6:" + (time3 - time2));
        }
        catch (InterruptedException e) {
            logger.error("------------\u542f\u52a8\u540c\u6b65\u670d\u52a1\uff1a\u4fdd\u5b58\u542f\u505c\u670d\u52a1\u914d\u7f6e\u5f02\u5e38:", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        if (!startSetIdsSetIds.isEmpty()) {
            DynamicObjectCollection modifySets = QueryServiceHelper.query((String)"cal_stopsyncbillset", (String)"starter.name,bookdate,calorg.name,storageorgunit.name,warehouse.name,accounttype,material.name,failbill_tag", (QFilter[])new QFilter("id", "in", startSetIdsSetIds).toArray());
            this.addLogs(modifySets, false);
            for (DynamicObject dynamicObject : modifySets) {
                String failbillids = dynamicObject.getString("failbill_tag");
                if (!StringUtils.isNotEmpty((String)failbillids)) continue;
                reExeBillIds.addAll(Arrays.asList(failbillids.split(",")));
            }
        }
        return reExeBillIds;
    }

    private void canStartSyncService() {
        QFilter q = new QFilter("billstatus", "in", (Object)new String[]{"A", "B"});
        q.and("calorg", "in", this.calOrgSet);
        if (this.materialIdSet != null && !this.materialIdSet.isEmpty()) {
            q.and("entryentity.material", "in", this.materialIdSet);
        }
        DataSet applyBillDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costupdateapplybill", (String)"billno", (QFilter[])q.toArray(), null);
        HashSet<String> billNos = new HashSet<String>();
        for (Row row : applyBillDataSet) {
            billNos.add(row.getString("billno"));
        }
        if (!billNos.isEmpty()) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6210\u672c\u8c03\u6574\u7533\u8bf7\u5355\uff1a%1$s\uff0c\u4e0d\u80fd\u542f\u52a8\u670d\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"StopSyncSettingModifyHelper_11", (String)"fi-cal-common", (Object[])new Object[0]), String.join((CharSequence)",", billNos));
            throw new KDBizException(errorMsg);
        }
    }

    private void stopSynceService(Date nowTime) {
        DynamicObject dynamicObject;
        Throwable throwable;
        TXHandle handler;
        QFilter q;
        this.currentSettingStr.retainAll(this.newSettingStr);
        String userId = RequestContext.get().getUserId();
        HashSet<Object> needFinishSettingIds = new HashSet<Object>();
        for (String string : this.currentSettingStr) {
            DynamicObject[] finish = this.finishMap.get(string);
            if (!"1".equals(finish)) continue;
            needFinishSettingIds.add(this.currentSettingIdMap.get(string));
        }
        DynamicObject[] needModifySettings = null;
        if (!needFinishSettingIds.isEmpty() && (needModifySettings = BusinessDataServiceHelper.load((String)"cal_stopsyncbillset", (String)"id,stoptime,stoper,starter,starttime,isfinish,failbill_tag", (QFilter[])(q = new QFilter("id", "in", needFinishSettingIds)).toArray())) != null) {
            for (DynamicObject dynamicObject2 : needModifySettings) {
                dynamicObject2.set("stoptime", (Object)nowTime);
                dynamicObject2.set("stoper", (Object)userId);
                dynamicObject2.set("starter", null);
                dynamicObject2.set("starttime", null);
                dynamicObject2.set("isfinish", (Object)"0");
                dynamicObject2.set("failbill_tag", (Object)"");
            }
        }
        this.newSettingStr.removeAll(this.currentSettingStr);
        HashSet<DynamicObject> newSettings = null;
        if (!this.newSettingStr.isEmpty()) {
            newSettings = new HashSet<DynamicObject>(this.newSettingStr.size());
            for (String newSetting : this.newSettingStr) {
                DynamicObject syncBillSetting = BusinessDataServiceHelper.newDynamicObject((String)"cal_stopsyncbillset");
                syncBillSetting.set("stoptype", (Object)"cal");
                syncBillSetting.set("calorg", this.calOrgMap.get(newSetting));
                syncBillSetting.set("storageorgunit", (Object)this.storageorgunit);
                syncBillSetting.set("accounttype", (Object)this.accountType);
                syncBillSetting.set("warehouse", (Object)this.warehouse);
                syncBillSetting.set("material", this.materialMap.get(newSetting));
                syncBillSetting.set("bookdate", (Object)this.bookDate);
                syncBillSetting.set("stoptime", (Object)nowTime);
                syncBillSetting.set("stoper", (Object)userId);
                syncBillSetting.set("starter", null);
                syncBillSetting.set("starttime", null);
                syncBillSetting.set("isfinish", (Object)"0");
                newSettings.add(syncBillSetting);
            }
        }
        Object[] stopSetting1 = null;
        Object[] stopSetting2 = null;
        long time1 = System.currentTimeMillis();
        logger.info("------------\u505c\u6b62\u540c\u6b65\u670d\u52a1:\u5f00\u59cb\uff1a" + time1);
        long time2 = System.currentTimeMillis();
        logger.info("------------\u505c\u6b62\u540c\u6b65\u670d\u52a1:\u83b7\u53d6\u540c\u6b65\u5206\u5e03\u5f0f\u9501\u7528\u65f6\uff1a" + (time2 - time1));
        if (needModifySettings != null) {
            logger.info("------------\u505c\u6b62\u540c\u6b65\u670d\u52a1:\u4fee\u6539\u914d\u7f6e\uff1a" + needModifySettings.length);
            handler = TX.requiresNew();
            throwable = null;
            try {
                stopSetting1 = SaveServiceHelper.save((DynamicObject[])needModifySettings);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (handler != null) {
                    if (throwable != null) {
                        try {
                            handler.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        handler.close();
                    }
                }
            }
        }
        if (newSettings != null) {
            logger.info("------------\u505c\u6b62\u540c\u6b65\u670d\u52a1:\u65b0\u589e\u914d\u7f6e\uff1a" + newSettings.size());
            handler = TX.requiresNew();
            throwable = null;
            try {
                stopSetting2 = SaveServiceHelper.save((DynamicObject[])newSettings.toArray(new DynamicObject[0]));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (handler != null) {
                    if (throwable != null) {
                        try {
                            handler.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        handler.close();
                    }
                }
            }
        }
        long time3 = System.currentTimeMillis();
        logger.info("------------\u505c\u6b62\u540c\u6b65\u670d\u52a1:\u4fdd\u5b58\u914d\u7f6e\u7528\u65f6\uff1a" + (time3 - time2));
        HashSet<Object> stopSetIds = new HashSet<Object>(16);
        if (stopSetting1 != null) {
            for (Object object : stopSetting1) {
                dynamicObject = (DynamicObject)object;
                stopSetIds.add(dynamicObject.getPkValue());
            }
        }
        if (stopSetting2 != null) {
            for (Object object : stopSetting2) {
                dynamicObject = (DynamicObject)object;
                stopSetIds.add(dynamicObject.getPkValue());
            }
        }
        if (!stopSetIds.isEmpty()) {
            DynamicObjectCollection modifySets = QueryServiceHelper.query((String)"cal_stopsyncbillset", (String)"stoper.name,calorg.name,storageorgunit.name,warehouse.name,accounttype,material.name,bookdate", (QFilter[])new QFilter("id", "in", stopSetIds).toArray());
            this.addLogs(modifySets, true);
        }
    }

    private void getNewSetting(Set<Long> calOrgSet, Long storageorgunit, String accountType, Long warehouse, Set<Long> materialIdSet, Date bookDate) {
        storageorgunit = storageorgunit == null ? Long.valueOf(0L) : storageorgunit;
        accountType = accountType == null ? "" : accountType;
        warehouse = warehouse == null ? Long.valueOf(0L) : warehouse;
        String bookDateStr = null;
        if (bookDate != null) {
            DateFormat dFormat = DateFormat.getDateInstance();
            bookDateStr = dFormat.format(bookDate);
        }
        for (Long calOrg : calOrgSet) {
            if (calOrg == null || calOrg == 0L) continue;
            if (materialIdSet == null || materialIdSet.isEmpty()) {
                String key = calOrg + "_" + storageorgunit + "_" + accountType + "_" + warehouse + "_0_" + bookDateStr;
                this.newSettingStr.add(key);
                this.calOrgMap.put(key, calOrg);
                continue;
            }
            for (Long string : materialIdSet) {
                if (string == null) {
                    string = 0L;
                }
                String key = calOrg + "_" + storageorgunit + "_" + accountType + "_" + warehouse + "_" + string + "_" + bookDateStr;
                this.newSettingStr.add(key);
                this.materialMap.put(key, string);
                this.calOrgMap.put(key, calOrg);
            }
        }
    }

    public void addLogs(DynamicObjectCollection array, boolean isStop) {
        if (array != null && array.size() > 0) {
            StringBuilder logdes = new StringBuilder();
            for (DynamicObject dynamicObject : array) {
                String str;
                String userName = "";
                userName = isStop ? dynamicObject.getString("stoper.name") : dynamicObject.getString("starter.name");
                if (StringUtils.isNotEmpty((String)userName)) {
                    logdes.append('\u3010').append(userName).append('\u3011');
                }
                String calorg = dynamicObject.getString("calorg.name");
                String storageorgunit = dynamicObject.getString("storageorgunit.name");
                String warehouse = dynamicObject.getString("warehouse.name");
                String accounttype = dynamicObject.getString("accounttype");
                String material = dynamicObject.getString("material.name");
                Date bookDate = dynamicObject.getDate("bookdate");
                String bookDateStr = null;
                if (bookDate != null) {
                    DateFormat dFormat = DateFormat.getInstance();
                    bookDateStr = dFormat.format(bookDate);
                }
                ArrayList<String> msg = new ArrayList<String>(8);
                if (StringUtils.isNotEmpty((String)calorg)) {
                    str = MessageFormat.format(ResManager.loadKDString((String)"\u914d\u7f6e\uff1a\u6838\u7b97\u7ec4\u7ec7\u3010{0}\u3011", (String)"StopSyncSettingModifyHelper_1", (String)"fi-cal-common", (Object[])new Object[0]), calorg);
                    msg.add(str);
                }
                if (StringUtils.isNotEmpty((String)storageorgunit)) {
                    str = MessageFormat.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u3010{0}\u3011", (String)"StopSyncSettingModifyHelper_2", (String)"fi-cal-common", (Object[])new Object[0]), storageorgunit);
                    msg.add(str);
                }
                if (StringUtils.isNotEmpty((String)warehouse)) {
                    str = MessageFormat.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u3010{0}\u3011", (String)"StopSyncSettingModifyHelper_3", (String)"fi-cal-common", (Object[])new Object[0]), warehouse);
                    msg.add(str);
                }
                if (StringUtils.isNotEmpty((String)accounttype)) {
                    String accountTypeName = AccountTypeEnum.getName(accounttype);
                    String str2 = String.format(ResManager.loadKDString((String)"\u8ba1\u4ef7\u65b9\u6cd5\u3010%1$s\u3011\uff0c", (String)"StopSyncSettingModifyHelper_20", (String)"fi-cal-common", (Object[])new Object[0]), accountTypeName);
                    logdes.append(str2);
                }
                if (StringUtils.isNotEmpty((String)material)) {
                    str = MessageFormat.format(ResManager.loadKDString((String)"\u7269\u6599\u3010{0}\u3011", (String)"StopSyncSettingModifyHelper_5", (String)"fi-cal-common", (Object[])new Object[0]), material);
                    msg.add(str);
                }
                if (!msg.isEmpty()) {
                    logdes.append(String.join((CharSequence)",", msg));
                }
                if (isStop) {
                    logdes.append(ResManager.loadKDString((String)"\u6838\u7b97\u5355\u540c\u6b65\u8fdb\u7a0b\u505c\u6b62\uff0c\u72b6\u6001\uff1a\u6210\u529f\u3002", (String)"StopSyncSettingModifyHelper_6", (String)"fi-cal-common", (Object[])new Object[0]));
                    logdes.append("\r\n");
                    continue;
                }
                logdes.append(ResManager.loadKDString((String)"\u6838\u7b97\u5355\u540c\u6b65\u8fdb\u7a0b\u542f\u52a8\uff0c\u72b6\u6001\uff1a\u6210\u529f\u3002", (String)"StopSyncSettingModifyHelper_7", (String)"fi-cal-common", (Object[])new Object[0]));
                logdes.append("\r\n");
            }
            if (isStop) {
                CalLogUtils.addLog(CalLogUtils.buildCalAppLog("cal_stopsyncbillset", ResManager.loadKDString((String)"\u505c\u6b62\u540c\u6b65", (String)"StopSyncSettingModifyHelper_8", (String)"fi-cal-common", (Object[])new Object[0]), logdes.toString(), RequestContext.get().getOrgId()));
            } else {
                CalLogUtils.addLog(CalLogUtils.buildCalAppLog("cal_stopsyncbillset", ResManager.loadKDString((String)"\u542f\u52a8\u540c\u6b65", (String)"StopSyncSettingModifyHelper_9", (String)"fi-cal-common", (Object[])new Object[0]), logdes.toString(), RequestContext.get().getOrgId()));
            }
        }
    }

    private void getCurrentSetting() {
        QFilter settingFilter = new QFilter("calorg", "in", this.calOrgSet);
        try (DataSet currentSetting = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stopsyncbillset", (String)"id,calorg,storageorgunit,accounttype,warehouse,material,failbill_tag,bookdate,isfinish", (QFilter[])settingFilter.toArray(), null);){
            for (Row row : currentSetting) {
                String calOrgId = row.getString("calorg");
                String storageorgunit = row.getString("storageorgunit");
                String accountType = row.getString("accounttype").trim();
                String warehouse = row.getString("warehouse");
                String materialId = row.getString("material");
                Date bookDate = row.getDate("bookdate");
                String bookDateStr = null;
                if (bookDate != null) {
                    DateFormat dFormat = DateFormat.getDateInstance();
                    bookDateStr = dFormat.format(bookDate);
                }
                Object settingId = row.get("id");
                String finish = row.getString("isfinish");
                String string = calOrgId + "_" + storageorgunit + "_" + accountType + "_" + warehouse + "_" + materialId + "_" + bookDateStr;
                this.currentSettingStr.add(string);
                this.currentSettingIdMap.put(string, settingId);
                this.finishMap.put(string, finish);
            }
        }
    }

    public void modifySetting4Invorg(Set<Long> mulInvOrgIds, Date bookDate, Boolean isstopsync) {
        if (isstopsync.booleanValue()) {
            this.stopSyncService4Invorg(mulInvOrgIds, bookDate);
        } else {
            this.startSyncService4Invorg(mulInvOrgIds, bookDate);
        }
    }

    private void startSyncService4Invorg(Set<Long> mulInvOrgIds, Date bookDate) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date date = TimeServiceHelper.now();
        QFilter filter = new QFilter("stoptype", "=", (Object)"inv");
        filter.and("storageorgunit", "in", mulInvOrgIds);
        if (bookDate != null) {
            filter.and("bookdate", ">=", (Object)bookDate);
        }
        ArrayList<Object[]> needStartSettings = new ArrayList<Object[]>(16);
        HashSet<Long> reExeBizBillIds = new HashSet<Long>(16);
        try (DataSet settingDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stopsyncbillset", (String)"id,failbill_tag", (QFilter[])filter.toArray(), null);){
            for (Object row : settingDS) {
                needStartSettings.add(new Object[]{"1", userId, date, null, row.getLong("id")});
                String failbills = row.getString("failbill_tag");
                if (!StringUtils.isNotEmpty((String)failbills)) continue;
                for (String s : failbills.split(",")) {
                    if (!StringUtils.isNotEmpty((String)s)) continue;
                    reExeBizBillIds.add(Long.valueOf(s));
                }
            }
        }
        if (!needStartSettings.isEmpty()) {
            var9_9 = null;
            try (TXHandle handler = TX.requiresNew();){
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)settingStartOpSql, needStartSettings);
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
        }
        if (reExeBizBillIds.isEmpty()) {
            return;
        }
        QFilter qser = new QFilter("bizbillid", "in", reExeBizBillIds);
        qser.and("success", "<>", (Object)"1");
        qser.and("actionname", "in", (Object)new String[]{ActionEnum.SUBMIT.getValue(), ActionEnum.UN_SUBMIT.getValue()});
        DynamicObjectCollection serinfos = QueryServiceHelper.query((String)"cal_syncbizbillrecord", (String)"id", (QFilter[])qser.toArray());
        HashSet<Long> serlogids = new HashSet<Long>(16);
        for (DynamicObject logid : serinfos) {
            serlogids.add(logid.getLong("id"));
        }
        if (!serlogids.isEmpty()) {
            OperateOption serop = OperateOption.create();
            serop.setVariableValue("ishasright", "true");
            HashSet batchSet = new HashSet(16);
            for (Object e : serlogids) {
                batchSet.add(e);
                if (batchSet.size() < 100) continue;
                OperationServiceHelper.executeOperate((String)"excute", (String)"cal_syncbizbillrecord", (Object[])batchSet.toArray(), (OperateOption)serop);
                batchSet.clear();
            }
            if (!batchSet.isEmpty()) {
                OperationServiceHelper.executeOperate((String)"excute", (String)"cal_syncbizbillrecord", (Object[])batchSet.toArray(), (OperateOption)serop);
            }
        }
        QFilter q = new QFilter("bizbillid", "in", reExeBizBillIds);
        q.and("success", "<>", (Object)"1");
        q.and("actionname", "in", (Object)new String[]{ActionEnum.AUDIT.getValue(), ActionEnum.UN_AUDIT.getValue()});
        DynamicObjectCollection infos = QueryServiceHelper.query((String)"cal_businesslog", (String)"id", (QFilter[])q.toArray());
        HashSet<Long> logids = new HashSet<Long>(16);
        for (DynamicObject logid : infos) {
            logids.add(logid.getLong("id"));
        }
        if (!logids.isEmpty()) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ishasright", "true");
            HashSet batchSet = new HashSet(16);
            for (Object e : logids) {
                batchSet.add(e);
                if (batchSet.size() < 100) continue;
                OperationServiceHelper.executeOperate((String)"excute", (String)"cal_businesslog", (Object[])batchSet.toArray(), (OperateOption)operateOption);
                batchSet.clear();
            }
            if (!batchSet.isEmpty()) {
                OperationServiceHelper.executeOperate((String)"excute", (String)"cal_businesslog", (Object[])batchSet.toArray(), (OperateOption)operateOption);
            }
        }
    }

    private void stopSyncService4Invorg(Set<Long> mulInvOrgIds, Date bookDate) {
        Object object;
        TXHandle handler;
        Long userid = Long.valueOf(RequestContext.get().getUserId());
        Date date = TimeServiceHelper.now();
        QFilter filter = new QFilter("stoptype", "=", (Object)"inv");
        filter.and("storageorgunit", "in", mulInvOrgIds);
        if (bookDate != null) {
            filter.and("bookdate", "=", (Object)bookDate);
        } else {
            filter.and(QFilter.isNull((String)"bookdate"));
        }
        HashSet<Long> existInvOrgIds = new HashSet<Long>(16);
        ArrayList<Object[]> needStopSettings = new ArrayList<Object[]>(16);
        DataSet settingDS = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_stopsyncbillset", (String)"id,storageorgunit,isfinish", (QFilter[])filter.toArray(), null);
        Object object2 = null;
        try {
            for (Row row : settingDS) {
                Long id = row.getLong("id");
                Long storageorgunitId = row.getLong("storageorgunit");
                String isfinish = row.getString("isfinish");
                existInvOrgIds.add(storageorgunitId);
                if (!"1".equals(isfinish)) continue;
                needStopSettings.add(new Object[]{"0", userid, date, 0L, null, null, id});
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (settingDS != null) {
                if (object2 != null) {
                    try {
                        settingDS.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    settingDS.close();
                }
            }
        }
        mulInvOrgIds.removeAll(existInvOrgIds);
        ArrayList<DynamicObject> needAddSettings = new ArrayList<DynamicObject>(16);
        for (Long mulInvOrgId : mulInvOrgIds) {
            DynamicObject setting = BusinessDataServiceHelper.newDynamicObject((String)"cal_stopsyncbillset");
            setting.set("stoptype", (Object)"inv");
            setting.set("storageorgunit", (Object)mulInvOrgId);
            setting.set("bookdate", (Object)bookDate);
            setting.set("isfinish", (Object)"0");
            setting.set("stoptime", (Object)date);
            setting.set("stoper", (Object)userid);
            needAddSettings.add(setting);
        }
        if (!needAddSettings.isEmpty()) {
            handler = TX.requiresNew();
            object = null;
            try {
                SaveServiceHelper.save((DynamicObject[])needAddSettings.toArray(new DynamicObject[0]));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (handler != null) {
                    if (object != null) {
                        try {
                            handler.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        handler.close();
                    }
                }
            }
        }
        if (!needStopSettings.isEmpty()) {
            handler = TX.requiresNew();
            object = null;
            try {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)settingStopOpSql, needStopSettings);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (handler != null) {
                    if (object != null) {
                        try {
                            handler.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        handler.close();
                    }
                }
            }
        }
    }
}

