/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBillDiffTypeEnum;
import kd.fi.cal.common.helper.CalBillRuleHelper;
import kd.fi.cal.common.helper.CostElementHelper;
import kd.fi.cal.common.helper.CostTypeHelper;
import kd.fi.cal.common.helper.InitCalBillHelper;
import kd.fi.cal.common.helper.ParamsHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.SCMHelper;
import kd.fi.cal.common.model.CostAccountInfo;
import kd.fi.cal.common.model.MaterialCostInfo;
import kd.fi.cal.common.model.SynBillErrInfo;
import kd.fi.cal.common.util.CommonUtils;

public class SynBizBillHelper {
    public static boolean verifyCostAccount(DynamicObjectCollection costAccColl, long ownerId, long billId, Map<Long, DynamicObject> ownerMap, Map<Long, Boolean> AccEndInitMap, Set<Long> idSet, Map<Long, SynBillErrInfo> errMap, Map<Long, DynamicObject> costAcc2StartPeriod, DynamicObject billentry) {
        if (costAccColl.isEmpty()) {
            String content;
            DynamicObject owner = ownerMap.get(ownerId);
            if (owner == null) {
                owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bos_org", (String)"id,number,name");
            }
            String msg = content = String.format(ResManager.loadKDString((String)"\u8d27\u4e3b\u201c%1$s\u201d\u6ca1\u6709\u627e\u5230\u53ef\u7528\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"SynBizBillHelper_14", (String)"fi-cal-common", (Object[])new Object[0]), owner == null ? "" : owner.getString("name"));
            errMap.put(billId, new SynBillErrInfo("3", msg));
            ownerMap.put(ownerId, owner);
            idSet.remove(billId);
            return false;
        }
        boolean isEndInit = false;
        boolean bizDateVerify = true;
        for (DynamicObject costAcc : costAccColl) {
            long costAccId = costAcc.getLong("id");
            if (AccEndInitMap.get(costAccId) == null) {
                isEndInit = PeriodHelper.isEndInit(costAcc.getLong("id"));
                AccEndInitMap.put(costAccId, isEndInit);
            } else {
                isEndInit = AccEndInitMap.get(costAccId);
            }
            if (isEndInit) {
                String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\uff08%2$s\uff09\u201d\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u540c\u6b65\u751f\u6210\u521d\u59cb\u6838\u7b97\u5355\u5931\u8d25\u3002", (String)"SynBizBillHelper_18", (String)"fi-cal-common", (Object[])new Object[0]), costAcc.getString("number"), costAcc.getString("name"));
                errMap.put(billId, new SynBillErrInfo("3", msg));
                idSet.remove(billId);
                break;
            }
            DynamicObject startPeriod = costAcc2StartPeriod.get(costAccId);
            if (startPeriod == null) {
                startPeriod = PeriodHelper.getStartPeriod(costAccId);
                if (startPeriod == null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\uff08%2$s\uff09\u201d\u672a\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\uff0c\u8bf7\u5148\u5728\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u4e2d\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"SynBizBillHelper_19", (String)"fi-cal-common", (Object[])new Object[0]), costAcc.getString("number"), costAcc.getString("name"));
                    errMap.put(billId, new SynBillErrInfo("3", msg));
                    idSet.remove(billId);
                    bizDateVerify = false;
                    break;
                }
                costAcc2StartPeriod.put(costAccId, startPeriod);
            }
            Date beginDate = startPeriod.getDate("begindate");
            if (billentry.getDate("biztime").before(beginDate)) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4e1a\u52a1\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u6210\u672c\u8d26\u7c3f\u201c%1$s\uff08%2$s\uff09\u201d\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u201c%3$s\u201d\uff0c\u540c\u6b65\u751f\u6210\u521d\u59cb\u6838\u7b97\u5355\u5931\u8d25\u3002", (String)"SynBizBillHelper_20", (String)"fi-cal-common", (Object[])new Object[0]), costAcc.getString("number"), costAcc.getString("name"), new SimpleDateFormat("yyyy-MM-dd").format(beginDate));
            errMap.put(billId, new SynBillErrInfo("3", msg));
            idSet.remove(billId);
            bizDateVerify = false;
            break;
        }
        return !isEndInit && bizDateVerify;
    }

    /*
     * WARNING - void declaration
     */
    public static void handleInitBillStdCost(DynamicObject[] billarr, Map<Long, CostAccountInfo> costAcc2Std, Map<Long, SynBillErrInfo> errMap, Map<Long, Long> billCurrencyMap, Map<Long, Long> calBillExratetableMap) {
        DynamicObject materialDyn;
        String matNum;
        CostAccountInfo accInfo;
        int billSize = billarr.length;
        HashSet<DynamicObject> calByCostEleInfos = new HashSet<DynamicObject>(billSize);
        HashSet<DynamicObject> unCalByCostEleInfos = new HashSet<DynamicObject>(billSize);
        HashSet<Long> costAccIdSet = new HashSet<Long>(16);
        HashSet<Long> stdMaterialIdSet = new HashSet<Long>(billSize);
        for (DynamicObject bill : billarr) {
            costAccIdSet.add(bill.getLong("costaccount_id"));
        }
        DynamicObjectCollection costAccColl = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,calorg,costtype,costtype.name,enablestandardcost", (QFilter[])new QFilter[]{new QFilter("id", "in", costAccIdSet)});
        for (DynamicObject costAcc : costAccColl) {
            long costAccId = costAcc.getLong("id");
            boolean isEnableStd = costAcc.getBoolean("enablestandardcost");
            boolean calByCostElement = ParamsHelper.getCostElementByCostAccount(costAccId);
            accInfo = new CostAccountInfo(isEnableStd, calByCostElement, costAcc.getLong("costtype"), costAcc.getString("costtype.name"));
            costAcc2Std.put(costAccId, accInfo);
        }
        for (DynamicObject bill : billarr) {
            long costAccId = bill.getLong("costaccount_id");
            accInfo = costAcc2Std.get(costAccId);
            boolean isEnableStd = accInfo.isEnableStd();
            boolean calByCostElement = accInfo.isCalBySubElement();
            if (calByCostElement) {
                calByCostEleInfos.add(bill);
            } else {
                unCalByCostEleInfos.add(bill);
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                long materialId = entry.getLong("material_id");
                if (!isEnableStd && !AccountTypeEnum.STANDARDCOST.getValue().equals(entry.getString("accounttype"))) continue;
                stdMaterialIdSet.add(materialId);
            }
        }
        int initMapSize = stdMaterialIdSet.size();
        HashMap<Long, String> materialMap = new HashMap<Long, String>(initMapSize);
        HashMap<String, List<MaterialCostInfo>> costInfoMap = new HashMap(initMapSize);
        if (!stdMaterialIdSet.isEmpty()) {
            costInfoMap = InitCalBillHelper.queryCostInfo(billarr);
        }
        Map<Long, Long> bill2CostTypeMap = CostTypeHelper.getCostTypeByBillAndBookDate(billarr, new String[]{"bizdate", "costaccount", "calorg", "storageorgunit", "bookdate"}, 1);
        HashSet<Long> costTypeIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Long> entry : bill2CostTypeMap.entrySet()) {
            costTypeIds.add(entry.getValue());
        }
        Map<Long, DynamicObject> costTypeInfos = CostTypeHelper.getCostTypeInfos(costTypeIds);
        HashMap<Long, Integer> currencyMap = new HashMap<Long, Integer>(8);
        String s = ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u6ca1\u6709\u7ef4\u62a4\u6210\u672c\u7c7b\u578b\u4e3a\u201c%2$s\u201d\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u3002", (String)"SynBizBillHelper_21", (String)"fi-cal-common", (Object[])new Object[0]);
        String tag = ResManager.loadKDString((String)"\u3010%1$s\u3011", (String)"SynBizBillHelper_22", (String)"fi-cal-common", (Object[])new Object[0]);
        if (!calByCostEleInfos.isEmpty()) {
            List<Long[]> costElementList = CostElementHelper.getAllCostEle4InitBill();
            Map<String, Object> exchangeRateMap = null;
            for (DynamicObject bill : calByCostEleInfos) {
                boolean currencyTag;
                long bizbillid = bill.getLong("bizbillid");
                if (errMap.containsKey(bizbillid)) continue;
                long currencyId = bill.getLong("localcurrency");
                Integer amtprecision = SynBizBillHelper.getAmtprecision(currencyMap, currencyId);
                long bizCurrencyId = billCurrencyMap.get(bizbillid);
                if (currencyId == bizCurrencyId) {
                    currencyTag = true;
                } else {
                    exchangeRateMap = SynBizBillHelper.getInitExchangeRateMap(currencyId, bizCurrencyId, calBillExratetableMap, bill);
                    currencyTag = false;
                }
                long orgId = bill.getLong("calorg_id");
                long costAccId = bill.getLong("costaccount_id");
                CostAccountInfo accInfo2 = costAcc2Std.get(costAccId);
                if (bill2CostTypeMap.get(bill.getLong("id")) == null) continue;
                boolean enableStd = accInfo2.isEnableStd();
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                StringBuilder matNumbers = new StringBuilder();
                for (DynamicObject entry : entrys) {
                    long materialId = entry.getLong("material_id");
                    if (InitCalBillHelper.isStd(enableStd, entry.getString("accounttype"))) {
                        List<MaterialCostInfo> costInfList = InitCalBillHelper.getStdCostInfFromMap(costInfoMap, entry);
                        if (costInfList == null) {
                            matNum = (String)materialMap.get(materialId);
                            if (matNum == null) {
                                materialDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)materialId)});
                                matNum = materialDyn.getString("number");
                                materialMap.put(materialId, matNum);
                            }
                            if (bill2CostTypeMap.get(bill.getLong("id")) == null || costTypeInfos.get(bill2CostTypeMap.get(bill.getLong("id"))) == null) continue;
                            matNumbers.append(String.format(tag, String.join((CharSequence)",", matNum)));
                            matNumbers.append(", ");
                            continue;
                        }
                        String diffAmtRule = "A";
                        if (ParamsHelper.getAppParam(orgId, "initdiffamtrule") != null) {
                            diffAmtRule = (String)ParamsHelper.getAppParam(orgId, "initdiffamtrule");
                        }
                        InitCalBillHelper.setSynSubEntry4StdEntry(costInfList, amtprecision, entry, costElementList, currencyTag, exchangeRateMap, diffAmtRule);
                        continue;
                    }
                    InitCalBillHelper.setSynSubEntry4NotStdCalByEle(entry, costElementList, amtprecision, currencyTag, exchangeRateMap);
                }
                if (matNumbers.length() <= 0) continue;
                String costTypeName = costTypeInfos.get(bill2CostTypeMap.get(bill.getLong("id"))).getString("name");
                String costTypeNum = costTypeInfos.get(bill2CostTypeMap.get(bill.getLong("id"))).getString("number");
                errMap.put(bill.getLong("bizbillid"), new SynBillErrInfo("3", String.format(s, matNumbers.substring(0, matNumbers.length() - 1), costTypeNum + " [" + costTypeName + "]")));
            }
        }
        if (!unCalByCostEleInfos.isEmpty()) {
            for (DynamicObject bill : unCalByCostEleInfos) {
                boolean currencyTag;
                long bizbillid = bill.getLong("bizbillid");
                if (errMap.containsKey(bizbillid)) continue;
                long costAccId = bill.getLong("costaccount_id");
                CostAccountInfo accInfo3 = costAcc2Std.get(costAccId);
                boolean enableStd = accInfo3.isEnableStd();
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                long currencyId = bill.getLong("localcurrency");
                Map<String, Object> exchangeRateMap = null;
                long bizCurrencyId = billCurrencyMap.get(bizbillid);
                Integer amtprecision = SynBizBillHelper.getAmtprecision(currencyMap, currencyId);
                if (currencyId == bizCurrencyId) {
                    currencyTag = true;
                } else {
                    exchangeRateMap = SynBizBillHelper.getInitExchangeRateMap(currencyId, bizCurrencyId, calBillExratetableMap, bill);
                    currencyTag = false;
                }
                StringBuilder matNumbers = new StringBuilder();
                for (DynamicObject entry : entrys) {
                    long materialId = entry.getLong("material_id");
                    BigDecimal resultAmount = entry.getBigDecimal("amount");
                    Long[] defaultElements = CostElementHelper.getDefaultMaterialElements();
                    BigDecimal qty = entry.getBigDecimal("baseqty");
                    if (enableStd || AccountTypeEnum.STANDARDCOST.getValue().equals(entry.getString("accounttype"))) {
                        void var47_70;
                        List<MaterialCostInfo> costInfos = InitCalBillHelper.getStdCostInfFromMap(costInfoMap, entry);
                        if (costInfos == null) {
                            matNum = (String)materialMap.get(materialId);
                            if (matNum == null) {
                                materialDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)materialId)});
                                matNum = materialDyn.getString("number");
                                materialMap.put(materialId, matNum);
                            }
                            if (bill2CostTypeMap.get(bill.getLong("id")) == null || costTypeInfos.get(bill2CostTypeMap.get(bill.getLong("id"))) == null) continue;
                            matNumbers.append(String.format(tag, String.join((CharSequence)",", matNum)));
                            matNumbers.append(",");
                            continue;
                        }
                        HashMap<Long, BigDecimal> subEle4StdCost = new HashMap<Long, BigDecimal>(8);
                        for (MaterialCostInfo materialCostInfo : costInfos) {
                            subEle4StdCost.put(materialCostInfo.getSubElementId(), materialCostInfo.getStandardCost());
                        }
                        BigDecimal stdPrice = BigDecimal.ZERO;
                        for (BigDecimal standardcost : subEle4StdCost.values()) {
                            if (standardcost == null) continue;
                            stdPrice = stdPrice.add(standardcost);
                        }
                        entry.set("price", (Object)stdPrice.setScale(10, RoundingMode.HALF_UP));
                        BigDecimal bigDecimal = BigDecimal.ZERO;
                        if (qty.compareTo(BigDecimal.ZERO) != 0) {
                            BigDecimal bigDecimal2 = stdPrice.multiply(qty).setScale((int)amtprecision, RoundingMode.HALF_UP);
                            entry.set("amount", (Object)bigDecimal2);
                            if (!currencyTag) {
                                resultAmount = InitCalBillHelper.getResultAmount(resultAmount, amtprecision, exchangeRateMap);
                            }
                            entry.set("costdiff", (Object)resultAmount.subtract(bigDecimal2).setScale((int)amtprecision, RoundingMode.HALF_UP));
                            entry.set("createtype", (Object)CostAdjustBillDiffTypeEnum.ORDER_DIFF.getValue());
                        }
                        InitCalBillHelper.setSubEntry4NotCalByEle(entry, defaultElements, (BigDecimal)var47_70);
                        continue;
                    }
                    if (!currencyTag && qty.compareTo(BigDecimal.ZERO) != 0) {
                        resultAmount = InitCalBillHelper.getResultAmount(resultAmount, amtprecision, exchangeRateMap);
                        entry.set("amount", (Object)resultAmount);
                    }
                    entry.set("price", (Object)resultAmount.divide(qty, 10, RoundingMode.HALF_UP));
                    InitCalBillHelper.setSubEntry4NotCalByEle(entry, defaultElements, resultAmount);
                }
                if (matNumbers.length() <= 0) continue;
                String costTypeName = costTypeInfos.get(bill2CostTypeMap.get(bill.getLong("id"))).getString("name");
                String costTypeNum = costTypeInfos.get(bill2CostTypeMap.get(bill.getLong("id"))).getString("number");
                errMap.put(bill.getLong("bizbillid"), new SynBillErrInfo("3", String.format(s, matNumbers.substring(0, matNumbers.length() - 1), costTypeNum + " [" + costTypeName + "]")));
            }
        }
    }

    public static DynamicObject[] checkBillsSync(DynamicObject[] writeOffInfos) {
        return SynBizBillHelper.checkBillsSync(writeOffInfos, false);
    }

    public static DynamicObject[] checkBillsSync(DynamicObject[] writeOffInfos, boolean isCalCharge) {
        HashMap<String, Set<Long>> writeOffBillTypeMap = new HashMap<String, Set<Long>>(writeOffInfos.length);
        HashSet<Object> wfIds = new HashSet<Object>(16);
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        for (DynamicObject writeOffInfo : writeOffInfos) {
            Long purID = writeOffInfo.getLong("billid");
            Object wfId = writeOffInfo.get("id");
            wfIds.add(wfId);
            bizBillIds.add(purID);
            String bizObjectNumber = writeOffInfo.getString("billtype");
            HashSet<Long> purIdSet = (HashSet<Long>)writeOffBillTypeMap.get(bizObjectNumber);
            if (purIdSet != null) {
                purIdSet.add(purID);
            } else {
                purIdSet = new HashSet<Long>(16);
                purIdSet.add(purID);
            }
            writeOffBillTypeMap.put(bizObjectNumber, purIdSet);
        }
        Set<String> legalPurIdSet = SynBizBillHelper.getValitePurId(writeOffBillTypeMap);
        HashSet<DynamicObject> writeOffInfoSet = new HashSet<DynamicObject>(legalPurIdSet.size());
        if (legalPurIdSet.isEmpty()) {
            return writeOffInfoSet.toArray(new DynamicObject[0]);
        }
        HashSet hasWfIds = new HashSet(16);
        if (!isCalCharge) {
            SynBizBillHelper.removeHasWfIds(wfIds, bizBillIds);
        }
        for (DynamicObject writeOffInfo : writeOffInfos) {
            Long purID = writeOffInfo.getLong("billid");
            Long purEntryId = writeOffInfo.getLong("billentryid");
            String key = purID + "_" + purEntryId;
            if (!legalPurIdSet.contains(key) || hasWfIds.contains(writeOffInfo.getLong("id"))) continue;
            writeOffInfoSet.add(writeOffInfo);
        }
        return writeOffInfoSet.toArray(new DynamicObject[0]);
    }

    public static Set<Long> removeHasWfIds(Set<Object> billIds, Set<Long> bizBillIds) {
        if (billIds.isEmpty() || bizBillIds.isEmpty()) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> hasWfIds = new HashSet<Long>(16);
        QFilter cosRecFilter = new QFilter("entry.writeoffid", "in", billIds);
        cosRecFilter.and("bizbillid", "in", bizBillIds);
        DataSet cosRecDs = QueryServiceHelper.queryDataSet((String)SynBizBillHelper.class.getName(), (String)"cal_costrecord", (String)"entry.writeoffid as writeoffid", (QFilter[])cosRecFilter.toArray(), null);
        for (Row row : cosRecDs) {
            hasWfIds.add(row.getLong("writeoffid"));
        }
        billIds.removeAll(hasWfIds);
        ArrayList hasWfIdList = new ArrayList(hasWfIds);
        Collections.sort(hasWfIdList);
        if (hasWfIdList.size() > 0) {
            String msg = ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u5df2\u62c6\u5355\u3002", (String)"PurWriteOffServiceProcess_4", (String)"fi-cal-business", (Object[])new Object[0]);
            SqlBuilder builder = new SqlBuilder();
            String format = "update t_cal_businesslog set fsuccess = '5',flog='%1$s',flog_tag='%1$s',fisclose='0',fcalstatus=' ' where ";
            builder.append(String.format(format, msg), new Object[0]);
            builder.appendIn("fbizbillid", hasWfIdList.toArray());
            try (TXHandle txHandle = TX.requiresNew();){
                DB.execute((DBRoute)new DBRoute("cal"), (SqlBuilder)builder);
            }
        }
        return hasWfIds;
    }

    private static Set<String> getValitePurId(Map<String, Set<Long>> writeOffBillTypeMap) {
        HashSet<String> legalPurIdSet = new HashSet<String>(writeOffBillTypeMap.size());
        if (writeOffBillTypeMap.size() < 1) {
            return legalPurIdSet;
        }
        Iterator<Map.Entry<String, Set<Long>>> entries = writeOffBillTypeMap.entrySet().iterator();
        String bizObjectNumber = null;
        Set<Long> purIdSet = null;
        while (entries.hasNext()) {
            Map.Entry<String, Set<Long>> entry = entries.next();
            bizObjectNumber = entry.getKey();
            purIdSet = entry.getValue();
        }
        MainEntityType bizbillentitytype = EntityMetadataCache.getDataEntityType(bizObjectNumber);
        Collection<DynamicObject> rules = CalBillRuleHelper.getCalBillRulesWithFieldMap(bizObjectNumber);
        if (rules.isEmpty()) {
            return legalPurIdSet;
        }
        String entryName = SCMHelper.getEntryKey(bizObjectNumber) + ".id";
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)bizObjectNumber);
        Map billAllFields = entityType.getAllFields();
        for (DynamicObject rule : rules) {
            DynamicObjectCollection bizBills;
            entryName = SynBizBillHelper.getMatEntryId(entryName, billAllFields, rule);
            String filter = rule.getString("filter_tag");
            QFilter[] qs = null;
            if (kd.bos.util.StringUtils.isNotEmpty((String)filter)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
                FilterBuilder filterBuilder = new FilterBuilder(bizbillentitytype, filterCondition);
                filterBuilder.buildFilter();
                ArrayList<QFilter> list = new ArrayList<QFilter>(16);
                list.add(filterBuilder.getQFilter());
                QFilter qf = new QFilter("id", "in", purIdSet);
                list.add(qf);
                qs = list.toArray(new QFilter[0]);
            } else {
                qs = new QFilter[]{new QFilter("id", "in", purIdSet)};
            }
            if ((bizBills = QueryServiceHelper.query((String)bizObjectNumber, (String)("id," + entryName), (QFilter[])qs)) == null || bizBills.isEmpty()) continue;
            for (DynamicObject bizBill : bizBills) {
                Long purID = bizBill.getLong("id");
                Long purEntryId = bizBill.getLong(entryName);
                legalPurIdSet.add(purID + "_" + purEntryId);
            }
        }
        return legalPurIdSet;
    }

    private static String getMatEntryId(String entryName, Map<String, IDataEntityProperty> billAllFields, DynamicObject rule) {
        for (DynamicObject ruleEntry : rule.getDynamicObjectCollection("fieldmap")) {
            IDataEntityProperty prop;
            String calFieldName;
            String bizFieldName = ruleEntry.getString("sourcefield");
            if (StringUtils.isEmpty((CharSequence)bizFieldName) || !"material".equals(calFieldName = ruleEntry.getString("calfield")) || (prop = billAllFields.get(bizFieldName.split("\\.")[0])) == null) continue;
            IDataEntityType parentProp = prop.getParent();
            String entryFieldPatch = CommonUtils.getFieldPath(parentProp.getName(), parentProp.getParent());
            if (!kd.bos.util.StringUtils.isNotEmpty((String)entryFieldPatch)) break;
            entryName = entryFieldPatch + ".id";
            break;
        }
        return entryName;
    }

    public static String getFirstEntryKeyByMatField(String entityName, Collection<DynamicObject> rules) {
        String firstEntryKey = "";
        if (rules == null || rules.isEmpty()) {
            MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            for (Map.Entry entryItem : bizEntityType.getAllEntities().entrySet()) {
                EntityType entityType = (EntityType)entryItem.getValue();
                if (!(entityType instanceof EntryType) || entityType instanceof LinkEntryType || entityType instanceof SubEntryType) continue;
                firstEntryKey = entityType.getName();
                break;
            }
            return firstEntryKey;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        Map billAllFields = entityType.getAllFields();
        for (DynamicObject rule : rules) {
            for (DynamicObject ruleEntry : rule.getDynamicObjectCollection("fieldmap")) {
                IDataEntityProperty prop;
                String calFieldName;
                String bizFieldName = ruleEntry.getString("sourcefield");
                if (StringUtils.isEmpty((CharSequence)bizFieldName) || !"material".equals(calFieldName = ruleEntry.getString("calfield")) || (prop = (IDataEntityProperty)billAllFields.get(bizFieldName.split("\\.")[0])) == null) continue;
                IDataEntityType parentProp = prop.getParent();
                while (parentProp instanceof EntryType) {
                    firstEntryKey = parentProp.getName();
                    parentProp = parentProp.getParent();
                }
                break block2;
            }
            if (!kd.bos.util.StringUtils.isNotEmpty((String)firstEntryKey)) continue;
            break;
        }
        return firstEntryKey;
    }

    public static Set<String> getAllEntryKeys(String entityName, boolean isFieldPath) {
        HashSet<String> entryKeys = new HashSet<String>(16);
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        for (Map.Entry entryItem : bizEntityType.getAllEntities().entrySet()) {
            String tableName;
            EntityType entityType = (EntityType)entryItem.getValue();
            if (!(entityType instanceof EntryType) || entityType instanceof LinkEntryType || kd.bos.util.StringUtils.isEmpty((String)(tableName = entityType.getAlias()))) continue;
            String entryKey = entityType.getName();
            IDataEntityType parentProp = entityType.getParent();
            if (isFieldPath) {
                String entryFieldPatch = CommonUtils.getFieldPath(entityType.getName(), parentProp);
                entryKeys.add(entryFieldPatch);
                continue;
            }
            entryKeys.add(entryKey);
        }
        return entryKeys;
    }

    public static Map<String, Object> getInitExchangeRateMap(long currencyId, long bizCurrencyId, Map<Long, Long> calBillExratetableMap, DynamicObject bill) {
        long id = bill.getLong("id");
        Date bookdate = bill.getDate("bookdate");
        Long exratetable = calBillExratetableMap.get(id);
        Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)bizCurrencyId, (Long)currencyId, (Long)exratetable, (Date)bookdate);
        Boolean quoteType = (Boolean)exchangeRateMap.get("quoteType");
        BigDecimal exchangeRate = (BigDecimal)exchangeRateMap.get("exchangeRate");
        if (bizCurrencyId == 0L) {
            exchangeRate = BigDecimal.ONE;
        }
        if (exchangeRate == null) {
            DynamicObject bizCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)bizCurrencyId, (String)"bd_currency");
            DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
            String bizCurrencyName = bizCurrency.getString("name");
            String currencyName = currency.getString("name");
            if (bizCurrencyId == 6L || currencyId == 6L) {
                String content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u672c\u4f4d\u5e01\u201c%1$s\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u672c\u4f4d\u5e01\u201c%2$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u3002", (String)"SynBizBillHelper_15", (String)"fi-cal-common", (Object[])new Object[0]), bizCurrencyName, currencyName);
                throw new KDBizException(content);
            }
            BigDecimal exchangeRateTargetUSD = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)bizCurrencyId, (Long)6L, (Long)exratetable, (Date)bookdate, (boolean)quoteType);
            BigDecimal exchangeRatesourceUSD = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)6L, (Long)currencyId, (Long)exratetable, (Date)bookdate, (boolean)quoteType);
            if (exchangeRateTargetUSD == null) {
                String content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u672c\u4f4d\u5e01\u201c%1$s\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u672c\u4f4d\u5e01\u201c%2$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u5e76\u4e14\u5355\u636e\u672c\u4f4d\u5e01\u201c%3$s\u201d\u4e0e\u201c\u7f8e\u5143\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u8868\u3002", (String)"SynBizBillHelper_16", (String)"fi-cal-common", (Object[])new Object[0]), bizCurrencyName, currencyName, bizCurrencyName);
                throw new KDBizException(content);
            }
            if (exchangeRatesourceUSD == null) {
                String content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u672c\u4f4d\u5e01\u201c%1$s\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u672c\u4f4d\u5e01\u201c%2$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u5e76\u4e14\u201c\u7f8e\u5143\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u672c\u4f4d\u5e01\u201c%3$s\u201d\u6ca1\u6709\u6c47\u7387\u5173\u7cfb\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u3002", (String)"SynBizBillHelper_17", (String)"fi-cal-common", (Object[])new Object[0]), bizCurrencyName, currencyName, currencyName);
                throw new KDBizException(content);
            }
            exchangeRateMap.put("exchangeRateTargetUSD", exchangeRateTargetUSD);
            exchangeRateMap.put("exchangeRatesourceUSD", exchangeRatesourceUSD);
        }
        return exchangeRateMap;
    }

    private static Integer getAmtprecision(Map<Long, Integer> currencyMap, long currencyId) {
        Integer amtprecision = currencyMap.get(currencyId);
        if (amtprecision == null) {
            DynamicObject currencyDyn = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currencyId)});
            amtprecision = currencyDyn.getInt("amtprecision");
            currencyMap.put(currencyId, amtprecision);
        }
        return amtprecision;
    }
}

