/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class SyncSimpleDycHelper {
    public DynamicObject[] parse(DynamicObject[] bizBillDyc) {
        if (bizBillDyc != null && bizBillDyc.length > 0) {
            bizBillDyc = this.replaceObjs(bizBillDyc, bizBillDyc[0].getDynamicObjectType());
        }
        return bizBillDyc;
    }

    public DynamicObject[] parseWriteOffDyc(DynamicObject[] bizBillDyc) {
        if (bizBillDyc != null && bizBillDyc.length > 0) {
            bizBillDyc = this.replaceWFObjs(bizBillDyc, bizBillDyc[0].getDynamicObjectType());
        }
        return bizBillDyc;
    }

    public DynamicObject[] parseParseEstimate(DynamicObject[] bizBillDyc) {
        if (bizBillDyc != null && bizBillDyc.length > 0) {
            bizBillDyc = this.replaceEstimateObjs(bizBillDyc, bizBillDyc[0].getDynamicObjectType());
        }
        return bizBillDyc;
    }

    private DynamicObject[] replaceEstimateObjs(DynamicObject[] bizBillDycs, DynamicObjectType dynamicObjectType) {
        ArrayList<String> noEntryFieldKeys = new ArrayList<String>(16);
        String estimateFields = "id,org,isadjust,billno,bookdate,bizdate";
        String estimateEntryFields = "id,e_srcbillid";
        String[] headFields = estimateFields.split(",");
        String[] entryFields = estimateEntryFields.split(",");
        noEntryFieldKeys.addAll(Arrays.asList(headFields));
        noEntryFieldKeys.addAll(Arrays.asList(entryFields));
        String entityName = bizBillDycs[0].getDataEntityType().getName();
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)entityName, noEntryFieldKeys);
        ArrayList<DynamicObject> newBillDycs = new ArrayList<DynamicObject>(16);
        for (DynamicObject billDyc : bizBillDycs) {
            DynamicObject newBillDyc = new DynamicObject(subDataEntityType);
            for (String wfRecordEntryField : headFields) {
                newBillDyc.set(wfRecordEntryField, billDyc.get(wfRecordEntryField));
            }
            for (DynamicObject billEntryDyc : billDyc.getDynamicObjectCollection("entry")) {
                DynamicObjectCollection newEntryDycs = newBillDyc.getDynamicObjectCollection("entry");
                DynamicObject newEntryDyc = newEntryDycs.addNew();
                newEntryDyc.set("id", billEntryDyc.getPkValue());
                for (String entryField : entryFields) {
                    newEntryDyc.set(entryField, billEntryDyc.get(entryField));
                }
            }
            newBillDycs.add(newBillDyc);
        }
        return newBillDycs.toArray(new DynamicObject[0]);
    }

    private DynamicObject[] replaceWFObjs(DynamicObject[] bizBillDycs, DynamicObjectType dynamicObjectType) {
        String wfRecordFields = "id,billid,verifyseq,billentryid,billtype,billno,verifyqty,billstatus,createtime,auditor,modifytime,auditdate,org";
        String wfRecordEntryFields = "e_billid,e_billentryid,e_billno,e_billtype";
        ArrayList<String> noEntryFieldKeys = new ArrayList<String>(16);
        String[] headFields = wfRecordFields.split(",");
        String[] entryFields = wfRecordEntryFields.split(",");
        noEntryFieldKeys.addAll(Arrays.asList(headFields));
        noEntryFieldKeys.addAll(Arrays.asList(entryFields));
        String entityName = bizBillDycs[0].getDataEntityType().getName();
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)entityName, noEntryFieldKeys);
        ArrayList<DynamicObject> newBillDycs = new ArrayList<DynamicObject>(16);
        for (DynamicObject billDyc : bizBillDycs) {
            DynamicObject newBillDyc = new DynamicObject(subDataEntityType);
            for (String wfRecordEntryField : headFields) {
                newBillDyc.set(wfRecordEntryField, billDyc.get(wfRecordEntryField));
            }
            for (DynamicObject billEntryDyc : billDyc.getDynamicObjectCollection("entry")) {
                DynamicObjectCollection newEntryDycs = newBillDyc.getDynamicObjectCollection("entry");
                DynamicObject newEntryDyc = newEntryDycs.addNew();
                newEntryDyc.set("id", billEntryDyc.getPkValue());
                for (String entryField : entryFields) {
                    newEntryDyc.set(entryField, billEntryDyc.get(entryField));
                }
            }
            newBillDycs.add(newBillDyc);
        }
        return newBillDycs.toArray(new DynamicObject[0]);
    }

    private DynamicObject[] replaceObjs(DynamicObject[] bizBillDyc, DynamicObjectType type) {
        boolean hasEntryField = false;
        for (IDataEntityProperty property : type.getProperties()) {
            if (!(property instanceof EntryProp) || property instanceof SubEntryProp || property instanceof LinkEntryProp) continue;
            hasEntryField = true;
            break;
        }
        if (hasEntryField) {
            DynamicObject[] newArr = new DynamicObject[bizBillDyc.length];
            String entityNumber = type.getName();
            String orgName = MetadataServiceHelper.getDataEntityType((String)entityNumber).getMainOrg();
            ArrayList<String> fields = new ArrayList<String>(16);
            fields.add("id");
            fields.add("billno");
            fields.add("billstatus");
            fields.add("auditor");
            fields.add("modifytime");
            fields.add("auditdate");
            String bizTimeName = "biztime";
            String bookDateName = "bookdate";
            boolean isContainBizDate = EntityMetadataCache.getDataEntityType((String)entityNumber).getProperties().containsKey((Object)bizTimeName);
            boolean isContainBookDate = EntityMetadataCache.getDataEntityType((String)entityNumber).getProperties().containsKey((Object)bookDateName);
            if (isContainBizDate) {
                fields.add(bizTimeName);
            }
            if (isContainBookDate) {
                fields.add(bookDateName);
            }
            fields.add(orgName);
            DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)entityNumber, fields);
            for (int i = 0; i < bizBillDyc.length; ++i) {
                newArr[i] = (DynamicObject)subDataEntityType.createInstance();
                newArr[i].set("id", bizBillDyc[i].get("id"));
                newArr[i].set("billno", bizBillDyc[i].get("billno"));
                newArr[i].set("billstatus", bizBillDyc[i].get("billstatus"));
                newArr[i].set("modifytime", bizBillDyc[i].get("modifytime"));
                newArr[i].set("auditdate", bizBillDyc[i].get("auditdate"));
                if (type.getProperty(orgName) != null) {
                    newArr[i].set(orgName, bizBillDyc[i].get(orgName));
                }
                if (type.getProperty("auditor") != null) {
                    newArr[i].set("auditor", bizBillDyc[i].get("auditor"));
                }
                if (isContainBizDate) {
                    newArr[i].set(bizTimeName, bizBillDyc[i].get(bizTimeName));
                }
                if (!isContainBookDate) continue;
                newArr[i].set(bookDateName, bizBillDyc[i].get(bookDateName));
            }
            return newArr;
        }
        return bizBillDyc;
    }

    public DynamicObject[] getSimpleBillDycs(String formId, Collection<Long> bizBillIds) {
        QFilter qFilter = new QFilter("id", "in", bizBillIds);
        StringBuilder selector = new StringBuilder();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        String mainOrgName = dataEntityType.getMainOrg();
        selector.append("id").append(",").append("billno").append(",").append("billstatus").append(",").append(mainOrgName).append(",").append("auditor").append(",").append("modifytime").append(",").append("auditdate");
        DynamicObject[] billDycs = BusinessDataServiceHelper.load((String)formId, (String)selector.toString(), (QFilter[])new QFilter[]{qFilter});
        return billDycs;
    }

    public List<DynamicObject> buildDelBizBillDycsByCostRecord(String formId, Set<Long> bizBillIds) {
        ArrayList<DynamicObject> delBizBillDycs = new ArrayList<DynamicObject>(16);
        QFilter costRecordFilter = new QFilter("bizbillid", "in", bizBillIds);
        costRecordFilter.and("bizentityobject.number", "=", (Object)formId);
        try (DataSet costRecordDataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "-queryCostRecord4ConstructBizBill"), (String)"cal_costrecord_subentity", (String)"bizbillid,billnumber,auditor,auditor.name,auditor.number,storageorgunit,storageorgunit.name,storageorgunit.number,billstatus,bizdate,bookdate", (QFilter[])costRecordFilter.toArray(), null).groupBy(new String[]{"bizbillid", "billnumber", "auditor", "auditor.name", "auditor.number", "storageorgunit", "storageorgunit.name", "storageorgunit.number", "billstatus", "bizdate", "bookdate"}).finish();){
            for (Row row : costRecordDataSet) {
                DynamicObject bizbill = BusinessDataServiceHelper.newDynamicObject((String)formId);
                bizbill.set("id", (Object)row.getLong("bizbillid"));
                bizbill.set("billno", row.get("billnumber"));
                DynamicObject auditor = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
                auditor.set("id", row.get("auditor"));
                auditor.set("name", row.get("auditor.name"));
                auditor.set("number", row.get("auditor.number"));
                bizbill.set("auditor", (Object)auditor);
                DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                org.set("id", row.get("storageorgunit"));
                org.set("name", row.get("storageorgunit.name"));
                org.set("number", row.get("storageorgunit.number"));
                bizbill.set("org", (Object)org);
                bizbill.set("billstatus", (Object)"A");
                bizbill.set("biztime", row.get("bizdate"));
                bizbill.set("bookdate", row.get("bookdate"));
                delBizBillDycs.add(bizbill);
            }
        }
        return delBizBillDycs;
    }
}

