/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.helper;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mutex.DataMutex;

public class VoucherCalMutexHelper {
    public static void batchReleaseVoucherCalMutex(List<Map<String, Object>> mutexReleaseList) {
        try (DataMutex dataMutex = DataMutex.create();){
            dataMutex.batchRelease(mutexReleaseList);
        }
        catch (IOException e) {
            String content = String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519%1$s", (String)"VoucherCalMutexHelper_4", (String)"fi-cal-common", (Object[])new Object[0]), e.getMessage());
            throw new KDException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", content), new Object[0]);
        }
    }

    public static Map<String, Set<Long>> batchRequireVoucherCalMutex(List<Map<String, Object>> mutexRequireList, Map<Long, Set<ExtendedDataEntity>> entityMap) {
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>();
        HashSet<Long> errorSet = new HashSet<Long>();
        try (DataMutex dataMutex = DataMutex.create();){
            Map batchrequire = dataMutex.batchrequire(mutexRequireList);
            for (Map.Entry map : batchrequire.entrySet()) {
                if (((Boolean)map.getValue()).booleanValue()) continue;
                Long key = Long.valueOf((String)map.getKey());
                Set<ExtendedDataEntity> entitySets = entityMap.get(key);
                for (ExtendedDataEntity entity : entitySets) {
                    String opkey;
                    DynamicObject costRecord = entity.getDataEntity();
                    String objId = costRecord.get("bizbillid").toString();
                    DynamicObject entityDyc = costRecord.getDynamicObject("bizentityobject");
                    String entityKey = "";
                    entityKey = entityDyc == null ? costRecord.getString("bizentityobject_id") : (String)entityDyc.getPkValue();
                    Map lockInfo = new HashMap();
                    lockInfo = dataMutex.getLockInfo(objId, "default_netctrl", entityKey);
                    if (lockInfo != null && lockInfo.size() > 0 && !StringUtils.isBlank((CharSequence)(opkey = (String)lockInfo.get("opkey"))) && "generatevoucher".equals(opkey)) continue;
                    errorSet.add(key);
                }
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:", (String)"VoucherCalMutexHelper_2", (String)"fi-cal-common", (Object[])new Object[0]) + e.getMessage()), new Object[0]);
        }
        resultMap.put("error", errorSet);
        return resultMap;
    }
}

