/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.lock;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.service.LivingServiceUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.lock.IBatchLock;
import kd.fi.cal.common.util.DateUtils;

public class DbBatchLock
implements AutoCloseable,
IBatchLock {
    private static final Log logger = LogFactory.getLog(DbBatchLock.class);
    private final int DEL_BATCH = 10000;
    private String oprationKey = "kd.fi.cal.common.helper.DbLockHelper";
    private Set<String> allLockSucessKeys = new HashSet<String>(16);
    private Map<Object, String> lockFailIdMsgMap = new HashMap<Object, String>(16);
    private int expireTime = 15;
    private Set<String> lockKeys = new HashSet<String>(16);
    private String appId = "cal";
    private static String DB_LOCK_LASTAUTOCLEARTIME = "DB_LOCK_LASTAUTOCLEARTIME";
    private boolean isCheckAlive = CalDbParamServiceHelper.getBoolean(CalDbParamConstant.REDIS_CHECK_ALIVE);
    private final String errorMsgFmt = ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c%1$s\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"RedisBatchLock_1", (String)"fi-cal-common", (Object[])new Object[0]);
    private static final String INSERT_SQL = "insert into t_cal_db_lock (fid,flockop,flocktime,finstanceid) VALUES (?,?,?,?)";

    public DbBatchLock() {
    }

    public DbBatchLock(String oprationKey, int expireTime) {
        this.oprationKey = oprationKey;
        this.expireTime = expireTime;
    }

    public DbBatchLock(String opKey) {
        this.oprationKey = opKey;
    }

    @Override
    public void lock() {
        this.getDbLock();
    }

    public void unlock(Set<String> lockKeyStrs) {
        if (lockKeyStrs.isEmpty()) {
            return;
        }
        this.releaseDbLock(lockKeyStrs);
    }

    @Override
    public void unlock() {
        this.releaseDbLock(this.allLockSucessKeys);
        this.autoUnlock();
    }

    private void autoUnlock() {
        IAppCache cache = AppCache.get((String)this.appId);
        Date curDate = TimeServiceHelper.now();
        long curTime = curDate.getTime();
        Long lastAutoClearTime = (Long)cache.get(DB_LOCK_LASTAUTOCLEARTIME, Long.class);
        if (lastAutoClearTime == null) {
            cache.put(DB_LOCK_LASTAUTOCLEARTIME, (Object)curTime);
            return;
        }
        boolean isExpire = this.isExpire(curTime, lastAutoClearTime);
        if (!isExpire) {
            return;
        }
        Date date = DateUtils.addDateTime(curDate, 12, 0 - this.expireTime);
        QFilter lockTimeF = new QFilter("locktime", "<=", (Object)date);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_db_lock", (String)"id,lockop,locktime,instanceid", (QFilter[])lockTimeF.toArray(), null);
        HashSet<String> expireLockKeys = new HashSet<String>(16);
        for (Row row : dataSet) {
            String curLockKey = row.getString("id");
            Date curLockTimeDate = row.getDate("locktime");
            long curLockTime = curLockTimeDate.getTime();
            boolean expire = this.isExpire(curTime, curLockTime);
            if (!expire) continue;
            expireLockKeys.add(curLockKey);
        }
        this.releaseDbLock(expireLockKeys);
        cache.put(DB_LOCK_LASTAUTOCLEARTIME, (Object)curTime);
    }

    public int getExpireTime() {
        return this.expireTime;
    }

    @Override
    public void setExpireTime(int lockWait) {
        this.expireTime = lockWait;
    }

    @Override
    public void close() {
        this.unlock();
    }

    private boolean isExpire(long curTime, Long lockTime) {
        if (lockTime == null) {
            return true;
        }
        return (curTime - lockTime) / 1000L / 60L >= (long)this.expireTime;
    }

    @Override
    public void setLockKeys(Set<String> lockKeys) {
        this.lockKeys = lockKeys;
    }

    @Override
    public Map<Object, String> getLockFailIdMsgMap() {
        return this.lockFailIdMsgMap;
    }

    private void getDbLock() {
        boolean twoLockSucess;
        Set<String> needLockKeys = this.lockKeys;
        boolean oneLockSuccess = this.tryLock(needLockKeys = this.removeHasLockKeys(needLockKeys));
        if (!oneLockSuccess && !(twoLockSucess = this.tryLock(needLockKeys = this.removeHasLockKeys(needLockKeys)))) {
            for (String needLockKey : needLockKeys) {
                this.lockFailIdMsgMap.putIfAbsent(needLockKey, String.format(this.errorMsgFmt, ""));
            }
        }
    }

    private boolean tryLock(Set<String> needLockKeys) {
        if (needLockKeys.isEmpty()) {
            return true;
        }
        boolean lockSucess = false;
        Date curTime = TimeServiceHelper.now();
        try (TXHandle tx = TX.requiresNew();){
            ArrayList<String> needLockKeysList = new ArrayList<String>(needLockKeys);
            Collections.sort(needLockKeysList);
            ArrayList<Object[]> params = new ArrayList<Object[]>(16);
            for (String lockKey : needLockKeysList) {
                params.add(new Object[]{lockKey, this.oprationKey, curTime, Instance.getInstanceId()});
            }
            DB.executeBatch((DBRoute)new DBRoute("cal"), (String)INSERT_SQL, params);
            this.allLockSucessKeys.addAll(needLockKeys);
            lockSucess = true;
        }
        catch (Throwable e) {
            logger.info("DbBatchLock-\u5c1d\u8bd5\u52a0\u9501\u5931\u8d25==>{}", (Object)e.getMessage());
        }
        return lockSucess;
    }

    private Set<String> removeHasLockKeys(Set<String> needLockKeys) {
        if (needLockKeys.isEmpty()) {
            return needLockKeys;
        }
        QFilter keyF = new QFilter("id", "in", needLockKeys);
        String selectFields = "id,lockop,locktime,instanceid";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_db_lock", (String)selectFields, (QFilter[])keyF.toArray(), null);
        long curTime = TimeServiceHelper.now().getTime();
        HashSet<String> expireKeys = new HashSet<String>(16);
        for (Row row : dataSet) {
            boolean isCurLockSucess;
            String curLockKey = row.getString("id");
            Date curLockTimeDate = row.getDate("locktime");
            String instanceId = row.getString("instanceId");
            String curLockOp = row.getString("lockop");
            long curLockTime = curLockTimeDate.getTime();
            boolean bl = isCurLockSucess = this.isExpire(curTime, curLockTime) || this.isCheckAlive && StringUtils.isNotEmpty((CharSequence)instanceId) && !LivingServiceUtils.isInstanceAlive((String)instanceId);
            if (isCurLockSucess) {
                expireKeys.add(curLockKey);
                continue;
            }
            ActionEnum actionEnum = ActionEnum.getEnum(curLockOp);
            String mutOpName = "";
            if (actionEnum != null) {
                mutOpName = actionEnum.getDesc();
            }
            this.lockFailIdMsgMap.put(curLockKey, String.format(this.errorMsgFmt, mutOpName));
        }
        needLockKeys.removeAll(this.lockFailIdMsgMap.keySet());
        this.releaseDbLock(expireKeys);
        return needLockKeys;
    }

    private void releaseDbLock(Set<String> expireKeys) {
        if (expireKeys.size() < 1) {
            return;
        }
        ArrayList<String> expireKeysList = new ArrayList<String>(expireKeys);
        Lists.partition(expireKeysList, (int)10000).forEach(tmpList -> {
            try (TXHandle tx = TX.requiresNew();){
                Collections.sort(tmpList);
                QFilter delIdF = new QFilter("id", "in", tmpList);
                DeleteServiceHelper.delete((String)"cal_db_lock", (QFilter[])delIdF.toArray());
            }
        });
    }
}

