/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.fi.cal.common.metadata.Element;

public class EntryElement
extends Element {
    private static final long serialVersionUID = 22L;
    private List<Element> items = new ArrayList<Element>();
    private String entity;
    private transient IFormView view;

    public EntryElement(String name, String entity) {
        super(name);
        this.entity = entity;
    }

    private EntryAp getEntryAp() {
        EntryAp entryAp = (EntryAp)ThreadCache.get((Object)"calinentryap");
        ArrayList entryApItems = (ArrayList)ThreadCache.get((Object)"entryapitems");
        if (entryAp == null) {
            String entityId = MetadataDao.getIdByNumber((String)this.entity, (MetaCategory)MetaCategory.Entity);
            FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
            EntityMetadata entitymeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            formmeta.bindEntityMetadata(entitymeta);
            for (ControlAp ap : formmeta.getItems()) {
                if (!StringUtils.equals((CharSequence)ap.getKey(), (CharSequence)"entryentity")) continue;
                entryAp = (EntryAp)ap;
                entryApItems = new ArrayList(entryAp.getItems());
                ThreadCache.put((Object)"calinentryap", (Object)entryAp);
                ThreadCache.put((Object)"entryapitems", entryApItems);
                break;
            }
        }
        if (entryAp == null) {
            entryAp = new EntryAp();
        }
        entryAp.setKey("entryap");
        entryAp.getItems().clear();
        entryAp.getItems().addAll(entryApItems);
        List<Element> items = this.getItems();
        for (Element item : items) {
            FieldAp entryFieldAp = item.getFieldAp();
            entryAp.getItems().add(entryFieldAp);
        }
        entryAp.setShowSeq(true);
        return entryAp;
    }

    public void setItems(List<Element> items) {
        this.items = items;
        for (Element item : items) {
            item.parentName = this.name;
        }
    }

    public List<Element> getItems() {
        return this.items;
    }

    public void build(IFormView view) {
        this.view = view;
        this.regPropAndEdit();
        this.regField();
    }

    @Override
    public void registerEntryProp(EntryType entryType) {
        List<Element> items = this.getItems();
        for (Element item : items) {
            item.registerEntryProp(entryType);
        }
    }

    public EntryGrid getControl(IFormView view) {
        EntryGrid gg = (EntryGrid)this.getEntryAp().buildRuntimeControl();
        gg.setKey(this.name);
        gg.setEntryKey(this.name);
        gg.setView(view);
        gg.setModel(view.getModel());
        List items = gg.getItems();
        for (Control item : items) {
            item.setView(view);
            ((FieldEdit)item).getProperty();
        }
        return gg;
    }

    private void regPropAndEdit() {
        MainEntityType mainEntityType = this.view.getModel().getDataEntityType();
        EntryType entryType = (EntryType)mainEntityType.getAllEntities().get(this.name);
        this.registerEntryProp(entryType);
        this.registerEntryEdit((EntryGrid)this.view.getControl(this.name), this.view);
    }

    public void registerEntryEdit(EntryGrid entryGrid, IFormView view) {
        EntryAp entryAp = this.getEntryAp();
        List items = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control item : items) {
            item.setView(view);
            entryGrid.getItems().add(item);
        }
    }

    private void regField() {
        EntryAp ap = this.getEntryAp();
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", this.name);
        mapEntry.put("columns", (String)ap.createControl().get("columns"));
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod(this.name, "createGridColumns", new Object[]{mapEntry});
        this.view.updateView(this.name);
    }
}

