/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.model;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CalSpDimension {
    private Long costAccountId;
    private Map<String, String> spMaterialCaldimension = new HashMap<String, String>();
    private Map<String, String> spMGroupCaldimension = new HashMap<String, String>();

    public CalSpDimension(Long costAccountId) {
        if (costAccountId == null || costAccountId == 0L || costAccountId == 0L) {
            return;
        }
        this.costAccountId = costAccountId;
        this.initSpCaldimension();
    }

    private void initSpCaldimension() {
        QFilter filter = new QFilter("calrange.costaccount.id", "=", (Object)this.costAccountId);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        Map caldimensionMap = BusinessDataServiceHelper.loadFromCache((String)"cal_bd_materialdimension", (QFilter[])filter.toArray());
        for (DynamicObject caldimensionMapObj : caldimensionMap.values()) {
            Object calRangeId = caldimensionMapObj.getDynamicObject("calrange").getPkValue();
            for (DynamicObject entry : caldimensionMapObj.getDynamicObjectCollection("entry")) {
                DynamicObject caldimension = entry.getDynamicObject("caldimension");
                DynamicObject material = entry.getDynamicObject("material");
                if (material != null) {
                    this.spMaterialCaldimension.put(calRangeId + "_" + material.getPkValue(), caldimension.getPkValue() + "@" + caldimension.getString("caldimension"));
                    continue;
                }
                DynamicObject mGroup = entry.getDynamicObject("materialgroup");
                this.spMGroupCaldimension.put(calRangeId + "_" + mGroup.getString("longnumber"), caldimension.getPkValue() + "@" + caldimension.getString("caldimension"));
            }
        }
    }

    public String getSpCaldimension(String calRangeId, String materialId, String mGroupNo) {
        String caldimension = this.spMaterialCaldimension.get(calRangeId + "_" + materialId);
        if (caldimension == null) {
            if (mGroupNo == null) {
                return null;
            }
            int beforeLongNoLenth = 0;
            for (Map.Entry<String, String> entry : this.spMGroupCaldimension.entrySet()) {
                String[] key = entry.getKey().split("_");
                if (!calRangeId.equals(key[0]) || !mGroupNo.startsWith(key[1]) || beforeLongNoLenth >= key[1].length()) continue;
                caldimension = entry.getValue();
                beforeLongNoLenth = key[1].length();
            }
        }
        return caldimension;
    }
}

