/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class BatchExcuteHelper {
    private static final Log logger = LogFactory.getLog(BatchExcuteHelper.class);

    public static DynamicObject[] batchSave(List<DynamicObject> objects, int batchSize, int threadNum) {
        DynamicObject[] infos = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])objects.toArray(new DynamicObject[0]));
        return infos;
    }

    public static OperationResult batchOperationexecuteOperate(String operationKey, String entityNumber, DynamicObject[] dataEntities, OperateOption option, int batchSize, int threadNum) {
        OperationResult operResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)option);
        return operResult;
    }

    public static void batchDelete(String entity, QFilter filter, int batchSize, boolean newTx) {
        logger.info("\u5206\u6279\u5220\u9664-\u5f00\u59cb->{}-{}-{}", new Object[]{entity, filter, batchSize});
        DataSet ds = QueryServiceHelper.queryDataSet((String)BatchExcuteHelper.class.getName(), (String)entity, (String)"id", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Object> ids = new HashSet<Object>(16);
        int size = batchSize <= 0 ? Integer.MAX_VALUE : batchSize;
        for (Row row : ds) {
            ids.add(row.get("id"));
            if (ids.size() < size) continue;
            BatchExcuteHelper.deleteByIds(entity, ids, newTx);
            ids = new HashSet(16);
        }
        if (ids.size() > 0) {
            BatchExcuteHelper.deleteByIds(entity, ids, newTx);
        }
        logger.info("\u5206\u6279\u5220\u9664-\u7ed3\u675f");
    }

    private static void deleteByIds(String entity, Set<Object> ids, boolean newTx) {
        block25: {
            try (TraceSpan span = Tracer.create((String)("deleteByIds-" + entity + "-" + ids.size()), (String)("deleteByIds-" + ids.size()));){
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
                if (newTx) {
                    try (TXHandle txHandle = TX.requiresNew();){
                        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])ids.toArray());
                        break block25;
                    }
                }
                DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])ids.toArray());
            }
        }
    }
}

