/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class CommonUtils {
    private static final Log logger = LogFactory.getLog(CommonUtils.class);

    public static String getUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String createEXPBillNo(int seqno) {
        return "EXP-" + String.valueOf(System.currentTimeMillis()).substring(2) + seqno;
    }

    public static boolean isNull4List(List list) {
        return list == null || list.isEmpty();
    }

    public static String getCodeErrorMessage(ErrorCode errorCode) {
        KDException kde = new KDException(errorCode, new Object[0]);
        return kde.getMessage();
    }

    public static String getCodeErrorMessage(ErrorCode errorCode, Object ... args) {
        KDException kde = new KDException(errorCode, args);
        return kde.getMessage();
    }

    public static List<Long> getIdList(DynamicObjectCollection colls) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject obj : colls) {
            idList.add(obj.getLong("id"));
        }
        return idList;
    }

    public static DBRoute getCalDBRouteKey() {
        return new DBRoute("cal");
    }

    public static DBRoute getScmDBRouteKey() {
        return new DBRoute("scm");
    }

    public static boolean isSetEqual(Set set1, Set set2) {
        if (set1 == null && set2 == null) {
            return true;
        }
        if (set1 == null || set2 == null || set1.size() != set2.size() || set1.size() == 0 || set2.size() == 0) {
            return false;
        }
        Iterator ite2 = set2.iterator();
        boolean isFullEqual = true;
        while (ite2.hasNext()) {
            if (set1.contains(ite2.next())) continue;
            isFullEqual = false;
        }
        return isFullEqual;
    }

    public static String trimComma(String dividebasis) {
        if (dividebasis.startsWith(",") || dividebasis.startsWith("\uff0c")) {
            dividebasis = dividebasis.substring(1, dividebasis.length());
        }
        if (dividebasis.endsWith(",") || dividebasis.endsWith("\uff0c")) {
            dividebasis = dividebasis.substring(0, dividebasis.length() - 1);
        }
        return dividebasis;
    }

    public static String trimBySign(String dividebasis, String sign) {
        if (dividebasis.startsWith(sign)) {
            dividebasis = dividebasis.substring(1, dividebasis.length());
        }
        if (dividebasis.endsWith(sign)) {
            dividebasis = dividebasis.substring(0, dividebasis.length() - 1);
        }
        return dividebasis;
    }

    public static String getMaterialGroupSplit() {
        String split = (String)AppCache.get((String)"cal").get("cal_materialgroup_split", String.class);
        if (StringUtils.isEmpty((String)split)) {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"bd_materialgroup");
            ParentBasedataProp prop = (ParentBasedataProp)type.findProperty("parent");
            split = prop.getLongNumberDLM();
            if (".".equals(split)) {
                split = "\\.";
            }
            AppCache.get((String)"cal").put("cal_materialgroup_split", (Object)split);
        }
        if (StringUtils.isEmpty((String)split)) {
            return "\\.";
        }
        return split;
    }

    public static String getLogMessage(Throwable e) {
        return CommonUtils.getLogMessage(e, 500);
    }

    public static String getLogMessage(Throwable e, int maxLength) {
        String message = "";
        if (e instanceof KDBizException) {
            if (e.getMessage() != null) {
                message = e.getMessage();
            }
        } else if (e instanceof Exception) {
            message = ExceptionUtils.getExceptionStackTraceMessage((Exception)((Exception)e));
        } else {
            message = e.getMessage();
            logger.error("message=" + message, e);
        }
        if (maxLength > 0 && message.length() > maxLength) {
            message = message.substring(0, maxLength);
        }
        return message;
    }

    public static Set<Long> getMaterialIdsByMatGroups(Set<String> matGroupLongNums, long materialGroupStandardId) {
        HashSet<Long> materialIds = new HashSet<Long>(1024);
        QFilter q1 = new QFilter("group.longnumber", "in", matGroupLongNums);
        String splitSign = CommonUtils.getMaterialGroupSplit();
        for (String longNum : matGroupLongNums) {
            q1.or("group.longnumber", "like", (Object)(longNum + splitSign + "%"));
        }
        QFilter q = new QFilter("standard", "=", (Object)materialGroupStandardId);
        q.and(q1);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.common.util.CommonUtils", (String)"bd_materialgroupdetail", (String)"material", (QFilter[])q.toArray(), null);){
            for (Row row : dataSet) {
                materialIds.add(row.getLong("material"));
            }
        }
        return materialIds;
    }

    public static List<List<Object[]>> getSplitList(List<Object[]> list) {
        int batchNum = CalDbParamServiceHelper.getInteger(CalDbParamConstant.COMMON_SPLITBATCHNUM);
        int i = 0;
        ArrayList<List<Object[]>> allList = new ArrayList<List<Object[]>>(list.size() / batchNum + 1);
        ArrayList<Object[]> splitList = new ArrayList<Object[]>(list.size() > batchNum ? batchNum : list.size());
        allList.add(splitList);
        for (Object[] datas : list) {
            if (i < batchNum) {
                splitList.add(datas);
            } else {
                splitList = new ArrayList(batchNum);
                splitList.add(datas);
                allList.add(splitList);
                i = 0;
            }
            ++i;
        }
        return allList;
    }

    public static List<Set<DynamicObject>> getSplitDynList(Set<DynamicObject> set) {
        int batchNum = CalDbParamServiceHelper.getInteger(CalDbParamConstant.COMMON_SPLITBATCHNUM);
        int i = 0;
        ArrayList<Set<DynamicObject>> allList = new ArrayList<Set<DynamicObject>>(set.size() / batchNum + 1);
        HashSet<DynamicObject> splitSet = new HashSet<DynamicObject>(set.size() > batchNum ? batchNum : set.size());
        allList.add(splitSet);
        for (DynamicObject data : set) {
            if (i < batchNum) {
                splitSet.add(data);
            } else {
                splitSet = new HashSet(batchNum);
                splitSet.add(data);
                allList.add(splitSet);
                i = 0;
            }
            ++i;
        }
        return allList;
    }

    public static List<Set<Long>> getSplitList(Set<Long> set) {
        int batchNum = CalDbParamServiceHelper.getInteger(CalDbParamConstant.COMMON_SPLITBATCHNUM);
        int i = 0;
        ArrayList<Set<Long>> allList = new ArrayList<Set<Long>>(set.size() / batchNum + 1);
        HashSet<Long> splitSet = new HashSet<Long>(set.size() > batchNum ? batchNum : set.size());
        allList.add(splitSet);
        for (Long data : set) {
            if (i < batchNum) {
                splitSet.add(data);
            } else {
                splitSet = new HashSet(batchNum);
                splitSet.add(data);
                allList.add(splitSet);
                i = 0;
            }
            ++i;
        }
        return allList;
    }

    public static String getAllFields(String entityName) {
        StringBuilder fields = new StringBuilder();
        MainEntityType calEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        Set selectorsSet = calEntityType.getAllFields().keySet();
        for (String o : selectorsSet) {
            fields.append(o).append(',');
        }
        return fields.substring(0, fields.length() - 1);
    }

    public static String getFieldPath(String entity, String field) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        IDataEntityProperty property = entityType.findProperty(field);
        if (property == null) {
            String msg = ResManager.loadKDString((String)"\u201c%1$s(%2$s)\u201d\u672a\u6269\u5c55\u201c%3$s\u201d\u5b57\u6bb5\uff0c\u8bf7\u53c2\u8003\u793e\u533a\u6587\u6863\u201c\u6838\u7b97\u589e\u52a0\u4e8c\u5f00\u5b57\u6bb5\u201d\u5904\u7406\u3002", (String)"BalanceDimFieldParser_0", (String)"fi-cal-business", (Object[])new Object[0]);
            msg = String.format(msg, entityType.getDisplayName(), entityType.getName(), field);
            throw new KDBizException(msg);
        }
        return CommonUtils.getFieldPath(field, property.getParent());
    }

    public static String getFieldPath(String field, IDataEntityType parentProp) {
        if (parentProp instanceof EntryType) {
            field = parentProp.getName() + "." + field;
            return CommonUtils.getFieldPath(field, parentProp.getParent());
        }
        return field;
    }

    public static String getSelectFieldByEntity(String entityNum, String[] fields) {
        StringBuilder selectFieldBuilder = new StringBuilder();
        MainEntityType entitytype = EntityMetadataCache.getDataEntityType((String)entityNum);
        for (String field : fields) {
            IDataEntityProperty fieldProperty = entitytype.findProperty(field);
            if (fieldProperty == null) continue;
            if (fieldProperty.getParent() instanceof EntryType) {
                selectFieldBuilder.append(fieldProperty.getParent().getName());
                selectFieldBuilder.append('.');
                selectFieldBuilder.append(field);
                selectFieldBuilder.append(" as ");
            }
            selectFieldBuilder.append(field);
            selectFieldBuilder.append(',');
        }
        return CommonUtils.trimComma(selectFieldBuilder.toString());
    }

    public static String getOpErrorMsg(OperationResult opResult) {
        String errorMsg = "";
        List errors = opResult.getAllErrorOrValidateInfo();
        if (!opResult.isSuccess()) {
            StringBuilder msg = new StringBuilder();
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                msg.append(operror.getMessage()).append('\n');
            }
            msg.append(opResult.getMessage()).append('\n');
            errorMsg = msg.toString();
        }
        return errorMsg;
    }

    public static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException(String.format("getSHA256Base64Str:[%s] args:[%s]", e.getMessage(), message));
        }
    }

    public static Long getBaseId(DynamicObject info, String baseIdKey) {
        Long baseId = info.getLong(baseIdKey + "_id");
        Object baseIdObj = info.get(baseIdKey);
        if (baseIdObj instanceof Long && !baseIdObj.equals(0L)) {
            baseId = (Long)baseIdObj;
        }
        return baseId;
    }
}

