/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class DateUtils {
    private static final Log logger = LogFactory.getLog(DateUtils.class);

    public static Date getThisMonthFirstDay() {
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        return c.getTime();
    }

    public static Date getThisMonthEndDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        return ca.getTime();
    }

    public static Date getDayEndTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        return calendar.getTime();
    }

    public static Date getDayStartTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static synchronized Date getCurrentSystemDate() {
        Date date = null;
        try {
            Calendar ca = Calendar.getInstance();
            Date time = ca.getTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = sdf.parse(sdf.format(time));
        }
        catch (ParseException e) {
            logger.error("DateUtils getCurrentSystemDate", (Throwable)e);
        }
        return date;
    }

    public static boolean compareDate(Date beginTime, Date endTime) {
        boolean result = true;
        result = !beginTime.before(endTime);
        return result;
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = (int)(diff + 1L);
        return days;
    }

    public static Date getDateByInt(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second) {
        GregorianCalendar invaliddateCalendar = new GregorianCalendar(year, month, dayOfMonth, hourOfDay, minute, second);
        return invaliddateCalendar.getTime();
    }

    public static Date addDateTime(Date date, int timeDIm, int size) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(timeDIm, size);
        return calendar.getTime();
    }

    public static boolean isTheSameDay(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        return c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5);
    }

    public static int getIntByDate(Date date, int model) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(model);
    }

    public static String getNowTimeStr() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date nowTime = TimeServiceHelper.now();
        String nowTimeStr = sdf.format(nowTime);
        return nowTimeStr;
    }

    public static List<QFilter> getDateSplitFilters(Date startdate, Date enddate, String dateField) {
        return DateUtils.getDateSplitFilters(startdate, enddate, dateField, true);
    }

    public static List<QFilter> getDateSplitFilters(Date startdate, Date enddate, String dateField, boolean containsRight) {
        int dateSplitBatch = CalDbParamServiceHelper.getInteger("costprice_bookdate_split_size");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        if (startdate == null && enddate == null) {
            filters.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
            return filters;
        }
        if (startdate == null && enddate != null) {
            if (containsRight) {
                filters.add(new QFilter(dateField, "<=", (Object)enddate));
            } else {
                filters.add(new QFilter(dateField, "<", (Object)enddate));
            }
            return filters;
        }
        if (startdate != null && enddate == null) {
            filters.add(new QFilter(dateField, ">=", (Object)startdate));
            return filters;
        }
        int diffDay = DateUtils.getDiffDays(startdate, enddate);
        int batchDiffDays = diffDay / dateSplitBatch + 1;
        for (int i = 0; i < dateSplitBatch; ++i) {
            QFilter curFilter = new QFilter(dateField, ">=", (Object)startdate);
            filters.add(curFilter);
            Date curEndDate = DateUtils.addDateTime(startdate, 5, batchDiffDays);
            if (i == dateSplitBatch - 1 || curEndDate.compareTo(enddate) >= 0) {
                curEndDate = enddate;
                if (containsRight) {
                    curFilter.and(new QFilter(dateField, "<=", (Object)curEndDate));
                    break;
                }
                curFilter.and(new QFilter(dateField, "<", (Object)curEndDate));
                break;
            }
            curFilter.and(new QFilter(dateField, "<", (Object)curEndDate));
            startdate = curEndDate;
        }
        return filters;
    }

    public static List<Object[]> getDateSpitFilters(Date srcStartDate, Date srcEndDate, int splitBookdateDay) {
        ArrayList<Object[]> startDateEndDateList = new ArrayList<Object[]>(16);
        Date startDate = srcStartDate;
        Date nowDate = srcEndDate;
        int diffDay = DateUtils.getDiffDays(startDate, nowDate);
        int batch = diffDay / splitBookdateDay;
        if (batch == 0) {
            batch = 1;
        }
        for (int i = 0; i < batch; ++i) {
            Date curEndDate = DateUtils.addDateTime(startDate, 5, splitBookdateDay);
            if (i == batch - 1) {
                curEndDate = nowDate;
            }
            curEndDate = DateUtils.getDayEndTime(curEndDate);
            startDateEndDateList.add(new Object[]{startDate, curEndDate});
            startDate = curEndDate;
        }
        return startDateEndDateList;
    }

    public static List<Date[]> getSplitDate(Date startDate, int splitDay) {
        return DateUtils.getSplitDate(startDate, TimeServiceHelper.now(), splitDay, true);
    }

    public static List<Date[]> getSplitDate(Date startDate, Date endDate, int splitDay, boolean containsAfter) {
        if (startDate.compareTo(endDate) >= 0) {
            if (containsAfter) {
                return Collections.singletonList(new Date[]{startDate, null});
            }
            return Collections.singletonList(new Date[]{startDate, endDate});
        }
        ArrayList<Date[]> dates = new ArrayList<Date[]>(4);
        while (startDate.before(endDate)) {
            Date curEndate = DateUtils.addDateTime(startDate, 5, splitDay);
            if (curEndate.before(endDate)) {
                dates.add(new Date[]{startDate, curEndate});
            } else {
                dates.add(new Date[]{startDate, endDate});
            }
            startDate = curEndate;
        }
        if (containsAfter) {
            dates.add(new Date[]{endDate, null});
        }
        return dates;
    }
}

