/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;

public class DynamicObjectUtils {
    public static void copyProperties(DynamicObject toObj, DynamicObject fromObj, String ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        int len = keys.length;
        for (int i = 0; i < len; ++i) {
            toObj.set(keys[i], fromObj.get(keys[i]));
        }
    }

    public static void copyProperties(DynamicObject fromObj, DynamicObject toObj, Map propMap) {
        Iterator iteator = propMap.keySet().iterator();
        while (iteator.hasNext()) {
            String fromProp = iteator.next().toString();
            String toProp = propMap.get(fromProp).toString();
            toObj.set(toProp, fromObj.get(fromProp));
        }
    }

    public static void copyProperties(DynamicObject toObj, DynamicObject fromObj, Set<String> ignoreKeys, Map<String, String> convertKeysMap, boolean needCopyId) {
        DataEntityPropertyCollection toPs = toObj.getDataEntityType().getProperties();
        DataEntityPropertyCollection fromPs = fromObj.getDataEntityType().getProperties();
        HashSet<String> fromPsSet = new HashSet<String>(fromPs.size());
        for (IDataEntityProperty dp : fromPs) {
            fromPsSet.add(dp.getName());
        }
        if (ignoreKeys == null) {
            ignoreKeys = new HashSet<String>();
        }
        if (!needCopyId) {
            ignoreKeys.add("id");
        }
        String toKey = null;
        String fromKey = null;
        int len = toPs.size();
        for (int i = 0; i < len; ++i) {
            String value;
            toKey = ((IDataEntityProperty)toPs.get(i)).getName();
            if (ignoreKeys.contains(toKey)) continue;
            fromKey = convertKeysMap != null ? ((value = convertKeysMap.get(toKey)) != null ? value : toKey) : toKey;
            if (!fromPsSet.contains(fromKey)) continue;
            toObj.set(toKey, fromObj.get(fromKey));
        }
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj) {
        DynamicObjectUtils.copy(fromObj, toObj, null, null);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys) {
        DynamicObjectUtils.copy(fromObj, toObj, ignoreKeys, null);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Map<String, String> transKeyMap) {
        DynamicObjectUtils.copy(fromObj, toObj, null, transKeyMap);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        if (fromObj == null || toObj == null) {
            return;
        }
        DataEntityPropertyCollection fromPros = fromObj.getDataEntityType().getProperties();
        if (fromPros == null || fromPros.size() == 0) {
            return;
        }
        DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
        if (toPros == null || toPros.size() == 0) {
            return;
        }
        HashSet<String> fromPsSet = new HashSet<String>(fromPros.size());
        for (Object pro : fromPros) {
            fromPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        HashSet<String> toPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : toPros) {
            toPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        ISimpleProperty primaryKeyObj = toObj.getDataEntityType().getPrimaryKey();
        String primaryKey = "";
        if (primaryKeyObj != null) {
            primaryKey = primaryKeyObj.getName();
        }
        for (IDataEntityProperty pro : toPros) {
            Object value;
            String toProName;
            String fromProName = toProName = pro.getName();
            if (transKeyMap != null) {
                value = transKeyMap.get(fromProName);
                if (value != null) {
                    toProName = value;
                }
            } else if (ignoreKeys != null && ignoreKeys.contains(toProName)) continue;
            if (!fromPsSet.contains(fromProName) || !toPsSet.contains(toProName)) continue;
            if (toProName.equals(primaryKey)) {
                toObj.set(toProName, null);
                continue;
            }
            value = fromObj.get(fromProName);
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
                DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toProName);
                if (toEntity != null) {
                    toEntity.clear();
                    DynamicObjectType entityType = toEntity.getDynamicObjectType();
                    for (DynamicObject baseEntry : formEntity) {
                        DynamicObject newEntry = new DynamicObject(entityType);
                        DynamicObjectUtils.copy(baseEntry, newEntry, ignoreKeys, transKeyMap);
                        toEntity.add((Object)newEntry);
                    }
                }
                toObj.set(toProName, (Object)toEntity);
                continue;
            }
            toObj.set(toProName, value);
        }
    }

    public static List<Map<String, Object>> dycsToMaps(DynamicObject[] dycs, Set<String> noEntryFieldKeys, String ... deepEntryKeys) {
        ArrayList<Map<String, Object>> billFieldValueMaps = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject dyc : dycs) {
            Map<String, Object> billFieldValueMap = DynamicObjectUtils.dycToMap(dyc, noEntryFieldKeys, deepEntryKeys);
            billFieldValueMaps.add(billFieldValueMap);
        }
        return billFieldValueMaps;
    }

    public static Map<String, Object> dycToMap(DynamicObject dyc, Set<String> noEntryFieldKeys, String ... deepEntryKeys) {
        HashMap<String, Object> billFieldValueMap = new HashMap<String, Object>(16);
        if (dyc == null) {
            return billFieldValueMap;
        }
        String entity = dyc.getDataEntityType().getName();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        HashMap<String, Object> billFieldKeyValueMap = new HashMap<String, Object>(16);
        DataEntityPropertyCollection properties = entityType.getProperties();
        for (String noEntryFieldKey : noEntryFieldKeys) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)noEntryFieldKey);
            if (property == null) continue;
            Object objValue = dyc.get(noEntryFieldKey);
            if (objValue instanceof DynamicObject) {
                objValue = ((DynamicObject)objValue).getPkValue();
            } else if (property instanceof DateTimeProp) {
                objValue = objValue == null ? null : Long.valueOf(((Date)objValue).getTime());
            }
            billFieldKeyValueMap.put(noEntryFieldKey, objValue);
        }
        for (String deepEntryKey : deepEntryKeys) {
            IDataEntityType deepEntryType = (IDataEntityType)entityType.getAllEntities().get(deepEntryKey);
            ArrayList<String> entryKeys = new ArrayList<String>(16);
            DynamicObjectUtils.getEntryKeys(deepEntryType, entryKeys, entity);
            DynamicObjectUtils.buildEntryMap(noEntryFieldKeys, entityType, dyc, billFieldKeyValueMap, entryKeys, 0);
        }
        return billFieldKeyValueMap;
    }

    public static DynamicObject[] mapsToDycs(List<Map<String, Object>> billFieldValueMaps, String entity, Set<String> noEntryFieldKeys, String ... deepEntryKeys) {
        ArrayList<DynamicObject> billDycs = new ArrayList<DynamicObject>(16);
        for (Map<String, Object> billFieldValueMap : billFieldValueMaps) {
            DynamicObject billDyc = DynamicObjectUtils.mapToDyc(billFieldValueMap, entity, noEntryFieldKeys, deepEntryKeys);
            if (billDyc == null) continue;
            billDycs.add(billDyc);
        }
        return billDycs.toArray(new DynamicObject[0]);
    }

    public static DynamicObject mapToDyc(Map<String, Object> billFieldValueMap, String entity, Set<String> noEntryFieldKeys, String ... deepEntryKeys) {
        if (billFieldValueMap == null || billFieldValueMap.isEmpty()) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)entity, noEntryFieldKeys);
        DynamicObject billDyc = new DynamicObject(subDataEntityType);
        DataEntityPropertyCollection properties = entityType.getProperties();
        for (Map.Entry<String, Object> fieldValueEntry : billFieldValueMap.entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)fieldValueEntry.getKey());
            if (property == null || property instanceof EntryProp) continue;
            Object objValue = fieldValueEntry.getValue();
            if (property instanceof DateTimeProp) {
                objValue = objValue == null ? null : new Date((Long)objValue);
            }
            billDyc.set(fieldValueEntry.getKey(), objValue);
        }
        for (String deepEntryKey : deepEntryKeys) {
            IDataEntityType deepEntryType = (IDataEntityType)entityType.getAllEntities().get(deepEntryKey);
            ArrayList<String> entryKeys = new ArrayList<String>(16);
            DynamicObjectUtils.getEntryKeys(deepEntryType, entryKeys, entity);
            DynamicObjectUtils.buildEntryDyc(entityType, billDyc, billFieldValueMap, entryKeys, 0);
        }
        return billDyc;
    }

    private static void buildEntryMap(Set<String> noEntryFieldKeys, MainEntityType entityType, DynamicObject parentDyc, Map<String, Object> parentFieldKeyValueMap, List<String> entryKeys, int entryIndex) {
        if (entryIndex >= entryKeys.size()) {
            return;
        }
        String curEntryKey = entryKeys.get(entryIndex);
        DataEntityPropertyCollection properties = ((EntityType)entityType.getAllEntities().get(curEntryKey)).getProperties();
        ArrayList<HashMap<String, Object>> entryKeyValueMaps = new ArrayList<HashMap<String, Object>>(16);
        DynamicObjectCollection entryDycs = parentDyc.getDynamicObjectCollection(curEntryKey);
        for (DynamicObject entryDyc : entryDycs) {
            HashMap<String, Object> entryFieldKeyValueMap = new HashMap<String, Object>(16);
            for (String noEntryFieldKey : noEntryFieldKeys) {
                if (!properties.containsKey((Object)noEntryFieldKey)) continue;
                entryFieldKeyValueMap.put(noEntryFieldKey, entryDyc.get(noEntryFieldKey));
            }
            DynamicObjectUtils.buildEntryMap(noEntryFieldKeys, entityType, entryDyc, entryFieldKeyValueMap, entryKeys, entryIndex + 1);
            entryKeyValueMaps.add(entryFieldKeyValueMap);
        }
        parentFieldKeyValueMap.put(curEntryKey, entryKeyValueMaps);
    }

    private static void getEntryKeys(IDataEntityType entryType, List<String> entryKeys, String entity) {
        if (entryType != null && !entryType.getName().equals(entity)) {
            entryKeys.add(0, entryType.getName());
            DynamicObjectUtils.getEntryKeys(entryType.getParent(), entryKeys, entity);
        }
    }

    private static void buildEntryDyc(MainEntityType entityType, DynamicObject parentDyc, Map<String, Object> billFieldValueMap, List<String> entryKeys, int entryIndex) {
        if (entryIndex >= entryKeys.size()) {
            return;
        }
        String curEntryKey = entryKeys.get(entryIndex);
        List entryKeyValueMaps = (List)billFieldValueMap.get(curEntryKey);
        if (entryKeyValueMaps == null) {
            return;
        }
        DataEntityPropertyCollection properties = ((EntityType)entityType.getAllEntities().get(curEntryKey)).getProperties();
        DynamicObjectCollection entryDycs = parentDyc.getDynamicObjectCollection(curEntryKey);
        Map allEntities = entityType.getAllEntities();
        for (Map entryKeyValueMap : entryKeyValueMaps) {
            DynamicObject entryDyc = entryDycs.addNew();
            for (Map.Entry fieldValueEntry : entryKeyValueMap.entrySet()) {
                if (allEntities.containsKey(fieldValueEntry.getKey()) || !properties.containsKey(fieldValueEntry.getKey())) continue;
                entryDyc.set((String)fieldValueEntry.getKey(), fieldValueEntry.getValue());
            }
            DynamicObjectUtils.buildEntryDyc(entityType, entryDyc, entryKeyValueMap, entryKeys, entryIndex + 1);
        }
    }

    public static Long getBaseId(DynamicObject info, String baseIdKey) {
        Long baseId = info.getLong(baseIdKey + "_id");
        Object baseIdObj = info.get(baseIdKey);
        if (baseIdObj instanceof Long && !baseIdObj.equals(0L)) {
            baseId = (Long)baseIdObj;
        }
        return baseId;
    }
}

