/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.OrgHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.ReportF7Helper;
import kd.fi.cal.common.util.CommonUtils;

public class ReportUtil {
    public static final String BOS_ORG = "bos_org";
    public static final String BD_SUPPLIER = "bd_supplier";
    public static final String BD_CUSTOMER = "bd_customer";
    public static final String OWNERTYPEHEAD = "ownertypehead";
    public static final String CALORGOWNERFROM = "mulowner";
    public static final String SUPPLIEROWNERFROM = "mulsupplierownerfrom";
    public static final String CUSTOMEROWNERFROM = "mulcustomerownerfrom";
    public static final String OWNERTO = "ownerto";
    public static final String MATERIALGROUP = "mulmaterialgroup";
    public static final String MATERIALGROUPSTANDARD = "materialgroupstandard";
    public static final String MATERIALFROM = "mulmaterial";
    public static final String MATERIALTO = "materialto";

    public static void ownertypeChanged(IDataModel model, IReportView view) {
        String ownertype = (String)model.getValue(OWNERTYPEHEAD);
        model.beginInit();
        model.setValue(CALORGOWNERFROM, null);
        model.setValue(CUSTOMEROWNERFROM, null);
        model.setValue(SUPPLIEROWNERFROM, null);
        model.endInit();
        if (StringUtils.isNotEmpty((String)ownertype)) {
            view.setEnable(Boolean.TRUE, new String[]{OWNERTO});
            switch (ownertype) {
                case "bos_org": {
                    view.setVisible(Boolean.TRUE, new String[]{CALORGOWNERFROM});
                    view.setVisible(Boolean.FALSE, new String[]{CUSTOMEROWNERFROM});
                    view.setVisible(Boolean.FALSE, new String[]{SUPPLIEROWNERFROM});
                    view.setEnable(Boolean.TRUE, new String[]{CALORGOWNERFROM});
                    break;
                }
                case "bd_supplier": {
                    view.setVisible(Boolean.FALSE, new String[]{CALORGOWNERFROM});
                    view.setVisible(Boolean.FALSE, new String[]{CUSTOMEROWNERFROM});
                    view.setVisible(Boolean.TRUE, new String[]{SUPPLIEROWNERFROM});
                    view.setEnable(Boolean.TRUE, new String[]{SUPPLIEROWNERFROM});
                    break;
                }
                case "bd_customer": {
                    view.setVisible(Boolean.FALSE, new String[]{CALORGOWNERFROM});
                    view.setVisible(Boolean.TRUE, new String[]{CUSTOMEROWNERFROM});
                    view.setVisible(Boolean.FALSE, new String[]{SUPPLIEROWNERFROM});
                    view.setEnable(Boolean.TRUE, new String[]{CUSTOMEROWNERFROM});
                    break;
                }
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{CALORGOWNERFROM});
            view.setVisible(Boolean.FALSE, new String[]{CUSTOMEROWNERFROM});
            view.setVisible(Boolean.TRUE, new String[]{SUPPLIEROWNERFROM});
            view.setEnable(Boolean.FALSE, new String[]{SUPPLIEROWNERFROM});
        }
        view.updateView(CALORGOWNERFROM);
        view.updateView(CUSTOMEROWNERFROM);
        view.updateView(SUPPLIEROWNERFROM);
    }

    public static void setOwnerVisible(IDataModel model, IReportView view, String calorgKey) {
        ReportQueryParam reportQueryParam = ((ReportShowParameter)view.getFormShowParameter()).getReportQueryParam();
        String ownerType = "";
        if (reportQueryParam != null) {
            ownerType = reportQueryParam.getFilter().getString(OWNERTYPEHEAD);
        }
        if (StringUtils.isNotEmpty((String)ownerType)) {
            if (BOS_ORG.equals(ownerType)) {
                view.setVisible(Boolean.FALSE, new String[]{SUPPLIEROWNERFROM});
                view.setVisible(Boolean.FALSE, new String[]{CUSTOMEROWNERFROM});
            } else if (BD_SUPPLIER.equals(ownerType)) {
                view.setVisible(Boolean.FALSE, new String[]{CALORGOWNERFROM});
                view.setVisible(Boolean.FALSE, new String[]{CUSTOMEROWNERFROM});
            } else if (BD_CUSTOMER.equals(ownerType)) {
                view.setVisible(Boolean.FALSE, new String[]{CALORGOWNERFROM});
                view.setVisible(Boolean.FALSE, new String[]{SUPPLIEROWNERFROM});
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{SUPPLIEROWNERFROM});
            view.setVisible(Boolean.FALSE, new String[]{CUSTOMEROWNERFROM});
            view.setVisible(Boolean.TRUE, new String[]{CALORGOWNERFROM});
            model.setValue(OWNERTYPEHEAD, (Object)BOS_ORG);
        }
    }

    public static void getOwnerFilter(QFilter q, String filter_ownertype, DynamicObjectCollection filter_owner, String entityName) {
        if (StringUtils.isEmpty((String)filter_ownertype)) {
            return;
        }
        String entry = "";
        if ("cal_costrecord".equals(entityName)) {
            entry = "entry.";
        } else if ("cal_costadjustbill".equals(entityName) || "cal_stdcostdiffbill".equals(entityName)) {
            entry = "entryentity.";
        }
        q.and(entry + "ownertype", "=", (Object)filter_ownertype);
        if (filter_owner != null && !filter_owner.isEmpty()) {
            HashSet<Object> set = new HashSet<Object>(8);
            for (DynamicObject info : filter_owner) {
                set.add(info.getPkValue());
            }
            q.and(entry + "owner", "in", set);
        }
    }

    public static void warehsgroupChanged(IDataModel model) {
        model.setValue("mulwarehouse", null);
        model.setValue("mullocation", null);
    }

    public static Set<Long> getWarehsGroupSet(FilterInfo filterInfo) {
        HashSet<Long> warehsGroupSet = new HashSet<Long>(8);
        DynamicObjectCollection filter_warehsgroup = filterInfo.getDynamicObjectCollection("mulwarehsgroup");
        if (filter_warehsgroup != null) {
            QFilter warehsGroupF = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            for (DynamicObject info : filter_warehsgroup) {
                warehsGroupSet.add(info.getLong("id"));
            }
            if (!warehsGroupSet.isEmpty()) {
                DynamicObjectCollection warehsGroupColl = QueryServiceHelper.query((String)"bd_warehousegroup", (String)"id", (QFilter[])new QFilter[]{warehsGroupF});
                for (DynamicObject warehsGroup : warehsGroupColl) {
                    warehsGroupSet.add(warehsGroup.getLong("id"));
                }
            }
        } else if (filterInfo.getBoolean("onlyqueryemptygroup")) {
            warehsGroupSet.add(0L);
        }
        return warehsGroupSet;
    }

    public static void beforeF7Select4Warehouse(BeforeF7SelectEvent e, IDataModel model) {
        ReportUtil.beforeF7Select4Warehouse(e, model, "calorg");
    }

    public static void beforeF7Select4Warehouse(BeforeF7SelectEvent e, IDataModel model, String calorgName) {
        DynamicObjectCollection mulwarehsgroup;
        DynamicObjectCollection storageOrgs = (DynamicObjectCollection)model.getValue("mulstorageorg");
        Object calOrgObj = model.getValue(calorgName);
        QFilter q = new QFilter("id", "=", (Object)-1L);
        Set<Object> calOrgSet = new HashSet(16);
        if (calOrgObj instanceof DynamicObject) {
            DynamicObject calOrg = (DynamicObject)calOrgObj;
            calOrgSet = ReportF7Helper.beforeF7Warehouse(storageOrgs, calOrg);
        } else if (calOrgObj instanceof DynamicObjectCollection) {
            calOrgSet = ReportF7Helper.beforeF7Warehouse(storageOrgs, (DynamicObjectCollection)calOrgObj);
        }
        if (calOrgSet.size() > 0) {
            q = new QFilter("id", "in", calOrgSet);
        }
        if (CommonUtils.isNull4List((List)(mulwarehsgroup = (DynamicObjectCollection)model.getValue("mulwarehsgroup")))) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
            return;
        }
        HashSet<Long> warehsgroupIds = new HashSet<Long>(16);
        for (DynamicObject warehsgroup : mulwarehsgroup) {
            QFilter warehsGroupF = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            DynamicObject warehsgroupDyn = warehsgroup.getDynamicObject("fbasedataid");
            warehsgroupIds.add(warehsgroupDyn.getLong("id"));
            warehsGroupF.or("longnumber", "like", (Object)(warehsgroupDyn.getString("longnumber") + "%"));
            DynamicObjectCollection warehsGroupColl = QueryServiceHelper.query((String)"bd_warehousegroup", (String)"id", (QFilter[])new QFilter[]{warehsGroupF});
            for (DynamicObject warehsGroup : warehsGroupColl) {
                warehsgroupIds.add(warehsGroup.getLong("id"));
            }
        }
        if (!warehsgroupIds.isEmpty()) {
            q.and("group", "in", warehsgroupIds);
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    public static void hideOwnerColumns(List<AbstractReportColumn> cols) {
        for (AbstractReportColumn column : cols) {
            ReportColumn reportColumn = (ReportColumn)column;
            if (!reportColumn.getFieldKey().contains("owner")) continue;
            reportColumn.setHide(true);
        }
    }

    public static void beforeF7Select4Mulcalorgowner(BeforeF7SelectEvent e, IDataModel model) {
        DynamicObject costaccount = (DynamicObject)model.getValue("costaccount");
        if (costaccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8d26\u7c3f\u3002", (String)"ReportUtil_0", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        Long[] ownerIsArray = AccountingSysHelper.getOwners(costaccount.getLong("id"));
        if (ownerIsArray.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7684\u6838\u7b97\u4f53\u7cfb\u4e2d\u672a\u8bbe\u7f6e\u8bb0\u8d26\u8303\u56f4\u3002", (String)"ReportUtil_1", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        QFilter q = new QFilter("id", "in", (Object)ownerIsArray);
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    public static void beforeF7Select4ownerto(BeforeF7SelectEvent e, IDataModel model) {
        String ownerType = (String)model.getValue(OWNERTYPEHEAD);
        if (StringUtils.isEmpty((String)ownerType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d27\u4e3b\u7c7b\u578b\u3002", (String)"ReportUtil_2", (String)"fi-cal-common", (Object[])new Object[0]));
        }
        if (!BOS_ORG.equals(ownerType)) {
            return;
        }
        ReportUtil.beforeF7Select4Mulcalorgowner(e, model);
    }

    public static void beforeF7Select4MulTrackNum(BeforeF7SelectEvent e, IDataModel model) {
        QFilter q = new QFilter("trackstatus", "!=", (Object)Character.valueOf('1'));
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(q);
    }

    public static void calOrgChanged(IDataModel model) {
        model.setValue("mulstorageorg", null);
        model.setValue(CALORGOWNERFROM, null);
        DynamicObject calOrg = (DynamicObject)model.getValue("calorg");
        if (calOrg == null) {
            model.setValue("costaccount", null);
        } else {
            DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg(calOrg.getLong("id"));
            if (costAccount != null) {
                model.setValue("costaccount", (Object)costAccount.getLong("id"));
            } else {
                model.setValue("costaccount", null);
            }
            model.setValue(OWNERTYPEHEAD, (Object)BOS_ORG);
        }
    }

    public static DataSet getClassifiedMaterialDataSet(FilterInfo filterInfo, boolean notShowMaterialGroup, DynamicObject materialgroupstandard) {
        if (notShowMaterialGroup) {
            return null;
        }
        Object pkValue = 730148448254487552L;
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        DynamicObjectCollection materialgroup = filterInfo.getDynamicObjectCollection(MATERIALGROUP);
        if (materialgroup != null) {
            filter.and(ReportUtil.getGroupFilter(materialgroup, true, "group.longnumber"));
        }
        DataSet classifiedMaterialDataSet = QueryServiceHelper.queryDataSet((String)ReportUtil.class.getName(), (String)"bd_materialgroupdetail", (String)"group,group.number as groupnumber,material,material.number as materialnumber,material.materialtype as materialtype", (QFilter[])filter.toArray(), (String)"group desc");
        QFilter materialNumberFilter = ReportUtil.getMaterialFromToFilter(filterInfo, "materialNumber");
        if (materialNumberFilter != null) {
            classifiedMaterialDataSet = classifiedMaterialDataSet.filter(materialNumberFilter.toString());
        }
        return classifiedMaterialDataSet;
    }

    public static DataSet getAllMaterialGroupDs(FilterInfo filterInfo, DynamicObject materialgroupstandard) {
        Object pkValue = 730148448254487552L;
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        DynamicObjectCollection materialgroup = filterInfo.getDynamicObjectCollection(MATERIALGROUP);
        if (materialgroup != null) {
            filter.and(ReportUtil.getGroupFilter(materialgroup, true, "longnumber"));
        }
        return QueryServiceHelper.queryDataSet((String)ReportUtil.class.getName(), (String)"bd_materialgroup", (String)"parent as pid,case when isleaf='0' then '1' else '0' end as isgroupnode,id as rowid", (QFilter[])filter.toArray(), null);
    }

    private static QFilter getMaterialFromToFilter(FilterInfo filterInfo, String materialKey) {
        Object materialfrom = filterInfo.getValue(MATERIALFROM);
        if (materialfrom instanceof DynamicObject) {
            DynamicObject from = (DynamicObject)materialfrom;
            DynamicObject to = filterInfo.getDynamicObject(MATERIALTO);
            QFilter filter = new QFilter(materialKey, ">=", from.get("number"));
            if (to != null) {
                QFilter tofilter = new QFilter(materialKey, "<=", to.get("number"));
                filter = filter.and(tofilter);
            }
            return filter;
        }
        if (materialfrom instanceof DynamicObjectCollection) {
            DynamicObjectCollection froms = (DynamicObjectCollection)materialfrom;
            if (froms.size() == 0) {
                return null;
            }
            if (froms.size() > 1) {
                HashSet<Object> idSet = new HashSet<Object>();
                for (DynamicObject from : froms) {
                    idSet.add(from.get("number"));
                }
                return new QFilter(materialKey, "in", idSet);
            }
            DynamicObject from = (DynamicObject)froms.get(0);
            DynamicObject to = filterInfo.getDynamicObject(MATERIALTO);
            QFilter filter = new QFilter(materialKey, ">=", from.get("number"));
            if (to != null) {
                filter.and(materialKey, "<=", to.get("number"));
            }
            return filter;
        }
        DynamicObject to = filterInfo.getDynamicObject(MATERIALTO);
        QFilter filter = null;
        if (to != null) {
            filter = new QFilter(materialKey, "<=", to.get("number"));
        }
        return filter;
    }

    public static void beforeMaterialgroupstandard(BeforeF7SelectEvent e, IDataModel model) {
        DynamicObject calOrg = (DynamicObject)model.getValue("calorg");
        if (calOrg == null) {
            return;
        }
        Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandard", (Object[])new Object[]{"bd_material", calOrg.getPkValue(), Boolean.TRUE});
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", (Object)ids));
    }

    private static QFilter getMaterialGroupByStandard(ListShowParameter showParameter, IDataModel model) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject materialgroupstandard = (DynamicObject)model.getValue(MATERIALGROUPSTANDARD);
        long matgroupstandardId = 730148448254487552L;
        if (materialgroupstandard != null) {
            matgroupstandardId = materialgroupstandard.getLong("id");
        }
        DynamicObject calOrg = (DynamicObject)model.getValue("calorg");
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(calOrg.getLong("id"));
        QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, matgroupstandardId, Boolean.FALSE});
        return qFilter.and(serviceResponse);
    }

    public static void beforeF7SelectMaterialGroup(BeforeF7SelectEvent e, IDataModel model) {
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(ReportUtil.getMaterialGroupByStandard((ListShowParameter)e.getFormShowParameter(), model));
    }

    public static void materialGroupStdChanged(IDataModel model) {
        model.setValue(MATERIALGROUP, null);
        model.setValue(MATERIALFROM, null);
        model.setValue(MATERIALTO, null);
    }

    public static void materialGroupChanged(IDataModel model) {
        model.setValue(MATERIALFROM, null);
        model.setValue(MATERIALTO, null);
    }

    public static QFilter getGroupFilter(DynamicObjectCollection materialgroupColl, boolean isFromFilteInfo, String fieldName) {
        if (materialgroupColl != null) {
            DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"bd_materialgroup").getProperty("parent");
            GroupProp group = (GroupProp)property;
            String longNumberDLM = "";
            if (group instanceof ParentBasedataProp) {
                longNumberDLM = ((ParentBasedataProp)group).getLongNumberDLM();
            }
            QFilter groupFilter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            HashSet<String> groupNumSet = new HashSet<String>(16);
            for (DynamicObject matgroup : materialgroupColl) {
                String longnumber = isFromFilteInfo ? matgroup.getString("longnumber") : ("bd_materialgroup".equals(matgroup.getDataEntityType().getName()) ? matgroup.getString("longnumber") : matgroup.getDynamicObject("fbasedataid").getString("longnumber"));
                groupFilter.or(new QFilter(fieldName, "like", (Object)(longnumber + longNumberDLM + "%")));
                groupNumSet.add(longnumber);
            }
            if (!groupNumSet.isEmpty()) {
                groupFilter.or(new QFilter(fieldName, "in", groupNumSet));
            }
            return groupFilter;
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    public static void beforeF7Select4Mulmaterial(IDataModel model, BeforeF7SelectEvent e) {
        DynamicObjectCollection materialgroupCol = (DynamicObjectCollection)model.getValue(MATERIALGROUP);
        if (materialgroupCol == null || materialgroupCol.isEmpty()) {
            ReportF7Helper.beforeF7Select4Material(e);
        } else {
            QFilter matFilter = ReportUtil.getMaterialByStandard(model, "material");
            DynamicObjectCollection matgroupdetailCol = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material.id", (QFilter[])new QFilter[]{ReportUtil.getGroupFilter(materialgroupCol, false, "group.longnumber"), matFilter});
            ArrayList<Long> materialIds = new ArrayList<Long>(4096);
            for (DynamicObject matgroupdetail : matgroupdetailCol) {
                materialIds.add(matgroupdetail.getLong("material.id"));
            }
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.setF7ClickByFilter(true);
            formShowParameter.setShowApproved(false);
            formShowParameter.setShowUsed(false);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", materialIds));
        }
    }

    public static QFilter getMaterialByStandard(IDataModel model, String key) {
        QFilter qFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
        HashSet<Object> sets = new HashSet<Object>(32);
        DynamicObject materialgroupstandard = (DynamicObject)model.getValue(MATERIALGROUPSTANDARD);
        if (materialgroupstandard == null || materialgroupstandard.getBoolean("ispreset") && (Long)materialgroupstandard.getPkValue() == 730148448254487552L) {
            return qFilter;
        }
        Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroupdetail", (String)"material", (QFilter[])new QFilter("standard", "=", materialgroupstandard.getPkValue()).toArray());
        for (Map.Entry entry : dynamicObjects.entrySet()) {
            sets.add(((DynamicObject)entry.getValue()).get("material.id"));
        }
        qFilter.and(key, "in", sets);
        return qFilter;
    }

    public static void mulMaterialChanged(IDataModel model, IFormView view) {
        DynamicObjectCollection coll = (DynamicObjectCollection)model.getValue(MATERIALFROM);
        if (coll != null) {
            if (coll.size() == 1) {
                model.setValue(MATERIALTO, ((DynamicObject)coll.get(0)).getDynamicObject("fbasedataid").getPkValue());
                view.setEnable(Boolean.TRUE, new String[]{MATERIALTO});
            } else if (coll.size() == 0) {
                model.setValue(MATERIALTO, null);
                view.setEnable(Boolean.TRUE, new String[]{MATERIALTO});
            } else {
                model.setValue(MATERIALTO, null);
                view.setEnable(Boolean.FALSE, new String[]{MATERIALTO});
            }
        } else {
            model.setValue(MATERIALTO, null);
            view.setEnable(Boolean.TRUE, new String[]{MATERIALTO});
        }
    }

    public static boolean isCalByCostelement(long costAccountId) {
        QFilter q = new QFilter("id", "=", (Object)costAccountId);
        DynamicObject costAccountInfo = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,calpolicy.calbycostelement", (QFilter[])q.toArray());
        return costAccountInfo == null ? false : costAccountInfo.getBoolean("calpolicy.calbycostelement");
    }

    public static DynamicObject getYearPeriodByDate(Object costAccountId, Date date) {
        DynamicObject periodDyc = null;
        QFilter filter = new QFilter("id", "=", costAccountId);
        DynamicObject calAcctDyc = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy,calpolicy.periodtype", (QFilter[])new QFilter[]{filter});
        if (calAcctDyc != null) {
            QFilter beginDate = new QFilter("begindate", "<=", (Object)date);
            QFilter endDatef = new QFilter("enddate", ">=", (Object)date);
            QFilter periodTypef = new QFilter("periodtype", "=", (Object)calAcctDyc.getLong("calpolicy.periodtype"));
            QFilter notAdjPeriodf = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
            periodDyc = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter[]{beginDate, endDatef, periodTypef, notAdjPeriodf});
        }
        return periodDyc;
    }

    public static int getBeginPeriod(DynamicObject costAccount) {
        if (costAccount == null) {
            return 0;
        }
        DynamicObject startPeriod = PeriodHelper.getSysCtrlEntity(costAccount.getLong("id"));
        int peridNumber = 0;
        if (startPeriod != null) {
            Long startPeriodId = startPeriod.getLong("startperiod.id");
            DynamicObject peirod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"periodyear,periodnumber,begindate,enddate", (QFilter[])new QFilter("id", "=", (Object)startPeriodId).toArray());
            peridNumber = peirod.getInt("periodyear") * 100 + peirod.getInt("periodnumber");
        }
        return peridNumber;
    }

    public static void beforeF7SelectMulSupplier(BeforeF7SelectEvent e, IDataModel model) {
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        formShowParameter.setF7ClickByFilter(true);
        formShowParameter.setShowApproved(false);
        formShowParameter.setShowUsed(false);
        formShowParameter.getListFilterParameter();
    }

    public static QFilter getBasedataFilter(String basedataType, Collection<Long> orgIds) {
        QFilter basedataFilter = null;
        for (Long orgId : orgIds) {
            QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)basedataType, (Long)orgId);
            if (basedataFilter == null) {
                basedataFilter = filter;
                continue;
            }
            basedataFilter.or(filter);
        }
        if (basedataFilter != null) {
            basedataFilter.and(new QFilter("status", "=", (Object)"C"));
        } else {
            basedataFilter = new QFilter("status", "=", (Object)"C");
        }
        return basedataFilter;
    }

    public static Set<Long> getBasedateIdsFromDyColNumers(DynamicObjectCollection filter_supplierFrom, String entity) {
        HashSet<String> nums = new HashSet<String>();
        for (DynamicObject info : filter_supplierFrom) {
            nums.add(info.getString("number"));
        }
        QFilter filter = new QFilter("number", "in", nums);
        DynamicObjectCollection supplierIds = QueryServiceHelper.query((String)BD_SUPPLIER, (String)"id", (QFilter[])filter.toArray());
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject id : supplierIds) {
            ids.add(id.getLong("id"));
        }
        return ids;
    }

    public static QFilter getCostAccountNextPeriodOf(DynamicObjectCollection costAccounts) {
        if (costAccounts == null) {
            return new QFilter("id", "=", (Object)-1L);
        }
        ArrayList<Long> costAccountIds = new ArrayList<Long>(16);
        for (DynamicObject costAccount : costAccounts) {
            DynamicObject baseData = costAccount.getDynamicObject("fbasedataid");
            if (baseData == null) continue;
            costAccountIds.add(baseData.getLong("id"));
        }
        QFilter q = null;
        if (!costAccountIds.isEmpty()) {
            QFilter filter = new QFilter("entry.costaccount.id", "in", costAccountIds);
            String fields = "entry.startperiod as id,entry.calpolicy.periodtype as periodtype,entry.startperiod.periodyear as periodyear,entry.startperiod.periodnumber as periodnumber";
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ReportUtil-getCostAccountNextPeriodOf", (String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter}, (String)"entry.startperiod");
            boolean flag = true;
            for (Row row : dataSet) {
                Long periodtype = row.getLong("periodtype");
                Integer periodyear = row.getInteger("periodyear");
                Integer periodnumber = row.getInteger("periodnumber");
                QFilter filterType = new QFilter("periodtype.id", "=", (Object)periodtype);
                QFilter filterYear = new QFilter("periodyear", "=", (Object)periodyear);
                QFilter filterNum = new QFilter("periodnumber", ">=", (Object)periodnumber);
                QFilter pfilter = filterYear.and(filterNum);
                QFilter pYear = new QFilter("periodyear", ">", (Object)periodyear);
                pfilter.or(pYear);
                QFilter q1 = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
                q = filterType.and(pfilter).and(q1);
                if (!flag) continue;
                break;
            }
        }
        return q;
    }

    public static Set<Long> getMulBaseEditIdSet(IDataModel model, String mulFieldName) {
        DynamicObjectCollection mulDyms = model.getDataEntity().getDynamicObjectCollection(mulFieldName);
        HashSet<Long> mulIdSet = new HashSet<Long>(mulDyms.size());
        for (DynamicObject dym : mulDyms) {
            mulIdSet.add(dym.getDynamicObject("fbasedataid").getLong("id"));
        }
        return mulIdSet;
    }

    public static void beforeF7Select4NewMulmaterial(IDataModel model, BeforeF7SelectEvent e, String calorgStr) {
        DynamicObjectCollection calOrgList = model.getDataEntity(true).getDynamicObjectCollection(calorgStr);
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        for (DynamicObject calOrg : calOrgList) {
            orgIds.add(calOrg.getDynamicObject("fbasedataid").getLong("id"));
        }
        DynamicObjectCollection materialgroupCol = (DynamicObjectCollection)model.getValue(MATERIALGROUP);
        if (materialgroupCol == null || materialgroupCol.isEmpty()) {
            ReportF7Helper.beforeF7Select4NewMaterial(e, orgIds);
        } else {
            QFilter matFilter = ReportUtil.getMaterialByStandard(model, "material");
            DynamicObjectCollection matgroupdetailCol = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material.id", (QFilter[])new QFilter[]{ReportUtil.getGroupFilter(materialgroupCol, false, "group.longnumber"), matFilter});
            ArrayList<Long> materialIds = new ArrayList<Long>(4096);
            for (DynamicObject matgroupdetail : matgroupdetailCol) {
                materialIds.add(matgroupdetail.getLong("material.id"));
            }
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            if (orgIds.isEmpty()) {
                params.put("isShowAllNoOrg", "true");
                formShowParameter.setCustomParams(params);
            } else {
                params.put("useOrgs", orgIds);
                formShowParameter.setCustomParams(params);
            }
            formShowParameter.setF7ClickByFilter(true);
            formShowParameter.setShowApproved(false);
            formShowParameter.setShowUsed(false);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", materialIds));
        }
    }
}

