/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.adjbill;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.cal.business.calculate.out.CalIntimeBufferPoolHelper;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;

public class AdjBillDeleteHelper {
    public void delete(QFilter filter) {
        this.doDelete("cal_costadjust_subentity", filter);
        this.doDelete("cal_stdcostdiffbill", filter);
    }

    private void doDelete(String adjEntity, QFilter adjustFilter) {
        Set<Long> adjustBillIds = this.getAdjBillIds(adjEntity, adjustFilter);
        if (adjustBillIds.isEmpty()) {
            return;
        }
        this.doUnAudit(adjEntity, adjustBillIds);
        this.doDelete(adjEntity, adjustBillIds);
    }

    private void doDelete(String adjEntity, Set<Long> adjustBillIds) {
        if ((adjustBillIds = CalIntimeBufferPoolHelper.removeBufferPoolRevBill(adjEntity, adjustBillIds)).isEmpty()) {
            return;
        }
        QFilter adjustBillIdsFilter = new QFilter("id", "in", adjustBillIds);
        DeleteServiceHelper.delete((String)adjEntity, (QFilter[])new QFilter[]{adjustBillIdsFilter});
    }

    private void doUnAudit(String adjEntity, Set<Long> adjustBillIds) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("unwriteoff", "1");
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignoreValidation", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)adjEntity, (Object[])adjustBillIds.toArray(new Object[adjustBillIds.size()]), (OperateOption)option);
        if (!result.isSuccess()) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u672c\u8c03\u6574\u5355\u5931\u8d25\uff1a", (String)"SyncBizBill4UnAuditServiceProcess_7", (String)"fi-cal-business", (Object[])new Object[0]));
            for (IOperateInfo error : result.getAllErrorOrValidateInfo()) {
                OperateInfo operror = (OperateInfo)error;
                errorMsg.append(operror.getMessage());
            }
            errorMsg.append(result.getMessage());
            throw new KDBizException(errorMsg.toString());
        }
    }

    private Set<Long> getAdjBillIds(String adjEntity, QFilter adjustFilter) {
        HashSet<Long> adjustBillIds = new HashSet<Long>(16);
        String select = "id,billno,isvoucher,createtype";
        DataSet adjDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)adjEntity, (String)select, (QFilter[])adjustFilter.toArray(), null);
        for (Row row : adjDs) {
            adjustBillIds.add(row.getLong("id"));
            if (!row.getBoolean("isvoucher").booleanValue()) continue;
            String typeName = CostAdjustBilCreateTypeEnum.getEnumDesc((String)row.getString("createtype"));
            String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u201c%2$s\u201d\u7684\u6210\u672c\u8c03\u6574\u5355\u201c%3$s\u201d,\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"SyncBizBill4UnAuditServiceProcess_11", (String)"fi-cal-business", (Object[])new Object[0]), "3", typeName, row.getString("billno"));
            throw new KDBizException(msg);
        }
        return adjustBillIds;
    }
}

