/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.account;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.account.CloseAccountParamBuilder;
import kd.fi.cal.business.datacheck.AlarmLevel;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.DataCheckTask;
import kd.fi.cal.business.datacheck.DataCheckTaskEntry;
import kd.fi.cal.business.datacheck.DataCheckTaskExecutor;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.ScmParamsHelper;
import kd.fi.cal.common.log.CalLogInfo;
import kd.fi.cal.common.log.CalLogUtils;
import kd.fi.cal.common.model.CloseAccountParam;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;

public class CloseAccountFacade {
    private static final Log logger = LogFactory.getLog(CloseAccountFacade.class);
    private boolean settle = false;
    private String DLOCK_KEY = "closeAccount_cal_" + CacheKeyUtil.getAcctId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, String> doCloseAccount(CloseAccountParam[] params) {
        HashMap<Long, String> map = new HashMap(16);
        Set<Long> ownerIds = this.getAllOwnerIds(params);
        ArrayList<DLock> locks = new ArrayList<DLock>(16);
        try (TXHandle txHandle = TX.required();){
            try {
                this.addLock(ownerIds, locks);
                params = this.getNeedCloseAccountParams(params, ownerIds);
                if (this.settle) {
                    this.doCloseAccountSettle(params);
                } else {
                    map = this.doCloseAccountNotSettle(params);
                }
            }
            finally {
                this.unLock(locks);
            }
        }
        return map;
    }

    private void doCloseAccountSettle(CloseAccountParam[] params) {
        if (params == null || params.length < 1) {
            logger.info("\u6838\u7b97\u5173\u8d26\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        for (CloseAccountParam closeAccountParam : params) {
            CloseAccountFacade closeActFacade = new CloseAccountFacade();
            if (closeAccountParam.isUpdateSaveBill()) {
                closeActFacade.updateInvDate(closeAccountParam, "A");
            }
            if (closeAccountParam.isUpdateSubmitBill()) {
                closeActFacade.updateInvDate(closeAccountParam, "B");
            }
            closeActFacade.closeAccount(closeAccountParam);
        }
    }

    private CloseAccountParam[] getNeedCloseAccountParams(CloseAccountParam[] params, Set<Long> ownerIds) {
        HashMap<Long, Date> ownerIdLasDateMap = new HashMap<Long, Date>(16);
        Map<Long, DynamicObject> ownerIdLastCloseAcctDycMap = CloseAccountParamBuilder.getOwnerIdLastCloseAcctDycMap(ownerIds);
        for (Map.Entry<Long, DynamicObject> ownerIdLastDyc : ownerIdLastCloseAcctDycMap.entrySet()) {
            Long ownerId = ownerIdLastDyc.getKey();
            DynamicObject lastDycValue = ownerIdLastDyc.getValue();
            if (lastDycValue == null) continue;
            Date lastCloseDate = lastDycValue.getDate("closedate");
            ownerIdLasDateMap.put(ownerId, lastCloseDate);
        }
        ArrayList<CloseAccountParam> newParams = new ArrayList<CloseAccountParam>(16);
        for (CloseAccountParam param : params) {
            long ownerId = param.getOwnerid();
            Date lastDate = (Date)ownerIdLasDateMap.get(ownerId);
            if (lastDate != null && !lastDate.before(param.getCloseDate())) continue;
            newParams.add(param);
        }
        params = newParams.toArray(new CloseAccountParam[0]);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, String> doCloseAccountNotSettle(CloseAccountParam[] params) {
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        if (params == null || params.length < 1) {
            logger.info("\u6838\u7b97\u5173\u8d26\u53c2\u6570\u4e3a\u7a7a");
            return map;
        }
        ArrayList<CalLogInfo> logInfos = new ArrayList<CalLogInfo>();
        for (CloseAccountParam param : params) {
            if (param == null) continue;
            String errorMsg = null;
            boolean isError = false;
            DynamicObject taskInfo = this.createTask(param.getOwner().getString("number"));
            Long calTaskId = taskInfo.getLong("id");
            try {
                this.addSuccessLog(param, "A", calTaskId);
                boolean isPassCheck = this.doCloseAccountCheck(param, calTaskId);
                if (!isPassCheck) {
                    this.addLog(param, "checkfail", "A");
                    map.put(param.getOwnerid(), ResManager.loadKDString((String)"\u5173\u8d26\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u8bf7\u8054\u67e5\u65e5\u5fd7\u5e76\u5728\u8be6\u60c5\u4e2d\u67e5\u770b\u68c0\u67e5\u7ed3\u679c\u3002", (String)"CloseAccountFacade_15", (String)"fi-cal-business", (Object[])new Object[0]));
                    continue;
                }
                try (TXHandle t = TX.requiresNew();){
                    try {
                        if (param.isUpdateSaveBill()) {
                            this.updateInvDate(param, "A");
                        }
                        if (param.isUpdateSubmitBill()) {
                            this.updateInvDate(param, "B");
                        }
                        this.closeAccount(param);
                    }
                    catch (Exception e) {
                        t.setRollback(true);
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                isError = true;
                if (e.getMessage() != null) {
                    errorMsg = e.getMessage();
                } else {
                    StackTraceElement[] errs;
                    StringBuilder sb = new StringBuilder();
                    for (StackTraceElement err : errs = e.getStackTrace()) {
                        sb.append(err).append('\n');
                    }
                    errorMsg = sb.toString();
                }
            }
            finally {
                this.updateTaskStatus(calTaskId);
            }
            if (isError) {
                if (errorMsg == null) {
                    errorMsg = ResManager.loadKDString((String)"\u672a\u8bb0\u5f55\u5230\u65e5\u5fd7\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u7cfb\u7edfmonitor\u65e5\u5fd7\u3002", (String)"CloseAccountFacade_0", (String)"fi-cal-business", (Object[])new Object[0]);
                }
                this.addLog(param, "error", "A");
                map.put(param.getOwnerid(), errorMsg);
            } else {
                this.addLog(param, null, "A");
            }
            String msg = String.format(ResManager.loadKDString((String)"\u8d27\u4e3b\u3010%1$s\u3011\u5173\u8d26", (String)"CloseAccountFacade_19", (String)"fi-cal-business", (Object[])new Object[0]), param.getOwner().getString("name"));
            logInfos.add(CalLogUtils.buildCalAppLog((boolean)isError, (String)"cal_closeaccount", (String)msg, (long)param.getOwnerid()));
        }
        CalLogUtils.addBatchLog(logInfos);
        return map;
    }

    private List<DLock> addLock(Set<Long> ownerIds, List<DLock> locks) {
        ArrayList<Long> ownerIdList = new ArrayList<Long>(ownerIds);
        Collections.sort(ownerIdList);
        for (Long ownerId : ownerIdList) {
            DLock lock = DLock.createReentrant((String)(this.DLOCK_KEY + ownerId), (String)"doCloseAccount");
            locks.add(lock);
            lock.lock();
        }
        return locks;
    }

    private void unLock(final List<DLock> locks) {
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                for (DLock lock : locks) {
                    lock.unlock();
                }
            }
        });
    }

    private Set<Long> getAllOwnerIds(CloseAccountParam[] params) {
        HashSet<Long> ownerIds = new HashSet<Long>(16);
        for (CloseAccountParam param : params) {
            long ownerId = param.getOwnerid();
            ownerIds.add(ownerId);
        }
        return ownerIds;
    }

    public Map<Long, String> doUnCloseAccount(CloseAccountParam[] params) {
        ArrayList<CalLogInfo> logInfos = new ArrayList<CalLogInfo>();
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (CloseAccountParam param : params) {
            boolean isError;
            String errorMsg;
            block20: {
                if (param == null) continue;
                this.addSuccessLog(param, "B", 0L);
                errorMsg = null;
                isError = false;
                try (TXHandle t = TX.requiresNew();){
                    try {
                        this.unCloseAccount(param);
                    }
                    catch (Exception e) {
                        StackTraceElement[] errs;
                        isError = true;
                        if (e.getMessage() != null) {
                            errorMsg = e.getMessage();
                            break block20;
                        }
                        StringBuilder sb = new StringBuilder();
                        for (StackTraceElement err : errs = e.getStackTrace()) {
                            sb.append(err).append('\n');
                        }
                        errorMsg = sb.toString();
                    }
                }
            }
            if (isError) {
                if (errorMsg == null) {
                    errorMsg = ResManager.loadKDString((String)"\u672a\u8bb0\u5f55\u5230\u65e5\u5fd7\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u7cfb\u7edfmonitor\u65e5\u5fd7\u3002", (String)"CloseAccountFacade_0", (String)"fi-cal-business", (Object[])new Object[0]);
                }
                this.addLog(param, errorMsg, "B");
                map.put(param.getOwnerid(), errorMsg);
            } else {
                this.addLog(param, null, "B");
            }
            String msg = String.format(ResManager.loadKDString((String)"\u8d27\u4e3b\u3010%1$s\u3011\u53cd\u5173\u8d26", (String)"CloseAccountFacade_22", (String)"fi-cal-business", (Object[])new Object[0]), param.getOwner().getString("name"));
            logInfos.add(CalLogUtils.buildCalAppLog((boolean)isError, (String)"cal_closeaccount", (String)msg, (long)param.getOwnerid()));
        }
        CalLogUtils.addBatchLog(logInfos);
        return map;
    }

    public void closeAccount(CloseAccountParam param) {
        this.saveCloseAccount(param);
    }

    private void unCloseAccount(CloseAccountParam param) {
        this.deleteCloseAccount(param);
    }

    public boolean doCloseAccountCheck(CloseAccountParam param, Long calTaskId) {
        boolean isPassCheck = true;
        if (param.getCheckItems().get("C") != null) {
            Map checkItems = (Map)param.getCheckItems().get("C");
            DynamicObject owner = param.getOwner();
            Date startDate = param.getLastCloseDate();
            Date endDate = param.getCloseDate();
            DataCheckParam checkParam = new DataCheckParam();
            HashSet<Long> orgSet = new HashSet<Long>(1);
            orgSet.add(owner.getLong("id"));
            checkParam.setCalorg(orgSet);
            checkParam.setStartDate(startDate);
            checkParam.setEndDate(endDate);
            checkParam.setMsgStatus(",A,B,C");
            HashSet<Long> msgReceivers = new HashSet<Long>(16);
            msgReceivers.add(Long.valueOf(RequestContext.get().getUserId()));
            checkParam.setMsgReceiver(msgReceivers);
            DataCheckTask task = new DataCheckTask();
            Map checkItemMap = BusinessDataServiceHelper.loadFromCache((String)"cal_datacheck_item", (String)"plugin,tips", (QFilter[])new QFilter("id", "in", checkItems.keySet()).toArray());
            for (Map.Entry checkItemEntry : checkItemMap.entrySet()) {
                DynamicObject checkItem = (DynamicObject)checkItemEntry.getValue();
                Long checkItemId = (Long)checkItemEntry.getKey();
                task.addDataCheckTaskEntry(new DataCheckTaskEntry(checkItemId, checkItem.getString("plugin"), checkItem.getString("tips"), AlarmLevel.getByValue((String)checkItems.get(checkItemId))));
            }
            DataSet ownerSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_org", (String)"id,name", (QFilter[])new QFilter("id", "in", (Object)param.getOwner().getLong("id")).toArray(), null);
            String ownerNames = this.getNamesString(ownerSet);
            task.setPlanId(calTaskId);
            task.setPlanType("cal_task");
            task.setTaskId(1255063777360084992L);
            task.setOwner(ownerNames);
            task.setCalorg(ownerNames);
            task.setPurpose("C");
            DataCheckTaskExecutor executor = new DataCheckTaskExecutor();
            executor.commitSync(task, checkParam);
            isPassCheck = this.getCheckStatus(1255063777360084992L, calTaskId);
        }
        return isPassCheck;
    }

    public void updateInvDate(CloseAccountParam param, String billStatus) {
        Date closeDate = param.getCloseDate();
        Long ownerId = param.getOwnerid();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("ownerId", ownerId);
        paramMap.put("beginDate", param.getLastCloseDate());
        paramMap.put("endDate", closeDate);
        paramMap.put("billStatus", billStatus);
        paramMap.put("isUpdate", "1");
        Map map = null;
        try (TXHandle t = TX.requiresNew();){
            map = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvBillStatusService", (String)"bizBillStatusCheck", (Object[])new Object[]{paramMap});
        }
        if (map != null && !map.isEmpty()) {
            DynamicObject[] costRecords;
            HashSet billIdSet = new HashSet(16);
            HashSet<Long> accountIdSet = new HashSet<Long>(16);
            HashSet<Long> inCalBillIdSet = new HashSet<Long>(16);
            HashSet<Long> outCalBillIdSet = new HashSet<Long>(16);
            for (Map.Entry entry : map.entrySet()) {
                DynamicObject[] billIds = (DynamicObject[])entry.getValue();
                billIdSet.addAll(billIds);
            }
            Date nextDate = DateUtils.addDateTime((Date)closeDate, (int)5, (int)1);
            nextDate = DateUtils.getDayStartTime((Date)nextDate);
            for (DynamicObject dynamicObject : costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord_subentity", (String)"id,costaccount,bookdate,period,writeoffdate,writeoffperiod,isinitbill,calbilltype,calbillid,bizdate", (QFilter[])new QFilter("bizbillid", "in", billIdSet).toArray())) {
                accountIdSet.add(dynamicObject.getLong("costaccount_id"));
            }
            if (accountIdSet.isEmpty()) {
                return;
            }
            boolean isBizDateEqualBookDate = ScmParamsHelper.isEnable((String)"INV0004");
            Map accountCRTPeriodMap = PeriodHelper.getCurrentPeriods(new HashSet(accountIdSet));
            Map<Long, DynamicObject> accountNXTPeriodMap = this.getAccountPeriodMap(accountIdSet, nextDate);
            for (DynamicObject costRecord : costRecords) {
                String calBillType;
                Long costAccountId = costRecord.getLong("costaccount_id");
                DynamicObject period = accountNXTPeriodMap.get(costAccountId);
                if (period == null) continue;
                Date bookdate = nextDate;
                Long periodId = period.getLong("id");
                Date writeOffDate = nextDate;
                Long writeoffPeriodid = period.getLong("id");
                Boolean isInitBill = costRecord.getBoolean("isinitbill");
                if (isInitBill.booleanValue()) {
                    DynamicObject currentPeriod = (DynamicObject)accountCRTPeriodMap.get(costAccountId);
                    if (currentPeriod == null) continue;
                    Date crtFirstDate = currentPeriod.getDate("begindate");
                    if (nextDate.before(crtFirstDate)) {
                        periodId = currentPeriod.getLong("id");
                        writeOffDate = crtFirstDate;
                        writeoffPeriodid = currentPeriod.getLong("id");
                    }
                }
                costRecord.set("period", (Object)periodId);
                costRecord.set("writeoffdate", (Object)writeOffDate);
                costRecord.set("writeoffperiod", (Object)writeoffPeriodid);
                if (isInitBill.booleanValue()) continue;
                costRecord.set("bookdate", (Object)bookdate);
                if (isBizDateEqualBookDate) {
                    costRecord.set("bizdate", (Object)bookdate);
                }
                if ("IN".equals(calBillType = costRecord.getString("calbilltype"))) {
                    inCalBillIdSet.add(costRecord.getLong("calbillid"));
                    continue;
                }
                outCalBillIdSet.add(costRecord.getLong("calbillid"));
            }
            if (costRecords.length > 0) {
                SaveServiceHelper.save((DynamicObject[])costRecords);
            }
            String string = this.getUpdateBillSql(inCalBillIdSet, "t_cal_incalbill", "fbookdate");
            String updateOutBillSql = this.getUpdateBillSql(outCalBillIdSet, "t_cal_outcalbill", "fbookdate");
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
            updateParams.add(new Object[]{nextDate});
            if (string != null) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)string, updateParams);
                if (isBizDateEqualBookDate) {
                    String string2 = this.getUpdateBillSql(inCalBillIdSet, "t_cal_incalbill", "fbizdate");
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)string2, updateParams);
                }
            }
            if (updateOutBillSql != null) {
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateOutBillSql, updateParams);
                if (isBizDateEqualBookDate) {
                    updateOutBillSql = this.getUpdateBillSql(outCalBillIdSet, "t_cal_outcalbill", "fbizdate");
                    DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)updateOutBillSql, updateParams);
                }
            }
        }
    }

    private void saveCloseAccount(CloseAccountParam param) {
        DynamicObject owner = param.getOwner();
        Map<String, DynamicObject> map = this.getLeafCloseAccountMap(owner.getLong("id"));
        String key = owner.getPkValue().toString();
        DynamicObject peviousInfo = map.get(key);
        Date closeDate = param.getCloseDate();
        DynamicObject info = BusinessDataServiceHelper.newDynamicObject((String)"cal_closeaccounttable");
        info.set("owner", (Object)owner);
        info.set("closedate", (Object)DateUtils.getDayStartTime((Date)closeDate));
        info.set("isleaf", (Object)Boolean.TRUE);
        if (peviousInfo != null) {
            info.set("previousid", peviousInfo.getPkValue());
            peviousInfo.set("isleaf", (Object)Boolean.FALSE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{peviousInfo});
        } else {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
        }
    }

    private void deleteCloseAccount(CloseAccountParam param) {
        DynamicObject[] previousInfos;
        QFilter q = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
        q.and("owner", "=", (Object)param.getOwnerid());
        HashSet<Long> idSet = new HashSet<Long>();
        HashSet<Long> previousIdSet = new HashSet<Long>();
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_closeaccounttable", (String)"id,previousid", (QFilter[])new QFilter[]{q});
        for (DynamicObject info : coll) {
            idSet.add(info.getLong("id"));
            previousIdSet.add(info.getLong("previousid"));
        }
        for (DynamicObject info : previousInfos = BusinessDataServiceHelper.load((String)"cal_closeaccounttable", (String)"id,isleaf", (QFilter[])new QFilter[]{new QFilter("id", "in", previousIdSet)})) {
            info.set("isleaf", (Object)Boolean.TRUE);
        }
        DeleteServiceHelper.delete((String)"cal_closeaccounttable", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
        SaveServiceHelper.save((DynamicObject[])previousInfos);
    }

    private Map<String, DynamicObject> getLeafCloseAccountMap(long ownerid) {
        QFilter q = new QFilter("owner", "=", (Object)ownerid);
        q.and("isleaf", "=", (Object)Boolean.TRUE);
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_closeaccounttable", (String)"id,owner,isleaf,closedate", (QFilter[])new QFilter[]{q});
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(64);
        for (DynamicObject info : infos) {
            map.put(info.getDynamicObject("owner").getPkValue().toString(), info);
        }
        return map;
    }

    private void addSuccessLog(CloseAccountParam param, String closeType, Long taskId) {
        DynamicObject owner = param.getOwner();
        Date closeDate = param.getCloseDate();
        Date lastCloseDate = param.getLastCloseDate();
        String msg = ResManager.loadKDString((String)"\u5173\u8d26\u5230", (String)"CloseAccountFacade_16", (String)"fi-cal-business", (Object[])new Object[0]);
        if ("B".equals(closeType)) {
            msg = ResManager.loadKDString((String)"\u53cd\u5173\u8d26\u5230", (String)"CloseAccountFacade_17", (String)"fi-cal-business", (Object[])new Object[0]);
        }
        Long[] calOrgIds = AccountingSysHelper.getCalOrgIds((Long)((Long)owner.getPkValue()));
        QFilter q = new QFilter("owner", "=", owner.getPkValue());
        q.and("expectdate", "=", (Object)closeDate);
        if (lastCloseDate != null) {
            q.and("lastdate", "=", (Object)lastCloseDate);
        }
        q.and("closetype", "=", (Object)closeType);
        DynamicObject[] existsLogs = BusinessDataServiceHelper.load((String)"cal_closeaccountlog", (String)"success,operationtime,operationuser,checkresult,taskid,org,queryscheme", (QFilter[])new QFilter[]{q});
        HashMap<Long, DynamicObject> calOrgCloseLogMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject existsLog : existsLogs) {
            DynamicObject calOrgDyc = existsLog.getDynamicObject("org");
            if (calOrgDyc == null) continue;
            calOrgCloseLogMap.put((Long)calOrgDyc.getPkValue(), existsLog);
        }
        ArrayList<DynamicObject> newCLoseLogDycs = new ArrayList<DynamicObject>(16);
        for (Long calOrgId : calOrgIds) {
            DynamicObject closeLogDyc = (DynamicObject)calOrgCloseLogMap.get(calOrgId);
            if (closeLogDyc == null) {
                DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"cal_closeaccountlog");
                String dateMsg = "";
                if ("A".equals(closeType)) {
                    dateMsg = lastCloseDate == null ? msg + this.getDateString(closeDate) : this.getDateString(lastCloseDate) + msg + this.getDateString(closeDate);
                    log.set("taskid", (Object)taskId);
                } else {
                    QFilter accountTableQ = new QFilter("owner", "=", owner.getPkValue());
                    accountTableQ.and("isleaf", "=", (Object)Boolean.FALSE);
                    DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_closeaccounttable", (String)"id,calorg,costaccount,owner,isleaf,closedate", (QFilter[])new QFilter[]{accountTableQ});
                    if (infos.length <= 0) {
                        dateMsg = msg + this.getDateString(lastCloseDate);
                    } else {
                        Date maxLastDate = null;
                        for (DynamicObject info : infos) {
                            Date date = info.getDate("closedate");
                            if (maxLastDate == null) {
                                maxLastDate = date;
                                continue;
                            }
                            if (!maxLastDate.before(date)) continue;
                            maxLastDate = date;
                        }
                        dateMsg = this.getDateString(lastCloseDate) + msg + this.getDateString(maxLastDate);
                    }
                }
                log.set("owner", (Object)owner);
                log.set("lastdate", (Object)lastCloseDate);
                log.set("expectdate", (Object)closeDate);
                log.set("closetype", (Object)closeType);
                log.set("success", (Object)Boolean.FALSE);
                log.set("operationtime", (Object)new Date());
                log.set("operationuser", (Object)RequestContext.get().getUserId());
                log.set("checkresult", (Object)ResManager.loadKDString((String)"\u8fd0\u884c\u4e2d", (String)"SettleAccountFacade_24", (String)"fi-cal-business", (Object[])new Object[0]));
                log.set("datemsg", (Object)dateMsg);
                log.set("org", (Object)calOrgId);
                log.set("queryscheme", (Object)param.getQuerySchemeId());
                newCLoseLogDycs.add(log);
                continue;
            }
            closeLogDyc.set("success", (Object)Boolean.FALSE);
            closeLogDyc.set("operationtime", (Object)new Date());
            closeLogDyc.set("operationuser", (Object)RequestContext.get().getUserId());
            closeLogDyc.set("checkresult", (Object)ResManager.loadKDString((String)"\u8fd0\u884c\u4e2d", (String)"SettleAccountFacade_24", (String)"fi-cal-business", (Object[])new Object[0]));
            closeLogDyc.set("taskid", (Object)taskId);
            closeLogDyc.set("queryscheme", (Object)param.getQuerySchemeId());
        }
        if (newCLoseLogDycs.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newCLoseLogDycs.toArray(new DynamicObject[0]));
        }
        if (calOrgCloseLogMap.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])calOrgCloseLogMap.values().toArray(new DynamicObject[0]));
        }
    }

    private void addLog(CloseAccountParam param, String errorMsg, String closeType) {
        DynamicObject owner = param.getOwner();
        Date closeDate = param.getCloseDate();
        Date lastCloseDate = param.getLastCloseDate();
        if ("B".equals(closeType)) {
            closeDate = param.getCloseDate();
        }
        QFilter q = new QFilter("owner", "=", owner.getPkValue());
        q.and("expectdate", "=", (Object)closeDate);
        if (lastCloseDate != null) {
            q.and("lastdate", "=", (Object)lastCloseDate);
        }
        q.and("closetype", "=", (Object)closeType);
        DynamicObject[] existsLogs = BusinessDataServiceHelper.load((String)"cal_closeaccountlog", (String)"success,checkresult", (QFilter[])new QFilter[]{q});
        if (existsLogs.length > 0) {
            for (DynamicObject existsLog : existsLogs) {
                existsLog.set("checkresult", (Object)ResManager.loadKDString((String)"\u8be6\u60c5", (String)"CloseAccountFacade_18", (String)"fi-cal-business", (Object[])new Object[0]));
                if (errorMsg == null) {
                    existsLog.set("success", (Object)Boolean.TRUE);
                    continue;
                }
                existsLog.set("success", (Object)Boolean.FALSE);
            }
            SaveServiceHelper.save((DynamicObject[])existsLogs);
        }
    }

    private String getDateString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    private DynamicObject createTask(String ownerNumber) {
        DynamicObject taskInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_task");
        taskInfo.set("name", (Object)String.format(ResManager.loadKDString((String)"\u8d27\u4e3b\u3010%1$s\u3011\u5173\u8d26", (String)"CloseAccountFacade_23", (String)"fi-cal-business", (Object[])new Object[0]), ownerNumber));
        taskInfo.set("starttime", (Object)TimeServiceHelper.now());
        taskInfo.set("creator_id", (Object)RequestContext.get().getUserId());
        taskInfo.set("status", (Object)"B");
        taskInfo.set("tasktype", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
        return taskInfo;
    }

    private String getNamesString(DataSet dataSet) {
        StringBuilder names = new StringBuilder();
        for (Row row : dataSet) {
            names.append(row.getString("name"));
            names.append(',');
        }
        return CommonUtils.trimComma((String)names.toString());
    }

    private boolean getCheckStatus(Long checkTaskId, Long calTaskId) {
        boolean isPassCheck = true;
        QFilter q = new QFilter("checkplan", "=", (Object)calTaskId);
        q.and("checktask", "=", (Object)checkTaskId);
        DataSet checkResultDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_datacheck_result", (String)"id,entryentity.entrystatus", (QFilter[])q.toArray(), null);
        for (Row row : checkResultDataSet) {
            String result = row.getString("entryentity.entrystatus");
            if (!"B".equals(result) && !"C".equals(result)) continue;
            isPassCheck = false;
            break;
        }
        return isPassCheck;
    }

    private void updateTaskStatus(Long calTaskId) {
        DynamicObject reloadTaskInfo = BusinessDataServiceHelper.loadSingle((Object)calTaskId, (String)"cal_task", (String)"status,endtime");
        reloadTaskInfo.set("status", (Object)"A");
        reloadTaskInfo.set("endtime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reloadTaskInfo});
    }

    private Map<Long, DynamicObject> getAccountPeriodMap(Set<Long> accountIdSet, Date nextDate) {
        HashMap<Long, DynamicObject> accountNextPeriodMap = new HashMap<Long, DynamicObject>(16);
        for (Long costAccountId : accountIdSet) {
            DynamicObject period = PeriodHelper.getPeriodByDate((Date)nextDate, (Long)costAccountId);
            if (period == null) continue;
            accountNextPeriodMap.put(costAccountId, period);
        }
        return accountNextPeriodMap;
    }

    private String getUpdateBillSql(Set<Long> billIdSet, String tableName, String field) {
        if (billIdSet.isEmpty()) {
            return null;
        }
        StringBuilder billIdBuilder = new StringBuilder();
        for (Long inId : billIdSet) {
            billIdBuilder.append(inId.toString());
            billIdBuilder.append(',');
        }
        String billIdString = CommonUtils.trimComma((String)billIdBuilder.toString());
        return "update " + tableName + " set " + field + " = ? where fid in (" + billIdString + ")";
    }

    public void setSettle(boolean settle) {
        this.settle = settle;
    }
}

