/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.account;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.model.CloseAccountParam;
import kd.fi.cal.common.util.DateUtils;

public class CloseAccountParamBuilder {
    private final DynamicObject closeAcctDyc;
    private Map<Long, Date> calOrgIdCurPeriodMaxEndDateMap;
    private Map<Long, DynamicObject> ownerIdLastCloseAcctDycMap;
    private boolean backgroundInvoke = false;
    private Long querySchemeId = 0L;

    public CloseAccountParamBuilder(DynamicObject closeAcctDyc) {
        this.closeAcctDyc = closeAcctDyc;
    }

    public CloseAccountParam[] build(int[] selectedRowIndexs) {
        this.init(selectedRowIndexs);
        return this.buildCloseAccountParams(selectedRowIndexs);
    }

    public static Boolean isUpdateInvDate(DynamicObject closeAcctDyc, String billStatus) {
        long itemId = "A".equals(billStatus) ? 1271579450798102528L : 1255062234141420544L;
        Boolean isUpdateInvDate = Boolean.FALSE;
        DynamicObjectCollection checkEntry = closeAcctDyc.getDynamicObjectCollection("checkentry");
        for (DynamicObject checkItem : checkEntry) {
            Long nowItemId;
            DynamicObject checkItemDyc = checkItem.getDynamicObject("checkitem");
            if (checkItemDyc == null || itemId != (nowItemId = Long.valueOf(checkItemDyc.getLong("id"))) || checkItem.getBoolean("ischeck")) continue;
            isUpdateInvDate = Boolean.TRUE;
        }
        return isUpdateInvDate;
    }

    public static Map<Long, Date> getCalOrgCurPeriodMaxEndDateMap(Set<Long> calOrgIds) {
        QFilter orgFilter = new QFilter("org", "in", calOrgIds);
        QFilter enableFilter = new QFilter("entry.isenabled", "=", (Object)Character.valueOf('1'));
        DataSet calPeriodDs = QueryServiceHelper.queryDataSet((String)CloseAccountParamBuilder.class.getName(), (String)"cal_sysctrlentity", (String)"org,entry.currentperiod.enddate", (QFilter[])new QFilter[]{enableFilter, orgFilter}, null);
        calPeriodDs.groupBy(new String[]{"org"}).max("entry.currentperiod.enddate");
        HashMap<Long, Date> calOrgIdCurPeriodMaxEndateMap = new HashMap<Long, Date>(16);
        for (Row row : calPeriodDs) {
            calOrgIdCurPeriodMaxEndateMap.put(row.getLong("org"), row.getDate("entry.currentperiod.enddate"));
        }
        return calOrgIdCurPeriodMaxEndateMap;
    }

    public static Map<Long, DynamicObject> getOwnerIdLastCloseAcctDycMap(Set<Long> ownerIds) {
        QFilter ownerFilter = new QFilter("owner", "in", ownerIds);
        ownerFilter.and("isleaf", "=", (Object)Boolean.TRUE);
        DynamicObject[] lastCloseAccountDycs = BusinessDataServiceHelper.load((String)"cal_closeaccounttable", (String)"id,calorg,costaccount,owner,isleaf,closedate", (QFilter[])new QFilter[]{ownerFilter});
        HashMap<Long, DynamicObject> ownerIdLastCloseAccountDycMap = new HashMap<Long, DynamicObject>(32);
        for (DynamicObject lastCloseAccountDyc : lastCloseAccountDycs) {
            ownerIdLastCloseAccountDycMap.put((Long)lastCloseAccountDyc.getDynamicObject("owner").getPkValue(), lastCloseAccountDyc);
        }
        return ownerIdLastCloseAccountDycMap;
    }

    public void setBackgroundInvoke(boolean backgroundInvoke) {
        this.backgroundInvoke = backgroundInvoke;
    }

    public boolean isBackgroundInvoke() {
        return this.backgroundInvoke;
    }

    private void init(int[] selectedRowIndexs) {
        HashSet<Long> ownerIds = new HashSet<Long>(16);
        HashSet<Long> calOrgIds = new HashSet<Long>(16);
        DynamicObjectCollection closeEntryDycs = this.closeAcctDyc.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < selectedRowIndexs.length; ++i) {
            DynamicObject calOrgDyc;
            DynamicObject closeEntryDyc = (DynamicObject)closeEntryDycs.get(selectedRowIndexs[i]);
            DynamicObject ownerDyc = closeEntryDyc.getDynamicObject("owner");
            if (ownerDyc != null) {
                ownerIds.add((Long)ownerDyc.getPkValue());
            }
            if ((calOrgDyc = closeEntryDyc.getDynamicObject("calorg")) == null) continue;
            calOrgIds.add((Long)calOrgDyc.getPkValue());
        }
        this.calOrgIdCurPeriodMaxEndDateMap = CloseAccountParamBuilder.getCalOrgCurPeriodMaxEndDateMap(calOrgIds);
        this.ownerIdLastCloseAcctDycMap = CloseAccountParamBuilder.getOwnerIdLastCloseAcctDycMap(ownerIds);
    }

    private CloseAccountParam[] buildCloseAccountParams(int[] selectedRowIndexs) {
        ArrayList<CloseAccountParam> params = new ArrayList<CloseAccountParam>(16);
        HashSet<Long> set = new HashSet<Long>(16);
        DynamicObjectCollection checkEntryDycs = this.closeAcctDyc.getDynamicObjectCollection("checkentry");
        int entryRowCount = checkEntryDycs.size();
        HashMap<String, HashMap<Long, String>> allCheckItemMap = new HashMap<String, HashMap<Long, String>>(16);
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject checkItemDyc;
            Boolean ischeck = ((DynamicObject)checkEntryDycs.get(i)).getBoolean("ischeck");
            if (!ischeck.booleanValue() || (checkItemDyc = ((DynamicObject)checkEntryDycs.get(i)).getDynamicObject("checkitem")) == null) continue;
            Long itemId = checkItemDyc.getLong("id");
            String level = ((DynamicObject)checkEntryDycs.get(i)).getString("level");
            String purpose = ((DynamicObject)checkEntryDycs.get(i)).getString("purpose");
            HashMap<Long, String> checkItemMap = (HashMap<Long, String>)allCheckItemMap.get(purpose);
            if (checkItemMap == null) {
                checkItemMap = new HashMap<Long, String>(16);
            }
            checkItemMap.put(itemId, level);
            allCheckItemMap.put(purpose, checkItemMap);
        }
        DynamicObjectCollection closeEntryDycs = this.closeAcctDyc.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < selectedRowIndexs.length; ++i) {
            DynamicObject closeEntryDyc = (DynamicObject)closeEntryDycs.get(selectedRowIndexs[i]);
            DynamicObject ownerDyc = closeEntryDyc.getDynamicObject("owner");
            if (set.contains(ownerDyc.getLong("id"))) continue;
            set.add(ownerDyc.getLong("id"));
            Date closeDate = closeEntryDyc.getDate("closedate");
            Date lastCloseDate = closeEntryDyc.getDate("lastclosedate");
            CloseAccountParam param = new CloseAccountParam();
            param.setOwner(ownerDyc);
            param.setCloseDate(closeDate);
            param.setLastCloseDate(lastCloseDate);
            if (this.isBackgroundInvoke()) {
                Date lastCloseDateDb;
                this.replaceCloseDateAndLastCloseDate(closeEntryDyc, param);
                if (param.getCloseDate() == null || (lastCloseDateDb = param.getLastCloseDate()) != null && DateUtils.getDayStartTime((Date)param.getCloseDate()).compareTo(lastCloseDateDb) <= 0) continue;
            }
            param.setCheckItems(allCheckItemMap);
            param.setUpdateSaveBill(CloseAccountParamBuilder.isUpdateInvDate(this.closeAcctDyc, "A").booleanValue());
            param.setUpdateSubmitBill(CloseAccountParamBuilder.isUpdateInvDate(this.closeAcctDyc, "B").booleanValue());
            param.setQuerySchemeId(this.getQuerySchemeId());
            params.add(param);
        }
        return params.toArray(new CloseAccountParam[0]);
    }

    private void replaceCloseDateAndLastCloseDate(DynamicObject closeEntryDyc, CloseAccountParam param) {
        if (this.isBackgroundInvoke()) {
            DynamicObject ownerDyc = closeEntryDyc.getDynamicObject("owner");
            DynamicObject calOrgDyc = closeEntryDyc.getDynamicObject("calorg");
            Date calOrgIdCurPeriodMaxEndDate = this.calOrgIdCurPeriodMaxEndDateMap.get((Long)calOrgDyc.getPkValue());
            DynamicObject ownerIdLastCloseAcctDyc = this.ownerIdLastCloseAcctDycMap.get((Long)ownerDyc.getPkValue());
            if (calOrgIdCurPeriodMaxEndDate != null) {
                param.setCloseDate(calOrgIdCurPeriodMaxEndDate);
            }
            if (ownerIdLastCloseAcctDyc != null) {
                param.setLastCloseDate(ownerIdLastCloseAcctDyc.getDate("closedate"));
            }
        }
    }

    public void setQuerySchemeId(Long querySchemeId) {
        this.querySchemeId = querySchemeId;
    }

    public Long getQuerySchemeId() {
        return this.querySchemeId;
    }
}

