/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.account;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.orm.query.QFilter;
import kd.fi.cal.business.account.AbstractAccount4Frm;
import kd.fi.cal.common.enums.DischargeTypeEnum;

public class CostRecordAccount4Frm
extends AbstractAccount4Frm {
    public CostRecordAccount4Frm(Map<String, Object> paramMap) {
        super(paramMap);
    }

    @Override
    public Set<String> getCacheId() {
        String selectFields = "id,bizbillid,bizentityobject,dischargetype,issplitcreate,writeoffstatus,isfivoucher,fivoucherid,istempvoucher,tempvoucherid,isdischargevoucher,dischargevoucherid,iscostcarryover,carryovervoucherid,isfeevoucher,feevoucherid";
        DataSet billDS = this.getDataSetByPartition(this.billIds, selectFields, this.billType);
        HashSet<Long> purWFBizBillIds = new HashSet<Long>(16);
        HashSet<Long> busBillSrcBizBillIds = new HashSet<Long>(16);
        HashSet<Long> busChargedBillBizBillIds = new HashSet<Long>(16);
        HashSet<Long> saloutBillIds = new HashSet<Long>(16);
        HashSet<Long> mftInBillCRIds = new HashSet<Long>(16);
        HashSet<Long> mftProOrderIds = new HashSet<Long>(16);
        HashMap<Long, Set<Long>> bizbill2CalBillIdsMap = new HashMap<Long, Set<Long>>(4);
        for (Row row : billDS) {
            Set calBillIds;
            Long id = row.getLong("id");
            Long bizbillid = row.getLong("bizbillid");
            String bizentityobject = row.getString("bizentityobject");
            String dischargetype = row.getString("dischargetype");
            boolean issplitcreate = row.getBoolean("issplitcreate");
            String writeoffstatus = row.getString("writeoffstatus");
            boolean isfivoucher = row.getBoolean("isfivoucher");
            Long fivoucherid = row.getLong("fivoucherid");
            boolean istempvoucher = row.getBoolean("istempvoucher");
            Long tempvoucherid = row.getLong("tempvoucherid");
            boolean isdischargevoucher = row.getBoolean("isdischargevoucher");
            Long dischargevoucherid = row.getLong("dischargevoucherid");
            boolean iscostcarryover = row.getBoolean("iscostcarryover");
            Long carryovervoucherid = row.getLong("carryovervoucherid");
            boolean isfeevoucher = row.getBoolean("isfeevoucher");
            Long feevoucherid = row.getLong("feevoucherid");
            if (isfivoucher) {
                this.builder.append(new Object[]{this.billType, fivoucherid, id});
            } else if (DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargetype) && issplitcreate && "A".equals(writeoffstatus)) {
                purWFBizBillIds.add(bizbillid);
                calBillIds = bizbill2CalBillIdsMap.computeIfAbsent(bizbillid, k -> new HashSet(4));
                calBillIds.add(id);
            } else if (DischargeTypeEnum.UNCLEAR.getValue().equals(dischargetype)) {
                busBillSrcBizBillIds.add(bizbillid);
                calBillIds = bizbill2CalBillIdsMap.computeIfAbsent(bizbillid, k -> new HashSet(4));
                calBillIds.add(id);
            }
            if (istempvoucher) {
                this.builder.append(new Object[]{this.billType, tempvoucherid, id});
            } else if (DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargetype) && !issplitcreate) {
                busBillSrcBizBillIds.add(bizbillid);
                calBillIds = bizbill2CalBillIdsMap.computeIfAbsent(bizbillid, k -> new HashSet(4));
                calBillIds.add(id);
            }
            if (isdischargevoucher) {
                this.builder.append(new Object[]{this.billType, dischargevoucherid, id});
            } else if (DischargeTypeEnum.BILLCOMECLEAR.getValue().equals(dischargetype) && issplitcreate && "A".equals(writeoffstatus)) {
                busChargedBillBizBillIds.add(bizbillid);
                calBillIds = bizbill2CalBillIdsMap.computeIfAbsent(bizbillid, k -> new HashSet(4));
                calBillIds.add(id);
            }
            if (iscostcarryover) {
                this.builder.append(new Object[]{this.billType, carryovervoucherid, id});
            } else if ("im_saloutbill".equals(bizentityobject)) {
                saloutBillIds.add(bizbillid);
                calBillIds = bizbill2CalBillIdsMap.computeIfAbsent(bizbillid, k -> new HashSet(4));
                calBillIds.add(id);
            }
            if (isfeevoucher) {
                this.builder.append(new Object[]{this.billType, feevoucherid, id});
            }
            if (!isfivoucher && "im_mdc_mftproorder".equals(bizentityobject)) {
                mftProOrderIds.add(bizbillid);
                calBillIds = bizbill2CalBillIdsMap.computeIfAbsent(bizbillid, k -> new HashSet(4));
                calBillIds.add(id);
                continue;
            }
            if (isfivoucher || !"im_mdc_mftmanuinbill".equals(bizentityobject)) continue;
            mftInBillCRIds.add(id);
        }
        this.queryAPBillVoucher(purWFBizBillIds, bizbill2CalBillIdsMap);
        this.queryApBusBillVoucher(busBillSrcBizBillIds, bizbill2CalBillIdsMap);
        this.queryApChargeBusBillVoucher(busChargedBillBizBillIds, bizbill2CalBillIdsMap);
        this.queryArBillVoucher(saloutBillIds, bizbill2CalBillIdsMap);
        this.queryMatAllocVoucher(mftProOrderIds, bizbill2CalBillIdsMap);
        this.queryFinCostTranVoucher(mftInBillCRIds, bizbill2CalBillIdsMap);
        return this.getDataSetCacheId();
    }

    private void queryFinCostTranVoucher(Set<Long> mftInBillCRIds, Map<Long, Set<Long>> bizbill2CalBillIdsMap) {
        if (mftInBillCRIds.isEmpty()) {
            return;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
        ArrayList inputs = new ArrayList(4);
        Lists.partition(Arrays.asList(mftInBillCRIds.toArray(new Long[0])), (int)this.split_size).forEach(list -> {
            QFilter filter = new QFilter("sourcebill", "in", list);
            filter.and(orgFilter);
            OrmInput input = new OrmInput(this.getClass().getName(), "aca_finishcosttranfer", "id,sourcebill", filter.toArray());
            inputs.add(input);
        });
        DataSet billDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        HashMap<Long, Set<Long>> finCostTran2calBillIdsMap = new HashMap<Long, Set<Long>>(4);
        for (Row row : billDS) {
            Long bizbill = row.getLong("sourcebill");
            Long apBillId = row.getLong("id");
            Set<Long> calBillIds = bizbill2CalBillIdsMap.get(bizbill);
            Set curCalBillIds = finCostTran2calBillIdsMap.computeIfAbsent(apBillId, k -> new HashSet(4));
            curCalBillIds.addAll(calBillIds);
        }
        this.queryOtherBillVoucher(Collections.singletonMap("aca_finishcosttranfer", finCostTran2calBillIdsMap.keySet()), finCostTran2calBillIdsMap);
    }

    private void queryMatAllocVoucher(Set<Long> mftProOrderIds, Map<Long, Set<Long>> bizbill2CalBillIdsMap) {
        if (mftProOrderIds.isEmpty()) {
            return;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
        ArrayList inputs = new ArrayList(4);
        Lists.partition(Arrays.asList(mftProOrderIds.toArray(new Long[0])), (int)this.split_size).forEach(list -> {
            QFilter filter = new QFilter("sourcebillid", "in", list);
            filter.and(orgFilter);
            OrmInput input = new OrmInput(this.getClass().getName(), "sca_matusecollect", "id,sourcebillid,entryentity.id", filter.toArray());
            inputs.add(input);
        });
        DataSet billDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        HashMap<Long, Set> matUseCollect2calBillIdsMap = new HashMap<Long, Set>(4);
        for (Row row : billDS) {
            Long bizbill = row.getLong("sourcebillid");
            Long apBillId = row.getLong("entryentity.id");
            Set<Long> calBillIds = bizbill2CalBillIdsMap.get(bizbill);
            Set curCalBillIds = matUseCollect2calBillIdsMap.computeIfAbsent(apBillId, k -> new HashSet(4));
            curCalBillIds.addAll(calBillIds);
        }
        ArrayList inputs2 = new ArrayList(4);
        Lists.partition(Arrays.asList(mftProOrderIds.toArray(new Long[0])), (int)this.split_size).forEach(list -> {
            QFilter filter = new QFilter("matcollect", "in", list);
            filter.and(orgFilter);
            OrmInput input = new OrmInput(this.getClass().getName(), "sca_matalloc", "id,matcollect", filter.toArray());
            inputs2.add(input);
        });
        DataSet matAllocDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs2.toArray(new OrmInput[0]));
        HashMap<Long, Set<Long>> matAlloc2calBillIdsMap = new HashMap<Long, Set<Long>>(4);
        for (Row row : matAllocDS) {
            Long bizbill = row.getLong("matcollect");
            Long apBillId = row.getLong("id");
            Set calBillIds = (Set)matUseCollect2calBillIdsMap.get(bizbill);
            Set curCalBillIds = matAlloc2calBillIdsMap.computeIfAbsent(apBillId, k -> new HashSet(4));
            curCalBillIds.addAll(calBillIds);
        }
        this.queryOtherBillVoucher(Collections.singletonMap("sca_matalloc", matAlloc2calBillIdsMap.keySet()), matAlloc2calBillIdsMap);
        this.queryOtherBillVoucher(Collections.singletonMap("aca_matalloc", matAlloc2calBillIdsMap.keySet()), matAlloc2calBillIdsMap);
    }

    private void queryArBillVoucher(Set<Long> saloutBillIds, Map<Long, Set<Long>> bizbill2CalBillIdsMap) {
        if (saloutBillIds.isEmpty()) {
            return;
        }
        Map<Long, Set<Long>> revcfmBill2calBillIdsMap = this.queryApArBill2CalBillidsMap(saloutBillIds, bizbill2CalBillIdsMap, "ar_verifyrecord");
        if (revcfmBill2calBillIdsMap.isEmpty()) {
            return;
        }
        this.queryOtherBillVoucher(Collections.singletonMap("ar_revcfmbill", revcfmBill2calBillIdsMap.keySet()), revcfmBill2calBillIdsMap);
    }

    private void queryApChargeBusBillVoucher(Set<Long> busChargedBillBizBillIds, Map<Long, Set<Long>> bizbill2CalBillIdsMap) {
        if (busChargedBillBizBillIds.isEmpty()) {
            return;
        }
        Map<Long, Set<Long>> apBill2calBillIdsMap = this.queryApArBill2CalBillidsMap(busChargedBillBizBillIds, bizbill2CalBillIdsMap, "ap_verifyrecord");
        if (apBill2calBillIdsMap.isEmpty()) {
            return;
        }
        Map<Long, Set<Long>> apBusBill2calBillIdsMap = this.queryApChareBusBill(apBill2calBillIdsMap);
        this.queryOtherBillVoucher(Collections.singletonMap("ap_busbill", apBusBill2calBillIdsMap.keySet()), apBusBill2calBillIdsMap);
    }

    private void queryApBusBillVoucher(Set<Long> busBillSrcBizBillIds, Map<Long, Set<Long>> bizbill2CalBillIdsMap) {
        if (busBillSrcBizBillIds.isEmpty()) {
            return;
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
        orgFilter.and("isadjust", "=", (Object)false);
        orgFilter.and("isrevaluation", "=", (Object)false);
        ArrayList inputs = new ArrayList(4);
        Lists.partition(Arrays.asList(busBillSrcBizBillIds.toArray(new Long[0])), (int)this.split_size).forEach(list -> {
            HashSet<String> sourceBillIdStrs = new HashSet<String>(4);
            for (Long aLong : list) {
                sourceBillIdStrs.add(aLong.toString());
            }
            QFilter filter = new QFilter("sourcebillid", "in", sourceBillIdStrs);
            filter.and(orgFilter);
            OrmInput input = new OrmInput(this.getClass().getName(), "ap_busbill", "id,sourcebillid", filter.toArray());
            inputs.add(input);
        });
        DataSet billDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        HashMap<Long, Set<Long>> apBill2calBillIdsMap = new HashMap<Long, Set<Long>>(4);
        for (Row row : billDS) {
            Long bizbill = Long.valueOf(row.getString("sourcebillid"));
            Long apBillId = row.getLong("id");
            Set<Long> calBillIds = bizbill2CalBillIdsMap.get(bizbill);
            Set curCalBillIds = apBill2calBillIdsMap.computeIfAbsent(apBillId, k -> new HashSet(4));
            curCalBillIds.addAll(calBillIds);
        }
        this.queryOtherBillVoucher(Collections.singletonMap("ap_busbill", apBill2calBillIdsMap.keySet()), apBill2calBillIdsMap);
    }

    private void queryAPBillVoucher(Set<Long> purWFBizBillIds, Map<Long, Set<Long>> bizbill2CalBillIdsMap) {
        if (purWFBizBillIds.isEmpty()) {
            return;
        }
        Map<Long, Set<Long>> apBill2calBillIdsMap = this.queryApArBill2CalBillidsMap(purWFBizBillIds, bizbill2CalBillIdsMap, "ap_verifyrecord");
        this.queryOtherBillVoucher(Collections.singletonMap("ap_finapbill", apBill2calBillIdsMap.keySet()), apBill2calBillIdsMap);
    }

    private Map<Long, Set<Long>> queryApArBill2CalBillidsMap(Set<Long> bizBillIds, Map<Long, Set<Long>> bizbill2CalBillIdsMap, String veryEntity) {
        String billentity;
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
        if ("ap_verifyrecord".equals(veryEntity)) {
            orgFilter.and("verifyrelation", "in", (Object)new String[]{"appurin", "appurreturn"});
            billentity = "ap_finapbill";
        } else {
            orgFilter.and("verifyrelation", "in", (Object)new String[]{"arsalout", "arsalreturn"});
            billentity = "ar_revcfmbill";
        }
        ArrayList inputs = new ArrayList(4);
        Lists.partition(Arrays.asList(bizBillIds.toArray(new Long[0])), (int)this.split_size).forEach(list -> {
            QFilter filter = new QFilter("billid", "in", list);
            filter.and(orgFilter);
            OrmInput input = new OrmInput(this.getClass().getName(), veryEntity, "billid,entry.e_billid,entry.e_hadwrittenoff", filter.toArray());
            inputs.add(input);
        });
        DataSet billDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        HashSet<Long> hadwriteoffBillIds = new HashSet<Long>(4);
        HashMap<Long, Set<Long>> arapBill2calBillIdsMap = new HashMap<Long, Set<Long>>(4);
        for (Row row : billDS) {
            Long bizbill = row.getLong("billid");
            Long apBillId = row.getLong("entry.e_billid");
            boolean hadwrittenoff = row.getBoolean("entry.e_hadwrittenoff");
            Set<Long> calBillIds = bizbill2CalBillIdsMap.get(bizbill);
            Set curCalBillIds = arapBill2calBillIdsMap.computeIfAbsent(apBillId, k -> new HashSet(4));
            curCalBillIds.addAll(calBillIds);
            if (!hadwrittenoff) continue;
            hadwriteoffBillIds.add(row.getLong("entry.e_billid"));
        }
        if (!hadwriteoffBillIds.isEmpty()) {
            ArrayList arapInputs = new ArrayList(4);
            Lists.partition(Arrays.asList(hadwriteoffBillIds.toArray(new Long[0])), (int)this.split_size).forEach(list -> {
                QFilter filter = new QFilter("sourcebillid", "in", list);
                OrmInput input = new OrmInput(this.getClass().getName(), billentity, "id,sourcebillid", filter.toArray());
                arapInputs.add(input);
            });
            DataSet apbillDS = Algo.create((String)this.getClass().getName()).createDataSet((Input[])arapInputs.toArray(new OrmInput[0]));
            for (Row row : apbillDS) {
                Long id = row.getLong("id");
                Long sourcebillid = row.getLong("sourcebillid");
                Set calBillIds = (Set)arapBill2calBillIdsMap.get(sourcebillid);
                arapBill2calBillIdsMap.put(id, calBillIds);
            }
        }
        return arapBill2calBillIdsMap;
    }
}

