/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.account;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.account.CloseAccountFacade;
import kd.fi.cal.business.account.ReconciliationParam;
import kd.fi.cal.business.calculate.billgroup.AutoSortServic;
import kd.fi.cal.business.calculate.billgroup.CostAccountGroupRecordHelper;
import kd.fi.cal.business.calculate.out.FIFOPeriodDataCalculate;
import kd.fi.cal.business.datacheck.AlarmLevel;
import kd.fi.cal.business.datacheck.DataCheckParam;
import kd.fi.cal.business.datacheck.DataCheckTask;
import kd.fi.cal.business.datacheck.DataCheckTaskEntry;
import kd.fi.cal.business.datacheck.DataCheckTaskExecutor;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.CalCustomEventCallHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;
import kd.fi.cal.common.log.CalLogInfo;
import kd.fi.cal.common.log.CalLogUtils;
import kd.fi.cal.common.model.CalculateUIParamsHelper;
import kd.fi.cal.common.model.CloseAccountParam;
import kd.fi.cal.common.model.SettleAccountParam;
import kd.fi.cal.common.model.SimpleSettleAccountParam;
import kd.fi.cal.common.util.CommonUtils;
import kd.fi.cal.common.util.DateUtils;

public class SettleAccountFacade {
    private StringBuilder errorMsg = new StringBuilder();
    private String line_break = "\r\n";
    private boolean backgroundInvoke = false;
    private boolean autoCloseValidateParam = false;
    public List<String> settleAccountErrorMsgs;
    public Set<Object> errorLogIds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSettleAccount(SimpleSettleAccountParam[] params) {
        this.settleAccountErrorMsgs = new ArrayList<String>();
        this.errorLogIds = new HashSet<Object>();
        ArrayList<CalLogInfo> logInfos = new ArrayList<CalLogInfo>(255);
        for (SimpleSettleAccountParam simpleParam : params) {
            SettleAccountParam param = this.convertParam(simpleParam);
            HashSet<Long> calcOrgIds = new HashSet<Long>(1);
            calcOrgIds.add(param.getCostAccount().getLong("calorg.id"));
            DynamicObject taskInfo = this.createTask(param.getCostAccount().getString("number"));
            Long calTaskId = taskInfo.getLong("id");
            String errorMsg = null;
            boolean isError = false;
            try {
                Object logIds;
                boolean isNeedCloseAccount;
                List<CloseAccountParam> closeAccountParamList = this.getCloseAccountParam(param);
                boolean bl = isNeedCloseAccount = closeAccountParamList.size() > 0;
                if (isNeedCloseAccount) {
                    this.addSuccessLog(param, "C", calTaskId);
                }
                boolean isPassCheck = true;
                Map checkItems = param.getCheckItems();
                if (checkItems != null && !checkItems.isEmpty()) {
                    isPassCheck = this.doCheck(param, closeAccountParamList, isNeedCloseAccount, calTaskId);
                } else {
                    if (isNeedCloseAccount) {
                        this.addLog(param, null, "C");
                    }
                    this.addSuccessLog(param, "A", calTaskId);
                }
                String checkMsg = this.checkCalRange(param);
                if (checkMsg != null) {
                    this.settleAccountErrorMsgs.add(checkMsg);
                    List<Object> logIds2 = this.addLog(param, checkMsg, "A");
                    if (logIds2 != null && !logIds2.isEmpty()) {
                        this.errorLogIds.addAll(logIds2);
                    }
                    isPassCheck = false;
                } else {
                    String checkAcctMsg = this.doCalGLCheckAccount(param);
                    if (StringUtils.isNotEmpty((String)checkAcctMsg)) {
                        this.settleAccountErrorMsgs.add(checkAcctMsg);
                        logIds = this.addLog(param, checkAcctMsg, "A");
                        if (logIds != null && !logIds.isEmpty()) {
                            this.errorLogIds.addAll((Collection<Object>)logIds);
                        }
                        isPassCheck = false;
                    }
                }
                if (!isPassCheck) continue;
                TXHandle t = TX.requiresNew();
                logIds = null;
                try {
                    try {
                        if (isNeedCloseAccount) {
                            CloseAccountFacade closeActFacade = new CloseAccountFacade();
                            closeActFacade.setSettle(true);
                            closeActFacade.doCloseAccount(closeAccountParamList.toArray(new CloseAccountParam[0]));
                        }
                        this.modifyStopSyncBizBill(calcOrgIds, true);
                        this.settleAccount(param);
                    }
                    catch (Exception e) {
                        t.markRollback();
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    logIds = throwable;
                    throw throwable;
                }
                finally {
                    if (t != null) {
                        if (logIds != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)logIds).addSuppressed(throwable);
                            }
                        } else {
                            t.close();
                        }
                    }
                }
                CalCustomEventCallHelper.calCheckoutEventCall((SimpleSettleAccountParam)simpleParam);
            }
            catch (Exception e) {
                isError = true;
                if (e.getMessage() != null) {
                    errorMsg = e.getMessage();
                } else {
                    StackTraceElement[] errs;
                    StringBuilder sb = new StringBuilder();
                    for (StackTraceElement err : errs = e.getStackTrace()) {
                        sb.append(err).append(this.line_break);
                    }
                    errorMsg = sb.toString();
                }
            }
            finally {
                this.modifyStopSyncBizBill(calcOrgIds, false);
                this.updateTaskStatus(calTaskId);
            }
            if (isError) {
                if (StringUtils.isEmpty((String)errorMsg)) {
                    errorMsg = ResManager.loadKDString((String)"\u672a\u8bb0\u5f55\u5230\u65e5\u5fd7\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u7cfb\u7edfmonitor\u65e5\u5fd7\u3002", (String)"SettleAccountFacade_0", (String)"fi-cal-business", (Object[])new Object[0]);
                }
                this.settleAccountErrorMsgs.add(errorMsg);
                List<Object> logIds = this.addLog(param, errorMsg, "A");
                if (logIds != null && !logIds.isEmpty()) {
                    this.errorLogIds.addAll(logIds);
                }
            } else {
                this.addLog(param, null, "A");
            }
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\u7ed3\u8d26", (String)"SettleAccountFacade_39", (String)"fi-cal-business", (Object[])new Object[0]), param.getCostAccount().getString("name"));
            logInfos.add(CalLogUtils.buildCalAppLog((boolean)isError, (String)"cal_settleaccount", (String)msg, (long)param.getCostAccount().getDynamicObject("calorg").getLong("id")));
        }
        CalLogUtils.addBatchLog(logInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnSettleAccount(SimpleSettleAccountParam[] params) {
        ArrayList<CalLogInfo> logInfos = new ArrayList<CalLogInfo>(255);
        for (SimpleSettleAccountParam simpleParam : params) {
            SettleAccountParam param = this.convertParam(simpleParam);
            HashSet<Long> calcOrgIds = new HashSet<Long>(1);
            calcOrgIds.add(param.getCostAccount().getLong("calorg.id"));
            this.addSuccessLog(param, "B", 0L);
            String errorMsg = "";
            boolean isError = false;
            try (TXHandle t = TX.requiresNew();){
                try {
                    this.checkUnSettleAccount(param);
                    this.modifyStopSyncBizBill(calcOrgIds, true);
                    this.unSettleAccount(param);
                }
                catch (Exception e) {
                    isError = true;
                    if (e.getMessage() != null) {
                        errorMsg = e.getMessage();
                    } else {
                        StackTraceElement[] errs;
                        StringBuilder sb = new StringBuilder();
                        for (StackTraceElement err : errs = e.getStackTrace()) {
                            sb.append(err).append(this.line_break);
                        }
                        errorMsg = sb.toString();
                    }
                }
                finally {
                    this.modifyStopSyncBizBill(calcOrgIds, false);
                }
            }
            if (isError) {
                if (StringUtils.isEmpty((String)errorMsg)) {
                    errorMsg = ResManager.loadKDString((String)"\u672a\u8bb0\u5f55\u5230\u65e5\u5fd7\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u7cfb\u7edfmonitor\u65e5\u5fd7\u3002", (String)"SettleAccountFacade_0", (String)"fi-cal-business", (Object[])new Object[0]);
                }
                this.addLog(param, errorMsg, "B");
            } else {
                this.addLog(param, null, "B");
            }
            String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u3010%1$s\u3011\u53cd\u7ed3\u8d26", (String)"SettleAccountFacade_40", (String)"fi-cal-business", (Object[])new Object[0]), param.getCostAccount().getString("name"));
            logInfos.add(CalLogUtils.buildCalAppLog((boolean)isError, (String)"cal_settleaccount", (String)msg, (long)param.getCostAccount().getDynamicObject("calorg").getLong("id")));
        }
        CalLogUtils.addBatchLog(logInfos);
    }

    private void unSettleAccount(SettleAccountParam param) {
        this.setPreviousPeriod(param);
        String settleAccountModel = CalDbParamServiceHelper.getString((String)CalDbParamConstant.SETTLEACCOUNT_MODEL, null);
        if ("A".equals(settleAccountModel)) {
            HashSet<Long> successAccountIds = new HashSet<Long>(1);
            successAccountIds.add(param.getCostAccount().getLong("id"));
            new CostAccountGroupRecordHelper().refreshGroupRecordByCostAccount(successAccountIds);
            if (AcctGroupModelHelper.isNewGroupModel()) {
                AutoSortServic sortService = new AutoSortServic();
                Set<Long> acctIds = Collections.singleton(param.getCostAccount().getLong("id"));
                sortService.sortByAsyncByAccountId(acctIds);
            }
        }
        this.deleteDischargeVoucher(param);
        this.setFifoBalRptIdToNull(param);
    }

    private void setPreviousPeriod(SettleAccountParam param) {
        DynamicObject costAccount = param.getCostAccount();
        DynamicObject previousPeriod = param.getPreviousPeriod();
        if (previousPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u4e0a\u4e00\u671f\u95f4\u6216\u8005\u6210\u672c\u8d26\u7c3f\u8fd8\u672a\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u8d26\u3002", (String)"SettleAccountFacade_4", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        String sql = "update t_cal_systemctrlentry set fcurrentperiodid = ? where fcostaccountid = ?";
        Object[] o = new Object[]{previousPeriod.getPkValue(), costAccount.getLong("id")};
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, (Object[])o);
    }

    private void checkUnSettleAccount(SettleAccountParam param) {
        this.checkPeriod(param);
        if (this.errorMsg.length() > 0) {
            throw new KDBizException(this.errorMsg.toString());
        }
    }

    private void checkPeriod(SettleAccountParam param) {
        DynamicObject costAccount = param.getCostAccount();
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity((Long)costAccount.getLong("id"));
        int i = PeriodHelper.compare2period((DynamicObject)sysCtrl.getDynamicObject("startperiod"), (DynamicObject)sysCtrl.getDynamicObject("currentperiod"));
        if (i != -1) {
            this.addErrorMsg(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u7b49\u4e8e\u542f\u7528\u671f\u95f4\uff0c\u4e0d\u9700\u8981\u53cd\u7ed3\u8d26\u3002", (String)"SettleAccountFacade_5", (String)"fi-cal-business", (Object[])new Object[0]));
        }
    }

    private void settleAccount(SettleAccountParam param) {
        this.setNextPeriod(param);
        String settleAccountModel = CalDbParamServiceHelper.getString((String)CalDbParamConstant.SETTLEACCOUNT_MODEL, null);
        if ("A".equals(settleAccountModel)) {
            HashSet<Long> successAccountIds = new HashSet<Long>(1);
            successAccountIds.add(param.getCostAccount().getLong("id"));
            new CostAccountGroupRecordHelper().refreshGroupRecordByCostAccount(successAccountIds);
            if (AcctGroupModelHelper.isNewGroupModel()) {
                AutoSortServic sortService = new AutoSortServic();
                Set<Long> acctIds = Collections.singleton(param.getCostAccount().getLong("id"));
                sortService.sortByAsyncByAccountId(acctIds);
            }
        }
        this.createDischargeVoucher(param);
        this.setFifoBalRptIdToNull(param);
        this.setFifoBalToNextPeriod(param);
    }

    private void setFifoBalToNextPeriod(SettleAccountParam param) {
        DynamicObject costAccount = param.getCostAccount();
        new FIFOPeriodDataCalculate(costAccount.getLong("id"), new HashSet<Long>(1)).calBalData4SettleAccount();
    }

    private void setFifoBalRptIdToNull(SettleAccountParam param) {
        DynamicObject costAccount = param.getCostAccount();
        String sql = "update t_cal_balance_fifo set fcalrptid = 0 where fcostaccountid = " + costAccount.getLong("id");
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql);
    }

    private void createDischargeVoucher(SettleAccountParam param) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("curPeriod", param.getNextPeriod().getLong("id"));
        map.put("prePeriod", param.getCurrentPeriod().getLong("id"));
        map.put("costAccount", param.getCostAccount().getLong("id"));
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{"SETTLEACCOUNT", map, null});
    }

    private void deleteDischargeVoucher(SettleAccountParam param) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("curPeriod", param.getCurrentPeriod().getLong("id"));
        map.put("costAccount", param.getCostAccount().getLong("id"));
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{"UNSETTLEACCOUNT", map, null});
    }

    private String checkCalRange(SettleAccountParam param) {
        String errorMsg = null;
        DynamicObject costAccount = param.getCostAccount();
        if (!costAccount.getBoolean("enable")) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u5df2\u88ab\u7981\u7528", (String)"SettleAccountFacade_44", (String)"fi-cal-business", (Object[])new Object[0]), costAccount.getString("name"));
            return errorMsg;
        }
        QFilter q = new QFilter("status", "=", (Object)Character.valueOf('C'));
        q.and("enable", "=", (Object)Character.valueOf('1'));
        q.and("costaccount", "=", (Object)costAccount.getLong("id"));
        if (!QueryServiceHelper.exists((String)"cal_bd_calrange", (QFilter[])q.toArray())) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u627e\u4e0d\u5230\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u6838\u7b97\u8303\u56f4\u3002", (String)"SettleAccountFacade_45", (String)"fi-cal-business", (Object[])new Object[0]), costAccount.getString("name"));
        }
        return errorMsg;
    }

    private void setNextPeriod(SettleAccountParam param) {
        DynamicObject costAccount = param.getCostAccount();
        DynamicObject nextPeriod = param.getNextPeriod();
        if (nextPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u4e0b\u4e00\u671f\u95f4\u6216\u8005\u5df2\u5230\u6700\u540e\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u7ed3\u8d26\u3002", (String)"SettleAccountFacade_20", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        String sql = "update t_cal_systemctrlentry set fcurrentperiodid = ? where fcostaccountid = ?";
        Object[] o = new Object[]{nextPeriod.getPkValue(), costAccount.getLong("id")};
        DB.execute((DBRoute)CommonUtils.getCalDBRouteKey(), (String)sql, (Object[])o);
    }

    private void addSuccessLog(SettleAccountParam param, String settleType, Long calTaskId) {
        DynamicObject costAccount = param.getCostAccount();
        DynamicObject period = param.getCurrentPeriod();
        DynamicObject expectPeriod = param.getNextPeriod();
        String msg = ResManager.loadKDString((String)"\u7ed3\u8d26\u5230", (String)"SettleAccountFacade_21", (String)"fi-cal-business", (Object[])new Object[0]);
        if ("B".equals(settleType)) {
            expectPeriod = param.getPreviousPeriod();
            msg = ResManager.loadKDString((String)"\u53cd\u7ed3\u8d26\u5230", (String)"SettleAccountFacade_23", (String)"fi-cal-business", (Object[])new Object[0]);
        } else if ("C".equals(settleType)) {
            msg = ResManager.loadKDString((String)"\u5173\u8d26\u5230", (String)"SettleAccountFacade_22", (String)"fi-cal-business", (Object[])new Object[0]);
        }
        QFilter q = new QFilter("costaccount", "=", costAccount.getPkValue());
        q.and("currentperiod", "=", period.getPkValue());
        if (expectPeriod == null) {
            q.and("expectperiod", "=", (Object)0L);
        } else {
            q.and("expectperiod", "=", expectPeriod.getPkValue());
        }
        q.and("settletype", "=", (Object)settleType);
        DynamicObject[] existsLogs = BusinessDataServiceHelper.load((String)"cal_settleaccountlog", (String)"success,operationtime,operationuser,log,checkresult,taskid,queryscheme", (QFilter[])new QFilter[]{q});
        if (existsLogs.length > 0) {
            existsLogs[0].set("success", (Object)Boolean.FALSE);
            existsLogs[0].set("operationtime", (Object)new Date());
            existsLogs[0].set("operationuser", (Object)RequestContext.get().getUserId());
            existsLogs[0].set("log", (Object)ResManager.loadKDString((String)"\u8fd0\u884c\u4e2d", (String)"SettleAccountFacade_24", (String)"fi-cal-business", (Object[])new Object[0]));
            existsLogs[0].set("checkresult", null);
            existsLogs[0].set("taskid", (Object)calTaskId);
            existsLogs[0].set("queryscheme", (Object)param.getQuerySchemeId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{existsLogs[0]});
        } else {
            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"cal_settleaccountlog");
            String periodMsg = "";
            periodMsg = expectPeriod == null ? period.getString("name") + msg : period.getString("name") + msg + expectPeriod.getString("name");
            log.set("costaccount", (Object)costAccount);
            log.set("currentperiod", (Object)period);
            log.set("expectperiod", (Object)expectPeriod);
            log.set("settletype", (Object)settleType);
            log.set("success", (Object)Boolean.FALSE);
            log.set("operationtime", (Object)new Date());
            log.set("operationuser", (Object)RequestContext.get().getUserId());
            log.set("log", (Object)ResManager.loadKDString((String)"\u8fd0\u884c\u4e2d", (String)"SettleAccountFacade_24", (String)"fi-cal-business", (Object[])new Object[0]));
            log.set("periodmsg", (Object)periodMsg);
            log.set("taskid", (Object)calTaskId);
            log.set("queryscheme", (Object)param.getQuerySchemeId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        }
    }

    private List<Object> addLog(SettleAccountParam param, String errorMsg, String settleType) {
        ArrayList<Object> logIds = new ArrayList<Object>();
        DynamicObject costAccount = param.getCostAccount();
        DynamicObject period = param.getCurrentPeriod();
        DynamicObject expectPeriod = param.getNextPeriod();
        if ("B".equals(settleType)) {
            expectPeriod = param.getPreviousPeriod();
        }
        QFilter q = new QFilter("costaccount", "=", costAccount.getPkValue());
        q.and("currentperiod", "=", period.getPkValue());
        if (expectPeriod == null) {
            q.and("expectperiod", "=", (Object)0L);
        } else {
            q.and("expectperiod", "=", expectPeriod.getPkValue());
        }
        q.and("settletype", "=", (Object)settleType);
        DynamicObject[] existsLogs = BusinessDataServiceHelper.load((String)"cal_settleaccountlog", (String)"success,log,log_tag,checkresult", (QFilter[])new QFilter[]{q});
        if (existsLogs.length > 0) {
            existsLogs[0].set("checkresult", (Object)ResManager.loadKDString((String)"\u8be6\u60c5", (String)"CloseAccountFacade_18", (String)"fi-cal-business", (Object[])new Object[0]));
            if (errorMsg == null) {
                existsLogs[0].set("success", (Object)Boolean.TRUE);
                existsLogs[0].set("log_tag", null);
                existsLogs[0].set("log", null);
                OperationServiceHelper.executeOperate((String)"save", (String)"cal_settleaccountlog", (DynamicObject[])new DynamicObject[]{existsLogs[0]}, (OperateOption)OperateOption.create());
            } else {
                existsLogs[0].set("success", (Object)Boolean.FALSE);
                existsLogs[0].set("log_tag", (Object)errorMsg);
                if (errorMsg.length() > 255) {
                    errorMsg = errorMsg.substring(0, 255);
                }
                existsLogs[0].set("log", (Object)errorMsg);
                Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{existsLogs[0]});
                if (save != null && save.length != 0) {
                    for (Object o : save) {
                        if (o == null) continue;
                        logIds.add(((DynamicObject)o).getPkValue());
                    }
                }
            }
        }
        return logIds;
    }

    private Long[] getAllOwners(DynamicObject costAccount) {
        return AccountingSysHelper.getOwners((Long)costAccount.getLong("id"));
    }

    private void addErrorMsg(String msg) {
        this.errorMsg.append(msg).append(';').append(this.line_break);
    }

    private SettleAccountParam convertParam(SimpleSettleAccountParam simpleParam) {
        SettleAccountParam param = new SettleAccountParam();
        param.setUpdateSaveBill(simpleParam.isUpdateSaveBill());
        param.setUpdateSubmitBill(simpleParam.isUpdateSubmitBill());
        param.setCheckItems(simpleParam.getCheckItems());
        param.setCheckStatus(simpleParam.isCheckStatus());
        param.setCostAccount(CalculateUIParamsHelper.getCostAccount((Long)simpleParam.getCostAccountId()));
        param.setCurrentPeriod(CalculateUIParamsHelper.getCalPeriod((Long)simpleParam.getCurrentPeriodId()));
        param.setNextPeriod(CalculateUIParamsHelper.getCalPeriod((Long)simpleParam.getNextPeriodId()));
        param.setPreviousPeriod(CalculateUIParamsHelper.getCalPeriod((Long)simpleParam.getPreviousPeriodId()));
        param.setQuerySchemeId(simpleParam.getQuerSchemeId());
        return param;
    }

    private DynamicObject createTask(String accountNumber) {
        DynamicObject taskInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_task");
        String msg = String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u3010%1$s\u3011\u7ed3\u8d26", (String)"CalculateOutCostPlugin_14", (String)"fi-cal-business", (Object[])new Object[0]), accountNumber);
        taskInfo.set("name", (Object)msg);
        taskInfo.set("starttime", (Object)TimeServiceHelper.now());
        taskInfo.set("creator_id", (Object)RequestContext.get().getUserId());
        taskInfo.set("status", (Object)"B");
        taskInfo.set("tasktype", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
        return taskInfo;
    }

    private boolean doCheck(SettleAccountParam param, List<CloseAccountParam> closeAccountParamList, boolean isNeedCloseAccount, Long calTaskId) {
        List<Object> logIds;
        boolean isPassCheck = true;
        Map closeAccountItems = (Map)param.getCheckItems().get("C");
        Map settleAccountItems = (Map)param.getCheckItems().get("B");
        if (isNeedCloseAccount) {
            if (closeAccountItems != null && !closeAccountItems.isEmpty()) {
                for (CloseAccountParam closeAccountParam : closeAccountParamList) {
                    boolean isPassCloseCheck = new CloseAccountFacade().doCloseAccountCheck(closeAccountParam, calTaskId);
                    if (isPassCloseCheck) continue;
                    isPassCheck = isPassCloseCheck;
                }
                if (!isPassCheck) {
                    this.settleAccountErrorMsgs.add(ResManager.loadKDString((String)"\u5173\u8d26\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u8bf7\u5728\u8be6\u60c5\u4e2d\u67e5\u770b\u68c0\u67e5\u7ed3\u679c\u3002", (String)"CloseAccountFacade_01", (String)"fi-cal-business", (Object[])new Object[0]));
                    logIds = this.addLog(param, ResManager.loadKDString((String)"\u5173\u8d26\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u8bf7\u5728\u8be6\u60c5\u4e2d\u67e5\u770b\u68c0\u67e5\u7ed3\u679c\u3002", (String)"CloseAccountFacade_01", (String)"fi-cal-business", (Object[])new Object[0]), "C");
                    if (logIds != null && !logIds.isEmpty()) {
                        this.errorLogIds.addAll(logIds);
                    }
                    return isPassCheck;
                }
                this.addLog(param, null, "C");
            } else {
                this.addLog(param, null, "C");
            }
        }
        this.addSuccessLog(param, "A", calTaskId);
        if (settleAccountItems != null && !settleAccountItems.isEmpty()) {
            isPassCheck = this.doSettleAccountCheck(param, calTaskId);
            if (!isPassCheck) {
                this.settleAccountErrorMsgs.add(ResManager.loadKDString((String)"\u7ed3\u8d26\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u8bf7\u5728\u8be6\u60c5\u4e2d\u67e5\u770b\u68c0\u67e5\u7ed3\u679c\u3002", (String)"SettleAccountFacade_01", (String)"fi-cal-business", (Object[])new Object[0]));
                logIds = this.addLog(param, ResManager.loadKDString((String)"\u7ed3\u8d26\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u8bf7\u5728\u8be6\u60c5\u4e2d\u67e5\u770b\u68c0\u67e5\u7ed3\u679c\u3002", (String)"SettleAccountFacade_01", (String)"fi-cal-business", (Object[])new Object[0]), "A");
                if (logIds != null && !logIds.isEmpty()) {
                    this.errorLogIds.addAll(logIds);
                }
                return isPassCheck;
            }
            this.addLog(param, null, "A");
        }
        return isPassCheck;
    }

    private List<CloseAccountParam> getCloseAccountParam(SettleAccountParam param) {
        ArrayList<CloseAccountParam> closeAccountParamList = new ArrayList<CloseAccountParam>();
        DynamicObject costAccount = param.getCostAccount();
        Long[] owners = this.getAllOwners(costAccount);
        if (owners == null || owners.length == 0) {
            return closeAccountParamList;
        }
        DynamicObject period = param.getCurrentPeriod();
        Date endDate = period.getDate("enddate");
        endDate = DateUtils.getDayStartTime((Date)endDate);
        DynamicObject[] ownerColls = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)owners)});
        HashMap<Long, DynamicObject> ownerMap = new HashMap<Long, DynamicObject>(64);
        for (DynamicObject objectArray : ownerColls) {
            ownerMap.put(objectArray.getLong("id"), objectArray);
        }
        QFilter q = new QFilter("owner", "in", (Object)owners);
        q.and("isleaf", "=", (Object)Boolean.TRUE);
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"cal_closeaccounttable", (String)"id,calorg,costaccount,owner,isleaf,closedate", (QFilter[])new QFilter[]{q});
        HashMap<Long, Date> dateMap = new HashMap<Long, Date>(64);
        for (DynamicObject info : infos) {
            dateMap.put(info.getDynamicObject("owner").getLong("id"), info.getDate("closedate"));
        }
        Long[] longArray = owners;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long ownerId = longArray[i];
            Date closeDate = (Date)dateMap.get(ownerId);
            if ((closeDate = DateUtils.getDayStartTime((Date)closeDate)) != null && !closeDate.before(endDate)) continue;
            CloseAccountParam closeAccountParam = new CloseAccountParam();
            closeAccountParam.setOwner((DynamicObject)ownerMap.get(ownerId));
            closeAccountParam.setCloseDate(endDate);
            closeAccountParam.setLastCloseDate(closeDate);
            closeAccountParam.setIsCheckStatus(param.isCheckStatus());
            if (param.getCheckItems().get("C") != null) {
                HashMap checkItemMap = new HashMap(16);
                checkItemMap.put("C", param.getCheckItems().get("C"));
                closeAccountParam.setCheckItems(checkItemMap);
            }
            closeAccountParam.setUpdateSaveBill(param.isUpdateSaveBill());
            closeAccountParam.setUpdateSubmitBill(param.isUpdateSubmitBill());
            closeAccountParamList.add(closeAccountParam);
        }
        return closeAccountParamList;
    }

    private boolean doSettleAccountCheck(SettleAccountParam param, Long calTaskId) {
        boolean isPassCheck = true;
        Map checkItems = (Map)param.getCheckItems().get("B");
        DynamicObject costAccount = param.getCostAccount();
        costAccount = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,name,calorg.id,calorg.name", (QFilter[])new QFilter("id", "=", (Object)costAccount.getLong("id")).toArray());
        Long accountId = costAccount.getLong("id");
        DataCheckParam checkParam = new DataCheckParam();
        HashSet<Long> accountSet = new HashSet<Long>(1);
        accountSet.add(accountId);
        HashSet<Long> calOrgSet = new HashSet<Long>(1);
        calOrgSet.add(costAccount.getLong("calorg.id"));
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity((Long)accountId);
        checkParam.setStartDate(sysCtrl.getDate("currentperiod.begindate"));
        checkParam.setEndDate(sysCtrl.getDate("currentperiod.enddate"));
        checkParam.setCostAccount(accountSet);
        checkParam.setCalorg(calOrgSet);
        checkParam.setMsgStatus(",A,B,C");
        HashSet<Long> msgReceivers = new HashSet<Long>(16);
        msgReceivers.add(Long.valueOf(RequestContext.get().getUserId()));
        checkParam.setMsgReceiver(msgReceivers);
        DataCheckTask task = new DataCheckTask();
        Map checkItemMap = BusinessDataServiceHelper.loadFromCache((String)"cal_datacheck_item", (String)"plugin,tips", (QFilter[])new QFilter("id", "in", checkItems.keySet()).toArray());
        for (Map.Entry checkItemEntry : checkItemMap.entrySet()) {
            DynamicObject checkItem = (DynamicObject)checkItemEntry.getValue();
            Long checkItemId = (Long)checkItemEntry.getKey();
            task.addDataCheckTaskEntry(new DataCheckTaskEntry(checkItemId, checkItem.getString("plugin"), checkItem.getString("tips"), AlarmLevel.getByValue((String)checkItems.get(checkItemId))));
        }
        String calOrgName = costAccount.getString("calorg.name");
        String accountName = costAccount.getString("name");
        task.setPlanId(calTaskId);
        task.setPlanType("cal_task");
        task.setTaskId(1266490172376219648L);
        task.setCostaccount(accountName);
        task.setCalorg(calOrgName);
        task.setPurpose("B");
        DataCheckTaskExecutor executor = new DataCheckTaskExecutor();
        executor.commitSync(task, checkParam);
        isPassCheck = this.getCheckStatus(1266490172376219648L, calTaskId);
        return isPassCheck;
    }

    private boolean getCheckStatus(Long checkTaskId, Long calTaskId) {
        boolean isPassCheck = true;
        QFilter q = new QFilter("checkplan", "=", (Object)calTaskId);
        q.and("checktask", "=", (Object)checkTaskId);
        DataSet checkResultDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_datacheck_result", (String)"id,entryentity.entrystatus", (QFilter[])q.toArray(), null);
        for (Row row : checkResultDataSet) {
            String result = row.getString("entryentity.entrystatus");
            if (!"B".equals(result) && !"C".equals(result)) continue;
            isPassCheck = false;
            break;
        }
        return isPassCheck;
    }

    private void updateTaskStatus(Long calTaskId) {
        DynamicObject reloadTaskInfo = BusinessDataServiceHelper.loadSingle((Object)calTaskId, (String)"cal_task", (String)"status,endtime");
        reloadTaskInfo.set("status", (Object)"A");
        reloadTaskInfo.set("endtime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reloadTaskInfo});
    }

    public void setBackgroundInvoke(boolean backgroundInvoke) {
        this.backgroundInvoke = backgroundInvoke;
    }

    public void setAutoCloseValidateParam(boolean autoCloseValidateParam) {
        this.autoCloseValidateParam = autoCloseValidateParam;
    }

    private String doCalGLCheckAccount(SettleAccountParam settleAcctParam) {
        String checkAcctMsg = null;
        if (!this.isBackgroundInvoke() && !this.autoCloseValidateParam) {
            return checkAcctMsg;
        }
        DynamicObject costAccountDyc = settleAcctParam.getCostAccount();
        Long costAccountId = costAccountDyc.getLong("id");
        Long periodid = settleAcctParam.getCurrentPeriod().getLong("id");
        Long calOrgId = costAccountDyc.getLong("calorg.id");
        ReconciliationParam param = new ReconciliationParam();
        param.setPeriodId(periodid);
        param.setAppNumber("cal");
        param.setBizBookId(costAccountId);
        param.setOrgId(calOrgId);
        param.setInit(false);
        QFilter filter = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject dy = QueryServiceHelper.queryOne((String)"cal_accountparamssetting", (String)"entry.endaccountcheck", (QFilter[])new QFilter[]{filter});
        if (dy == null) {
            return checkAcctMsg;
        }
        String checkLevel = dy.getString("entry.endaccountcheck");
        if (!checkLevel.equals("B")) {
            String code = "";
            try {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconciliationService", (String)"execute", (Object[])new Object[]{SerializationUtils.toJsonString((Object)param)});
            }
            catch (KDBizException e) {
                ErrorCode ec = e.getErrorCode();
                code = ec.getCode();
            }
            if ("2".equals(code)) {
                checkAcctMsg = ResManager.loadKDString((String)"\u5b58\u5728\u5bf9\u8d26\u4e0d\u5e73\u7684\u6570\u636e\uff0c\u7ed3\u8d26\u5931\u8d25\u3002", (String)"SettleAccountFacade_37", (String)"fi-cal-business", (Object[])new Object[0]);
            }
        }
        return checkAcctMsg;
    }

    public boolean isBackgroundInvoke() {
        return this.backgroundInvoke;
    }

    private void modifyStopSyncBizBill(Set<Long> calOrgIds, boolean isStop) {
        new StopSyncSettingModifyHelper().modifySetting(calOrgIds, null, null, null, null, null, isStop, TimeServiceHelper.now());
    }
}

