/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.account;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.SimpleSettleAccountParam;

public class SettleAccountTaskDispatcher {
    private static final Log logger = LogFactory.getLog(SettleAccountTaskDispatcher.class);
    private final DynamicObject settleAccountDyc;
    private int[] selectedRowIndexs;
    private boolean settleAccout = true;
    private boolean backgroundInvoke = false;
    private Long querySchemeId = 0L;

    public SettleAccountTaskDispatcher(DynamicObject settleAccountDyc) {
        this.settleAccountDyc = settleAccountDyc;
    }

    public void dispatch() {
        this.dispatchSingleTask();
    }

    private void dispatchSingleTask() {
        SimpleSettleAccountParam[] params = new SimpleSettleAccountParam[this.selectedRowIndexs.length];
        DynamicObjectCollection settleAcctEntryDycs = this.settleAccountDyc.getDynamicObjectCollection("entryentity");
        HashSet<String> logPeriodMsgs = new HashSet<String>(16);
        for (int i = 0; i < this.selectedRowIndexs.length; ++i) {
            SimpleSettleAccountParam param = new SimpleSettleAccountParam();
            int rowIndex = this.selectedRowIndexs[i];
            DynamicObject costAccount = ((DynamicObject)settleAcctEntryDycs.get(rowIndex)).getDynamicObject("costaccount");
            DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
            if (period == null) {
                String periodMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u672a\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\u3002", (String)"SettleAccountFacade_41", (String)"fi-cal-business", (Object[])new Object[0]), costAccount.getString("name"));
                logPeriodMsgs.add(periodMsg);
                if (this.isBackgroundInvoke()) continue;
                throw new KDBizException(periodMsg);
            }
            DynamicObject nexPeriod = PeriodHelper.getNextPeriod((Object)period.getPkValue());
            DynamicObject previousPeriod = PeriodHelper.getPreviousPeriod((Object)period.getPkValue());
            param.setCostAccountId(costAccount.getLong("id"));
            param.setCostAccountName(costAccount.getString("name"));
            param.setCostAccountNum(costAccount.getString("number"));
            param.setCurrentPeriodId(period.getLong("id"));
            param.setCurrentPeriodNum(period.getString("number"));
            if (nexPeriod != null) {
                param.setNextPeriodId(nexPeriod.getLong("id"));
                param.setNextPeriodNum(nexPeriod.getString("number"));
            }
            if (previousPeriod != null) {
                param.setPreviousPeriodId(previousPeriod.getLong("id"));
                param.setPreviousPeriodNum(previousPeriod.getString("number"));
            }
            if (this.settleAccout) {
                this.setCheckParam(param);
            }
            param.setQuerSchemeId(this.getQuerySchemeId());
            params[i] = param;
        }
        this.doJob(params, this.settleAccout);
        logger.info("SettleAccountTaskDispatcher-logPeriodMsgs==>{}", logPeriodMsgs);
    }

    private void setCheckParam(SimpleSettleAccountParam param) {
        DynamicObjectCollection checkEntryDycs = this.settleAccountDyc.getDynamicObjectCollection("checkentry");
        int entryRowCount = checkEntryDycs.size();
        HashMap<String, HashMap<Long, String>> allCheckItemMap = new HashMap<String, HashMap<Long, String>>(16);
        for (int j = 0; j < entryRowCount; ++j) {
            DynamicObject checkItemDyc;
            DynamicObject checkEntryDyc = (DynamicObject)checkEntryDycs.get(j);
            Boolean ischeck = checkEntryDyc.getBoolean("ischeck");
            if (!ischeck.booleanValue() || (checkItemDyc = checkEntryDyc.getDynamicObject("checkitem")) == null) continue;
            Long itemId = checkItemDyc.getLong("id");
            String level = checkEntryDyc.getString("level");
            String purpose = checkEntryDyc.getString("purpose");
            HashMap<Long, String> checkItemMap = (HashMap<Long, String>)allCheckItemMap.get(purpose);
            if (checkItemMap == null) {
                checkItemMap = new HashMap<Long, String>(16);
            }
            checkItemMap.put(itemId, level);
            allCheckItemMap.put(purpose, checkItemMap);
        }
        param.setCheckItems(allCheckItemMap);
        param.setUpdateSaveBill(SettleAccountTaskDispatcher.isUpdateInvDate(this.settleAccountDyc, "A").booleanValue());
        param.setUpdateSubmitBill(SettleAccountTaskDispatcher.isUpdateInvDate(this.settleAccountDyc, "B").booleanValue());
    }

    public void setSelectedRowIndexs(int[] selectedRowIndexs) {
        this.selectedRowIndexs = selectedRowIndexs;
    }

    public static Boolean isUpdateInvDate(DynamicObject settleAccountDyc, String billStatus) {
        long itemId = "A".equals(billStatus) ? 1271579450798102528L : 1255062234141420544L;
        Boolean isUpdateInvDate = Boolean.FALSE;
        DynamicObjectCollection checkEntry = settleAccountDyc.getDynamicObjectCollection("checkentry");
        for (DynamicObject checkItem : checkEntry) {
            Long nowItemId;
            DynamicObject checkItemDyc = checkItem.getDynamicObject("checkitem");
            if (checkItemDyc == null || itemId != (nowItemId = Long.valueOf(checkItemDyc.getLong("id"))) || checkItem.getBoolean("ischeck")) continue;
            isUpdateInvDate = Boolean.TRUE;
        }
        return isUpdateInvDate;
    }

    private void doJob(SimpleSettleAccountParam[] params, boolean isSettle) {
        for (SimpleSettleAccountParam param : params) {
            HashMap<String, Object> jobParams = new HashMap<String, Object>(16);
            try {
                jobParams.put("param", JSONUtils.toString((Object)param));
            }
            catch (IOException e) {
                throw new KDBizException(e.getMessage());
            }
            jobParams.put("isSettle", isSettle);
            jobParams.put("backgroundInvoke", this.backgroundInvoke);
            JobInfo job = new JobInfo();
            String OpName = String.format(ResManager.loadKDString((String)"\u5b58\u8d27\u6838\u7b97\u7ed3\u8d26-\u6210\u672c\u8d26\u7c3f\u7f16\u7801:%1$s,\u6210\u672c\u8d26\u7c3f\u540d\u79f0:%2$s,\u671f\u95f4%3$s\u7ed3\u8d26\u5230%4$s", (String)"SettleAccountFacade_42", (String)"fi-cal-business", (Object[])new Object[0]), param.getCostAccountNum(), param.getCostAccountName(), param.getCurrentPeriodNum(), param.getNextPeriodNum());
            if (!isSettle) {
                OpName = String.format(ResManager.loadKDString((String)"\u5b58\u8d27\u6838\u7b97\u53cd\u7ed3\u8d26-\u6210\u672c\u8d26\u7c3f\u7f16\u7801:%1$s,\u6210\u672c\u8d26\u7c3f\u540d\u79f0:%2$s,\u671f\u95f4%3$s\u53cd\u7ed3\u8d26\u5230%4$s", (String)"SettleAccountFacade_43", (String)"fi-cal-business", (Object[])new Object[0]), param.getCostAccountNum(), param.getCostAccountName(), param.getCurrentPeriodNum(), param.getPreviousPeriodNum());
            }
            job.setName(OpName);
            job.setTaskDefineId("2TEDX/U6F3VT");
            job.setJobType(JobType.REALTIME);
            job.setParams(jobParams);
            job.setAppId("cal");
            job.setTaskClassname("kd.fi.cal.formplugin.account.SettleAccountTask");
            job.setRunByLang(Lang.get());
            String string = JobClient.dispatch((JobInfo)job);
        }
    }

    public void setSettleAccout(boolean settleAccout) {
        this.settleAccout = settleAccout;
    }

    public void setBackgroundInvoke(boolean backgroundInvoke) {
        this.backgroundInvoke = backgroundInvoke;
    }

    public void setQuerySchemeId(Long querySchemeId) {
        this.querySchemeId = querySchemeId;
    }

    public Long getQuerySchemeId() {
        return this.querySchemeId;
    }

    public boolean isBackgroundInvoke() {
        return this.backgroundInvoke;
    }
}

