/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.adjbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.calculate.billgroup.GroupRelationCostCalculator;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.business.process.inner.OmInBillInfoHelper;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.enums.CostAdjustBilCreateTypeEnum;
import kd.fi.cal.common.helper.AcctGroupModelHelper;
import kd.fi.cal.common.helper.BillNoHelper;
import kd.fi.cal.common.helper.CalStdcostdiffbillHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.model.CostAdjustDetailParams;

public class OrderDiffAdjBillCreateHelper {
    private boolean isSync;
    private final DynamicObject[] costRecordDycs;
    private Set<String> omInBills;
    private static final String NO_FEED = "N";

    public OrderDiffAdjBillCreateHelper(Boolean isSync, DynamicObject[] costRecordDycs) {
        this.isSync = isSync;
        this.costRecordDycs = costRecordDycs;
        this.omInBills = CommonSettingHelper.getBizEntityNumbers((String)"ominbiztype");
    }

    public Set<Long> createCostAdjustBill(Map<Long, String> tgCalentryIdGroupIdMap, Map<String, String> groupIdSrcBillValueStrMap) {
        try (TraceSpan span = Tracer.create((String)"OrderDiffAdjBillCreateHelper", (String)"createCostAdjustBill");){
            Set<Long> set = this.doCreateCostAdjustBill(tgCalentryIdGroupIdMap, groupIdSrcBillValueStrMap);
            return set;
        }
    }

    public Set<Long> doCreateCostAdjustBill(Map<Long, String> tgCalentryIdGroupIdMap, Map<String, String> groupIdSrcBillValueStrMap) {
        HashSet<Long> needUpdateQueuetypeEntryids = new HashSet<Long>(16);
        if (this.costRecordDycs == null) {
            return null;
        }
        Set bizTypeIdSet = CommonSettingHelper.getNotUpdBalBizType();
        int cSize = this.costRecordDycs.length;
        HashSet<Long> costAccountIds = new HashSet<Long>(cSize);
        for (DynamicObject info : this.costRecordDycs) {
            costAccountIds.add(info.getLong("costaccount_id"));
        }
        Map costAccountMap = BusinessDataServiceHelper.loadFromCache((Object[])costAccountIds.toArray(), (String)"cal_bd_costaccount");
        HashSet<DynamicObject> validInfoSet = new HashSet<DynamicObject>(cSize);
        for (DynamicObject info : this.costRecordDycs) {
            DynamicObject invscheme = info.getDynamicObject("invscheme");
            boolean isforwardamount = invscheme.getBoolean("isforwardamount");
            Long bizTypeId = info.getLong("biztype_id");
            if (!bizTypeIdSet.contains(bizTypeId) && !isforwardamount) continue;
            long costAccountId = info.getLong("costaccount_id");
            DynamicObject costAccount = (DynamicObject)costAccountMap.get(costAccountId);
            int enableStandardCost = costAccount.getBoolean("enablestandardcost");
            boolean isStanrd = false;
            for (DynamicObject entry : info.getDynamicObjectCollection("entry")) {
                String accountType = entry.getString("accounttype");
                if (!AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) continue;
                isStanrd = true;
                break;
            }
            if (enableStandardCost == 0 && !isStanrd) continue;
            validInfoSet.add(info);
        }
        if (validInfoSet.isEmpty()) {
            return null;
        }
        DynamicObject[] validInfos = validInfoSet.toArray(new DynamicObject[0]);
        ArrayList<CostAdjustDetailParams> paramsList = new ArrayList<CostAdjustDetailParams>(1024);
        HashSet<DynamicObject> costAdjustSet = new HashSet<DynamicObject>(16);
        HashSet<Long> entryIdSet = new HashSet<Long>(1024);
        HashSet<Long> ids = new HashSet<Long>(1024);
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>(1024);
        HashMap<Long, DynamicObject> entryBillMap = new HashMap<Long, DynamicObject>(1024);
        HashSet<Long> needCreateDiffBillEntryIds = new HashSet<Long>(16);
        for (DynamicObject info : validInfos) {
            Long bizTypeId = info.getLong("biztype_id");
            ids.add(info.getLong("id"));
            boolean needCreateDillBill = bizTypeIdSet.contains(bizTypeId);
            for (DynamicObject entry : info.getDynamicObjectCollection("entry")) {
                if (needCreateDillBill) {
                    needCreateDiffBillEntryIds.add(entry.getLong("id"));
                }
                entryIdSet.add(entry.getLong("id"));
                entryMap.put(entry.getLong("id"), entry);
                entryBillMap.put(entry.getLong("id"), info);
                String calBillType = info.getString("calbilltype");
                boolean isBaseqtyUnSame = this.isBaseqtyUnSameSrcTg(tgCalentryIdGroupIdMap, groupIdSrcBillValueStrMap, entry);
                boolean isPeriodUnSame = this.isPeriodUnSameSrcTg(tgCalentryIdGroupIdMap, groupIdSrcBillValueStrMap, entry, info);
                if (!"OUT".equals(calBillType) || !isBaseqtyUnSame || !isPeriodUnSame) continue;
                needUpdateQueuetypeEntryids.add(entry.getLong("id"));
            }
        }
        HashSet<Long> needRemove = new HashSet<Long>(16);
        HashSet<Long> bizbillIds = new HashSet<Long>(16);
        HashSet<Long> bizbillentryIds = new HashSet<Long>(16);
        for (DynamicObject costRecord : validInfos) {
            long bizbillid = costRecord.getLong("bizbillid");
            bizbillIds.add(bizbillid);
            DynamicObjectCollection entrys = costRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                long bizbillentryId = entry.getLong("bizbillentryid");
                bizbillentryIds.add(bizbillentryId);
            }
        }
        OmInBillInfoHelper omHelper = new OmInBillInfoHelper();
        omHelper.getSubTypeAndBizId(bizbillIds, bizbillentryIds, NO_FEED, needRemove);
        HashSet<String> omInBillsWithoutImOsPurInBIll = new HashSet<String>(this.omInBills);
        omInBillsWithoutImOsPurInBIll.remove("im_ospurinbill");
        QFilter q = new QFilter("entryid", "in", entryIdSet);
        HashMap<String, DynamicObject> costAdjustMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> costAdjustEntryMap = new HashMap<String, DynamicObject>(128);
        String updateQueuetypeIds = null;
        StringBuilder updateQueuetypeSb = new StringBuilder();
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, ids)});){
            ctx.set();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_detail", (String)"entryid,costelement,costsubelement,costsubelement.type,standardcost,actualcost", (QFilter[])q.toArray(), null);){
                for (Row row : dataSet) {
                    DynamicObject entry;
                    boolean isBaseqtyUnSame;
                    DynamicObject info;
                    String diffType;
                    String type = row.getString("costsubelement.type");
                    long entryId = row.getLong("entryid");
                    BigDecimal standardcost = row.getBigDecimal("standardcost");
                    BigDecimal actualcost = row.getBigDecimal("actualcost");
                    BigDecimal diffAmount = actualcost.subtract(standardcost);
                    if (diffAmount.compareTo(BigDecimal.ZERO) == 0 || (diffType = this.getDiffType(type, info = (DynamicObject)entryBillMap.get(entryId), isBaseqtyUnSame = this.isBaseqtyUnSameSrcTg(tgCalentryIdGroupIdMap, groupIdSrcBillValueStrMap, entry = (DynamicObject)entryMap.get(entryId)))).isEmpty()) continue;
                    long billId = info.getLong("id");
                    DynamicObject costAdjustInfo = null;
                    String billCreateType = String.valueOf(billId);
                    if (costAdjustMap.containsKey(billCreateType)) {
                        costAdjustInfo = (DynamicObject)costAdjustMap.get(billCreateType);
                    } else {
                        costAdjustInfo = this.createCostAdjustHead(info);
                        costAdjustMap.put(billCreateType, costAdjustInfo);
                    }
                    DynamicObject costAccount = (DynamicObject)costAccountMap.get(info.get("costaccount_id"));
                    boolean enableStandardCost = costAccount.getBoolean("enablestandardcost");
                    if (entry == null) continue;
                    DynamicObject invtype = entry.getDynamicObject("invtype");
                    boolean isforwardamount = false;
                    if (invtype != null) {
                        isforwardamount = invtype.getBoolean("isforwardamount");
                    }
                    if (!needCreateDiffBillEntryIds.contains(entryId) && !isforwardamount) continue;
                    String accountType = entry.getString("accounttype");
                    String bizEntityObject = info.getDynamicObject("bizentityobject").getString("id");
                    boolean stdAndQtyLargeZero = AccountTypeEnum.STANDARDCOST.getValue().equals(accountType) && entry.getBigDecimal("baseqty").compareTo(BigDecimal.ZERO) > 0;
                    long bizbillid = info.getLong("bizbillid");
                    if (this.isSync && "im_ospurinbill".equals(bizEntityObject) && needRemove.contains(bizbillid) || this.isSync && omInBillsWithoutImOsPurInBIll.contains(bizEntityObject) && stdAndQtyLargeZero || !enableStandardCost && !AccountTypeEnum.STANDARDCOST.getValue().equals(accountType)) continue;
                    DynamicObject costAdjustEntry = null;
                    String entryCreateType = String.valueOf(entryId);
                    if (costAdjustEntryMap.containsKey(entryCreateType)) {
                        costAdjustEntry = (DynamicObject)costAdjustEntryMap.get(entryCreateType);
                    } else {
                        costAdjustEntry = this.createCostAdjustEntry(costAdjustInfo, info, entry);
                        costAdjustEntryMap.put(entryCreateType, costAdjustEntry);
                        long costAdjustEntryId = DBServiceHelper.genLongIds((String)"t_cal_costadjustbillentry", (int)1)[0];
                        costAdjustEntry.set("id", (Object)costAdjustEntryId);
                    }
                    String calBillType = info.getString("calbilltype");
                    costAdjustEntry.set("adjustamt", (Object)costAdjustEntry.getBigDecimal("adjustamt").add(diffAmount));
                    CostAdjustDetailParams param = new CostAdjustDetailParams();
                    param.setAdjustAmt(diffAmount);
                    param.setEntryid((Object)costAdjustEntry.getLong("id"));
                    param.setCostElementId((Object)row.getLong("costelement"));
                    param.setCostSubElementId((Object)row.getLong("costsubelement"));
                    CalStdcostdiffbillHelper.setParamSubDdiffAmt((String)diffType, (BigDecimal)diffAmount, (CostAdjustDetailParams)param);
                    if ("OUT".equals(calBillType)) {
                        boolean isPeriodUnSame = this.isPeriodUnSameSrcTg(tgCalentryIdGroupIdMap, groupIdSrcBillValueStrMap, entry, info);
                        if (isBaseqtyUnSame && isPeriodUnSame) {
                            costAdjustEntry.set("queuetype", (Object)"0");
                            costAdjustEntry.set("signnum", (Object)-1);
                            updateQueuetypeSb.append(costAdjustEntry.getLong("id"));
                            updateQueuetypeSb.append(",");
                        }
                    }
                    costAdjustSet.add(costAdjustInfo);
                    paramsList.add(param);
                }
            }
        }
        if (updateQueuetypeSb.length() > 0) {
            updateQueuetypeIds = updateQueuetypeSb.substring(0, updateQueuetypeSb.length() - 1);
        }
        this.setSeq(costAdjustSet);
        this.saveAudit(costAdjustSet, updateQueuetypeIds, paramsList);
        return needUpdateQueuetypeEntryids;
    }

    private boolean isBaseqtyUnSameSrcTg(Map<Long, String> tgCalentryIdGroupIdMap, Map<String, String> groupIdSrcBillValueStrMap, DynamicObject entry) {
        BigDecimal tgBaseqty;
        String[] values;
        BigDecimal srcBaseqty;
        BigDecimal mulBaseqty;
        String valueStr;
        String groupId;
        Long calentryid;
        boolean isBaseqtyUnSame = false;
        if (null == tgCalentryIdGroupIdMap || null == groupIdSrcBillValueStrMap) {
            return isBaseqtyUnSame;
        }
        if (entry != null && tgCalentryIdGroupIdMap.containsKey(calentryid = Long.valueOf(entry.getLong("calentryid"))) && groupIdSrcBillValueStrMap.containsKey(groupId = tgCalentryIdGroupIdMap.get(calentryid)) && !StringUtils.isEmpty((String)(valueStr = groupIdSrcBillValueStrMap.get(groupId))) && (mulBaseqty = (srcBaseqty = new BigDecimal((values = valueStr.split("_"))[1])).multiply(tgBaseqty = entry.getBigDecimal("baseqty"))).compareTo(BigDecimal.ZERO) < 0) {
            isBaseqtyUnSame = true;
        }
        return isBaseqtyUnSame;
    }

    private boolean isPeriodUnSameSrcTg(Map<Long, String> tgCalentryIdGroupIdMap, Map<String, String> groupIdSrcBillValueStrMap, DynamicObject entry, DynamicObject info) {
        String valueStr;
        String groupId;
        boolean isPeriodUnSame = false;
        if (null == tgCalentryIdGroupIdMap || null == groupIdSrcBillValueStrMap) {
            return isPeriodUnSame;
        }
        Long calentryid = entry.getLong("calentryid");
        if (tgCalentryIdGroupIdMap.containsKey(calentryid) && groupIdSrcBillValueStrMap.containsKey(groupId = tgCalentryIdGroupIdMap.get(calentryid)) && !StringUtils.isEmpty((String)(valueStr = groupIdSrcBillValueStrMap.get(groupId)))) {
            String[] values = valueStr.split("_");
            Long srcPeriod = Long.parseLong(values[0]);
            Long tgPeriod = info.getDynamicObject("period").getLong("id");
            if (srcPeriod.longValue() != tgPeriod.longValue()) {
                isPeriodUnSame = true;
            }
        }
        return isPeriodUnSame;
    }

    private String getDiffType(String subEleType, DynamicObject recordDyc, boolean isBaseqtyUnSame) {
        String diffType = "";
        boolean isInitBill = recordDyc.getBoolean("isinitbill");
        if (isInitBill) {
            return diffType;
        }
        String calBillType = recordDyc.getString("calbilltype");
        String bizEntityObject = recordDyc.getDynamicObject("bizentityobject").getString("id");
        if ("OUT".equals(calBillType)) {
            diffType = "002".equals(subEleType) ? "K" : "T";
            if (isBaseqtyUnSame) {
                diffType = "M";
            }
            if (!isBaseqtyUnSame && "im_transinbill".equals(bizEntityObject)) {
                diffType = "M";
            }
            return diffType;
        }
        if ("im_purinbill".equals(bizEntityObject) || this.omInBills.contains(bizEntityObject)) {
            boolean purInOrdDiff;
            boolean bl = purInOrdDiff = "001".equals(subEleType) || "003".equals(subEleType) || "004".equals(subEleType) || "005".equals(subEleType);
            if (purInOrdDiff) {
                diffType = "G";
            } else if ("002".equals(subEleType)) {
                diffType = "K";
            }
        } else {
            boolean otherDiff;
            boolean bl = otherDiff = "001".equals(subEleType) || "003".equals(subEleType) || "004".equals(subEleType) || "005".equals(subEleType);
            if (otherDiff) {
                diffType = "T";
            } else if ("002".equals(subEleType)) {
                diffType = "K";
            }
        }
        return diffType;
    }

    private DynamicObject createCostAdjustHead(DynamicObject info) {
        DynamicObject costAdjustBill = BusinessDataServiceHelper.newDynamicObject((String)"cal_stdcostdiffbill");
        String calbilltype = info.getString("calbilltype");
        if ("IN".equals(calbilltype)) {
            costAdjustBill.set("cstype", (Object)"bd_supplier");
            costAdjustBill.set("custsupplier", info.get("supplier_id"));
        } else {
            costAdjustBill.set("cstype", (Object)"bd_customer");
            costAdjustBill.set("custsupplier", info.get("customer_id"));
        }
        costAdjustBill.set("currency", info.get("localcurrency_id"));
        Date firstDate = null;
        try {
            firstDate = PeriodHelper.getCurrentPeriod((Long)info.getLong("costaccount.id")).getDate("begindate");
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6210\u672c\u8d26\u7c3f\u5f53\u524d\u6700\u5927\u671f\u95f4\u65e5\u671f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u3002", (String)"OrderDiffAdjBillCreateHelper_0", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        Date bizdate = info.getDate("bizdate");
        if (bizdate.before(firstDate)) {
            bizdate = firstDate;
        }
        costAdjustBill.set("bizdate", (Object)bizdate);
        Date bookdate = info.getDate("bookdate");
        if (bookdate.before(firstDate)) {
            bookdate = firstDate;
        }
        costAdjustBill.set("bookdate", (Object)bookdate);
        costAdjustBill.set("biztype", (Object)"A");
        String calBillType = info.getString("calbilltype");
        if ("OUT".equals(calBillType)) {
            costAdjustBill.set("biztype", (Object)"B");
        }
        costAdjustBill.set("billstatus", (Object)"B");
        costAdjustBill.set("createtype", (Object)CostAdjustBilCreateTypeEnum.BILL_SYNC.getValue());
        costAdjustBill.set("costaccount", (Object)info.getLong("costaccount_id"));
        Object accountID = info.get("costaccount_id");
        DynamicObject costAccont = BusinessDataServiceHelper.loadSingle((Object)accountID, (String)"cal_bd_costaccount", (String)"calorg");
        costAdjustBill.set("calorg", costAccont.get("calorg"));
        costAdjustBill.set("billtype", info.get("billtype_id"));
        Date date = TimeServiceHelper.now();
        costAdjustBill.set("createtime", (Object)date);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        costAdjustBill.set("creator_id", (Object)userId);
        costAdjustBill.set("adminorg", info.get("adminorg_id"));
        String number = BillNoHelper.getBillNo((String)"cal_stdcostdiffbill", (DynamicObject)costAdjustBill, (String)costAccont.getString("calorg_id"));
        costAdjustBill.set("billno", (Object)number);
        return costAdjustBill;
    }

    private DynamicObject createCostAdjustEntry(DynamicObject costAdjustBillHead, DynamicObject costRecordInfo, DynamicObject costRecordEntry) {
        MainEntityType costRecordEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_costadjustbill");
        DynamicObject entry = costAdjustBillHead.getDynamicObjectCollection("entryentity").addNew();
        entry.set("storageorgunit", costRecordInfo.get("storageorgunit_id"));
        entry.set("material", costRecordEntry.get("material_id"));
        entry.set("lot", costRecordEntry.get("lot"));
        entry.set("warehouse", costRecordEntry.get("warehouse_id"));
        entry.set("location", costRecordEntry.get("location_id"));
        entry.set("ownertype", (Object)"bos_org");
        entry.set("owner", costRecordEntry.get("owner_id"));
        entry.set("ecostcenter", costRecordEntry.get("ecostcenter_id"));
        entry.set("assist", costRecordEntry.get("assist_id"));
        entry.set("invbilltype", costRecordInfo.get("billtype_id"));
        entry.set("invbillnum", (Object)costRecordInfo.getString("billno"));
        entry.set("inventryseq", costRecordEntry.get("seq"));
        entry.set("invbillid", costRecordInfo.get("id"));
        entry.set("invbizentityobject", (Object)"cal_costrecord");
        entry.set("invbillentryid", costRecordEntry.get("id"));
        entry.set("baseunit", costRecordEntry.get("baseunit_id"));
        entry.set("project", costRecordEntry.get("project_id"));
        entry.set("invtype", costRecordEntry.get("invtype_id"));
        entry.set("invstatus", costRecordEntry.get("invstatus_id"));
        entry.set("mversion", costRecordEntry.get("mversion_id"));
        entry.set("tracknumber", costRecordEntry.get("tracknumber"));
        entry.set("configuredcode", costRecordEntry.get("configuredcode"));
        entry.set("productline", costRecordEntry.get("productline_id"));
        entry.set("noupdatecalfields", costRecordEntry.get("noupdatecalfields"));
        entry.set("stocktype", costRecordEntry.get("stocktype"));
        CommonSettingHelper.setExFieldValue((MainEntityType)costAdjustEntityType, (MainEntityType)costRecordEntityType, (DynamicObject)entry, (DynamicObject)costRecordEntry);
        return entry;
    }

    public void setCalentryIdGroupIdSrcBillValue(Set<Long> billIdSet, Map<Long, String> tgCalentryIdGroupIdMap, Map<String, String> groupIdSrcBillValueStrMap) {
        if (AcctGroupModelHelper.isBizGroupModel()) {
            this.setCalentryIdGroupIdSrcBillValueByBizGroup(billIdSet, tgCalentryIdGroupIdMap, groupIdSrcBillValueStrMap);
        } else {
            this.setCalentryIdGroupIdSrcBillValueByGroup(billIdSet, tgCalentryIdGroupIdMap, groupIdSrcBillValueStrMap);
        }
    }

    private void setCalentryIdGroupIdSrcBillValueByBizGroup(Set<Long> billIdSet, Map<Long, String> tgCalentryIdGroupIdMap, Map<String, String> groupIdSrcBillValueStrMap) {
        QFilter costRecordFilter = new QFilter("entryentity.bizbillid", "=", billIdSet);
        HashMap<String, Set<Long>> formId2BizbillidMap = new HashMap<String, Set<Long>>(4);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)GroupRelationCostCalculator.class.getName(), (String)"cal_costrecord", (String)"bizentityobject,bizbillid", (QFilter[])costRecordFilter.toArray(), null);){
            for (Row row : dataSet) {
                String formid = row.getString("bizentityobject");
                Long bizbillid = row.getLong("bizbillid");
                Set bizbillids = formId2BizbillidMap.computeIfAbsent(formid, k -> new HashSet(16));
                bizbillids.add(bizbillid);
            }
        }
        DataSet groupBillRecords = new BizGroupRecordBuilder().getAllGroupRecordDataSetByBizBillIds(formId2BizbillidMap);
        DataSet[] ds = groupBillRecords.select("type,calentryid,groupid,bizbillid").splitByFilter(new String[]{"type = '0'", "type = '1'"}, false);
        DataSet srcDS = ds[0];
        DataSet destDS = ds[1];
        for (Object row : destDS) {
            tgCalentryIdGroupIdMap.put(row.getLong("calentryid"), row.getString("groupid"));
        }
        HashSet<Long> srcbillIds = new HashSet<Long>(16);
        for (Row row : srcDS.copy()) {
            srcbillIds.add(row.getLong("bizbillid"));
        }
        QFilter bizBillIdF = new QFilter("bizbillid", "in", srcbillIds);
        QFilter billStatusF = new QFilter("billstatus", "in", (Object)new String[]{"A", "B"});
        DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"bizbillid,period,entry.baseqty as baseqty", (QFilter[])new QFilter[]{bizBillIdF, billStatusF}, null);
        costRecordDs = srcDS.join(costRecordDs).on("bizbillid", "bizbillid").select(new String[]{"groupid", "bizbillid"}, new String[]{"period", "baseqty"}).finish();
        for (Row row : costRecordDs) {
            String groupId = row.getString("groupid");
            String valueStr = row.getLong("period") + "_" + row.getBigDecimal("baseqty").longValue();
            groupIdSrcBillValueStrMap.put(groupId, valueStr);
        }
    }

    private void setCalentryIdGroupIdSrcBillValueByGroup(Set<Long> billIdSet, Map<Long, String> tgCalentryIdGroupIdMap, Map<String, String> groupIdSrcBillValueStrMap) {
        QFilter tgtIdF = new QFilter("entryentity.bizbillid", "in", billIdSet);
        QFilter isTgtF = new QFilter("entryentity.type", "=", (Object)"1");
        HashSet<Long> groupIdSet = new HashSet<Long>(16);
        String groupRecKey = AcctGroupModelHelper.isNewGroupModel() ? "cal_account_grouprecord" : "cal_groupbillrecord";
        String tgSelectFields = "id,entryentity.billentryid as tgcalentryid";
        if ("cal_account_grouprecord".equals(groupRecKey)) {
            tgSelectFields = "id,entryentity.calentryid as tgcalentryid";
        }
        try (DataSet billGroupDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)groupRecKey, (String)tgSelectFields, (QFilter[])new QFilter[]{tgtIdF, isTgtF}, null);){
            for (Row row : billGroupDs) {
                tgCalentryIdGroupIdMap.put(row.getLong("tgcalentryid"), row.getLong("id").toString());
                groupIdSet.add(row.getLong("id"));
            }
        }
        QFilter billGroupIdF = new QFilter("id", "in", groupIdSet);
        QFilter isSrcF = new QFilter("entryentity.type", "=", (Object)"0");
        HashSet<Long> srcbillIds = new HashSet<Long>(16);
        try (DataSet billGroupRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)groupRecKey, (String)"id as groupid,entryentity.bizbillid as srcbizbillid", (QFilter[])new QFilter[]{billGroupIdF, isSrcF}, null);){
            for (Row row : billGroupRecordDs.copy()) {
                srcbillIds.add(row.getLong("srcbizbillid"));
            }
            QFilter bizBillIdF = new QFilter("bizbillid", "in", srcbillIds);
            QFilter billStatusF = new QFilter("billstatus", "in", (Object)new String[]{"A", "B"});
            DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"bizbillid,period,entry.baseqty as baseqty", (QFilter[])new QFilter[]{bizBillIdF, billStatusF}, null);
            costRecordDs = billGroupRecordDs.join(costRecordDs).on("srcbizbillid", "bizbillid").select(new String[]{"groupid", "srcbizbillid"}, new String[]{"period", "baseqty"}).finish();
            for (Row row : costRecordDs) {
                Long groupId = row.getLong("groupid");
                String valueStr = row.getLong("period") + "_" + row.getBigDecimal("baseqty").longValue();
                groupIdSrcBillValueStrMap.put(groupId.toString(), valueStr);
            }
        }
    }

    private void setSeq(Set<DynamicObject> costAdjustSet) {
        for (DynamicObject costAdjustInfo2 : costAdjustSet) {
            if (costAdjustInfo2.getDynamicObjectCollection("entryentity").isEmpty()) continue;
            int seq = 1;
            for (DynamicObject entry5 : costAdjustInfo2.getDynamicObjectCollection("entryentity")) {
                entry5.set("seq", (Object)seq);
                ++seq;
            }
        }
    }

    private void saveAudit(Set<DynamicObject> costAdjustSet, String updateQueuetypeIds, List<CostAdjustDetailParams> paramsList) {
        if (!costAdjustSet.isEmpty()) {
            OperateOption option = OperateOption.create();
            String params = SerializationUtils.toJsonString(paramsList);
            option.setVariableValue("CostAdjustDetailParms", params);
            option.setVariableValue("updateQueuetypeIds", updateQueuetypeIds);
            option.setVariableValue("ishasright", "true");
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"cal_stdcostdiffbill", (DynamicObject[])costAdjustSet.toArray(new DynamicObject[0]), (OperateOption)option);
            List errors = result.getAllErrorOrValidateInfo();
            if (!errors.isEmpty()) {
                StringBuilder msg = new StringBuilder();
                msg.append(ResManager.loadKDString((String)"\uff08\u8ba2\u5355\u4ef7\u5dee\u6210\u672c\u8c03\u6574\u5355\u65b0\u589e\u4fdd\u5b58\u5931\u8d25\uff09", (String)"SyncBizBill4AuditServiceProcess_9", (String)"fi-cal-business", (Object[])new Object[0]));
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
                throw new KDBizException(msg.toString());
            }
            List idList = result.getSuccessPkIds();
            MainEntityType costAdjustEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_stdcostdiffbill");
            DynamicObject[] costAdjusts = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)costAdjustEntityType);
            result = OperationServiceHelper.executeOperate((String)"audit", (String)"cal_stdcostdiffbill", (DynamicObject[])costAdjusts, (OperateOption)option);
            errors = result.getAllErrorOrValidateInfo();
            if (!result.isSuccess()) {
                StringBuilder msg = new StringBuilder();
                msg.append(ResManager.loadKDString((String)"\uff08\u8ba2\u5355\u4ef7\u5dee\u6210\u672c\u8c03\u6574\u5355\u5ba1\u6838\u5931\u8d25\uff09", (String)"SyncBizBill4AuditServiceProcess_10", (String)"fi-cal-business", (Object[])new Object[0]));
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
                msg.append(result.getMessage()).append('\n');
                throw new KDBizException(msg.toString());
            }
        }
    }
}

