/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.autosort;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.autosort.graphmodel.GraphNodeManager;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CalGroupAccountHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.util.CommonUtils;

public class AutoSortHelperNew {
    private static final String CONNECTOR = "_";
    private static final Long DEFAULT_GROUPNO = -1L;
    private static final int DEFAULT_GROUPSEQ = 99999999;
    public static final int BATCH_SIZE = 100000;
    private Map<Long, Long> currentPeriodCache = new HashMap<Long, Long>(16);
    private static final String DLOCK_KEY = "Cal_AutoSortHelperNew#";
    private static Log log = LogFactory.getLog(AutoSortHelperNew.class);
    private boolean filterGroupAcct = false;

    public void refreshSortResult(Set<Long> deleteGroupRecordIds, List<DynamicObject> newRecordList) {
        if ((deleteGroupRecordIds == null || deleteGroupRecordIds.isEmpty()) && (newRecordList == null || newRecordList.isEmpty())) {
            return;
        }
        Throwable throwable = null;
        try (TXHandle handle = TX.required();){
            DataSet finalSet = null;
            if (deleteGroupRecordIds != null && !deleteGroupRecordIds.isEmpty()) {
                QFilter deleteFilter = new QFilter("bizgrouprecordid", "in", deleteGroupRecordIds);
                new CalGroupAccountHelper().addNotGroupAcctFilterByAcctFieldIf("entryentity.costaccount", deleteFilter, this.filterGroupAcct);
                finalSet = this.getRelationDataSet(deleteFilter, null, null);
                DeleteServiceHelper.delete((String)"cal_account_grouprecord", (QFilter[])deleteFilter.toArray());
            }
            if (newRecordList != null && !newRecordList.isEmpty()) {
                List<DynamicObject> newObjects = null;
                TXHandle h = TX.requiresNew();
                Object object = null;
                try {
                    newObjects = this.saveObject(newRecordList);
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h != null) {
                        if (object != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object).addSuppressed(throwable3);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
                HashSet<Long> newRecordIds = new HashSet<Long>(newObjects.size());
                for (Object e : newObjects) {
                    newRecordIds.add(((DynamicObject)e).getLong("id"));
                }
                DataSet newDataSet = this.getRelationDataSet(new QFilter("id", "in", newRecordIds), null, null);
                finalSet = finalSet == null ? newDataSet : finalSet.union(newDataSet);
            }
            if (finalSet == null) {
                return;
            }
            try {
                boolean bl;
                DataSet inDataSet = finalSet.copy().filter("srccostaccount = targetcostaccount and srcmaterial = targetmaterial and srccalrange = targetcalrange and srcperiod = targetperiod").orderBy(new String[]{"targetbookdate", "targetauditdate", "srcbookdate", "srcauditdate"});
                DataSet outDataSet = finalSet.filter("srccostaccount != targetcostaccount or srcmaterial != targetmaterial or srccalrange != targetcalrange or srcperiod != targetperiod").orderBy(new String[]{"targetbookdate", "targetauditdate", "srcbookdate", "srcauditdate"});
                HashMap<String, DynamicObject> sortResultMap = new HashMap<String, DynamicObject>();
                boolean bl2 = bl = !outDataSet.isEmpty();
                if (bl) {
                    this.rebuildOutSort(sortResultMap, outDataSet, false, null);
                }
                if (!inDataSet.isEmpty()) {
                    this.rebuildInnerSort(sortResultMap, inDataSet, false);
                }
                this.flushTODB(sortResultMap);
            }
            catch (Throwable e) {
                handle.markRollback();
                log.error("\u5237\u65b0\u667a\u80fd\u6392\u5e8f\u51fa\u73b0\u5f02\u5e38", e);
                throw e;
            }
        }
    }

    private void flushTODB(Map<String, DynamicObject> sortResultMap) {
        ArrayList<DynamicObject> insertObj = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> updateObj = new ArrayList<DynamicObject>(10);
        HashSet<Long> deleteObj = new HashSet<Long>(16);
        for (DynamicObject sortResult : sortResultMap.values()) {
            boolean isAddNew;
            boolean isEmptyInSort = sortResult.getLong("groupno") == DEFAULT_GROUPNO.longValue() && sortResult.getDynamicObjectCollection("entryentity").isEmpty();
            boolean bl = isAddNew = !sortResult.getDataEntityState().getFromDatabase();
            if (isAddNew) {
                if (isEmptyInSort) continue;
                insertObj.add(sortResult);
                continue;
            }
            if (isEmptyInSort) {
                deleteObj.add(sortResult.getLong("id"));
                continue;
            }
            updateObj.add(sortResult);
        }
        if (!deleteObj.isEmpty()) {
            DeleteServiceHelper.delete((String)"cal_sortresult", (QFilter[])new QFilter("id", "in", deleteObj).toArray());
        }
        this.saveObject(insertObj);
        this.saveObject(updateObj);
    }

    private List<DynamicObject> saveObject(List<DynamicObject> objList) {
        if (objList == null || objList.isEmpty()) {
            return objList;
        }
        objList.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Long id1 = o1.getLong("id");
                Long id2 = o2.getLong("id");
                if (id1 != null && id2 != null) {
                    return id1.compareTo(id2);
                }
                return 0;
            }
        });
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(100000);
        Iterator<DynamicObject> it = objList.iterator();
        while (it.hasNext()) {
            if (saveList.size() >= 100000) {
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
                saveList.clear();
            }
            saveList.add(it.next());
        }
        if (!saveList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
        }
        return objList;
    }

    public void rebuildAllSortResult() {
        try (TXHandle handle = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"cal_sortresult", null);
                DataSet dataSet = this.getRelationDataSet(null, null, null);
                DataSet outDataSet = dataSet.copy().filter("srccostaccount != targetcostaccount or srcmaterial != targetmaterial or srccalrange != targetcalrange or srcperiod != targetperiod").orderBy(new String[]{"targetbookdate", "targetauditdate", "srcbookdate", "srcauditdate"});
                DataSet inDataSet = dataSet.copy().filter("srccostaccount = targetcostaccount and srcmaterial = targetmaterial and srccalrange = targetcalrange and srcperiod = targetperiod").orderBy(new String[]{"targetbookdate", "targetauditdate", "srcbookdate", "srcauditdate"});
                HashMap<String, DynamicObject> sortResultMap = new HashMap<String, DynamicObject>();
                this.rebuildOutSort(sortResultMap, outDataSet, true, null);
                this.rebuildInnerSort(sortResultMap, inDataSet, true);
                this.flushTODB(sortResultMap);
            }
            catch (Throwable e) {
                handle.markRollback();
                log.error("\u5237\u65b0\u667a\u80fd\u6392\u5e8f\u51fa\u73b0\u5f02\u5e38", e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildAllSortResultByCostAccounts(Set<Long> costAccountids, String desc) {
        Map associationCostAccountNameMap = AccountingSysHelper.getAssociationCostAccountNameMap(costAccountids);
        boolean isingroup = costAccountids != null && costAccountids.size() < associationCostAccountNameMap.size();
        ArrayList<DLock> lockList = new ArrayList<DLock>(16);
        try (TXHandle handle = TX.required();){
            try {
                for (Map.Entry costaccount : associationCostAccountNameMap.entrySet()) {
                    Long costAccountId = (Long)costaccount.getKey();
                    String costAccountName = (String)costaccount.getValue();
                    DLock lock = DLock.createReentrant((String)(DLOCK_KEY + costAccountId), (String)(costAccountName + ":" + desc));
                    lockList.add(lock);
                    if (lock.tryLock()) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u6b63\u5728\u91cd\u5efa\u667a\u80fd\u6392\u5e8f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AutoSortHelperNew_1", (String)"fi-cal-business", (Object[])new Object[0]), costAccountName);
                    if (isingroup) {
                        msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8de8\u8d26\u7c3f\u6210\u7ec4\u3002\u6210\u672c\u8d26\u7c3f\u201c%1$s\u201d\u6b63\u5728\u91cd\u5efa\u667a\u80fd\u6392\u5e8f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AutoSortHelperNew_2", (String)"fi-cal-business", (Object[])new Object[0]), costAccountName);
                    }
                    throw new KDBizException(msg);
                }
                DeleteServiceHelper.delete((String)"cal_sortresult", (QFilter[])new QFilter("costaccount", "in", associationCostAccountNameMap.keySet()).toArray());
                DataSet dataSet = this.getRelationDataSet(new QFilter("entryentity.costaccount", "in", associationCostAccountNameMap.keySet()), null, null);
                DataSet outDataSet = dataSet.copy().filter("srccostaccount != targetcostaccount or srcmaterial != targetmaterial or srccalrange != targetcalrange or srcperiod != targetperiod").orderBy(new String[]{"targetbookdate", "targetauditdate", "srcbookdate", "srcauditdate"});
                DataSet inDataSet = dataSet.copy().filter("srccostaccount = targetcostaccount and srcmaterial = targetmaterial and srccalrange = targetcalrange and srcperiod = targetperiod").orderBy(new String[]{"targetbookdate", "targetauditdate", "srcbookdate", "srcauditdate"});
                HashMap<String, DynamicObject> sortResultMap = new HashMap<String, DynamicObject>();
                this.rebuildOutSort(sortResultMap, outDataSet, true, associationCostAccountNameMap.keySet());
                this.rebuildInnerSort(sortResultMap, inDataSet, true);
                this.flushTODB(sortResultMap);
            }
            catch (Throwable e) {
                handle.markRollback();
                log.error("\u5237\u65b0\u667a\u80fd\u6392\u5e8f\u51fa\u73b0\u5f02\u5e38", e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            CommitListener commitListener = new CommitListener(lockList){
                final /* synthetic */ List val$lockList;
                {
                    this.val$lockList = list;
                }

                public void onEnded(boolean rollbacked) {
                    try (TXHandle txHandle = TX.notSupported();){
                        for (DLock lock : this.val$lockList) {
                            lock.close();
                        }
                    }
                }
            };
            TX.addCommitListener((CommitListener)commitListener);
            throw throwable;
        }
        CommitListener commitListener = new /* invalid duplicate definition of identical inner class */;
        TX.addCommitListener((CommitListener)commitListener);
    }

    private DataSet getRelationDataSet(QFilter filter, Long material, Long calrange) {
        int queryBatachSize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.AUTOSORT_OLD_QUERY_BATCHSIZE);
        QFilter defFilter = new QFilter("entryentity.isbeforeperiod", "=", (Object)false);
        if (filter != null) {
            defFilter = defFilter.and(filter);
        }
        DataSet groupRecord = QueryServiceHelper.queryDataSet((String)AutoSortHelperNew.class.getName(), (String)"cal_account_grouprecord", (String)"id", (QFilter[])defFilter.toArray(), null);
        HashSet<Long> groupRecordIds = new HashSet<Long>(16);
        ArrayList<DataSet> groupRecordList = new ArrayList<DataSet>(4);
        for (Row row : groupRecord) {
            groupRecordIds.add(row.getLong("id"));
            if (groupRecordIds.size() < queryBatachSize) continue;
            QFilter newfilter = new QFilter("id", "in", groupRecordIds);
            newfilter.and("entryentity.isbeforeperiod", "=", (Object)false);
            new CalGroupAccountHelper().addNotGroupAcctFilterByAcctFieldIf("entryentity.costaccount", newfilter, this.filterGroupAcct);
            groupRecord = QueryServiceHelper.queryDataSet((String)AutoSortHelperNew.class.getName(), (String)"cal_account_grouprecord", (String)"id,entryentity.type as type,entryentity.calentryid as calentryid,entryentity.costrecordentryid as costrecordentryid,entryentity.costaccount as costaccount,entryentity.period as period", (QFilter[])newfilter.toArray(), (String)null);
            groupRecordList.add(groupRecord);
            groupRecordIds = new HashSet(queryBatachSize);
        }
        QFilter newfilter = new QFilter("id", "in", groupRecordIds);
        newfilter.and("entryentity.isbeforeperiod", "=", (Object)false);
        groupRecord = QueryServiceHelper.queryDataSet((String)AutoSortHelperNew.class.getName(), (String)"cal_account_grouprecord", (String)"id,entryentity.type as type,entryentity.calentryid as calentryid,entryentity.costrecordentryid as costrecordentryid,entryentity.costaccount as costaccount,entryentity.period as period", (QFilter[])newfilter.toArray(), (String)null);
        if (!groupRecordList.isEmpty()) {
            groupRecord = groupRecord.union(groupRecordList.toArray(new DataSet[0]));
            groupRecord = groupRecord.orderBy(new String[]{"costaccount"});
        }
        HashSet<Long> calEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> costaccountIdSet = new HashSet<Long>(16);
        DataSet groupRecordCopy = groupRecord.copy();
        String divideFieldsStr = CommonSettingHelper.getDivideBasisStr();
        String caldimensionFieldsStr = CommonSettingHelper.getCalDimensionStr();
        String[] allFields = (divideFieldsStr + "," + caldimensionFieldsStr).split(",");
        QFilter costRecordFilter = new QFilter("billstatus", "=", (Object)"C");
        if (material != null) {
            costRecordFilter.and("entry.material", "=", (Object)material);
        }
        if (calrange == null) {
            costRecordFilter.and("entry.calrange", "!=", (Object)0L);
        } else {
            costRecordFilter.and("entry.calrange", "=", (Object)calrange);
        }
        ArrayList<DataSet> costRecordSetList = new ArrayList<DataSet>(16);
        String costRecordSelects = "entry.id as entryid,entry.calrange as calrange,entry.material as material,entry.accounttype as accounttype,entry.caldimension as caldimension,entry.caldimension.caldimension as caldimensionstr,bookdate,auditdate,costaccount.dividebasis as dividebasis,costaccount.dividebasis.dividebasis as dividebasisstr," + this.getCostRecordQueryStr(allFields);
        while (groupRecordCopy.hasNext()) {
            Row row = groupRecordCopy.next();
            calEntryIdSet.add(row.getLong("calentryid"));
            costaccountIdSet.add(row.getLong("costaccount"));
            if (calEntryIdSet.size() < queryBatachSize) continue;
            QFilter curFilter = new QFilter("entry.calentryid", "in", calEntryIdSet);
            curFilter.and("costaccount", "in", costaccountIdSet);
            curFilter.and(costRecordFilter);
            DataSet costRecordSet = QueryServiceHelper.queryDataSet((String)AutoSortHelperNew.class.getName(), (String)"cal_costrecord", (String)costRecordSelects, (QFilter[])curFilter.toArray(), null);
            costRecordSetList.add(costRecordSet);
            calEntryIdSet = new HashSet(queryBatachSize);
            costaccountIdSet = new HashSet(16);
        }
        QFilter curFilter = new QFilter("entry.calentryid", "in", calEntryIdSet);
        curFilter.and("costaccount", "in", costaccountIdSet);
        curFilter.and(costRecordFilter);
        DataSet costRecordSet = QueryServiceHelper.queryDataSet((String)AutoSortHelperNew.class.getName(), (String)"cal_costrecord", (String)costRecordSelects, (QFilter[])curFilter.toArray(), null);
        if (!costRecordSetList.isEmpty()) {
            costRecordSet = costRecordSet.union(costRecordSetList.toArray(new DataSet[0]));
        }
        groupRecord = groupRecord.join(costRecordSet, JoinType.INNER).on("costrecordentryid", "entryid").select(new String[]{"id", "type", "costaccount", "id-id as period"}, costRecordSet.getRowMeta().getFieldNames()).finish();
        DataSet srcRecord = groupRecord.copy().filter("type = '0'");
        DataSet targetRecord = groupRecord.filter("type = '1'");
        HashSet<String> joinSortFields = new HashSet<String>(Arrays.asList(allFields));
        joinSortFields.add("costaccount");
        joinSortFields.add("period");
        joinSortFields.add("calrange");
        joinSortFields.add("accounttype");
        joinSortFields.add("material");
        joinSortFields.add("dividebasis");
        joinSortFields.add("dividebasisstr");
        joinSortFields.add("caldimension");
        joinSortFields.add("caldimensionstr");
        joinSortFields.add("bookdate");
        joinSortFields.add("auditdate");
        List<String> srcFieldList = this.changeFieldPrefix(joinSortFields, "src");
        List<String> targetFieldList = this.changeFieldPrefix(joinSortFields, "target");
        DataSet finalSet = srcRecord.join(targetRecord, JoinType.INNER).on("id", "id").select(srcFieldList.toArray(new String[srcFieldList.size()]), targetFieldList.toArray(new String[targetFieldList.size()])).finish().orderBy(new String[]{"targetbookdate", "targetauditdate", "srcbookdate", "srcauditdate"});
        return finalSet;
    }

    private void createSortResultEntry(DynamicObject sortResult, GraphNodeManager<InSortNode> inManager) {
        sortResult.getDynamicObjectCollection("entryentity").clear();
        if (inManager.isEmpty()) {
            return;
        }
        List<InSortNode> list = inManager.linearSort2List();
        StringBuilder fieldSb = new StringBuilder();
        StringBuilder fieldValueSb = new StringBuilder();
        for (int j = 0; j < list.size(); ++j) {
            DynamicObject resultEntry = sortResult.getDynamicObjectCollection("entryentity").addNew();
            resultEntry.set("seq", (Object)(j + 1));
            InSortNode inNode = list.get(j);
            for (Map.Entry valueEntry : inNode.divideValues.entrySet()) {
                resultEntry.set((String)valueEntry.getKey(), valueEntry.getValue());
                fieldValueSb.append(valueEntry.getValue());
                fieldValueSb.append(CONNECTOR);
                fieldSb.append((String)valueEntry.getKey());
                fieldSb.append(',');
            }
            if (fieldSb.length() != 0 && fieldSb.toString().endsWith(",")) {
                fieldSb.deleteCharAt(fieldSb.length() - 1);
            }
            resultEntry.set("dividebasis", (Object)fieldSb.toString());
            resultEntry.set("dividebasisvalue", (Object)fieldValueSb.toString());
            fieldSb.setLength(0);
            fieldValueSb.setLength(0);
            for (Map.Entry valueEntry : inNode.caldimensionValues.entrySet()) {
                String key = (String)valueEntry.getKey();
                Object value = valueEntry.getValue();
                resultEntry.set(key, value);
                if (value == null || value.equals("")) {
                    value = "#";
                }
                fieldValueSb.append(value);
                fieldValueSb.append(CONNECTOR);
                fieldSb.append(key);
                fieldSb.append(',');
            }
            if (fieldSb.length() != 0 && fieldSb.toString().endsWith(",")) {
                fieldSb.deleteCharAt(fieldSb.length() - 1);
            }
            resultEntry.set("caldimension", (Object)fieldSb.toString());
            resultEntry.set("caldimensionvalue", (Object)fieldValueSb.toString());
            fieldSb.setLength(0);
            fieldValueSb.setLength(0);
        }
    }

    private List<String> changeFieldPrefix(Set<String> joinSortFields, String prefix) {
        ArrayList<String> fieldList = new ArrayList<String>(joinSortFields.size());
        for (String field : joinSortFields) {
            fieldList.add(field + " as " + prefix + field);
        }
        return fieldList;
    }

    private String getCostRecordQueryStr(String[] allFields) {
        HashSet<String> fields = new HashSet<String>(Arrays.asList(allFields));
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_costrecord");
        StringBuilder sb = new StringBuilder();
        for (String field : fields) {
            IDataEntityProperty property = entityType.findProperty(field);
            if (property == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u3010%1$s\u3011\u4e0d\u5b58\u5728\u5c5e\u6027%2$s", (String)"AutoSortHelper_2", (String)"fi-cal-business", (Object[])new Object[0]), entityType.getName(), field);
                throw new KDBizException(msg);
            }
            IDataEntityType parentProp = property.getParent();
            boolean isEntryProp = parentProp instanceof EntryType;
            if (isEntryProp) {
                sb.append(parentProp.getName());
                sb.append('.');
            }
            sb.append(field);
            if (isEntryProp) {
                sb.append(" as ");
                sb.append(field);
            }
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private String getSortResultQueryStr() {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cal_sortresult");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : entityType.getAllFields().entrySet()) {
            String field = (String)entry.getKey();
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            IDataEntityType parentProp = property.getParent();
            boolean isEntryProp = parentProp instanceof EntryType;
            if (isEntryProp) {
                sb.append(parentProp.getName());
                sb.append('.');
            }
            sb.append(field);
            sb.append(',');
        }
        sb.append("entryentity.seq");
        return sb.toString();
    }

    private void rebuildInnerSort(Map<String, DynamicObject> sortResultMap, DataSet inDataSet, boolean rebuildAll) {
        if (sortResultMap == null) {
            return;
        }
        HashMap<String, GraphNodeManager<InSortNode>> inManageMap = new HashMap<String, GraphNodeManager<InSortNode>>();
        if (!rebuildAll) {
            inDataSet = inDataSet.groupBy(new String[]{"srccostaccount", "srcmaterial", "srccalrange", "srcperiod"}).finish();
            while (inDataSet.hasNext()) {
                Row row = inDataSet.next();
                Long costaccount = row.getLong("srccostaccount");
                Long material = row.getLong("srcmaterial");
                Long calrange = row.getLong("srccalrange");
                QFilter filter = new QFilter("entryentity.costaccount", "=", (Object)costaccount);
                QFilter beforeFilter = new QFilter("entryentity.isbeforeperiod", "=", (Object)false);
                filter.and(beforeFilter);
                filter = filter.and("entryentity.material", "=", (Object)material);
                DataSet thisInSet = this.getRelationDataSet(filter, material, calrange).orderBy(new String[]{"targetbookdate", "targetauditdate", "srcbookdate", "srcauditdate"});
                Throwable throwable = null;
                try {
                    this.addInSortNode(thisInSet, inManageMap);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (thisInSet == null) continue;
                    if (throwable != null) {
                        try {
                            thisInSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    thisInSet.close();
                }
            }
        } else {
            this.addInSortNode(inDataSet, inManageMap);
        }
        for (Map.Entry entry : inManageMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] keys = key.split("#");
            DynamicObject sortResult = null;
            GraphNodeManager inNodeManager = (GraphNodeManager)entry.getValue();
            if (sortResultMap != null && sortResultMap.containsKey(key)) {
                sortResult = sortResultMap.get(key);
            } else {
                QFilter filter = new QFilter("headcalorg", "=", (Object)Long.parseLong(keys[0]));
                filter = filter.and("costaccount", "=", (Object)Long.parseLong(keys[1]));
                filter = filter.and("material", "=", (Object)Long.parseLong(keys[2]));
                filter = filter.and("calrange", "=", (Object)Long.parseLong(keys[3]));
                filter = filter.and("period", "=", (Object)Long.parseLong(keys[4]));
                new CalGroupAccountHelper().addNotGroupAcctFilterByAcctFieldIf("costaccount", filter, this.filterGroupAcct);
                sortResult = BusinessDataServiceHelper.loadSingle((String)"cal_sortresult", (String)this.getSortResultQueryStr(), (QFilter[])filter.toArray());
                if (sortResult == null) {
                    sortResult = BusinessDataServiceHelper.newDynamicObject((String)"cal_sortresult");
                    sortResult.set("groupno", (Object)DEFAULT_GROUPNO);
                    sortResult.set("groupseq", (Object)99999999);
                    sortResult.set("headcalorg", (Object)Long.parseLong(keys[0]));
                    sortResult.set("costaccount", (Object)Long.parseLong(keys[1]));
                    sortResult.set("material", (Object)Long.parseLong(keys[2]));
                    sortResult.set("calrange", (Object)Long.parseLong(keys[3]));
                    sortResult.set("period", (Object)Long.parseLong(keys[4]));
                    sortResult.set("accounttype", (Object)keys[5]);
                }
                sortResultMap.put(key, sortResult);
            }
            this.createSortResultEntry(sortResult, inNodeManager);
        }
    }

    private void addInSortNode(DataSet inDataSet, Map<String, GraphNodeManager<InSortNode>> inManageMap) {
        HashSet<String> relationSet = new HashSet<String>(128);
        while (inDataSet.hasNext()) {
            Row row = inDataSet.next();
            Long calorg = row.getLong("srccalorg");
            Long costaccount = row.getLong("srccostaccount");
            Long material = row.getLong("srcmaterial");
            Long calrange = row.getLong("srccalrange");
            Long period = row.getLong("srcperiod");
            String accounttype = row.getString("srcaccounttype");
            String caldimensionstr = row.getString("srccaldimensionstr");
            String dividebasisstr = row.getString("srcdividebasisstr");
            String inManagerKey = calorg + "#" + costaccount + "#" + material + "#" + calrange + "#" + period + "#" + accounttype;
            GraphNodeManager<InSortNode> inManager = inManageMap.get(inManagerKey);
            if (inManager == null) {
                inManager = new GraphNodeManager();
                inManageMap.put(inManagerKey, inManager);
            }
            String[] dividebasisField = CommonUtils.trimComma((String)dividebasisstr).split(",");
            String[] caldimensionField = caldimensionstr == null ? new String[]{} : CommonUtils.trimComma((String)caldimensionstr).split(",");
            InSortNode srcNode = new InSortNode(dividebasisField, caldimensionField, "src", row);
            InSortNode destNode = new InSortNode(dividebasisField, caldimensionField, "target", row);
            String relationKey = inManagerKey + "|" + srcNode.getRelationKey() + "|" + destNode.getRelationKey();
            if (!relationSet.add(relationKey)) continue;
            inManager.addVector(srcNode, destNode);
        }
    }

    private void rebuildOutSort(Map<String, DynamicObject> sortResultMap, DataSet dataSet, boolean allRebuild, Set<Long> costAccountids) {
        if (sortResultMap == null) {
            return;
        }
        if (!allRebuild) {
            dataSet = this.getRelationDataSet(null, null, null);
            dataSet = dataSet.filter("srccostaccount != targetcostaccount or srcmaterial != targetmaterial or srccalrange != targetcalrange or srcperiod != targetperiod").orderBy(new String[]{"targetbookdate", "targetauditdate", "srcbookdate", "srcauditdate"});
        }
        QFilter outSortfilter = new QFilter("groupno", "!=", (Object)DEFAULT_GROUPNO);
        if (costAccountids != null) {
            outSortfilter.and("costaccount", "in", costAccountids);
        }
        new CalGroupAccountHelper().addNotGroupAcctFilterByAcctFieldIf("costaccount", outSortfilter, this.filterGroupAcct);
        DynamicObject[] outSortResults = BusinessDataServiceHelper.load((String)"cal_sortresult", (String)this.getSortResultQueryStr(), (QFilter[])outSortfilter.toArray());
        HashSet<String> outSortResultKey = new HashSet<String>(16);
        for (DynamicObject outSortResult : outSortResults) {
            String key = outSortResult.getLong("headcalorg_id") + "#" + outSortResult.getLong("costaccount_id") + "#" + outSortResult.getLong("material_id") + "#" + outSortResult.getLong("calrange_id") + "#" + outSortResult.getLong("period_id") + "#" + outSortResult.getString("accounttype");
            outSortResultKey.add(key);
            sortResultMap.put(key, outSortResult);
        }
        GraphNodeManager<OutSortNode> outManager = new GraphNodeManager<OutSortNode>();
        HashSet<String> relationSet = new HashSet<String>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long srccalorg = row.getLong("srccalorg");
            Long srccostaccount = row.getLong("srccostaccount");
            Long srcmaterial = row.getLong("srcmaterial");
            Long srccalrange = row.getLong("srccalrange");
            Long srcperiod = row.getLong("srcperiod");
            String srcaccounttype = row.getString("srcaccounttype");
            Long targetcalorg = row.getLong("targetcalorg");
            Long targetcostaccount = row.getLong("targetcostaccount");
            Long targetmaterial = row.getLong("targetmaterial");
            Long targetcalrange = row.getLong("targetcalrange");
            Long targetperiod = row.getLong("targetperiod");
            String targetaccounttype = row.getString("targetaccounttype");
            OutSortNode srcNode = new OutSortNode(srccalorg, srccostaccount, srcmaterial, srccalrange, srcperiod, srcaccounttype);
            OutSortNode destNode = new OutSortNode(targetcalorg, targetcostaccount, targetmaterial, targetcalrange, targetperiod, targetaccounttype);
            String relationKey = srcNode.getRelationKey() + "|" + destNode.getRelationKey();
            if (!relationSet.add(relationKey)) continue;
            outManager.addVector(srcNode, destNode);
        }
        Map map = outManager.groupSort();
        IDGenerator idGenerator = new IDGenerator("t_cal_sortresult");
        for (Map.Entry entry : map.entrySet()) {
            Long groupno = idGenerator.getId();
            List nodeList = entry.getValue();
            for (int i = 0; i < nodeList.size(); ++i) {
                OutSortNode node = (OutSortNode)nodeList.get(i);
                String key = node.calorg + "#" + node.costaccount + "#" + node.material + "#" + node.calrange + "#" + node.period + "#" + node.accounttype;
                DynamicObject sortResult = sortResultMap.get(key);
                if (sortResult == null) {
                    QFilter filter = new QFilter("headcalorg", "=", (Object)node.calorg);
                    filter = filter.and("accounttype", "=", (Object)node.accounttype);
                    filter = filter.and("costaccount", "=", (Object)node.costaccount);
                    filter = filter.and("material", "=", (Object)node.material);
                    filter = filter.and("calrange", "=", (Object)node.calrange);
                    filter = filter.and("period", "=", (Object)node.period);
                    new CalGroupAccountHelper().addNotGroupAcctFilterByAcctFieldIf("costaccount", filter, this.filterGroupAcct);
                    sortResult = BusinessDataServiceHelper.loadSingle((String)"cal_sortresult", (String)this.getSortResultQueryStr(), (QFilter[])filter.toArray());
                    if (sortResult == null) {
                        sortResult = BusinessDataServiceHelper.newDynamicObject((String)"cal_sortresult");
                        sortResult.set("headcalorg", (Object)node.calorg);
                        sortResult.set("accounttype", (Object)node.accounttype);
                        sortResult.set("costaccount", (Object)node.costaccount);
                        sortResult.set("material", (Object)node.material);
                        sortResult.set("calrange", (Object)node.calrange);
                        sortResult.set("period", (Object)node.period);
                        sortResult.set("accounttype", (Object)node.accounttype);
                    }
                } else {
                    outSortResultKey.remove(key);
                }
                sortResult.set("groupno", (Object)groupno);
                sortResult.set("groupseq", (Object)(i + 1));
                sortResultMap.put(key, sortResult);
            }
        }
        for (String key : outSortResultKey) {
            DynamicObject sortResult = sortResultMap.get(key);
            sortResult.set("groupno", (Object)DEFAULT_GROUPNO);
            sortResult.set("groupseq", (Object)99999999);
        }
    }

    public void setFilterGroupAcct(boolean filterGroupAcct) {
        this.filterGroupAcct = filterGroupAcct;
    }

    private static class InSortNode {
        private Map<String, Object> divideValues;
        private Map<String, Object> caldimensionValues;
        private String divideValuesStr;
        private String caldimensionValuesStr;

        private InSortNode(String[] divideFields, String[] caldimensionFields, String prefix, Row row) {
            Object value;
            this.divideValues = new LinkedHashMap<String, Object>(divideFields.length);
            StringBuilder sb = new StringBuilder();
            for (String field : divideFields) {
                value = row.get(prefix + field);
                this.divideValues.put(field, value);
                sb.append(value);
                sb.append('_');
            }
            this.divideValuesStr = sb.toString();
            sb.setLength(0);
            this.caldimensionValues = new LinkedHashMap<String, Object>(caldimensionFields.length);
            for (String field : caldimensionFields) {
                value = row.get(prefix + field);
                this.caldimensionValues.put(field, value);
                sb.append(value);
                sb.append('_');
            }
            this.caldimensionValuesStr = sb.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof InSortNode) {
                InSortNode node = (InSortNode)o;
                return this.divideValuesStr.equals(node.divideValuesStr) && this.caldimensionValuesStr.equals(node.caldimensionValuesStr);
            }
            return false;
        }

        public int hashCode() {
            return (this.divideValuesStr + "#" + this.caldimensionValuesStr).hashCode();
        }

        public String getRelationKey() {
            return this.divideValuesStr + "#" + this.caldimensionValuesStr;
        }
    }

    private static class OutSortNode {
        private Long calorg;
        private Long costaccount;
        private Long material;
        private Long calrange;
        private Long period;
        private String accounttype;
        private String key;

        private OutSortNode(Long calorg, Long costaccount, Long material, Long calrange, Long period, String accounttype) {
            this.calorg = calorg;
            this.costaccount = costaccount;
            this.material = material;
            this.calrange = calrange;
            this.period = period;
            this.accounttype = accounttype;
            this.key = costaccount + "#" + material + "#" + calrange + "#" + period;
        }

        public boolean equals(Object o) {
            if (o instanceof OutSortNode) {
                OutSortNode node = (OutSortNode)o;
                return this.key.equals(node.key);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String getRelationKey() {
            return this.key;
        }
    }
}

