/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.autosort.graphmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.cal.business.autosort.graphmodel.Node;

public class Graph<K> {
    private Set<Node<K>> nodes;

    public Graph(Set<Node<K>> nodeSet) {
        this.nodes = nodeSet;
    }

    public List<K> sort() {
        HashMap<K, Integer> indexMap = new HashMap<K, Integer>(1024);
        ArrayList<SortNode> nodeArr = new ArrayList<SortNode>(1024);
        int index = 0;
        for (Node<K> node : this.nodes) {
            nodeArr.add(new SortNode(node, index));
            indexMap.put(node.getKey(), index);
            ++index;
        }
        Stack stack = new Stack();
        for (int i = 0; i < nodeArr.size(); ++i) {
            if (((SortNode)nodeArr.get(i)).inCount != 0) continue;
            stack.push(nodeArr.get(i));
        }
        int count = 0;
        LinkedList sortList = new LinkedList();
        while (!stack.empty()) {
            SortNode sNode = (SortNode)stack.pop();
            Node node = null;
            int sIndex = sNode.index;
            sortList.add(((SortNode)nodeArr.get(sIndex)).node.getKey());
            ++count;
            node = ((SortNode)nodeArr.get(sIndex)).node;
            while (node != null) {
                int k = (Integer)indexMap.get(node.getKey());
                if (--((SortNode)nodeArr.get(k)).inCount == 0) {
                    stack.push(nodeArr.get(k));
                }
                node = sNode.next();
            }
        }
        if (count < nodeArr.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u73af\u72b6\u6709\u5411\u56fe\uff0c\u6392\u5e8f\u51fa\u9519\u3002", (String)"Graph_0", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        return sortList;
    }

    private class SortNode {
        private int index;
        private int inCount;
        private Node<K> node;
        private int currentIndex = -1;

        public SortNode(Node<K> node, int index) {
            this.node = node;
            this.index = index;
            List beforeNodes = node.getBeforeNodes();
            this.inCount = beforeNodes == null ? 0 : beforeNodes.size();
        }

        public Node<K> next() {
            List nextNodes = this.node.getNextNodes();
            if (nextNodes == null) {
                return null;
            }
            ++this.currentIndex;
            if (this.currentIndex > nextNodes.size() - 1) {
                return null;
            }
            return nextNodes.get(this.currentIndex);
        }
    }
}

