/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.autosort.graphmodel;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Node<K> {
    private K key;
    private LinkedList<Node<K>> dNext;
    private LinkedList<Node<K>> dBefore;

    public K getKey() {
        return this.key;
    }

    public void setK(K k) {
        this.key = k;
    }

    public Node(K key) {
        this.key = key;
    }

    public boolean hasBeforeNode() {
        return this.dBefore == null || this.dBefore.isEmpty();
    }

    public boolean appendNext(Node<K> nextNode) {
        if (this.key.equals(nextNode.getKey())) {
            return false;
        }
        if (this.hasLoop(nextNode)) {
            return false;
        }
        if (this.dNext == null) {
            this.dNext = new LinkedList();
        }
        this.dNext.add(nextNode);
        super.appendBefore(this);
        return true;
    }

    private boolean hasLoop(Node<K> nextNode) {
        if (this.dBefore == null) {
            return false;
        }
        if (this.dBefore.contains(nextNode)) {
            return true;
        }
        for (Node node : this.dBefore) {
            if (!node.hasLoop(nextNode)) continue;
            return true;
        }
        return false;
    }

    private void appendBefore(Node<K> node) {
        if (this.dBefore == null) {
            this.dBefore = new LinkedList();
        }
        this.dBefore.add(node);
    }

    public Set<Node<K>> getAllConnectedNodes() {
        HashSet<Node<K>> set = new HashSet<Node<K>>();
        if (this.dBefore != null) {
            set.addAll(this.dBefore);
        }
        if (this.dNext != null) {
            set.addAll(this.dNext);
        }
        return set;
    }

    public List<Node<K>> getNextNodes() {
        return this.dNext;
    }

    public List<Node<K>> getBeforeNodes() {
        return this.dBefore;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Node) {
            Node node = (Node)obj;
            return this.key.equals(node.getKey());
        }
        return false;
    }

    public String toString() {
        return this.key.toString();
    }
}

