/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.balance.BalanceUpdateRuleMetadata;
import kd.bos.metadata.balance.BalanceUpdateRuleReader;
import kd.bos.metadata.balance.policy.BalanceFieldMapItem;
import kd.bos.metadata.balance.policy.BalanceFieldMapPolicy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.BalanceSourceEnum;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.util.ArrayUtils;

public class BalanceOpInvoker {
    private static final Log logger = LogFactory.getLog(BalanceOpInvoker.class);
    private String billStatus;
    private Integer batch = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.CAL_BALUPDATE_BATCHSIZE);
    Boolean isNewTx = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.BALUPDATE_NEWTX);
    private String entity = "cal_costrecord_subentity";
    private List<String> dimFieldSet = new ArrayList<String>();
    private String dimFields = "";
    private String costElementFields = "costelement,costsubelement";
    private StringBuilder costRecordAliasSelectsFields = new StringBuilder();

    public void invokeCostRecordUpdateBalOp(Set<Long> idSet, BalanceSourceEnum opAliasEnum) {
        String balOpKey = "updatebal";
        try (AlgoContext context = Algo.newContext();){
            this.invokeCostRecordBalOp(idSet, opAliasEnum, balOpKey);
        }
    }

    public void invokeBalOp(Set<Long> idSet, BalanceSourceEnum opAliasEnum) {
        String balOpKey = "updatebal";
        try (AlgoContext context = Algo.newContext();){
            this.invokeCostRecordBalOp(idSet, opAliasEnum, balOpKey);
        }
    }

    public void invokeCostRecordUpdateBalReverseOp(Set<Long> idSet, BalanceSourceEnum opAliasEnum) {
        String balOpKey = "updatebal_reverse";
        try (AlgoContext context = Algo.newContext();){
            this.invokeCostRecordBalOp(idSet, opAliasEnum, balOpKey);
        }
    }

    public void invokeBalReverseOp(Set<Long> idSet, BalanceSourceEnum opAliasEnum) {
        String balOpKey = "updatebal_reverse";
        try (AlgoContext context = Algo.newContext();){
            this.invokeCostRecordBalOp(idSet, opAliasEnum, balOpKey);
        }
    }

    private void invokeCostRecordBalOp(Set<Long> idSet, BalanceSourceEnum opAliasEnum, String balOpKey) {
        Integer balWaitTimeout;
        OperateOption option = OperateOption.create();
        BalanceSourceEnum balanceSourceEnum = opAliasEnum = opAliasEnum == null ? BalanceSourceEnum.OTHER : opAliasEnum;
        if (opAliasEnum != null) {
            String name = opAliasEnum.getName();
            name = balOpKey + name;
            if (name.length() < 20) {
                option.setVariableValue("balance_update_op_alias", opAliasEnum.getName());
            }
        }
        if ((balWaitTimeout = CalDbParamServiceHelper.getInteger((String)"cal_bal_waittype_timeout")) > 0) {
            option.setVariableValue("bal_waittype_interval", "600");
            option.setVariableValue("bal_waittype_timeout", String.valueOf(balWaitTimeout));
        }
        StringBuilder msg = new StringBuilder();
        boolean notCostAdjust = !"cal_costadjust_subentity".equals(this.entity) && !"cal_stdcostdiffbill".equals(this.entity);
        Lists.partition(new ArrayList<Long>(idSet), (int)this.batch).forEach(list -> {
            List errors;
            OperationResult result;
            if (this.isNewTx.booleanValue() && notCostAdjust) {
                TXHandle handle = TX.requiresNew();
                Object object = null;
                try {
                    result = OperationServiceHelper.executeOperate((String)balOpKey, (String)this.entity, (Object[])list.toArray(), (OperateOption)option);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (handle != null) {
                        if (object != null) {
                            try {
                                handle.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            handle.close();
                        }
                    }
                }
            } else {
                result = OperationServiceHelper.executeOperate((String)balOpKey, (String)this.entity, (Object[])list.toArray(), (OperateOption)option);
            }
            if (!(errors = result.getAllErrorOrValidateInfo()).isEmpty()) {
                for (IOperateInfo error : errors) {
                    OperateInfo operror = (OperateInfo)error;
                    msg.append(operror.getMessage()).append('\n');
                }
            }
            if (!result.isSuccess()) {
                msg.append(result.getMessage()).append('\n');
            }
        });
        if (msg.length() > 0) {
            throw new KDBizException(msg.toString());
        }
        this.addBalanceUpdateRecord(idSet, opAliasEnum);
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    private void addBalanceUpdateRecord(Set<Long> idSet, BalanceSourceEnum sourceEnum) {
        Boolean saveBalRecord = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.SAVE_BAL_RECORD);
        if (!saveBalRecord.booleanValue()) {
            return;
        }
        try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_calcostrecord", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fid", FilterType.in_range, idSet)});){
            ctx.set();
            this.init();
            DataSet costRecords = this.getCostRecords(idSet);
            this.createBalanceRecord4CostRecord(costRecords, sourceEnum);
        }
        catch (Exception e) {
            logger.info("\u65b0\u4f59\u989d\u6a21\u578b\u751f\u6210\u5b58\u8d27\u6210\u672c\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38==>{}", (Object)e);
        }
    }

    private void createBalanceRecord4CostRecord(DataSet recordset, BalanceSourceEnum source) {
        Long entryid = null;
        DynamicObject updateRecord = null;
        LinkedList<DynamicObject> recordList = new LinkedList<DynamicObject>();
        String userId = RequestContext.get().getUserId();
        Date date = new Date();
        int batchSize = 100000;
        while (recordset.hasNext()) {
            Row row = recordset.next();
            if (!row.getLong("entryid").equals(entryid)) {
                entryid = row.getLong("entryid");
                updateRecord = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_updaterecord");
                updateRecord.set("billno", row.get("billno"));
                updateRecord.set("billentity", (Object)"cal_costrecord_subentity");
                updateRecord.set("period", row.get("periodid"));
                updateRecord.set("inorout", row.get("calbilltype"));
                updateRecord.set("billid", row.get("id"));
                updateRecord.set("billentryid", row.get("entryid"));
                updateRecord.set("user", (Object)userId);
                updateRecord.set("actualcost", (Object)BigDecimal.ZERO);
                BigDecimal baseqty = null;
                baseqty = "IN".equals(updateRecord.getString("inorout")) ? row.getBigDecimal("inbaseqty") : row.getBigDecimal("outbaseqty");
                updateRecord.set("baseqty", (Object)baseqty);
                if (source.getValue().equals(BalanceSourceEnum.DEAL_ABNORMAL_COST.getValue())) {
                    if ("C".equals(this.getBillStatus())) {
                        updateRecord.set("source", (Object)source.getValue());
                    } else {
                        String accType = row.getString("acctype");
                        if ("C".equals(accType) || "E".equals(accType)) {
                            updateRecord.set("source", (Object)source.getValue());
                        } else {
                            updateRecord.set("source", (Object)BalanceSourceEnum.COSTRECORD_CREATE.getValue());
                        }
                    }
                } else {
                    updateRecord.set("source", (Object)source.getValue());
                }
                updateRecord.set("updatetime", (Object)date);
                for (String field : this.dimFieldSet) {
                    updateRecord.set(field, row.get(field));
                }
                if (recordList.size() >= batchSize) {
                    SaveServiceHelper.save((DynamicObject[])recordList.toArray(new DynamicObject[recordList.size()]));
                    recordList.clear();
                }
                recordList.add(updateRecord);
            }
            if (updateRecord == null) {
                return;
            }
            DynamicObject entry = updateRecord.getDynamicObjectCollection("entryentity").addNew();
            entry.set("costsubelement", (Object)row.getLong("costsubelement"));
            BigDecimal subactualcost = null;
            subactualcost = "IN".equals(updateRecord.getString("inorout")) ? row.getBigDecimal("inactualcost") : row.getBigDecimal("outactualcost");
            entry.set("subactualcost", (Object)subactualcost);
            updateRecord.set("actualcost", (Object)updateRecord.getBigDecimal("actualcost").add(subactualcost));
        }
        if (!recordList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])recordList.toArray(new DynamicObject[0]));
        }
    }

    private DataSet getCostRecords(Set<Long> idSet) {
        logger.info("BalanceCalculatorNew-\u5f00\u59cb\u67e5\u8be2\u6210\u672c\u8bb0\u5f55\uff1a" + System.currentTimeMillis());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)("id,billno,bizdate,period as periodid,period.periodyear as year,period.periodnumber as month,calbilltype,costaccount.calsystem as calsystem,costaccount.calorg as calorg,costaccount.calpolicy as calpolicy,entry.id as entryid," + this.costRecordAliasSelectsFields + "costaccount.enablestandardcost as enablestd,entry.accounttype as acctype,entry.baseunit as baseunit,entry.baseqty as baseqty,entry.calrange as calrange,entry.caldimension caldimension,invscheme.isforwardamount as isinvschecal,entry.invtype.isforwardamount as isinvtypecal"), (QFilter[])new QFilter("id", "in", idSet).toArray(), null);
        HashSet<Long> entryIds = new HashSet<Long>();
        DataSet entryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"entry.id as entryid", (QFilter[])new QFilter("id", "in", idSet).toArray(), null);
        for (Row row : entryDataSet) {
            entryIds.add(row.getLong("entryid"));
        }
        DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord_detail", (String)"id,entryid,costelement,costsubelement,standardcost,actualcost", (QFilter[])new QFilter("entryid", "in", entryIds).toArray(), null);
        DataSet joinDataSet = dataSet.join(detailDataSet, JoinType.INNER).on("entryid", "entryid").select((String[])ArrayUtils.concatAll((Object[])new String[]{"id", "billno", "bizdate", "periodid", "year", "month", "calbilltype", "calsystem", "calorg", "calpolicy", "entryid", "baseunit", "baseqty", "acctype", "enablestd", "calrange", "caldimension", "isinvschecal", "isinvtypecal"}, (Object[][])new String[][]{this.dimFieldSet.toArray(new String[0])}), new String[]{"id as detailid", "costelement", "costsubelement", "standardcost", "actualcost"}).finish();
        joinDataSet = joinDataSet.select("id,billno,bizdate,periodid,year,month,calbilltype,calsystem,calorg,calpolicy,entryid,baseunit,baseqty,detailid,acctype,enablestd,calrange,caldimension," + this.dimFields + this.costElementFields + ",standardcost as standardcost,actualcost as actualcost,case when calbilltype = 'IN' then baseqty else 0 end as inbaseqty,case when calbilltype = 'IN' and (enablestd = TRUE or acctype = 'D') then standardcost else 0 end as instandardcost,case when (calbilltype = 'IN' and acctype <> 'D') then actualcost when (calbilltype = 'IN' and (acctype = 'D' and isinvschecal and isinvtypecal)) then standardcost else 0 end as inactualcost,case when calbilltype = 'IN' then 0 else baseqty end as outbaseqty,case when calbilltype = 'IN' or (enablestd = FALSE and acctype <> 'D') then 0 else standardcost end as outstandardcost,case when calbilltype = 'IN' then 0 when (calbilltype = 'OUT' and acctype <> 'D') then actualcost when (calbilltype = 'OUT' and (acctype = 'D' and isinvschecal and isinvtypecal)) then standardcost end as outactualcost,0 as incostdiff,0 as outcostdiff");
        return joinDataSet;
    }

    private void init() {
        if (this.dimFieldSet.isEmpty()) {
            this.dimFieldSet.add("costaccount");
            this.dimFieldSet.add("storageorgunit");
            this.dimFieldSet.add("ownertype");
            this.dimFieldSet.add("owner");
            this.dimFieldSet.add("material");
            this.dimFieldSet.add("assist");
            this.dimFieldSet.add("lot");
            this.dimFieldSet.add("warehouse");
            this.dimFieldSet.add("location");
            this.dimFieldSet.add("invtype");
            this.dimFieldSet.add("invstatus");
            this.dimFieldSet.add("project");
            this.dimFieldSet.add("mversion");
            this.dimFieldSet.add("configuredcode");
            this.dimFieldSet.add("tracknumber");
        }
        if (this.costRecordAliasSelectsFields.length() == 0) {
            this.costRecordAliasSelectsFields.append("costaccount as costaccount,storageorgunit as storageorgunit,entry.ownertype as ownertype,entry.owner as owner,entry.material as material,entry.assist as assist,entry.lot as lot,entry.warehouse as warehouse,entry.location as location,entry.invtype as invtype,entry.invstatus as invstatus,entry.project as project,entry.mversion as mversion,entry.configuredcode as configuredcode,entry.tracknumber as tracknumber,");
        }
        for (String dimField : this.dimFieldSet) {
            this.dimFields = this.dimFields + dimField + ",";
        }
    }

    private void initBalanceFields(DynamicObject balRule, String entityName, StringBuilder aliasFields) {
        BalanceUpdateRuleReader reader = new BalanceUpdateRuleReader();
        MainEntityType bizEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        String balUpdateRuleId = balRule.getString("id");
        BalanceUpdateRuleMetadata ruleMetadata = reader.loadMeta(balUpdateRuleId, false);
        BalanceFieldMapPolicy fieldMapPolicy = ruleMetadata.getRuleElement().getFieldMapPolicy();
        for (BalanceFieldMapItem fieldMapItem : fieldMapPolicy.getBalanceFieldMapItems()) {
            String sourceField;
            String convertType = fieldMapItem.getConvertType();
            String targetField = fieldMapItem.getTargetField();
            if (!"0".equals(convertType) || (sourceField = fieldMapItem.getSourceField()) == null) continue;
            if (bizEntityType.findProperty(sourceField).getParent() instanceof EntryType) {
                sourceField = bizEntityType.findProperty(sourceField).getParent().getName() + "." + sourceField;
            }
            aliasFields.append(sourceField).append(" as ").append(targetField).append(',');
        }
    }

    public String getBillStatus() {
        return this.billStatus;
    }

    public void setBillStatus(String billStatus) {
        this.billStatus = billStatus;
    }
}

