/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.Collector;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BalanceUncompressFunction
extends ReduceGroupFunctionWithCollector {
    private static Log log = LogFactory.getLog(BalanceUncompressFunction.class);
    private Long defaultMatSubElementId;
    private List<Long[]> elementIds;
    private Set<Long> enableCalByElementCostAccountIds;
    private RowMeta rowMeta;
    private Set<String> dimFields;
    private boolean withStdData;
    private RowMeta oriDataRowMeta;
    private String[] oriDataField;
    private RowMeta calRowMeta;
    private static final RowMeta periodWithQtyRowMeta = new RowMeta(new Field[]{new Field("period", (DataType)DataType.IntegerType), new Field("endperiod", (DataType)DataType.IntegerType), new Field("baseqty", (DataType)DataType.BigDecimalType), new Field("baseqty_in", (DataType)DataType.BigDecimalType), new Field("baseqty_out", (DataType)DataType.BigDecimalType), new Field("baseqty_bal", (DataType)DataType.BigDecimalType)});
    private static final RowMeta oriDataNoStdRowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("curperiod", (DataType)DataType.IntegerType), new Field("curendperiod", (DataType)DataType.IntegerType), new Field("curcostsubelement", (DataType)DataType.LongType), new Field("actualcost", (DataType)DataType.BigDecimalType), new Field("actualcost_in", (DataType)DataType.BigDecimalType), new Field("actualcost_out", (DataType)DataType.BigDecimalType), new Field("actualcost_bal", (DataType)DataType.BigDecimalType)});
    private static final String[] oriDataNoStdFields = new String[]{"id", "period", "endperiod", "costsubelement", "actualcost", "actualcost_in", "actualcost_out", "actualcost_bal"};
    private static final RowMeta calNoStdRowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("period", (DataType)DataType.IntegerType), new Field("endperiod", (DataType)DataType.IntegerType), new Field("costelement", (DataType)DataType.LongType), new Field("costsubelement", (DataType)DataType.LongType), new Field("actualcost", (DataType)DataType.BigDecimalType), new Field("actualcost_in", (DataType)DataType.BigDecimalType), new Field("actualcost_out", (DataType)DataType.BigDecimalType), new Field("actualcost_bal", (DataType)DataType.BigDecimalType)});
    private static final RowMeta oriDataWithStdRowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("curperiod", (DataType)DataType.IntegerType), new Field("curendperiod", (DataType)DataType.IntegerType), new Field("curcostsubelement", (DataType)DataType.LongType), new Field("actualcost", (DataType)DataType.BigDecimalType), new Field("standardcost", (DataType)DataType.BigDecimalType), new Field("costdiff", (DataType)DataType.BigDecimalType), new Field("actualcost_in", (DataType)DataType.BigDecimalType), new Field("standardcost_in", (DataType)DataType.BigDecimalType), new Field("costdiff_in", (DataType)DataType.BigDecimalType), new Field("actualcost_out", (DataType)DataType.BigDecimalType), new Field("standardcost_out", (DataType)DataType.BigDecimalType), new Field("costdiff_out", (DataType)DataType.BigDecimalType), new Field("actualcost_bal", (DataType)DataType.BigDecimalType), new Field("standardcost_bal", (DataType)DataType.BigDecimalType), new Field("costdiff_bal", (DataType)DataType.BigDecimalType)});
    private static final String[] oriDataWithStdFields = new String[]{"id", "period", "endperiod", "costsubelement", "actualcost", "standardcost", "costdiff", "actualcost_in", "standardcost_in", "costdiff_in", "actualcost_out", "standardcost_out", "costdiff_out", "actualcost_bal", "standardcost_bal", "costdiff_bal"};
    private static final RowMeta calWithStdRowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("period", (DataType)DataType.IntegerType), new Field("endperiod", (DataType)DataType.IntegerType), new Field("costelement", (DataType)DataType.LongType), new Field("costsubelement", (DataType)DataType.LongType), new Field("actualcost", (DataType)DataType.BigDecimalType), new Field("standardcost", (DataType)DataType.BigDecimalType), new Field("costdiff", (DataType)DataType.BigDecimalType), new Field("actualcost_in", (DataType)DataType.BigDecimalType), new Field("standardcost_in", (DataType)DataType.BigDecimalType), new Field("costdiff_in", (DataType)DataType.BigDecimalType), new Field("actualcost_out", (DataType)DataType.BigDecimalType), new Field("standardcost_out", (DataType)DataType.BigDecimalType), new Field("costdiff_out", (DataType)DataType.BigDecimalType), new Field("actualcost_bal", (DataType)DataType.BigDecimalType), new Field("standardcost_bal", (DataType)DataType.BigDecimalType), new Field("costdiff_bal", (DataType)DataType.BigDecimalType)});
    private static final RowMeta subEleRowMeta = new RowMeta(new Field[]{new Field("costelement", (DataType)DataType.LongType), new Field("costsubelement", (DataType)DataType.LongType)});

    public BalanceUncompressFunction(Long defaultMatSubElementId, List<Long[]> elementIds, Set<Long> enableCalByElementCostAccountIds, RowMeta rowMeta, Set<String> dimFields, boolean withStdData) {
        this.defaultMatSubElementId = defaultMatSubElementId;
        this.elementIds = elementIds;
        this.enableCalByElementCostAccountIds = enableCalByElementCostAccountIds;
        this.rowMeta = rowMeta;
        this.dimFields = dimFields;
        this.withStdData = withStdData;
        if (withStdData) {
            this.oriDataRowMeta = oriDataWithStdRowMeta;
            this.oriDataField = oriDataWithStdFields;
            this.calRowMeta = calWithStdRowMeta;
        } else {
            this.oriDataRowMeta = oriDataNoStdRowMeta;
            this.oriDataField = oriDataNoStdFields;
            this.calRowMeta = calNoStdRowMeta;
        }
    }

    public void reduce(Iterator<Row> iterator, Collector collector) {
        DataSetBuilder periodWithQtyBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(periodWithQtyRowMeta);
        DataSetBuilder oriDataBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(this.oriDataRowMeta);
        DataSetBuilder subEleBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(subEleRowMeta);
        boolean notHandle = false;
        boolean firstIt = true;
        HashMap<String, Object> dimValueMap = new HashMap<String, Object>(16);
        HashMap<String, BigDecimal> period2qtyMap = new HashMap<String, BigDecimal>(16);
        HashMap<Integer, Long> period2matBalIdMap = new HashMap<Integer, Long>(16);
        while (iterator.hasNext()) {
            Row row = iterator.next();
            Long l = row.getLong("costaccount");
            if (!this.enableCalByElementCostAccountIds.contains(l)) {
                collector.collect(this.getObjects(row, this.rowMeta.getFieldNames()));
                notHandle = true;
                continue;
            }
            if (firstIt) {
                for (String dimField : this.dimFields) {
                    dimValueMap.put(dimField, row.get(dimField));
                }
                firstIt = false;
            }
            Long costsubelement = row.getLong("costsubelement");
            int period = row.getInteger("period");
            if (this.defaultMatSubElementId.compareTo(costsubelement) == 0) {
                period2matBalIdMap.put(period, row.getLong("id"));
                periodWithQtyBuilder.append(this.getObjects(row, periodWithQtyRowMeta.getFieldNames()));
                period2qtyMap.put(period + "baseqty", row.getBigDecimal("baseqty"));
                period2qtyMap.put(period + "baseqty_in", row.getBigDecimal("baseqty_in"));
                period2qtyMap.put(period + "baseqty_out", row.getBigDecimal("baseqty_out"));
                period2qtyMap.put(period + "baseqty_bal", row.getBigDecimal("baseqty_bal"));
            }
            oriDataBuilder.append(this.getObjects(row, this.oriDataField));
        }
        if (notHandle) {
            return;
        }
        for (Object[] objectArray : this.elementIds) {
            subEleBuilder.append(objectArray);
        }
        DataSet periodWithDataset = periodWithQtyBuilder.build();
        DataSet dataSet = oriDataBuilder.build();
        DataSet subEleDataset = subEleBuilder.build();
        DataSet dataSet2 = periodWithDataset.join(subEleDataset, JoinType.CROSS).select(periodWithQtyRowMeta.getFieldNames(), subEleRowMeta.getFieldNames()).finish();
        dataSet2 = dataSet2.join(dataSet, JoinType.LEFT).on("costsubelement", "curcostsubelement").select(dataSet2.getRowMeta().getFieldNames(), dataSet.getRowMeta().getFieldNames()).finish();
        dataSet2 = this.calculateDataSet(dataSet2, period2matBalIdMap);
        RowMeta calRowMeta = dataSet2.getRowMeta();
        for (Row row : dataSet2) {
            collector.collect(this.getObjects(row, this.rowMeta.getFieldNames(), period2qtyMap, dimValueMap, calRowMeta));
        }
    }

    private Object[] getObjects(Row row, String[] fieldNames, Map<String, BigDecimal> period2qtyMap, Map<String, Object> dimValueMap, RowMeta calRowMeta) {
        ArrayList<Object> values = new ArrayList<Object>(16);
        int period = row.getInteger("period");
        for (String fieldName : fieldNames) {
            if (dimValueMap.containsKey(fieldName)) {
                values.add(dimValueMap.get(fieldName));
                continue;
            }
            if ("baseqty".equals(fieldName) || "baseqty_in".equals(fieldName) || "baseqty_out".equals(fieldName) || "baseqty_bal".equals(fieldName)) {
                values.add(period2qtyMap.get(period + fieldName));
                continue;
            }
            if (calRowMeta.getFieldIndex(fieldName, false) > -1) {
                values.add(row.get(fieldName));
                continue;
            }
            log.error("\u6570\u636e\u538b\u7f29\u672a\u83b7\u53d6\u5230\u503c" + fieldName);
            values.add(null);
        }
        return values.toArray();
    }

    private DataSet calculateDataSet(DataSet dataSet, Map<Integer, Long> period2matBalIdMap) {
        DataSetBuilder builder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(this.calRowMeta);
        for (Row row : dataSet) {
            Long id = row.getLong("id");
            int period = row.getInteger("period");
            int endperiod = row.getInteger("endperiod");
            Integer curperiod = row.getInteger("curperiod");
            Integer curendperiod = row.getInteger("curendperiod");
            Long costelement = row.getLong("costelement");
            Long costsubelement = row.getLong("costsubelement");
            if (curperiod == null || curendperiod == null || period < curperiod || endperiod > curendperiod) {
                if (id == null) {
                    id = period2matBalIdMap.get(period);
                }
                if (this.withStdData) {
                    builder.append(new Object[]{id, period, endperiod, costelement, costsubelement, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
                    continue;
                }
                builder.append(new Object[]{id, period, endperiod, costelement, costsubelement, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
                continue;
            }
            if (period == curperiod) {
                if (this.withStdData) {
                    builder.append(new Object[]{id, period, endperiod, costelement, costsubelement, row.getBigDecimal("actualcost"), row.getBigDecimal("standardcost"), row.getBigDecimal("costdiff"), row.getBigDecimal("actualcost_in"), row.getBigDecimal("standardcost_in"), row.getBigDecimal("costdiff_in"), row.getBigDecimal("actualcost_out"), row.getBigDecimal("standardcost_out"), row.getBigDecimal("costdiff_out"), row.getBigDecimal("actualcost_bal"), row.getBigDecimal("standardcost_bal"), row.getBigDecimal("costdiff_bal")});
                    continue;
                }
                builder.append(new Object[]{id, period, endperiod, costelement, costsubelement, row.getBigDecimal("actualcost"), row.getBigDecimal("actualcost_in"), row.getBigDecimal("actualcost_out"), row.getBigDecimal("actualcost_bal")});
                continue;
            }
            if (period <= curperiod) continue;
            if (this.withStdData) {
                builder.append(new Object[]{id, period, endperiod, costelement, costsubelement, row.getBigDecimal("actualcost_bal"), row.getBigDecimal("standardcost_bal"), row.getBigDecimal("costdiff_bal"), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, row.getBigDecimal("actualcost_bal"), row.getBigDecimal("standardcost_bal"), row.getBigDecimal("costdiff_bal")});
                continue;
            }
            builder.append(new Object[]{id, period, endperiod, costelement, costsubelement, row.getBigDecimal("actualcost_bal"), BigDecimal.ZERO, BigDecimal.ZERO, row.getBigDecimal("actualcost_bal")});
        }
        dataSet = builder.build();
        dataSet = this.withStdData ? dataSet.groupBy(new String[]{"id", "period", "endperiod", "costelement", "costsubelement"}).sum("actualcost").sum("standardcost").sum("costdiff").sum("actualcost_in").sum("standardcost_in").sum("costdiff_in").sum("actualcost_out").sum("standardcost_out").sum("costdiff_out").sum("actualcost_bal").sum("standardcost_bal").sum("costdiff_bal").finish() : dataSet.groupBy(new String[]{"id", "period", "endperiod", "costelement", "costsubelement"}).sum("actualcost").sum("actualcost_in").sum("actualcost_out").sum("actualcost_bal").finish();
        return dataSet;
    }

    private Object[] getObjects(Row row, String[] fieldNames) {
        ArrayList<Object> values = new ArrayList<Object>(16);
        for (String fieldName : fieldNames) {
            values.add(row.get(fieldName));
        }
        return values.toArray();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

