/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.cache.ThreadCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.balance.BalanceDimFieldParser;
import kd.fi.cal.business.balance.BalanceUncompressFunction;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CostElementHelper;

public class BalanceUncompressHelper {
    private static final String CAL_BALANCE_ALLSUBELEMENT = "cal_balance_allsubelement";
    private static final String DATA_SELECT = "baseqty,actualcost,baseqty_in,actualcost_in,baseqty_out,actualcost_out,baseqty_bal,actualcost_bal";
    private static final String DATAWITHSTD_SELECT = "baseqty,actualcost,baseqty_in,actualcost_in,baseqty_out,actualcost_out,baseqty_bal,actualcost_bal,standardcost,costdiff,standardcost_in,costdiff_in,standardcost_out,costdiff_out,standardcost_bal,costdiff_bal";
    private static final List<String> CHECK_FIELDS = Arrays.asList("costsubelement", "baseqty", "actualcost", "baseqty_in", "actualcost_in", "baseqty_out", "actualcost_out", "baseqty_bal", "actualcost_bal", "standardcost", "costdiff", "standardcost_in", "costdiff_in", "standardcost_out", "costdiff_out", "standardcost_bal", "costdiff_bal");

    public static String getBalancDataSetDetailByCache(boolean withNamenum, boolean withStdData, Collection<String> otherFields, List<QFilter> qFilters) {
        DataSet balDS = BalanceUncompressHelper.getBalancDataSetDetail(withNamenum, withStdData, otherFields, qFilters);
        CacheHint cacheHint = new CacheHint();
        cacheHint.setTimeout((long)CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.BALUNCOMPRESS_CACHE_TIMEOUT).intValue(), TimeUnit.SECONDS);
        CachedDataSet cache = balDS.cache(cacheHint);
        String cacheId = cache.getCacheId();
        return cacheId;
    }

    public static DataSet getBalancDataSetDetail(boolean withNamenum, boolean withStdData, Collection<String> otherFields, List<QFilter> qFilters) {
        Set<String> selectFields = BalanceUncompressHelper.getBalanceSelectFields(withNamenum, otherFields);
        DataSet balDS = BalanceUncompressHelper.queryBalanceDetail(qFilters, selectFields, withStdData);
        return balDS;
    }

    public static String getBalancDataForSDK(boolean withNamenum, boolean withStdData, Collection<String> otherFields, List<QFilter> qFilters) {
        return BalanceUncompressHelper.getBalancDataSetDetailByCache(withNamenum, withStdData, otherFields, qFilters);
    }

    private static DataSet queryBalanceDetail(List<QFilter> qFilters, Set<String> selectFields, boolean withStdData) {
        String selects = String.join((CharSequence)",", selectFields);
        selects = withStdData ? selects + "," + DATAWITHSTD_SELECT : selects + "," + DATA_SELECT;
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(4);
        for (QFilter qFilter : qFilters) {
            if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION).booleanValue()) {
                BalanceUncompressHelper.checkQfilter(qFilter);
            }
            OrmInput input = new OrmInput(BalanceUncompressHelper.class.getName(), "cal_bal", selects, qFilter.toArray());
            inputs.add(input);
        }
        DataSet dataSet = Algo.create((String)BalanceUncompressHelper.class.getName()).createDataSet((Input[])inputs.toArray(new OrmInput[0]));
        HashSet<String> dimFields = new HashSet<String>(selectFields);
        dimFields.remove("id");
        dimFields.remove("period");
        dimFields.remove("endperiod");
        dimFields.remove("costelement");
        dimFields.remove("costsubelement");
        if (CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION).booleanValue()) {
            Long defaultMatSubElementId = CostElementHelper.getDefaultMatSubElementId();
            List<Long[]> elementIds = BalanceUncompressHelper.getElementId();
            Set enableCalByElementCostAccountIds = CostElementHelper.getEnableCalByEleCostAcctIds();
            if (!enableCalByElementCostAccountIds.isEmpty()) {
                dataSet = dataSet.groupBy(dimFields.toArray(new String[0])).reduceGroup((ReduceGroupFunctionWithCollector)new BalanceUncompressFunction(defaultMatSubElementId, elementIds, enableCalByElementCostAccountIds, dataSet.getRowMeta(), dimFields, withStdData));
            }
        }
        return dataSet;
    }

    private static void checkQfilter(QFilter qFilter) {
        if (qFilter == null) {
            return;
        }
        if (CHECK_FIELDS.contains(qFilter.getProperty().toLowerCase())) {
            throw new KDBizException("BalanceUncompressHelper error : " + qFilter.getProperty() + " not support. QFilter:" + qFilter);
        }
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter curFilter = nest.getFilter();
            if (!CHECK_FIELDS.contains(curFilter.getProperty().toLowerCase())) continue;
            throw new KDBizException("BalanceUncompressHelper error : " + curFilter.getProperty() + " not support. QFilter:" + qFilter);
        }
    }

    private static List<Long[]> getElementId() {
        ArrayList<Long[]> elementIds = (ArrayList<Long[]>)ThreadCache.get((Object)CAL_BALANCE_ALLSUBELEMENT);
        if (elementIds == null) {
            elementIds = new ArrayList<Long[]>(8);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)BalanceUncompressHelper.class.getName(), (String)"cad_elementdetail", (String)"element,subelement", (QFilter[])new QFilter("subelement.syncflag", "=", (Object)"1").toArray(), null);){
                for (Row row : dataSet) {
                    elementIds.add(new Long[]{row.getLong("element"), row.getLong("subelement")});
                }
            }
            ThreadCache.put((Object)CAL_BALANCE_ALLSUBELEMENT, elementIds);
        }
        return elementIds;
    }

    private static Set<String> getBalanceSelectFields(boolean withNamenum, Collection<String> otherFields) {
        Set<String> selectField = new BalanceDimFieldParser().getDimFieldsWithBaseNameNotAs(withNamenum, withNamenum);
        selectField.add("id");
        selectField.add("calorg");
        selectField.add("calrange");
        selectField.add("baseunit");
        selectField.add("period");
        selectField.add("endperiod");
        selectField.add("costelement");
        selectField.add("costsubelement");
        if (withNamenum) {
            selectField.add("calorg.name");
            selectField.add("calorg.number");
        }
        if (otherFields != null) {
            for (String otherField : otherFields) {
                selectField.add(otherField);
            }
        }
        return selectField;
    }
}

