/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.biz.balance.model.IDataTransform;
import kd.bos.biz.balance.model.UpdateRule;
import kd.fi.cal.common.helper.CostElementHelper;

public class CalBalDataCompressionTransform
implements IDataTransform {
    private final UpdateRule rule;
    private static final List<String> BAL_COST_FIELDS = Arrays.asList("costdiff_in", "standardcost_in", "actualcost_in", "actualcost_out", "standardcost_out", "costdiff_out", "actualcost", "standardcost", "costdiff");
    private static final List<String> BAL_QTY_FIELDS = Arrays.asList("baseqty_in", "baseqty_out", "baseqty");

    public CalBalDataCompressionTransform(UpdateRule rule) {
        this.rule = rule;
    }

    public DataSet doTransform(DataSet srcData) {
        Long defaultMatSubElementId = CostElementHelper.getDefaultMatSubElementId();
        RowMeta rowMeta = srcData.getRowMeta();
        Set enableCalByEleCostAccountIds = CostElementHelper.getEnableCalByEleCostAcctIds();
        DataSetBuilder dataBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        for (Row row : srcData) {
            Long subEleId = row.getLong("costsubelement");
            Long costAccountId = row.getLong("costaccount");
            Object[] newRow = this.createNewRow(row, rowMeta);
            Long curDefMatSubEleId = defaultMatSubElementId;
            if (!enableCalByEleCostAccountIds.contains(costAccountId)) {
                curDefMatSubEleId = 773175233367685120L;
            }
            if (curDefMatSubEleId.equals(subEleId)) {
                dataBuilder.append(newRow);
                continue;
            }
            boolean costNotZero = this.isCostNotZero(row, rowMeta);
            if (!costNotZero) continue;
            this.dealQtyZero(newRow, rowMeta);
            dataBuilder.append(newRow);
        }
        srcData = dataBuilder.build();
        return srcData;
    }

    private Object[] createNewRow(Row row, RowMeta rowMeta) {
        RowMeta resultRowMeta = rowMeta;
        int resultFieldCount = resultRowMeta.getFieldCount();
        Object[] newValues = new Object[resultFieldCount];
        Field[] srcFields = rowMeta.getFields();
        for (int i = 0; i < rowMeta.getFieldCount(); ++i) {
            newValues[i] = row.get(srcFields[i].getName());
        }
        return newValues;
    }

    private boolean isCostNotZero(Row row, RowMeta rowMeta) {
        boolean costNotZero = false;
        for (String costField : BAL_COST_FIELDS) {
            BigDecimal cost;
            int fieldIndex = rowMeta.getFieldIndex(costField, false);
            if (fieldIndex <= -1 || (cost = row.getBigDecimal(costField)) == null || BigDecimal.ZERO.compareTo(cost) == 0) continue;
            costNotZero = true;
            break;
        }
        return costNotZero;
    }

    private void dealQtyZero(Object[] newRow, RowMeta rowMeta) {
        for (String qtyField : BAL_QTY_FIELDS) {
            int fieldIndex = rowMeta.getFieldIndex(qtyField, false);
            if (fieldIndex <= -1) continue;
            newRow[fieldIndex] = BigDecimal.ZERO;
        }
    }
}

