/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance;

import java.math.BigDecimal;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;

public class DealDomainBalFunction
extends MapFunction {
    private final RowMeta resultRowMeta;

    public DealDomainBalFunction(RowMeta rowMeta) {
        this.resultRowMeta = rowMeta;
    }

    public Object[] map(Row row) {
        Integer signNum = row.getInteger("signnum");
        BigDecimal signBigDec = new BigDecimal(signNum);
        Object[] newRow = this.createNewRow(row, this.resultRowMeta);
        this.dealSumQtyAndCost(row, signBigDec, newRow);
        this.dealFixedQtyAndCost(row, signBigDec, newRow);
        return newRow;
    }

    private Object[] createNewRow(Row row, RowMeta resultRowMeta) {
        Object[] newRow = new Object[resultRowMeta.getFieldCount()];
        for (String fieldName : resultRowMeta.getFieldNames()) {
            int fieldIndex = resultRowMeta.getFieldIndex(fieldName);
            newRow[fieldIndex] = row.get(fieldName);
        }
        return newRow;
    }

    public RowMeta getResultRowMeta() {
        return this.resultRowMeta;
    }

    private void dealSumQtyAndCost(Row row, BigDecimal signBigDec, Object[] newRow) {
        int sumInQtyIndex = this.resultRowMeta.getFieldIndex("suminqty", false);
        int sumInCostIndex = this.resultRowMeta.getFieldIndex("sumincost", false);
        int sumOutQtyIndex = this.resultRowMeta.getFieldIndex("sumoutqty", false);
        int sumOutCostIndex = this.resultRowMeta.getFieldIndex("sumoutcost", false);
        if (sumInQtyIndex > -1) {
            newRow[sumInQtyIndex] = row.getBigDecimal("suminqty").multiply(signBigDec);
        }
        if (sumInCostIndex > -1) {
            newRow[sumInCostIndex] = row.getBigDecimal("sumincost").multiply(signBigDec);
        }
        if (sumOutQtyIndex > -1) {
            newRow[sumOutQtyIndex] = row.getBigDecimal("sumoutqty").multiply(signBigDec);
        }
        if (sumOutCostIndex > -1) {
            newRow[sumOutCostIndex] = row.getBigDecimal("sumoutcost").multiply(signBigDec);
        }
    }

    private void dealFixedQtyAndCost(Row row, BigDecimal signBigDec, Object[] newRow) {
        Boolean isVoucher = row.getBoolean("visvoucher");
        String queueType = row.getString("queuetype");
        Boolean isReWork = row.getBoolean("isrework");
        Long gBillId = row.getLong("gbizbillid");
        boolean isInQueue = "0".equals(queueType);
        boolean isOutVou = "1".equals(queueType) && isVoucher != false;
        boolean isNotGroup = gBillId == null || gBillId.equals(0L);
        boolean isUpdateFixed = (isInQueue || isOutVou || isReWork != false) && isNotGroup;
        int inQtyIndex = this.resultRowMeta.getFieldIndex("inqty", false);
        int inCostIndex = this.resultRowMeta.getFieldIndex("incost", false);
        int outQtyIndex = this.resultRowMeta.getFieldIndex("outqty", false);
        int outCostIndex = this.resultRowMeta.getFieldIndex("outcost", false);
        if (isUpdateFixed) {
            if (inQtyIndex > -1) {
                newRow[inQtyIndex] = row.getBigDecimal("inqty").multiply(signBigDec);
            }
            if (inCostIndex > -1) {
                newRow[inCostIndex] = row.getBigDecimal("incost").multiply(signBigDec);
            }
            if (outQtyIndex > -1) {
                newRow[outQtyIndex] = row.getBigDecimal("outqty").multiply(signBigDec);
            }
            if (outCostIndex > -1) {
                newRow[outCostIndex] = row.getBigDecimal("outcost").multiply(signBigDec);
            }
        } else {
            if (inQtyIndex > -1) {
                newRow[inQtyIndex] = BigDecimal.ZERO;
            }
            if (inCostIndex > -1) {
                newRow[inCostIndex] = BigDecimal.ZERO;
            }
            if (outQtyIndex > -1) {
                newRow[outQtyIndex] = BigDecimal.ZERO;
            }
            if (outCostIndex > -1) {
                newRow[outCostIndex] = BigDecimal.ZERO;
            }
        }
    }
}

