/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.biz.balance.model.IDataTransform;

public class DealNoUpdataCalFieldTransform
implements IDataTransform {
    protected static final String diffTypes = "g,h,k,p,q,r,m,s,t,c,x,w,y";
    String entityNumber = null;
    String balanceNo = null;

    public DealNoUpdataCalFieldTransform(String entityNumber, String balanceNo) {
        this.entityNumber = entityNumber;
        this.balanceNo = balanceNo;
    }

    public DataSet doTransform(DataSet srcData) {
        if (srcData != null) {
            RowMeta rowMeta = srcData.getRowMeta();
            DataSetBuilder dataBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
            for (Row row : srcData) {
                Object[] copyRowVals = this.copyRow(row, rowMeta);
                if ("cal_initbill".equals(this.entityNumber) && "cal_standcost_bal".equals(this.balanceNo)) {
                    String diffType = row.getString(rowMeta.getFieldIndex("createtype", Boolean.FALSE.booleanValue())).toLowerCase();
                    for (String type : diffTypes.split(",")) {
                        if (type.equals(diffType)) continue;
                        copyRowVals[rowMeta.getFieldIndex((String)new StringBuilder().append((String)"diff_").append((String)type).toString(), (boolean)Boolean.FALSE.booleanValue())] = BigDecimal.ZERO;
                    }
                }
                if (rowMeta.getFieldIndex("noupdatecalfields", Boolean.FALSE.booleanValue()) <= 0) {
                    dataBuilder.append(copyRowVals);
                    continue;
                }
                String noUpdateCalStr = row.getString("noupdatecalfields");
                JSONObject noUpdateCalJsonObject = JSON.parseObject((String)noUpdateCalStr);
                if (noUpdateCalJsonObject == null || noUpdateCalJsonObject.isEmpty()) {
                    dataBuilder.append(copyRowVals);
                    continue;
                }
                JSONArray noupdateFields = noUpdateCalJsonObject.getJSONArray("setnull");
                for (Object noupdateField : noupdateFields) {
                    if (rowMeta.getFieldIndex(noupdateField.toString(), Boolean.FALSE.booleanValue()) < 0) continue;
                    copyRowVals[rowMeta.getFieldIndex((String)noupdateField.toString(), (boolean)Boolean.FALSE.booleanValue())] = this.getDefaultVal(row, rowMeta, noupdateField.toString());
                }
                dataBuilder.append(copyRowVals);
            }
            return dataBuilder.build();
        }
        return srcData;
    }

    private Object[] copyRow(Row row, RowMeta rowMeta) {
        Object[] currRowVals = new Object[rowMeta.getFieldCount()];
        for (int index = 0; index < rowMeta.getFieldCount(); ++index) {
            currRowVals[index] = "noupdatecalfields".equals(rowMeta.getFieldName(index)) ? " " : row.get(index);
        }
        return currRowVals;
    }

    private Object getDefaultVal(Row row, RowMeta rowMeta, String fieldAlias) {
        int index = rowMeta.getFieldIndex(fieldAlias);
        Object value = row.get(index);
        if (rowMeta.getDataType(index).equals((Object)DataType.BigDecimalType)) {
            value = BigDecimal.ZERO;
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.StringType)) {
            value = " ";
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.LongType)) {
            value = 0L;
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.IntegerType)) {
            value = 0;
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.BooleanType)) {
            value = Boolean.FALSE;
        }
        return value;
    }
}

