/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.biz.balance.model.IDataTransform;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.business.balance.DealDomainBalFunction;
import kd.fi.cal.business.calculate.bizbillgroup.BizGroupRecordBuilder;
import kd.fi.cal.common.helper.AcctGroupModelHelper;

public class DomainBalFilterTransForm
implements IDataTransform {
    private final String entity;

    public DomainBalFilterTransForm(String entity) {
        this.entity = entity;
    }

    public DataSet doTransform(DataSet srcData) {
        if (srcData != null) {
            HashSet<Long> billIds = new HashSet<Long>(16);
            for (Row row : srcData.copy()) {
                billIds.add(row.getLong("billId"));
            }
            if (billIds.isEmpty()) {
                return srcData;
            }
            RowMeta srcRowMeta = srcData.getRowMeta();
            if ("cal_costrecord_subentity".equals(this.entity) || "cal_costrecord".equals(this.entity)) {
                String selectFields = "id vid,isvoucher visvoucher,bizbillid vbizbillid,calbilltype vcalbilltype,bizentityobject vbizentityobject,entry.isrework isrework,entry.subentrycostelement.id detailid,entry.queuetype as queuetype,entry.signnum as signnum,entry.id ventryid";
                DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entity, (String)selectFields, (QFilter[])new QFilter("id", "in", billIds).toArray(), null);
                HashMap<Long, Long> bizBillIdRecIdMap = new HashMap<Long, Long>(16);
                HashMap<String, Set<Long>> form2BizbillIdMap = new HashMap<String, Set<Long>>(16);
                for (Row row : billDs.copy()) {
                    Long bizbillid = row.getLong("vbizbillid");
                    String bizentityobject = row.getString("vbizentityobject");
                    bizBillIdRecIdMap.put(row.getLong("vid"), bizbillid);
                    Set bizbillids = form2BizbillIdMap.computeIfAbsent(bizentityobject, k -> new HashSet(16));
                    bizbillids.add(bizbillid);
                }
                DataSet recJoinBillGroupDs = this.getBillDsJoinGroupDs(billDs, bizBillIdRecIdMap, form2BizbillIdMap);
                String[] srcFieldNames = srcRowMeta.getFieldNames();
                srcData = srcData.leftJoin(recJoinBillGroupDs).on("billid", "vid").on("entryid", "detailid").select(srcFieldNames, recJoinBillGroupDs.getRowMeta().getFieldNames()).finish();
                srcData = srcData.map((MapFunction)new DealDomainBalFunction(srcData.getRowMeta()));
                srcData = srcData.select(srcFieldNames);
            } else if ("cal_costadjust_subentity".equals(this.entity)) {
                String[] srcFieldNames = srcData.getRowMeta().getFieldNames();
                String otherFields = "queuetype,signnum,'0' as visvoucher,'0' as isrework,0L as gbizbillid";
                DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entity, (String)"id vid,entryentity.queuetype queuetype,entryentity.signnum signnum,entryentity.subentryentity.id detailid", (QFilter[])new QFilter("id", "in", billIds).toArray(), null);
                srcData = srcData.join(billDs).on("billid", "vid").on("entryid", "detailid").select(srcFieldNames, otherFields.split(",")).finish();
                srcData = srcData.map((MapFunction)new DealDomainBalFunction(srcData.getRowMeta()));
                srcData = srcData.select(srcFieldNames);
            }
        }
        return srcData;
    }

    private DataSet getBillDsJoinGroupDs(DataSet billDs, Map<Long, Long> bizBillIdRecIdMap, Map<String, Set<Long>> form2BizbillIdMap) {
        DataSet recJoinBillGroupDs = null;
        DataSet billGroupDs = null;
        if (AcctGroupModelHelper.isBizGroupModel()) {
            billGroupDs = new BizGroupRecordBuilder().getAllGroupRecordDataSetByBizBillIds(form2BizbillIdMap);
            billGroupDs = billGroupDs.groupBy(new String[]{"bizbillid", "costrecordentryid"}).finish();
            recJoinBillGroupDs = billDs.leftJoin(billGroupDs).on("vbizbillid", "bizbillid").on("ventryid", "costrecordentryid").select(billDs.getRowMeta().getFieldNames(), new String[]{"bizbillid as gbizbillid"}).finish();
        } else {
            String groupRecKey = AcctGroupModelHelper.isNewGroupModel() ? "cal_account_grouprecord" : "cal_groupbillrecord";
            QFilter billF = new QFilter("entryentity.bizbillid", "in", bizBillIdRecIdMap.values());
            billGroupDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)groupRecKey, (String)"entryentity.bizbillid as gbizbillid", (QFilter[])new QFilter[]{billF}, null);
            billGroupDs = billGroupDs.groupBy(new String[]{"gbizbillid"}).finish();
            recJoinBillGroupDs = billDs.leftJoin(billGroupDs).on("vbizbillid", "gbizbillid").select(billDs.getRowMeta().getFieldNames(), new String[]{"gbizbillid"}).finish();
        }
        return recJoinBillGroupDs;
    }
}

