/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.builder.CalBalanceBuilder;
import kd.fi.cal.common.enums.AccountTypeEnum;
import kd.fi.cal.common.helper.CalBalanceModelHelper;
import kd.fi.cal.common.helper.InitCalBillHelper;
import kd.fi.cal.common.util.CommonUtils;

public class InitBillOldBalanceCalculator {
    public void updateAudit(DynamicObject[] billInfos) {
        if (CalBalanceModelHelper.isNewBalance()) {
            return;
        }
        HashMap<Long, HashSet<Long>> costAccountMap = new HashMap<Long, HashSet<Long>>(16);
        for (DynamicObject info : billInfos) {
            long costAccountId = info.getLong("costaccount.id");
            HashSet<Long> billIdSet = (HashSet<Long>)costAccountMap.get(costAccountId);
            if (billIdSet != null) {
                billIdSet.add(info.getLong("id"));
                continue;
            }
            billIdSet = new HashSet<Long>(64);
            billIdSet.add(info.getLong("id"));
            costAccountMap.put(costAccountId, billIdSet);
        }
        this.handleBalance(billInfos, costAccountMap.keySet());
    }

    private void handleBalance(DynamicObject[] billInfos, Set<Long> costAccountIds) {
        int billSize = billInfos.length;
        Set dimFieldSet = CalBalanceModelHelper.getAllDimField();
        int entryNum = 0;
        int stdEntryNum = 0;
        HashSet<Long> storageorgSet = new HashSet<Long>(billSize);
        HashSet<Long> materialSet = new HashSet<Long>(billSize);
        HashSet<Long> warehouseSet = new HashSet<Long>(billSize);
        HashSet<Long> stdStorageorgSet = new HashSet<Long>(billSize);
        HashSet<Long> stdMaterialSet = new HashSet<Long>(billSize);
        HashSet<Long> stdWarehouseSet = new HashSet<Long>(billSize);
        for (DynamicObject info : billInfos) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            DynamicObject costAccount = info.getDynamicObject("costaccount");
            boolean enableStd = costAccount.getBoolean("enablestandardcost");
            for (DynamicObject entry : entrys) {
                long storarageId = entry.getLong("storageorgunit.id");
                long materialId = entry.getLong("material.id");
                long warehouseId = entry.getLong("warehouse.id");
                storageorgSet.add(storarageId);
                materialSet.add(materialId);
                warehouseSet.add(warehouseId);
                ++entryNum;
                if (!InitCalBillHelper.isStd((boolean)enableStd, (String)entry.getString("accounttype"))) continue;
                stdStorageorgSet.add(storarageId);
                stdMaterialSet.add(materialId);
                stdWarehouseSet.add(warehouseId);
                ++stdEntryNum;
            }
        }
        HashMap<String, Long> existsDimMap = new HashMap<String, Long>(512);
        HashMap<String, Set<Long>> notBeginDimMap = new HashMap<String, Set<Long>>(128);
        HashMap<String, Long> periodMap = new HashMap<String, Long>(128);
        this.queryBalance(costAccountIds, dimFieldSet, storageorgSet, materialSet, warehouseSet, existsDimMap, notBeginDimMap, periodMap, "cal_balance");
        Set existsDim = existsDimMap.keySet();
        ArrayList updateList = new ArrayList(billSize);
        ArrayList detailUpdateList = new ArrayList(billSize);
        ArrayList<Object[]> endPeriodUpdateList = new ArrayList<Object[]>(billSize);
        long[] balIds = DB.genLongIds((String)"t_cal_balance", (int)entryNum);
        int idLen = 0;
        ArrayList<DynamicObject> saveCalBalList = new ArrayList<DynamicObject>(entryNum);
        ArrayList saveCalBalDetails = new ArrayList(entryNum);
        MainEntityType initCalEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_initbill");
        HashSet<String> insertedDim = new HashSet<String>(entryNum);
        HashSet<Long> balIdTempSet = new HashSet<Long>(1);
        for (DynamicObject info : billInfos) {
            DynamicObject costAcc = info.getDynamicObject("costaccount");
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                Set dispatchBalIds;
                boolean isStdAccType = AccountTypeEnum.STANDARDCOST.getValue().equals(entry.getString("accounttype"));
                boolean isStd = costAcc.getBoolean("enablestandardcost") || isStdAccType;
                String billDimStr = InitCalBillHelper.getEntryDimString((MainEntityType)initCalEntityType, (Set)dimFieldSet, (DynamicObject)info, (DynamicObject)entry);
                if (existsDim.contains(billDimStr)) {
                    long balId = (Long)existsDimMap.get(billDimStr);
                    balIdTempSet.add(balId);
                    InitCalBillHelper.handleUpdateBalList(balIdTempSet, (DynamicObject)entry, updateList, detailUpdateList, (boolean)isStd, (boolean)true);
                    balIdTempSet.clear();
                } else {
                    long id = balIds[idLen];
                    ((DynamicObject)info.getDynamicObjectCollection("entryentity").get(0)).getDynamicObjectCollection("subentryentity");
                    Map<String, Object> balDynMap = CalBalanceBuilder.createOneCalBalance(info, entry, id, isStd);
                    saveCalBalList.add((DynamicObject)balDynMap.get("cal_balance"));
                    saveCalBalDetails.addAll((List)balDynMap.get("cal_balance_detail"));
                    if (insertedDim.add(billDimStr) && notBeginDimMap.containsKey(billDimStr)) {
                        endPeriodUpdateList.add(new Object[]{periodMap.get(billDimStr), id});
                    }
                    existsDimMap.put(billDimStr, id);
                    ++idLen;
                }
                if ((dispatchBalIds = (Set)notBeginDimMap.get(billDimStr)) == null) continue;
                InitCalBillHelper.handleUpdateBalList((Set)dispatchBalIds, (DynamicObject)entry, updateList, detailUpdateList, (boolean)isStd, (boolean)true);
            }
        }
        DynamicObject[] saveCalBalArr = saveCalBalList.toArray(new DynamicObject[0]);
        SaveServiceHelper.save((DynamicObject[])saveCalBalArr);
        SaveServiceHelper.save((DynamicObject[])saveCalBalDetails.toArray(new DynamicObject[0]));
        if (!updateList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"update t_cal_balance set fperiodbeginqty = fperiodbeginqty + ?,fbeginstandardcost = fbeginstandardcost + ?,fperiodbeginactualcost = fperiodbeginactualcost + ?,fperiodbegincostdiff = fperiodbegincostdiff + ?,fyearinqty = fyearinqty + ?,fyearinstandradcost = fyearinstandradcost + ?,fyearinactualcost = fyearinactualcost + ?,fyearincostdiff = fyearincostdiff + ?,fyearissueqty = fyearissueqty + ?,fyearissuestandradcost = fyearissuestandradcost + ?,fyearissueactualcost = fyearissueactualcost + ?,fyearissuecostdiff = fyearissuecostdiff + ?,fperiodendqty = fperiodendqty + ?,fperiodendstandardcost = fperiodendstandardcost + ?,fperiodendactualcost = fperiodendactualcost + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fid = ?", updateList);
        }
        if (!detailUpdateList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"update t_cal_balance_detail set fperiodbeginqty = fperiodbeginqty + ?,fbeginstandardcost = fbeginstandardcost + ?,fperiodbeginactualcost = fperiodbeginactualcost + ?,fperiodbegincostdiff = fperiodbegincostdiff + ?,fyearinqty = fyearinqty + ?,fyearinstandradcost = fyearinstandradcost + ?,fyearinactualcost = fyearinactualcost + ?,fyearincostdiff = fyearincostdiff + ?,fyearissueqty = fyearissueqty + ?,fyearissuestandradcost = fyearissuestandradcost + ?,fyearissueactualcost = fyearissueactualcost + ?,fyearissuecostdiff = fyearissuecostdiff + ?,fperiodendqty = fperiodendqty + ?,fperiodendstandardcost = fperiodendstandardcost + ?,fperiodendactualcost = fperiodendactualcost + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fid = ? and fcostsubelementid = ?", detailUpdateList);
        }
        if (!endPeriodUpdateList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"update t_cal_balance set fendperiod = ? where fid = ?", endPeriodUpdateList);
        }
        if (stdEntryNum == 0) {
            return;
        }
        HashMap<String, Long> stdExistsDimMap = new HashMap<String, Long>(512);
        HashMap<String, Set<Long>> stdNotBeginDimMap = new HashMap<String, Set<Long>>(128);
        HashMap<String, Long> stdPeriodMap = new HashMap<String, Long>(128);
        dimFieldSet = CalBalanceModelHelper.getAllStdDimField();
        dimFieldSet.add("createtype");
        this.queryBalance(costAccountIds, dimFieldSet, stdStorageorgSet, stdMaterialSet, stdWarehouseSet, stdExistsDimMap, stdNotBeginDimMap, stdPeriodMap, "cal_purpricediff");
        Set stdExistsDim = stdExistsDimMap.keySet();
        ArrayList stdUpdateList = new ArrayList(stdEntryNum);
        ArrayList stdDetailUpdateList = new ArrayList(stdEntryNum);
        ArrayList<Object[]> stdEndPeriodUpdList = new ArrayList<Object[]>(stdEntryNum);
        long[] stdcalIds = DB.genLongIds((String)"t_cal_purpricediff", (int)stdEntryNum);
        ArrayList<DynamicObject> saveStdBalList = new ArrayList<DynamicObject>(stdEntryNum);
        ArrayList saveStdBalDetails = new ArrayList(stdEntryNum * 5);
        HashSet<Long> stdBalIdTempSet = new HashSet<Long>(1);
        idLen = 0;
        for (DynamicObject info : billInfos) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (StringUtils.isEmpty((CharSequence)entry.getString("createtype"))) continue;
                String billDimStr = InitCalBillHelper.getEntryDimString((MainEntityType)initCalEntityType, (Set)dimFieldSet, (DynamicObject)info, (DynamicObject)entry);
                if (stdExistsDim.contains(billDimStr)) {
                    long balId = (Long)stdExistsDimMap.get(billDimStr);
                    stdBalIdTempSet.add(balId);
                    InitCalBillHelper.handleUpdateStdBalList(stdBalIdTempSet, (DynamicObject)entry, stdUpdateList, stdDetailUpdateList, (boolean)true);
                    stdBalIdTempSet.clear();
                } else {
                    long id = stdcalIds[idLen];
                    Map<String, Object> balDynMap = CalBalanceBuilder.createOneStdBalance(info, entry, id);
                    saveStdBalList.add((DynamicObject)balDynMap.get("cal_balance"));
                    saveStdBalDetails.addAll((List)balDynMap.get("cal_purpricediff_detail"));
                    if (insertedDim.add(billDimStr) && stdNotBeginDimMap.containsKey(billDimStr)) {
                        stdEndPeriodUpdList.add(new Object[]{stdPeriodMap.get(billDimStr), id});
                    }
                    stdExistsDimMap.put(billDimStr, id);
                    ++idLen;
                }
                if (!stdNotBeginDimMap.containsKey(billDimStr)) continue;
                Set dispatchBalIds = (Set)stdNotBeginDimMap.remove(billDimStr);
                InitCalBillHelper.handleUpdateStdBalList((Set)dispatchBalIds, (DynamicObject)entry, stdUpdateList, stdDetailUpdateList, (boolean)true);
            }
        }
        saveCalBalArr = saveStdBalList.toArray(new DynamicObject[0]);
        SaveServiceHelper.save((DynamicObject[])saveCalBalArr);
        SaveServiceHelper.save((DynamicObject[])saveStdBalDetails.toArray(new DynamicObject[0]));
        if (!stdUpdateList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"update t_cal_purpricediff set fperiodbegincostdiff = fperiodbegincostdiff + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fid = ?", stdUpdateList);
        }
        if (!stdDetailUpdateList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"update t_cal_purdiff_detail set fperiodbegincostdiff = fperiodbegincostdiff + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fbalid = ? and fcostsubelementid = ?", stdDetailUpdateList);
        }
        if (!stdEndPeriodUpdList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"update t_cal_purpricediff set fendperiod = ? where fid = ?", stdEndPeriodUpdList);
        }
    }

    private void queryBalance(Set<Long> costAccountIds, Set<String> dimFieldSet, Set<Long> storageorgSet, Set<Long> materialSet, Set<Long> warehouseSet, Map<String, Long> existsDimMap, Map<String, Set<Long>> notBeginDimMap, Map<String, Long> periodMap, String balanceType) {
        QFilter balFilter = new QFilter("costaccount", "in", costAccountIds);
        balFilter.and("storageorgunit", "in", storageorgSet);
        balFilter.and("material", "in", materialSet);
        balFilter.and("warehouse", "in", warehouseSet);
        try (DataSet balDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)balanceType, (String)("id,period," + String.join((CharSequence)",", dimFieldSet)), (QFilter[])new QFilter[]{balFilter}, (String)"period");){
            for (Row row : balDs) {
                StringBuilder sb = new StringBuilder();
                for (String dimField : dimFieldSet) {
                    sb.append(row.get(dimField)).append('|');
                }
                String balDimStr = sb.toString();
                if (row.getInteger("period") == 0) {
                    existsDimMap.put(balDimStr, row.getLong("id"));
                    continue;
                }
                Set<Long> balIds = notBeginDimMap.get(balDimStr);
                if (balIds == null) {
                    balIds = new HashSet<Long>(16);
                    periodMap.put(balDimStr, row.getLong("period"));
                }
                balIds.add(row.getLong("id"));
                notBeginDimMap.put(balDimStr, balIds);
            }
        }
    }

    public void updateUnAudit(DynamicObject[] billInfos) {
        if (CalBalanceModelHelper.isNewBalance()) {
            return;
        }
        MainEntityType initCalEntityType = MetadataServiceHelper.getDataEntityType((String)"cal_initbill");
        int billSize = billInfos.length;
        int entryNum = 0;
        int stdEntryNum = 0;
        HashSet<Long> costAccountSet = new HashSet<Long>(billSize);
        HashSet<Long> storageorgSet = new HashSet<Long>(billSize);
        HashSet<Long> materialSet = new HashSet<Long>(billSize);
        HashSet<Long> warehouseSet = new HashSet<Long>(billSize);
        HashSet<Long> stdStorageorgSet = new HashSet<Long>(billSize);
        HashSet<Long> stdMaterialSet = new HashSet<Long>(billSize);
        HashSet<Long> stdWarehouseSet = new HashSet<Long>(billSize);
        for (DynamicObject info : billInfos) {
            DynamicObject[] costAccount = info.getDynamicObject("costaccount");
            costAccountSet.add(costAccount.getLong("id"));
            int enableStd = costAccount.getBoolean("enablestandardcost");
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                long storarageId = entry.getLong("storageorgunit.id");
                long materialId = entry.getLong("material.id");
                long warehouseId = entry.getLong("warehouse.id");
                storageorgSet.add(storarageId);
                materialSet.add(materialId);
                warehouseSet.add(warehouseId);
                ++entryNum;
                if (!InitCalBillHelper.isStd(enableStd != 0, (String)entry.getString("accounttype"))) continue;
                stdStorageorgSet.add(storarageId);
                stdMaterialSet.add(materialId);
                stdWarehouseSet.add(warehouseId);
                ++stdEntryNum;
            }
        }
        ArrayList updateList = new ArrayList(entryNum);
        ArrayList detailUpdateList = new ArrayList(entryNum);
        Set dimFieldSet = CalBalanceModelHelper.getAllDimField();
        HashMap<String, Set<Long>> balDimMap = new HashMap<String, Set<Long>>(entryNum);
        this.queryBalance(costAccountSet, storageorgSet, materialSet, warehouseSet, dimFieldSet, balDimMap, "cal_balance");
        for (DynamicObject info : billInfos) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            DynamicObject costAcc = info.getDynamicObject("costaccount");
            for (DynamicObject entry : entrys) {
                String billDimStr = InitCalBillHelper.getEntryDimString((MainEntityType)initCalEntityType, (Set)dimFieldSet, (DynamicObject)info, (DynamicObject)entry);
                boolean isStd = InitCalBillHelper.isStd((DynamicObject)costAcc, (String)entry.getString("accounttype"));
                InitCalBillHelper.handleUpdateBalList((Set)((Set)balDimMap.get(billDimStr)), (DynamicObject)entry, updateList, detailUpdateList, (boolean)isStd, (boolean)false);
            }
        }
        if (!updateList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"update t_cal_balance set fperiodbeginqty = fperiodbeginqty + ?,fbeginstandardcost = fbeginstandardcost + ?,fperiodbeginactualcost = fperiodbeginactualcost + ?,fperiodbegincostdiff = fperiodbegincostdiff + ?,fyearinqty = fyearinqty + ?,fyearinstandradcost = fyearinstandradcost + ?,fyearinactualcost = fyearinactualcost + ?,fyearincostdiff = fyearincostdiff + ?,fyearissueqty = fyearissueqty + ?,fyearissuestandradcost = fyearissuestandradcost + ?,fyearissueactualcost = fyearissueactualcost + ?,fyearissuecostdiff = fyearissuecostdiff + ?,fperiodendqty = fperiodendqty + ?,fperiodendstandardcost = fperiodendstandardcost + ?,fperiodendactualcost = fperiodendactualcost + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fid = ?", updateList);
        }
        if (!detailUpdateList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"update t_cal_balance_detail set fperiodbeginqty = fperiodbeginqty + ?,fbeginstandardcost = fbeginstandardcost + ?,fperiodbeginactualcost = fperiodbeginactualcost + ?,fperiodbegincostdiff = fperiodbegincostdiff + ?,fyearinqty = fyearinqty + ?,fyearinstandradcost = fyearinstandradcost + ?,fyearinactualcost = fyearinactualcost + ?,fyearincostdiff = fyearincostdiff + ?,fyearissueqty = fyearissueqty + ?,fyearissuestandradcost = fyearissuestandradcost + ?,fyearissueactualcost = fyearissueactualcost + ?,fyearissuecostdiff = fyearissuecostdiff + ?,fperiodendqty = fperiodendqty + ?,fperiodendstandardcost = fperiodendstandardcost + ?,fperiodendactualcost = fperiodendactualcost + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fid = ? and fcostsubelementid = ?", detailUpdateList);
        }
        if (stdEntryNum == 0) {
            return;
        }
        HashMap<String, Set<Long>> stdBalDimMap = new HashMap<String, Set<Long>>(entryNum);
        dimFieldSet = CalBalanceModelHelper.getAllStdDimField();
        dimFieldSet.add("createtype");
        this.queryBalance(costAccountSet, stdStorageorgSet, stdMaterialSet, stdWarehouseSet, dimFieldSet, stdBalDimMap, "cal_purpricediff");
        ArrayList stdUpdateList = new ArrayList(entryNum);
        ArrayList stdDetailUpdateList = new ArrayList(entryNum);
        for (DynamicObject info : billInfos) {
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (StringUtils.isEmpty((CharSequence)entry.getString("createtype"))) continue;
                String billDimStr = InitCalBillHelper.getEntryDimString((MainEntityType)initCalEntityType, (Set)dimFieldSet, (DynamicObject)info, (DynamicObject)entry);
                InitCalBillHelper.handleUpdateStdBalList((Set)((Set)stdBalDimMap.get(billDimStr)), (DynamicObject)entry, stdUpdateList, stdDetailUpdateList, (boolean)false);
            }
        }
        if (!stdUpdateList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"update t_cal_purpricediff set fperiodbegincostdiff = fperiodbegincostdiff + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fid = ?", stdUpdateList);
        }
        if (!stdDetailUpdateList.isEmpty()) {
            DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)"update t_cal_purdiff_detail set fperiodbegincostdiff = fperiodbegincostdiff + ?,fperiodendcostdiff = fperiodendcostdiff + ? where fbalid = ? and fcostsubelementid = ?", stdDetailUpdateList);
        }
    }

    private void queryBalance(Set<Long> costAccountSet, Set<Long> storageorgSet, Set<Long> materialSet, Set<Long> warehouseSet, Set<String> dimFieldSet, Map<String, Set<Long>> balDimMap, String balanceType) {
        QFilter balFilter = new QFilter("costaccount", "in", costAccountSet);
        balFilter.and("storageorgunit", "in", storageorgSet);
        balFilter.and("material", "in", materialSet);
        balFilter.and("warehouse", "in", warehouseSet);
        String selectFields = "id,period," + String.join((CharSequence)",", dimFieldSet);
        try (DataSet balDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)balanceType, (String)selectFields, (QFilter[])new QFilter[]{balFilter}, null);){
            for (Row row : balDs) {
                StringBuilder sb = new StringBuilder();
                for (String dimField : dimFieldSet) {
                    sb.append(row.get(dimField)).append('|');
                }
                String balDimStr = sb.toString();
                Set<Long> balIds = balDimMap.get(balDimStr);
                if (balIds == null) {
                    balIds = new HashSet<Long>(16);
                }
                balIds.add(row.getLong("id"));
                balDimMap.put(balDimStr, balIds);
            }
        }
    }
}

