/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance;

import java.util.List;
import kd.bos.biz.balance.model.IBalanceUpdatePlugin;
import kd.bos.biz.balance.model.IDataTransform;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.fi.cal.business.balance.CalBalDataCompressionTransform;
import kd.fi.cal.business.balance.CalBalPeriodFilterTransform;
import kd.fi.cal.business.balance.DealNoUpdataCalFieldTransform;
import kd.fi.cal.business.balance.StdCostDiffBillJsonToRowTransform;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class StdCostDiffBillBalanceUpdatePlugin
implements IBalanceUpdatePlugin {
    public void addTransform(List<IDataTransform> transformCollector, UpdateRule rule) {
        if ("cal_stdcostdiffbill".equals(rule.getEntityNumber())) {
            StdCostDiffBillJsonToRowTransform transform = new StdCostDiffBillJsonToRowTransform(rule.getPerQtyType());
            transformCollector.add(transform);
        } else if ("cal_initbill".equals(rule.getEntityNumber()) || "cal_costrecord_subentity".equals(rule.getEntityNumber()) || "cal_costadjust_subentity".equals(rule.getEntityNumber())) {
            DealNoUpdataCalFieldTransform transform = new DealNoUpdataCalFieldTransform(rule.getEntityNumber(), rule.getBalanceNo());
            transformCollector.add(transform);
        }
        this.calBalComPress(transformCollector, rule);
        if (!"cal_inventorybalance".equals(rule.getEntityNumber()) && !"cal_initbill".equals(rule.getEntityNumber())) {
            this.calBalPeriodFilter(transformCollector);
        }
    }

    private void calBalPeriodFilter(List<IDataTransform> transformCollector) {
        Integer period = CalDbParamServiceHelper.getInteger((String)"PrePeriodImBillSyncPeriod");
        if (period != null) {
            transformCollector.add(new CalBalPeriodFilterTransform(period));
        }
    }

    private void calBalComPress(List<IDataTransform> transformCollector, UpdateRule rule) {
        Boolean balCompress = Boolean.FALSE;
        try (TXHandle tx = TX.requiresNew();){
            balCompress = CalDbParamServiceHelper.getBoolean((String)CalDbParamConstant.CAL_BAL_DATA_COMPRESSION);
        }
        if (balCompress.booleanValue()) {
            CalBalDataCompressionTransform dcTransform = new CalBalDataCompressionTransform(rule);
            transformCollector.add(dcTransform);
        }
    }
}

