/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.Collector;
import kd.bos.algo.DataType;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;

public class StdCostDiffBillJsonReduceFunction
extends ReduceGroupFunctionWithCollector {
    protected RowMeta rowMeta;
    private String perQtyType = "_in";

    public StdCostDiffBillJsonReduceFunction(RowMeta rowMeta, String perQtyType) {
        this.rowMeta = rowMeta;
        this.perQtyType = perQtyType;
    }

    public void reduce(Iterator<Row> iterator, Collector collector) {
        HashSet<String> srcFields = new HashSet<String>(16);
        for (String field : this.rowMeta.getFieldNames()) {
            srcFields.add(field);
        }
        while (iterator.hasNext()) {
            Row row = iterator.next();
            String jsonData = row.getString("subentryentityjson");
            JSONObject jsonObject = JSON.parseObject((String)jsonData);
            JSONArray valuesData = jsonObject.getJSONArray("data");
            JSONArray indexData = jsonObject.getJSONArray("index");
            String noUpdateCalStr = row.getString("noupdatecalfields");
            JSONObject noUpdateCalJsonObject = JSON.parseObject((String)noUpdateCalStr);
            JSONArray noupdateFields = null;
            if (noUpdateCalJsonObject != null) {
                noupdateFields = noUpdateCalJsonObject.getJSONArray("setnull");
            }
            for (int index = 0; index < valuesData.size(); ++index) {
                JSONArray values = valuesData.getJSONArray(index);
                Object[] copyRowVals = this.copyRow(row, this.rowMeta);
                if (noupdateFields != null) {
                    for (Object noUpdataFiel : noupdateFields) {
                        if (this.rowMeta.getFieldIndex(noUpdataFiel.toString(), false) < 0) continue;
                        copyRowVals[this.rowMeta.getFieldIndex((String)noUpdataFiel.toString())] = this.getDefaultVal(row, this.rowMeta, noUpdataFiel.toString());
                    }
                }
                BigDecimal totalAdjAmt = BigDecimal.ZERO;
                for (int i = 0; i < indexData.size(); ++i) {
                    String subEntryField = indexData.get(i).toString().replace("ddiff", "diff");
                    if ("costelement".equals(subEntryField) || "costsubelement".equals(subEntryField)) continue;
                    subEntryField = subEntryField.replace("_id", "");
                    subEntryField = subEntryField.replace("sub_adjustamt", "adjustamt");
                    Object value = values.get(i);
                    if ("id".equals(subEntryField)) {
                        copyRowVals[this.rowMeta.getFieldIndex((String)"entryid")] = value == null ? Long.valueOf(0L) : value;
                        continue;
                    }
                    if ("adjustamt".equals(subEntryField)) {
                        if (srcFields.contains("costdiff" + this.perQtyType)) {
                            Object object = copyRowVals[this.rowMeta.getFieldIndex((String)new StringBuilder().append((String)"costdiff").append((String)this.perQtyType).toString())] = value == null ? BigDecimal.ZERO : value;
                        }
                        if (srcFields.contains("actualcost" + this.perQtyType)) {
                            Object object = copyRowVals[this.rowMeta.getFieldIndex((String)new StringBuilder().append((String)"actualcost").append((String)this.perQtyType).toString())] = value == null ? BigDecimal.ZERO : value;
                        }
                        if (srcFields.contains("standardcost" + this.perQtyType)) {
                            Object object = copyRowVals[this.rowMeta.getFieldIndex((String)new StringBuilder().append((String)"standardcost").append((String)this.perQtyType).toString())] = value == null ? BigDecimal.ZERO : value;
                        }
                        if (value == null) continue;
                        totalAdjAmt = totalAdjAmt.add(new BigDecimal(value.toString()));
                        continue;
                    }
                    if (srcFields.contains(subEntryField)) {
                        copyRowVals[this.rowMeta.getFieldIndex((String)subEntryField)] = value == null ? Long.valueOf(0L) : value;
                        continue;
                    }
                    if (!srcFields.contains(subEntryField + this.perQtyType)) continue;
                    copyRowVals[this.rowMeta.getFieldIndex((String)new StringBuilder().append((String)subEntryField).append((String)this.perQtyType).toString())] = value == null ? BigDecimal.ZERO : value;
                }
                if (srcFields.contains("costdiff" + this.perQtyType)) {
                    copyRowVals[this.rowMeta.getFieldIndex((String)new StringBuilder().append((String)"costdiff").append((String)this.perQtyType).toString())] = totalAdjAmt;
                }
                collector.collect(copyRowVals);
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private Object[] copyRow(Row row, RowMeta rowMeta) {
        Object[] currRowVals = new Object[rowMeta.getFieldCount()];
        for (int index = 0; index < rowMeta.getFieldCount(); ++index) {
            currRowVals[index] = "noupdatecalfields".equals(rowMeta.getFieldName(index)) ? " " : ("subentryentityjson".equals(rowMeta.getFieldName(index)) ? " " : row.get(index));
        }
        return currRowVals;
    }

    private Object getDefaultVal(Row row, RowMeta rowMeta, String fieldAlias) {
        int index = rowMeta.getFieldIndex(fieldAlias);
        Object value = row.get(index);
        if (rowMeta.getDataType(index).equals((Object)DataType.BigDecimalType)) {
            value = BigDecimal.ZERO;
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.StringType)) {
            value = " ";
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.LongType)) {
            value = 0L;
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.IntegerType)) {
            value = 0;
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.BooleanType)) {
            value = Boolean.FALSE;
        }
        return value;
    }
}

