/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.biz.balance.model.IDataTransform;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.fi.cal.business.balance.StdCostDiffBillJsonReduceFunction;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;

public class StdCostDiffBillJsonToRowTransform
implements IDataTransform {
    private String perQtyType = "_in";

    public StdCostDiffBillJsonToRowTransform(String perQtyType) {
        if (!"2".equals(perQtyType)) {
            this.perQtyType = "_out";
        }
    }

    public DataSet doTransform(DataSet srcData) {
        if (srcData != null) {
            String jsonDealModel;
            RowMeta rowMeta = srcData.getRowMeta();
            HashSet<String> srcFields = new HashSet<String>(16);
            for (String field : rowMeta.getFieldNames()) {
                srcFields.add(field);
            }
            if (srcFields.contains("costsubelement")) {
                rowMeta.getField("costsubelement").setDataType((DataType)DataType.LongType);
            }
            if (srcFields.contains("costelement")) {
                rowMeta.getField("costelement").setDataType((DataType)DataType.LongType);
            }
            TXHandle handler = TX.requiresNew();
            Object object = null;
            try {
                jsonDealModel = CalDbParamServiceHelper.getString((String)CalDbParamConstant.STDCOSTDIFF_JSON_DEALMODEL, null);
            }
            catch (Throwable field) {
                object = field;
                throw field;
            }
            finally {
                if (handler != null) {
                    if (object != null) {
                        try {
                            handler.close();
                        }
                        catch (Throwable field) {
                            ((Throwable)object).addSuppressed(field);
                        }
                    } else {
                        handler.close();
                    }
                }
            }
            if ("A".equals(jsonDealModel)) {
                DataSetBuilder dataBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
                for (Row row : srcData) {
                    String jsonData = row.getString("subentryentityjson");
                    JSONObject jsonObject = JSON.parseObject((String)jsonData);
                    JSONArray valuesData = jsonObject.getJSONArray("data");
                    JSONArray indexData = jsonObject.getJSONArray("index");
                    String noUpdateCalStr = row.getString("noupdatecalfields");
                    JSONObject noUpdateCalJsonObject = JSON.parseObject((String)noUpdateCalStr);
                    JSONArray noupdateFields = null;
                    if (noUpdateCalJsonObject != null) {
                        noupdateFields = noUpdateCalJsonObject.getJSONArray("setnull");
                    }
                    for (int index = 0; index < valuesData.size(); ++index) {
                        JSONArray values = valuesData.getJSONArray(index);
                        Object[] copyRowVals = this.copyRow(row, rowMeta);
                        if (noupdateFields != null) {
                            for (Object noUpdataFiel : noupdateFields) {
                                if (rowMeta.getFieldIndex(noUpdataFiel.toString(), false) < 0) continue;
                                copyRowVals[rowMeta.getFieldIndex((String)noUpdataFiel.toString())] = this.getDefaultVal(row, rowMeta, noUpdataFiel.toString());
                            }
                        }
                        BigDecimal totalAdjAmt = BigDecimal.ZERO;
                        for (int i = 0; i < indexData.size(); ++i) {
                            String subEntryField = indexData.get(i).toString().replace("ddiff", "diff");
                            if ("costelement".equals(subEntryField) || "costsubelement".equals(subEntryField)) continue;
                            subEntryField = subEntryField.replace("_id", "");
                            subEntryField = subEntryField.replace("sub_adjustamt", "adjustamt");
                            Object value = values.get(i);
                            if ("id".equals(subEntryField)) {
                                copyRowVals[rowMeta.getFieldIndex((String)"entryid")] = value == null ? Long.valueOf(0L) : value;
                                continue;
                            }
                            if ("adjustamt".equals(subEntryField)) {
                                if (srcFields.contains("costdiff" + this.perQtyType)) {
                                    Object object2 = copyRowVals[rowMeta.getFieldIndex((String)new StringBuilder().append((String)"costdiff").append((String)this.perQtyType).toString())] = value == null ? BigDecimal.ZERO : value;
                                }
                                if (srcFields.contains("actualcost" + this.perQtyType)) {
                                    Object object3 = copyRowVals[rowMeta.getFieldIndex((String)new StringBuilder().append((String)"actualcost").append((String)this.perQtyType).toString())] = value == null ? BigDecimal.ZERO : value;
                                }
                                if (srcFields.contains("standardcost" + this.perQtyType)) {
                                    Object object4 = copyRowVals[rowMeta.getFieldIndex((String)new StringBuilder().append((String)"standardcost").append((String)this.perQtyType).toString())] = value == null ? BigDecimal.ZERO : value;
                                }
                                if (value == null) continue;
                                totalAdjAmt = totalAdjAmt.add(new BigDecimal(value.toString()));
                                continue;
                            }
                            if (srcFields.contains(subEntryField)) {
                                copyRowVals[rowMeta.getFieldIndex((String)subEntryField)] = value == null ? Long.valueOf(0L) : value;
                                continue;
                            }
                            if (!srcFields.contains(subEntryField + this.perQtyType)) continue;
                            copyRowVals[rowMeta.getFieldIndex((String)new StringBuilder().append((String)subEntryField).append((String)this.perQtyType).toString())] = value == null ? BigDecimal.ZERO : value;
                        }
                        if (srcFields.contains("costdiff" + this.perQtyType)) {
                            copyRowVals[rowMeta.getFieldIndex((String)new StringBuilder().append((String)"costdiff").append((String)this.perQtyType).toString())] = totalAdjAmt;
                        }
                        dataBuilder.append(copyRowVals);
                    }
                }
                srcData = dataBuilder.build();
                return srcData;
            }
            srcData = srcData.groupBy(new String[]{"billid"}).reduceGroup((ReduceGroupFunctionWithCollector)new StdCostDiffBillJsonReduceFunction(srcData.getRowMeta(), this.perQtyType));
            return srcData;
        }
        return srcData;
    }

    private Object[] copyRow(Row row, RowMeta rowMeta) {
        Object[] currRowVals = new Object[rowMeta.getFieldCount()];
        for (int index = 0; index < rowMeta.getFieldCount(); ++index) {
            currRowVals[index] = "noupdatecalfields".equals(rowMeta.getFieldName(index)) ? " " : ("subentryentityjson".equals(rowMeta.getFieldName(index)) ? " " : row.get(index));
        }
        return currRowVals;
    }

    private Object getDefaultVal(Row row, RowMeta rowMeta, String fieldAlias) {
        int index = rowMeta.getFieldIndex(fieldAlias);
        Object value = row.get(index);
        if (rowMeta.getDataType(index).equals((Object)DataType.BigDecimalType)) {
            value = BigDecimal.ZERO;
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.StringType)) {
            value = " ";
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.LongType)) {
            value = 0L;
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.IntegerType)) {
            value = 0;
        }
        if (rowMeta.getDataType(index).equals((Object)DataType.BooleanType)) {
            value = Boolean.FALSE;
        }
        return value;
    }
}

