/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance.recal;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.biz.balance.engine.BalanceUpdateManager;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.fi.cal.business.balance.recal.CalBalReCalCache;

abstract class AbstractReCalComsumer {
    private int direction = 1;
    private int fixBatch = 0;
    private int dyBatch = 500;
    private static final int MIN_BATCH = 500;
    private int batchStep = 400;
    private long batchTime = Integer.MAX_VALUE;
    private int total = 100;
    private int overCount = 0;
    private StringBuilder log = new StringBuilder();
    private int logSize = 0;
    private Long taskId;
    private AtomicInteger succesCount;
    protected StringBuilder errorMsg;

    public Long getTaskId() {
        return this.taskId;
    }

    protected void setTotal(int total) {
        if (total > 0) {
            this.total = total;
        }
    }

    public AbstractReCalComsumer(Long taskId) {
        this.taskId = taskId;
        this.fixBatch = CalBalReCalCache.getBatchCount();
        this.succesCount = new AtomicInteger(0);
    }

    public StringBuilder getErrorMsg() {
        return this.errorMsg == null ? new StringBuilder() : this.errorMsg;
    }

    abstract void doUpdate();

    protected void batchUpdate(Set<Object> ids, UpdateRule rule) {
        long t = System.currentTimeMillis();
        try (TXHandle tx = TX.requiresNew();){
            BalanceUpdateManager.doReUpdate(ids, (UpdateRule)rule);
        }
        int size = ids.size();
        this.succesCount.addAndGet(size);
        this.updateBatchCount(size, t -= System.currentTimeMillis());
    }

    private void updateBatchCount(int size, long t) {
        if (this.fixBatch >= 500 || size != this.dyBatch) {
            return;
        }
        long pt = t * (long)this.dyBatch / (long)size;
        if (pt > this.batchTime) {
            this.direction *= -1;
        }
        this.batchTime = pt;
        this.dyBatch += this.batchStep * this.direction;
        int n = this.dyBatch = this.dyBatch > 500 ? this.dyBatch : 500;
        if (this.dyBatch == 500) {
            this.direction = 1;
        }
    }

    protected int getBatch() {
        return this.fixBatch >= 500 ? this.fixBatch : this.dyBatch;
    }

    public int getSuccesCount() {
        return this.succesCount.get();
    }

    protected void addPercent(int percent, String msg) {
        if (this.logSize > 2000) {
            this.log.setLength(0);
            this.logSize = 0;
        }
        this.log.append("\r\n").append(percent).append("%-").append(msg);
        ++this.logSize;
        CalBalReCalCache.setTaskPercent(this.getTaskId(), percent, this.log.toString());
    }

    protected void addOverCount() {
        ++this.overCount;
    }

    protected void addPercent(String msg) {
        int percent = this.overCount * 100 / this.total;
        percent = percent >= 100 ? 99 : percent;
        this.addPercent(percent, msg);
    }
}

