/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance.recal;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.balance.recal.CalBalReCalCache;
import kd.fi.cal.business.balance.recal.CalBalRecalHandle;
import kd.fi.cal.business.balance.recal.ExceptionUtil;
import kd.fi.cal.business.balance.recal.ReCalMonitorLog;
import kd.fi.cal.business.balance.recal.TaskResult;

public class BalUpdateTask
implements Callable<TaskResult> {
    private QFilter msgFs;
    private List<UpdateRule> rules;
    private Date start;
    private boolean following;
    private int batchCount = 3000;
    private AtomicInteger taskNo = new AtomicInteger(1000000);
    private AtomicInteger msgCount = new AtomicInteger(0);
    private String parentTaskId;
    private Long costAccountId;

    public BalUpdateTask(List<UpdateRule> rules, Long costAccountId, QFilter msgFs) {
        this.msgFs = msgFs;
        this.rules = rules;
        this.costAccountId = costAccountId;
        this.batchCount = CalBalReCalCache.getBatchCount();
    }

    public void setfollowing(boolean following) {
        this.following = following;
    }

    public boolean isFollowing() {
        return this.following;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public void setParentTaskId(int parentTaskId) {
        this.parentTaskId = parentTaskId + "-";
    }

    private Map<String, Long> getRuleStartId() {
        if (!this.isFollowing()) {
            return new HashMap<String, Long>();
        }
        ArrayList<String> ids = new ArrayList<String>(this.rules.size());
        for (UpdateRule rule : this.rules) {
            ids.add(rule.getId());
        }
        QFilter fs = new QFilter("rule", "in", ids).and("status", "=", (Object)"A");
        return CalBalRecalHandle.queryLastIds(fs);
    }

    private long getMinStartId(Map<String, Long> ruleStartId, List<UpdateRule> groupRules) {
        long minId = Long.MAX_VALUE;
        for (UpdateRule rule : groupRules) {
            Long id = ruleStartId.get(rule.getId());
            if (id == null) {
                return 0L;
            }
            minId = id < minId ? id : minId;
        }
        return minId;
    }

    private void updateRuleGroup(MessagePublisher pub, Map<String, Long> startIds, String costAccounCol, List<UpdateRule> groupRules) {
        QFilter fs = new QFilter(costAccounCol, "=", (Object)this.costAccountId);
        Long fromId = this.getMinStartId(startIds, groupRules);
        if (fromId > 0L) {
            fs.and("id", ">", (Object)fromId);
        }
        fs.and(this.msgFs);
        String billName = groupRules.get(0).getEntityNumber();
        try (DataSet billIds = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.balance.recal.BalUpdateTask.updateRuleGroup", (String)billName, (String)"id", (QFilter[])fs.toArray(), (String)"id asc");){
            long startId = -1L;
            long endId = -1L;
            ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(this.batchCount);
            int index = 0;
            for (Row row : billIds) {
                endId = index == 0 ? (startId = row.getLong("id").longValue()) : row.getLong("id");
                if (++index >= this.batchCount) {
                    this.addLogs(startId, endId, logs, startIds, groupRules);
                    index = 0;
                }
                if (logs.size() < this.batchCount) continue;
                this.batchPublish(logs, pub);
                logs.clear();
            }
            if (index != 0) {
                this.addLogs(startId, endId, logs, startIds, groupRules);
            }
            if (!logs.isEmpty()) {
                this.batchPublish(logs, pub);
            }
            this.saveReCalpoint(endId, groupRules);
        }
    }

    private Map<String, Map<String, List<UpdateRule>>> groupRules() {
        HashMap<String, Map<String, List<UpdateRule>>> groups = new HashMap<String, Map<String, List<UpdateRule>>>(this.rules.size());
        String orgCol = null;
        for (UpdateRule rule : this.rules) {
            ArrayList<UpdateRule> rs;
            String bill = rule.getEntityNumber();
            HashMap<String, ArrayList<UpdateRule>> orgGroups = (HashMap<String, ArrayList<UpdateRule>>)groups.get(bill);
            if (orgGroups == null) {
                orgGroups = new HashMap<String, ArrayList<UpdateRule>>(4);
                groups.put(bill, orgGroups);
            }
            if ((rs = (ArrayList<UpdateRule>)orgGroups.get(orgCol = (String)rule.getSrcColFullNameMap().get(rule.getTargetSrcColMap().get("costaccount")))) == null) {
                rs = new ArrayList<UpdateRule>(this.rules.size());
                orgGroups.put(orgCol, rs);
            }
            rs.add(rule);
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult call() throws Exception {
        MessagePublisher pub = MQFactory.get().createSimplePublisher("fi", "fi.cal.recal_queue");
        Object billIds = null;
        try {
            Map<String, Long> startIds = this.getRuleStartId();
            Map<String, Map<String, List<UpdateRule>>> groupRules = this.groupRules();
            Map<String, List<UpdateRule>> orgRules = null;
            for (Map.Entry<String, Map<String, List<UpdateRule>>> billRules : groupRules.entrySet()) {
                orgRules = billRules.getValue();
                for (Map.Entry<String, List<UpdateRule>> entry : orgRules.entrySet()) {
                    this.updateRuleGroup(pub, startIds, entry.getKey(), entry.getValue());
                }
            }
            TaskResult taskResult = new TaskResult(this.costAccountId, this.msgCount.get());
            return taskResult;
        }
        catch (Exception e) {
            TaskResult result = new TaskResult(this.costAccountId, this.msgCount.get());
            result.setError(ExceptionUtil.parseMsg(e, 2000));
            TaskResult taskResult = result;
            return taskResult;
        }
        finally {
            pub.close();
            if (billIds != null) {
                billIds.close();
            }
        }
    }

    private void saveReCalpoint(long endId, List<UpdateRule> groupRules) {
        if (endId > 0L && this.isFollowing()) {
            try {
                int size = groupRules.size();
                DynamicObject point = null;
                DynamicObject[] points = new DynamicObject[size];
                for (int i = 0; i < size; ++i) {
                    point = BusinessDataServiceHelper.newDynamicObject((String)"cal_recal_point");
                    point.set("createtime", (Object)this.start);
                    point.set("rule", (Object)groupRules.get(i).getId());
                    point.set("costaccount", (Object)this.costAccountId);
                    point.set("endid", (Object)endId);
                    point.set("status", (Object)"B");
                    points[i] = point;
                }
                SaveServiceHelper.save((DynamicObject[])points);
            }
            catch (Exception e) {
                ReCalMonitorLog.error(ResManager.loadKDString((String)"\u4fdd\u5b58\u91cd\u7b97\u8282\u70b9", (String)"BalUpdateTask_0", (String)"fi-cal-business", (Object[])new Object[0]), e);
            }
        }
    }

    private void addLogs(long startId, long endId, List<DynamicObject> logs, Map<String, Long> startIds, List<UpdateRule> groupRules) {
        Long fixedStartId = null;
        DynamicObject log = null;
        for (UpdateRule rule : groupRules) {
            fixedStartId = startIds.get(rule.getId());
            fixedStartId = fixedStartId == null ? Long.valueOf(0L) : fixedStartId;
            long l = startId = fixedStartId <= startId ? startId : fixedStartId;
            if (startId > endId) continue;
            QFilter fs = new QFilter("id", ">=", (Object)startId).and("id", "<=", (Object)endId).and(this.msgFs);
            fs.and((String)rule.getSrcColFullNameMap().get(rule.getTargetSrcColMap().get("costaccount")), "=", (Object)this.costAccountId);
            log = BusinessDataServiceHelper.newDynamicObject((String)"cal_recal_msg");
            logs.add(log);
            log.set("taskno", (Object)(this.parentTaskId + this.taskNo.addAndGet(1)));
            log.set("startid", (Object)fixedStartId);
            log.set("status", (Object)"C");
            log.set("rule", (Object)rule.getId());
            log.set("start", (Object)this.start);
            log.set("billname", (Object)rule.getEntityNumber());
            log.set("billfs", (Object)fs.toSerializedString());
            log.set("billfs_view", (Object)fs.toString());
        }
    }

    private void batchPublish(List<DynamicObject> logs, MessagePublisher pub) {
        int size = logs.size();
        long[] ids = DB.genGlobalLongIds((int)size);
        DynamicObject[] logArrr = new DynamicObject[size];
        ArrayList<JSONObject> pubs = new ArrayList<JSONObject>(size);
        JSONObject p = null;
        for (int i = 0; i < size; ++i) {
            logs.get(i).set("id", (Object)ids[i]);
            logArrr[i] = logs.get(i);
            p = new JSONObject(1);
            p.put("taskid", (Object)ids[i]);
            pubs.add(p);
        }
        SaveServiceHelper.save((DynamicObject[])logArrr);
        for (JSONObject msg : pubs) {
            pub.publish(msg.toJSONString());
            this.msgCount.incrementAndGet();
        }
    }
}

