/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance.recal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.biz.balance.engine.BalanceUpdateManager;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.UpdateCtx;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cal.business.balance.recal.CalBalReCalCache;
import kd.fi.cal.common.helper.PeriodHelper;
import org.apache.commons.lang3.StringUtils;

public class CalBalReCalByMatHandle {
    private final String[] balTBs;
    private int period;
    private Set<Long> matIds;
    private List<Long> costAccountIds;
    private Set<String> lotNums = new HashSet<String>(16);
    private int batch;

    public CalBalReCalByMatHandle(String[] balTBs, List<Long> costAccountIds, int period, Set<Long> matIds) {
        this.balTBs = balTBs;
        this.costAccountIds = costAccountIds;
        this.period = period;
        this.matIds = matIds;
    }

    public void handle() {
        StringBuilder log = new StringBuilder();
        log.append(TimeServiceHelper.formatUserNow()).append("-0%\uff1astart").append("\r\n");
        CalBalReCalCache.setReCalPercent(0, log.toString());
        for (String balTB : this.balTBs) {
            BalanceTB balanceTB = BalanceTB.getBalanceTB((String)balTB);
            log.append(TimeServiceHelper.formatUserNow()).append("-1%\uff1aexplain bal table-").append(balTB).append("\r\n");
            CalBalReCalCache.setReCalPercent(1, log.toString());
            try (TXHandle tx = TX.requiresNew((String)"kd.fi.cal.business.balance.recal.CalBalRecalHandle.reCalByMat");){
                try {
                    this.deleteSp(balanceTB, balanceTB.getSnapshotTb());
                    log.append(TimeServiceHelper.formatUserNow()).append("-5%\uff1adelete snap\r\n");
                    this.deleteSp(balanceTB, balanceTB.getTmpSnapshotTb());
                    log.append(TimeServiceHelper.formatUserNow()).append("-10%\uff1adelete tmp snap\r\n");
                    CalBalReCalCache.setReCalPercent(10, log.toString());
                    this.deleteBal(balanceTB);
                    log.append(TimeServiceHelper.formatUserNow()).append("-30%\uff1adelete bal\r\n");
                    CalBalReCalCache.setReCalPercent(30, log.toString());
                    this.updateLastEndPeriod(balanceTB);
                    log.append(TimeServiceHelper.formatUserNow()).append("-50%\uff1aupdatePeriod\r\n");
                    CalBalReCalCache.setReCalPercent(50, log.toString());
                }
                catch (Exception e) {
                    tx.markRollback();
                    log.append(TimeServiceHelper.formatUserNow()).append("-100%\uff1aerror\r\n");
                    log.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)e)).append("\r\n");
                    CalBalReCalCache.setReCalPercent(100, log.toString());
                    if (tx != null) {
                        if (var8_16 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var8_16.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                    return;
                }
            }
        }
        DataSet unionDataSet = this.getBillDs();
        HashMap<String, Set> entityBillIdsMap = new HashMap<String, Set>(16);
        for (Object row : unionDataSet) {
            Set set = entityBillIdsMap.computeIfAbsent(row.getString("entity"), k -> new HashSet(16));
            set.add(row.getLong("id"));
        }
        int size = 1000;
        size = this.batch >= 1000 ? this.batch : size;
        try {
            for (Map.Entry entry : entityBillIdsMap.entrySet()) {
                Lists.partition(new ArrayList((Collection)entry.getValue()), (int)size).forEach(list -> {
                    try (TXHandle txHandle = TX.requiresNew();){
                        BalanceUpdateManager.doUpdate((UpdateCtx)new UpdateCtx("audit", (String)entry.getKey(), new HashSet(list)));
                        BalanceUpdateManager.doUpdate((UpdateCtx)new UpdateCtx("updatebal", (String)entry.getKey(), new HashSet(list)));
                    }
                });
            }
            log.append(TimeServiceHelper.formatUserNow()).append("-100%\uff1afinish\r\n");
            CalBalReCalCache.setReCalPercent(100, log.toString());
        }
        catch (Throwable e) {
            log.append(TimeServiceHelper.formatUserNow()).append("-100%\uff1aerror\r\n");
            log.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(e))).append("\r\n");
            CalBalReCalCache.setReCalPercent(100, log.toString());
            return;
        }
    }

    private DataSet getBillDs() {
        Date minDate = null;
        for (Long costAccountId : this.costAccountIds) {
            int year = this.period / 100;
            int month = this.period % 100;
            DynamicObject periodDyc = PeriodHelper.getPeriodByYearMonth((long)costAccountId, null, (int)year, (int)month);
            if (periodDyc == null) continue;
            Date beginDate = periodDyc.getDate("beginDate");
            if (minDate != null) continue;
            minDate = beginDate;
        }
        ArrayList<OrmInput> billIOs = new ArrayList<OrmInput>(16);
        QFilter commonFilter = new QFilter("costaccount", "in", this.costAccountIds);
        commonFilter.and("billstatus", "=", (Object)"C");
        QFilter startDateFilter = null;
        if (minDate != null) {
            startDateFilter = new QFilter("bookdate", ">=", minDate);
            commonFilter.and(startDateFilter);
        }
        QFilter recMatFilter = new QFilter("entry.material", "in", this.matIds);
        QFilter recLotFilter = null;
        if (this.lotNums.size() > 0) {
            recLotFilter = new QFilter("entry.lot", "in", this.lotNums);
        }
        String format = "'%s' as entity, id";
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("entity", (DataType)DataType.StringType), new Field("id", (DataType)DataType.LongType)});
        OrmInput recOI = new OrmInput(this.getClass().getName(), "cal_costrecord_subentity", String.format(format, "cal_costrecord_subentity"), new QFilter[]{commonFilter, recMatFilter, recLotFilter}, rowMeta);
        QFilter adjMatFilter = new QFilter("entryentity.material", "in", this.matIds);
        QFilter adjLotFilter = null;
        if (this.lotNums.size() > 0) {
            adjLotFilter = new QFilter("entryentity.lot", "in", this.lotNums);
        }
        OrmInput adjOI = new OrmInput(this.getClass().getName(), "cal_costadjust_subentity", String.format(format, "cal_costadjust_subentity"), new QFilter[]{commonFilter, adjMatFilter, adjLotFilter}, rowMeta);
        OrmInput initOI = new OrmInput(this.getClass().getName(), "cal_initbill", String.format(format, "cal_initbill"), new QFilter[]{commonFilter, adjMatFilter, adjLotFilter}, rowMeta);
        billIOs.add(recOI);
        billIOs.add(adjOI);
        if (this.period == 0) {
            billIOs.add(initOI);
        }
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSet unionDataSet = algo.createDataSet((Input[])billIOs.toArray(new OrmInput[billIOs.size()]));
        return unionDataSet;
    }

    private void updateLastEndPeriod(BalanceTB tb) {
        String costAccount = (String)tb.getColFieldMap().get("costaccount");
        String matField = (String)tb.getColFieldMap().get("material");
        String lotField = (String)tb.getColFieldMap().get("lot");
        String periodCol = tb.getPeriodCol();
        SqlBuilder updatePeriodSql = new SqlBuilder();
        updatePeriodSql.append("update ", new Object[0]).append(tb.getTb(), new Object[0]);
        updatePeriodSql.append(" set fendperiod = 999999 ", new Object[0]);
        updatePeriodSql.append(" WHERE ", new Object[0]);
        updatePeriodSql.appendIn(costAccount, this.costAccountIds.toArray());
        updatePeriodSql.append(" AND ", new Object[0]);
        updatePeriodSql.appendIn(matField, this.matIds.toArray());
        if (this.lotNums.size() > 0) {
            updatePeriodSql.append(" AND ", new Object[0]);
            updatePeriodSql.appendIn(lotField, this.lotNums.toArray());
        }
        if (this.period > 0 && StringUtils.isNotBlank((CharSequence)periodCol)) {
            updatePeriodSql.append(" AND ", new Object[0]);
            updatePeriodSql.append(" fendperiod >= ? ", new Object[]{this.period});
        }
        DB.execute((DBRoute)tb.getDbRoute(), (SqlBuilder)updatePeriodSql);
    }

    private void deleteBal(BalanceTB tb) {
        String costAccount = (String)tb.getColFieldMap().get("costaccount");
        String matField = (String)tb.getColFieldMap().get("material");
        String lotField = (String)tb.getColFieldMap().get("lot");
        String periodCol = tb.getPeriodCol();
        String periodAlias = (String)tb.getColFieldMap().get(periodCol);
        TreeSet<String> tbExts = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.equals(o2)) {
                    return 0;
                }
                return StringUtils.isBlank((CharSequence)o1) ? 1 : -1;
            }
        });
        tbExts.addAll(tb.getColTbMap().values());
        for (String tbExt : tbExts) {
            SqlBuilder balSql = new SqlBuilder();
            balSql.append("DELETE FROM", new Object[0]);
            balSql.append(tb.getTb() + tbExt, new Object[0]);
            balSql.append(" WHERE ", new Object[0]);
            balSql.appendIn(costAccount, this.costAccountIds.toArray());
            balSql.append(" AND ", new Object[0]);
            balSql.appendIn(matField, this.matIds.toArray());
            if (this.lotNums.size() > 0) {
                balSql.append(" AND ", new Object[0]);
                balSql.appendIn(lotField, this.lotNums.toArray());
            }
            if (this.period > 0 && StringUtils.isNotBlank((CharSequence)periodCol)) {
                balSql.append(" AND ", new Object[0]);
                balSql.append(periodAlias, new Object[0]).append(" >= ? ", new Object[]{this.period});
            }
            DB.execute((DBRoute)tb.getDbRoute(), (SqlBuilder)balSql);
        }
    }

    private void deleteSp(BalanceTB tb, String snapshotTb) {
        int batch = 100000;
        DataSet balDs = this.getBalDs(tb);
        HashSet<String> keyCols = new HashSet<String>(16);
        for (Row row : balDs) {
            String keyCol = row.getString("fkeycol");
            keyCols.add(keyCol);
            if (keyCols.size() <= batch) continue;
            this.deleteSpByBatch(tb, snapshotTb, keyCols);
            keyCols = new HashSet(16);
        }
        this.deleteSpByBatch(tb, snapshotTb, keyCols);
    }

    private void deleteSpByBatch(BalanceTB tb, String snapshotTb, Set<String> keyCols) {
        if (keyCols.isEmpty()) {
            return;
        }
        String periodCol = tb.getPeriodCol();
        String periodAlias = (String)tb.getColFieldMap().get(periodCol);
        SqlBuilder spSql = new SqlBuilder();
        spSql.append("DELETE FROM ", new Object[0]).append(snapshotTb, new Object[0]);
        spSql.append(" WHERE ", new Object[0]).appendIn("fkeycol", keyCols.toArray());
        spSql.append(" AND ", new Object[0]).append(periodAlias, new Object[0]).append(" >= ? ", new Object[]{this.period});
        DB.execute((DBRoute)tb.getDbRoute(), (SqlBuilder)spSql);
    }

    private DataSet getBalDs(BalanceTB tb) {
        String costAccount = (String)tb.getColFieldMap().get("costaccount");
        String matField = (String)tb.getColFieldMap().get("material");
        String lotField = (String)tb.getColFieldMap().get("lot");
        String periodCol = tb.getPeriodCol();
        String periodAlias = (String)tb.getColFieldMap().get(periodCol);
        SqlBuilder balSql = new SqlBuilder();
        balSql.append("SELECT ", new Object[0]).append("fkeycol", new Object[0]);
        balSql.append(" FROM ", new Object[0]).append(tb.getTb(), new Object[0]);
        balSql.append(" WHERE ", new Object[0]);
        balSql.appendIn(costAccount, this.costAccountIds.toArray());
        balSql.append(" AND ", new Object[0]);
        balSql.appendIn(matField, this.matIds.toArray());
        if (this.lotNums.size() > 0) {
            balSql.append(" AND ", new Object[0]);
            balSql.appendIn(lotField, this.lotNums.toArray());
        }
        if (this.period > 0 && StringUtils.isNotBlank((CharSequence)periodCol)) {
            balSql.append(" AND ", new Object[0]);
            balSql.append(periodAlias, new Object[0]).append(" >= ? ", new Object[]{this.period});
        }
        DataSet balDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)tb.getDbRoute(), (SqlBuilder)balSql);
        return balDs;
    }

    public void setLotNums(Set<String> lotNums) {
        this.lotNums = lotNums;
    }

    public void setBatch(int batch) {
        this.batch = batch;
    }

    public int getBatch() {
        return this.batch;
    }
}

