/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance.recal;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.engine.BalanceUpdateManager;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.IRuleFilter;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.balance.BizDataType;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.balance.BalanceRuleCacheUtils;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cal.business.balance.recal.BalUpdateTask;
import kd.fi.cal.business.balance.recal.CalBalReCalCache;
import kd.fi.cal.business.balance.recal.ExceptionUtil;
import kd.fi.cal.business.balance.recal.TaskResult;
import kd.fi.cal.business.balance.recal.UpdatePointStatusTask;
import kd.fi.cal.common.helper.StopSyncSettingModifyHelper;
import org.apache.commons.lang3.StringUtils;

public class CalBalRecalHandle {
    private static ExecutorService ser = ThreadPools.newExecutorService((String)"cal_recal_handle", (int)8);
    private static final String PERIOD_UPDATED = "cal_period_updated";
    private static final String F_BILLSTATUS = "billstatus";
    private static final String F_COST_ACCOUNT = "costaccount";
    private static final String[] COLS = new String[]{"endid", "rule"};

    public static void periodSet0ByBalFs(String[] balTBs, List<Long> costAccountIds) {
        StringBuilder log = new StringBuilder();
        CalBalRecalHandle.set0ByByBalFs(log, balTBs, costAccountIds);
    }

    public static void periodClearByBalFs(String[] balTBs, List<Long> costAccountIds, int period) {
        StringBuilder log = new StringBuilder();
        CalBalRecalHandle.clearBalsByBalFs(log, balTBs, costAccountIds, period);
    }

    public static void periodChangeEngine(boolean isNew) {
        String sql = null;
        sql = isNew ? "insert into T_IM_INVDBPARAM(fid,forgid,fkey,fvalue) values (" + DB.genGlobalLongId() + ", 0 ,'" + PERIOD_UPDATED + "','1')" : "delete from T_IM_INVDBPARAM where fkey = 'cal_period_updated' ";
        DB.execute((DBRoute)new DBRoute("scm"), (String)sql);
        CalBalReCalCache.getCalAppCache().remove(PERIOD_UPDATED);
    }

    public static void clearSnapData(String[] balTBs) {
        StringBuilder log = new StringBuilder();
        try {
            CalBalRecalHandle.addPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6e05\u7406\u5df2\u56de\u6eda\u7684\u3002\u3002\u3002", (String)"CalBalRecalHandle_1", (String)"fi-cal-business", (Object[])new Object[0]), log);
            int total = 0;
            for (String tbStr : balTBs) {
                BalanceTB tb = BalanceTB.getBalanceTB((String)tbStr);
                CalBalRecalHandle.addPercent(total += 10, String.format(ResManager.loadKDString((String)"\u5df2\u52a0\u8f7d\u4f59\u989d\u8868\u3010%s\u3011\u4fe1\u606f\u3002\u3002\u3002", (String)"CalBalRecalHandle_2", (String)"fi-cal-business", (Object[])new Object[0]), tbStr), log);
                CalBalRecalHandle.clearSnapData(tb, null);
                CalBalRecalHandle.addPercent(total += 10, String.format(ResManager.loadKDString((String)"\u4f59\u989d\u8868\u3010%s\u3011\u4fe1\u606f\uff0c\u5df2\u56de\u6eda\u72b6\u6001\u5feb\u7167\u5df2\u6e05\u7406\u3002\u3002\u3002", (String)"CalBalRecalHandle_3", (String)"fi-cal-business", (Object[])new Object[0]), tbStr), log);
            }
            CalBalRecalHandle.addPercent(100, ResManager.loadKDString((String)"\u6e05\u7406\u5b8c\u6bd5\u3002\u3002", (String)"CalBalRecalHandle_4", (String)"fi-cal-business", (Object[])new Object[0]), log);
        }
        catch (Exception e) {
            log.append(CalBalRecalHandle.parseMsg(e, 2000));
            CalBalRecalHandle.addPercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5f02\u5e38\u3002\u3002\u3002", (String)"CalBalRecalHandle_0", (String)"fi-cal-business", (Object[])new Object[0]), log);
        }
    }

    public static void clearSnapData(BalanceTB tb, StringBuilder andStr) {
        String snapTb = tb.getSnapshotTb();
        StringBuilder sql = new StringBuilder("DELETE FROM ").append(snapTb);
        sql.append(" WHERE ").append("fstatus").append("='").append("B").append("' ");
        if (andStr != null) {
            sql.append((CharSequence)andStr);
        }
        DB.execute((DBRoute)tb.getDbRoute(), (String)sql.toString());
    }

    public static boolean reLoadPeriodBalFlag() {
        CalBalReCalCache.getCalAppCache().remove(PERIOD_UPDATED);
        return CalBalRecalHandle.isNewPeriodBal();
    }

    public static boolean isNewPeriodBal() {
        String tb = (String)CalBalReCalCache.getCalAppCache().get(PERIOD_UPDATED, String.class);
        boolean isNew = false;
        if (tb == null) {
            String sql = "select fid from T_IM_INVDBPARAM where fkey  = 'cal_period_updated'";
            try (DataSet data = DB.queryDataSet((String)"kd.scmc.im.business.balance.BalanceUpdateHandle.isNewPeriodBal", (DBRoute)new DBRoute("scm"), (String)sql);){
                isNew = data.hasNext();
            }
            tb = String.valueOf(isNew);
            CalBalReCalCache.getCalAppCache().put(PERIOD_UPDATED, (Object)tb);
        } else {
            isNew = "true".equalsIgnoreCase(tb);
        }
        return isNew;
    }

    public static void reCalByBillFs(Date start, String[] balTBs, QFilter fs, final String bill) {
        StringBuilder log = new StringBuilder();
        IRuleFilter filter = new IRuleFilter(){

            public boolean filter(UpdateRule rule) {
                return bill == null ? rule.isEnable() : bill.equals(rule.getEntityNumber()) && rule.isEnable();
            }
        };
        ArrayList<UpdateRule> rules = new ArrayList<UpdateRule>(64);
        for (String bal : balTBs) {
            rules.addAll(UpdateRuleCache.getUpdateRuleByBal((String)bal, (IRuleFilter)filter));
        }
        List<Long> accs = CalBalRecalHandle.getCostAccounts(bill, rules, fs);
        CalBalRecalHandle.doReCalByBatchId(log, start, accs, fs, false, rules);
    }

    private static void doReCalByBatchId(StringBuilder log, Date start, List<Long> accounts, QFilter fs, boolean isFollowing, List<UpdateRule> rules) {
        try {
            CalBalRecalHandle.addPercent(1, String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u91cd\u7b97\uff1a\u5df2\u52a0\u8f7d\u4f59\u989d\u89c4\u5219\u3010%1$s\u3011\u4e2a\uff0c\u9700\u8ba1\u7b97\u3010%2$s\u3011\u4e2a\u6210\u672c\u8d26\u7c3f\u3002\u3002\u3002", (String)"CalBalRecalHandle_5", (String)"fi-cal-business", (Object[])new Object[0]), rules.size(), accounts.size()), log);
            int total = accounts.size() * 2;
            total = total == 0 ? 100 : total;
            ArrayList<BalUpdateTask> tasks = new ArrayList<BalUpdateTask>(accounts.size());
            QFilter commonFs = new QFilter(F_BILLSTATUS, "=", (Object)"C");
            if (fs != null) {
                commonFs.and(fs);
                CalBalRecalHandle.addPercent(2, String.format(ResManager.loadKDString((String)"\u7ec4\u88c5\u90e8\u5206\u8fc7\u6ee4\u6761\u4ef6\uff1a%s\u3002\u3002\u3002", (String)"CalBalRecalHandle_6", (String)"fi-cal-business", (Object[])new Object[0]), fs.toString()), log);
            }
            int i = 100;
            int count = 0;
            for (Long accId : accounts) {
                BalUpdateTask task = new BalUpdateTask(rules, accId, commonFs);
                task.setStart(start);
                task.setParentTaskId(i++);
                task.setfollowing(isFollowing);
                tasks.add(task);
                ++count;
            }
            CalBalRecalHandle.addPercent(count, total, ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u521b\u5efa\u5b8c\u6bd5\uff0c\u7b49\u6548\u6d88\u606f\u53d1\u5e03\u3002\u3002\u3002", (String)"CalBalRecalHandle_7", (String)"fi-cal-business", (Object[])new Object[0]), log);
            List results = ser.invokeAll(tasks);
            int msgCount = 0;
            int successCount = 0;
            int faildCount = 0;
            for (Future result : results) {
                ++count;
                try {
                    TaskResult taskResult = (TaskResult)result.get();
                    msgCount += taskResult.getMsgCount();
                    CalBalRecalHandle.addPercent(count, total, taskResult.toString(), log);
                    if (taskResult.isSuccess()) {
                        ++successCount;
                        continue;
                    }
                    ++faildCount;
                }
                catch (Exception e) {
                    CalBalRecalHandle.addPercent(count, total, String.format(ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u6267\u884c\u5f02\u5e38\u3002\u3002\u3002\u65e5\u5fd7\uff1a%1$s", (String)"CalBalRecalHandle_8", (String)"fi-cal-business", (Object[])new Object[0]), CalBalRecalHandle.parseMsg(e, 2000)), log);
                    ++faildCount;
                }
            }
            CalBalRecalHandle.addPercent(100, String.format(ResManager.loadKDString((String)"\u91cd\u7b97\u4efb\u52a1\u53d1\u5e03\u5b8c\u6bd5\uff0c\u6210\u529f\u4efb\u52a1\u3010%1$s\u3011\u4e2a\uff0c\u5171\u53d1\u51fa\u91cd\u7b97\u6d88\u606f\u6570\u3010%2$s\u3011\u4e2a\uff0c\u5931\u8d25\u4efb\u52a1\u3010%3$s\u3011\u4e2a\u3002\u3002\u3002\u8bf7\u6839\u636e\u5f00\u59cb\u65e5\u671f\u67e5\u8be2\u6267\u884c\u8be6\u60c5", (String)"CalBalRecalHandle_9", (String)"fi-cal-business", (Object[])new Object[0]), successCount, msgCount, faildCount), log);
        }
        catch (Exception e) {
            log.append(CalBalRecalHandle.parseMsg(e, 2000));
            CalBalRecalHandle.addPercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5f02\u5e38\u3002\u3002\u3002", (String)"CalBalRecalHandle_0", (String)"fi-cal-business", (Object[])new Object[0]), log);
        }
    }

    private static List<Long> getCostAccounts(String bill, List<UpdateRule> rules, QFilter fs) {
        List<Long> accs = null;
        if (bill != null && fs != null) {
            HashSet cols = new HashSet(2);
            for (UpdateRule rule : rules) {
                cols.add(rule.getSrcColFullNameMap().get(rule.getTargetSrcColMap().get(F_COST_ACCOUNT)));
            }
            HashSet<Long> accIds = new HashSet<Long>();
            fs = new QFilter(F_BILLSTATUS, "=", (Object)"C").and(fs);
            DataSet idDatas = QueryServiceHelper.queryDataSet((String)"kd.scmc.im.business.balance.BalanceUpdateHandle.getCostAccounts", (String)bill, (String)String.join((CharSequence)",", cols), (QFilter[])fs.toArray(), null);
            for (Row row : idDatas) {
                for (String col : cols) {
                    accIds.add(row.getLong(col));
                }
            }
            accs = new ArrayList<Long>(accIds);
        } else {
            accs = CalBalRecalHandle.getAllCostAccs();
        }
        return accs;
    }

    public static void clearBals(String[] balTBs) {
        CalBalRecalHandle.clearBals(new StringBuilder(), balTBs);
    }

    private static void clearBals(StringBuilder log, String ... balTBs) {
        CalBalRecalHandle.clearBalsByBalFs(log, balTBs, null, -1);
    }

    public static void set0(String[] balTBs) {
        StringBuilder log = new StringBuilder();
        CalBalRecalHandle.setAll0(log, balTBs);
    }

    private static void setAll0(StringBuilder log, String[] balTBs) {
        CalBalRecalHandle.set0ByByBalFs(log, balTBs, null);
    }

    public static void periodReCal(Date start, String[] balTBs) {
        StringBuilder log = new StringBuilder();
        List<Long> allCostAccs = CalBalRecalHandle.getAllCostAccs();
        CalBalRecalHandle.doReCalByCostAccountGroup(start, log, allCostAccs, 0, balTBs);
    }

    private static List<Long> getAllCostAccs() {
        ArrayList<Long> costAccounts = new ArrayList<Long>(1024);
        try (DataSet ids = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.balance.recal.CalBalRecalHandle.periodReCal", (String)"cal_bd_costaccount", (String)"id", null, null);){
            for (Row row : ids) {
                costAccounts.add(row.getLong("id"));
            }
        }
        return costAccounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doReCalByCostAccountGroup(Date start, StringBuilder log, List<Long> costAccountIds, int startPeriod, String ... bals) {
        CalBalRecalHandle.addPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u91cd\u7b97\u4efb\u52a1\u3002\u3002\u3002", (String)"CalBalRecalHandle_10", (String)"fi-cal-business", (Object[])new Object[0]), log);
        try (MessagePublisher pub = null;){
            CalBalRecalHandle.addPercent(0, String.format(ResManager.loadKDString((String)"\u5df2\u52a0\u8f7d\u3010%s\u3011\u4e2a\u6210\u672c\u8d26\u7c3f\u3002\u3002\u3002", (String)"CalBalRecalHandle_11", (String)"fi-cal-business", (Object[])new Object[0]), costAccountIds.size()), log);
            CalBalReCalCache.setStartPeriod(start, startPeriod);
            int total = costAccountIds.size() * bals.length;
            total = total == 0 ? 100 : total;
            CalBalRecalHandle.addPercent(0, String.format(ResManager.loadKDString((String)"\u5171\u5206\u89e3\u51fa\u3010%s\u3011\u4e2a\u6d88\u606f\u4efb\u52a1\u3002\u3002\u3002", (String)"CalBalRecalHandle_12", (String)"fi-cal-business", (Object[])new Object[0]), total), log);
            pub = MQFactory.get().createSimplePublisher("fi", "fi.cal.recal_queue");
            int batch = 2048;
            ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(batch);
            DynamicObject task = null;
            long startNo = 1000000L;
            int count = 0;
            for (String bal : bals) {
                CalBalRecalHandle.addPercent(count + 1, total, String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4f59\u989d\u8868\u3010%s\u3002\u3002\u3002\u3011", (String)"CalBalRecalHandle_13", (String)"fi-cal-business", (Object[])new Object[0]), bal), log);
                for (Long costAccountId : costAccountIds) {
                    ++count;
                    task = BusinessDataServiceHelper.newDynamicObject((String)"cal_recal_msg");
                    task.set("bal", (Object)bal);
                    task.set(F_COST_ACCOUNT, (Object)costAccountId);
                    task.set("start", (Object)start);
                    task.set("status", (Object)"C");
                    task.set("taskno", (Object)(startNo + (long)count));
                    tasks.add(task);
                    if (tasks.size() < batch) continue;
                    CalBalRecalHandle.batchPublish(tasks, pub);
                    CalBalRecalHandle.addPercent(count, total, String.format(ResManager.loadKDString((String)"\u5df2\u6279\u91cf\u53d1\u9001\u3010%s\u3011\u6761\u4efb\u52a1\u6d88\u606f\u3002\u3002\u3002", (String)"CalBalRecalHandle_14", (String)"fi-cal-business", (Object[])new Object[0]), tasks.size()), log);
                    tasks.clear();
                }
            }
            if (!tasks.isEmpty()) {
                CalBalRecalHandle.batchPublish(tasks, pub);
                CalBalRecalHandle.addPercent(count, total, String.format(ResManager.loadKDString((String)"\u5df2\u6279\u91cf\u53d1\u9001\u3010%s\u3011\u6761\u4efb\u52a1\u6d88\u606f\u3002\u3002\u3002", (String)"CalBalRecalHandle_14", (String)"fi-cal-business", (Object[])new Object[0]), tasks.size()), log);
            }
            CalBalRecalHandle.addPercent(100, ResManager.loadKDString((String)"\u4efb\u52a1\u6d88\u606f\u5168\u90e8\u53d1\u9001\u5b8c\u6bd5\uff0c\u8bf7\u67e5\u770b\u6d88\u606f\u4efb\u52a1\u8fdb\u5ea6\u3002\u3002\u3002", (String)"CalBalRecalHandle_15", (String)"fi-cal-business", (Object[])new Object[0]), log);
        }
    }

    private static void batchPublish(List<DynamicObject> logs, MessagePublisher pub) {
        int size = logs.size();
        long[] ids = DB.genGlobalLongIds((int)size);
        DynamicObject[] logArrr = new DynamicObject[size];
        ArrayList<JSONObject> pubs = new ArrayList<JSONObject>(size);
        JSONObject p = null;
        for (int i = 0; i < size; ++i) {
            logs.get(i).set("id", (Object)ids[i]);
            logArrr[i] = logs.get(i);
            p = new JSONObject(1);
            p.put("taskid", (Object)ids[i]);
            pubs.add(p);
        }
        SaveServiceHelper.save((DynamicObject[])logArrr);
        for (JSONObject msg : pubs) {
            pub.publish(msg.toJSONString());
        }
    }

    private static List<Long> getCostAccounts() {
        return null;
    }

    public static void periodReCalByBalFs(Date start, String[] balTBs, List<Long> costAccountIds, int startPeriod) {
        StringBuilder log = new StringBuilder();
        if (costAccountIds.isEmpty()) {
            costAccountIds = CalBalRecalHandle.getCostAccounts();
        }
        CalBalRecalHandle.doReCalByCostAccountGroup(start, log, costAccountIds, startPeriod, balTBs);
    }

    private static void clearBalsByBalFs(StringBuilder log, String[] balTBs, List<Long> costAccountIds, int period) {
        try {
            int tatal = balTBs.length * 2;
            CalBalRecalHandle.addPercent(0, tatal, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4f59\u989d\u6e05\u7406\u3002\u3002\u3002", (String)"CalBalRecalHandle_16", (String)"fi-cal-business", (Object[])new Object[0]), log);
            QFilter fs = new QFilter("rule.balancetablenumber", "in", (Object)balTBs);
            if (costAccountIds != null) {
                fs.and(F_COST_ACCOUNT, "in", costAccountIds);
            }
            DeleteServiceHelper.delete((String)"cal_recal_point", (QFilter[])fs.toArray());
            CalBalRecalHandle.addPercent(1, String.format(ResManager.loadKDString((String)"\u5df2\u6e05\u9664\u91cd\u7b97\u8282\u70b9\u4fe1\u606f\uff0c\u6761\u4ef6\uff1a%1$s", (String)"CalBalRecalHandle_17", (String)"fi-cal-business", (Object[])new Object[0]), fs), log);
            BalanceTB tb = null;
            int i = 0;
            for (String balTB : balTBs) {
                tb = BalanceTB.getBalanceTB((String)balTB);
                CalBalRecalHandle.addPercent(++i, tatal, String.format(ResManager.loadKDString((String)"\u5df2\u89e3\u6790\u4f59\u989d\u8868\u3010%s\u3011\u3002\u3002\u3002", (String)"CalBalRecalHandle_18", (String)"fi-cal-business", (Object[])new Object[0]), balTB), log);
                try (TXHandle tx = TX.requiresNew((String)"kd.fi.cal.business.balance.recal.CalBalRecalHandle.clearBalsByBalFs");){
                    try {
                        DB.execute((DBRoute)tb.getDbRoute(), (String)CalBalRecalHandle.getDeleteSnapDataSql(tb, costAccountIds, period));
                        CalBalRecalHandle.addPercent(i, tatal, String.format(ResManager.loadKDString((String)"\u5df2\u6e05\u7a7a\u4f59\u989d\u8868\u3010%s\u3011\u7684\u5feb\u7167\u6570\u636e\u3002\u3002\u3002", (String)"CalBalRecalHandle_19", (String)"fi-cal-business", (Object[])new Object[0]), balTB), log);
                        TreeSet<String> tbExts = new TreeSet<String>(new Comparator<String>(){

                            @Override
                            public int compare(String o1, String o2) {
                                if (o1.equals(o2)) {
                                    return 0;
                                }
                                return StringUtils.isBlank((CharSequence)o1) ? 1 : -1;
                            }
                        });
                        tbExts.addAll(tb.getColTbMap().values());
                        ++i;
                        for (String tbExt : tbExts) {
                            DB.execute((DBRoute)tb.getDbRoute(), (String)CalBalRecalHandle.getDeleteBalDataSql(tb, costAccountIds, tbExt, period));
                            CalBalRecalHandle.addPercent(i, tatal, String.format(ResManager.loadKDString((String)"\u5df2\u6e05\u7a7a\u4f59\u989d\u8868\u3010%1$s%2$s\u3011\u6570\u636e\u3002\u3002\u3002", (String)"CalBalRecalHandle_20", (String)"fi-cal-business", (Object[])new Object[0]), tb.getTb(), tbExt), log);
                        }
                        CalBalRecalHandle.updateLastEndPeriod(costAccountIds, period, tb);
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
            CalBalRecalHandle.addPercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6bd5\u3002\u3002\u3002", (String)"CalBalRecalHandle_21", (String)"fi-cal-business", (Object[])new Object[0]), log);
        }
        catch (Exception e) {
            log.append(CalBalRecalHandle.parseMsg(e, 2000));
            CalBalRecalHandle.addPercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5f02\u5e38\u3002\u3002\u3002", (String)"CalBalRecalHandle_0", (String)"fi-cal-business", (Object[])new Object[0]), log);
        }
    }

    private static void updateLastEndPeriod(List<Long> costAccountIds, int period, BalanceTB tb) {
        StringBuilder sql = new StringBuilder("update ").append(tb.getTb()).append(" set fendperiod = 999999 ");
        StringBuilder mainTbNoPeriodWhere = CalBalRecalHandle.getMainTbNoPeriodWhere(tb, costAccountIds);
        if (mainTbNoPeriodWhere.length() > 0) {
            mainTbNoPeriodWhere.append(" and ");
        } else {
            mainTbNoPeriodWhere.append(" where ");
        }
        sql.append((CharSequence)mainTbNoPeriodWhere);
        sql.append(" fendperiod >=  ");
        sql.append(period);
        DB.execute((DBRoute)tb.getDbRoute(), (String)sql.toString());
    }

    private static String getDeleteBalDataSql(BalanceTB tb, List<Long> costAccountIds, String tbExt, int period) {
        StringBuilder sql = new StringBuilder(costAccountIds == null && period < 0 ? "TRUNCATE TABLE " : "DELETE FROM ").append(tb.getTb()).append(tbExt);
        sql.append(CalBalRecalHandle.getSqlWhere(tb, costAccountIds, tbExt, period));
        return sql.toString();
    }

    private static void set0ByByBalFs(StringBuilder log, String[] balTBs, List<Long> costAccountIds) {
        try {
            CalBalRecalHandle.addPercent(0, ResManager.loadKDString((String)"\u5f00\u59cb\u4f59\u989d\u5f52\u96f6\u3002\u3002\u3002", (String)"CalBalRecalHandle_22", (String)"fi-cal-business", (Object[])new Object[0]), log);
            QFilter fs = new QFilter("rule.balancetablenumber", "in", (Object)balTBs);
            if (costAccountIds != null) {
                fs.and(F_COST_ACCOUNT, "in", costAccountIds);
            }
            DeleteServiceHelper.delete((String)"cal_recal_point", (QFilter[])fs.toArray());
            CalBalRecalHandle.addPercent(1, String.format(ResManager.loadKDString((String)"\u5df2\u6e05\u9664\u91cd\u7b97\u8282\u70b9\u4fe1\u606f\uff0c\u6761\u4ef6\uff1a%1$s", (String)"CalBalRecalHandle_17", (String)"fi-cal-business", (Object[])new Object[0]), fs), log);
            int total = 0;
            for (String tbStr : balTBs) {
                BalanceTB tb = BalanceTB.getBalanceTB((String)tbStr);
                List<StringBuilder> sqls = CalBalRecalHandle.getSetAll0Sql(tb, costAccountIds, 0);
                try (TXHandle tx = TX.requiresNew((String)"kd.fi.cal.business.balance.recal.CalBalRecalHandle.set0ByByBalFs");){
                    try {
                        for (StringBuilder sql : sqls) {
                            DB.update((DBRoute)tb.getDbRoute(), (String)sql.toString());
                        }
                        CalBalRecalHandle.addPercent(total += 10, String.format(ResManager.loadKDString((String)"\u4f59\u989d\u8868\u3010%s\u3011\u6570\u91cf\u5df2\u5f52\u96f6\u3002\u3002\u3002", (String)"CalBalRecalHandle_23", (String)"fi-cal-business", (Object[])new Object[0]), tbStr), log);
                        DB.execute((DBRoute)tb.getDbRoute(), (String)CalBalRecalHandle.getDeleteSnapDataSql(tb, costAccountIds, 0));
                        CalBalRecalHandle.addPercent(total += 10, String.format(ResManager.loadKDString((String)"\u5df2\u6e05\u7a7a\u4f59\u989d\u8868\u3010%s\u3011\u7684\u5feb\u7167\u6570\u636e\u3002\u3002\u3002", (String)"CalBalRecalHandle_19", (String)"fi-cal-business", (Object[])new Object[0]), tbStr), log);
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
            CalBalRecalHandle.addPercent(100, ResManager.loadKDString((String)"\u6e05\u7406\u5b8c\u6bd5\u3002\u3002", (String)"CalBalRecalHandle_4", (String)"fi-cal-business", (Object[])new Object[0]), log);
        }
        catch (Exception e) {
            log.append(CalBalRecalHandle.parseMsg(e, 2000));
            CalBalRecalHandle.addPercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5f02\u5e38\u3002\u3002\u3002", (String)"CalBalRecalHandle_0", (String)"fi-cal-business", (Object[])new Object[0]), log);
        }
    }

    private static void addPercent(int percent, String msg, StringBuilder log) {
        log.append("\r\n").append(percent).append("%-").append(msg);
        CalBalReCalCache.setReCalPercent(percent, log.toString());
    }

    private static void addPercent(int count, int total, String msg, StringBuilder log) {
        int percent = count * 100 / total;
        percent = percent >= 100 ? 99 : percent;
        CalBalRecalHandle.addPercent(percent, msg, log);
    }

    private static String parseMsg(Exception e, int i) {
        return ExceptionUtil.parseMsg(e, i);
    }

    private static List<StringBuilder> getSetAll0Sql(BalanceTB tb, List<Long> costAccountIds, int period) {
        Map<String, List<String>> colGroup = CalBalRecalHandle.groupCols(tb);
        ArrayList<StringBuilder> sqls = new ArrayList<StringBuilder>(colGroup.size());
        Map colFieldMap = tb.getColFieldMap();
        String tbExt = null;
        List<String> qtyCols = null;
        for (Map.Entry<String, List<String>> entry : colGroup.entrySet()) {
            tbExt = entry.getKey();
            qtyCols = entry.getValue();
            StringBuilder sql = new StringBuilder(" UPDATE ");
            sql.append(tb.getTb()).append(tbExt).append(" SET ");
            int index = 0;
            for (String qtyCol : qtyCols) {
                if (index != 0) {
                    sql.append(',');
                }
                sql.append((String)colFieldMap.get(qtyCol)).append(" = 0 ");
                ++index;
            }
            sql.append(CalBalRecalHandle.getSqlWhere(tb, costAccountIds, tbExt, period));
            sqls.add(sql);
        }
        return sqls;
    }

    private static Map<String, List<String>> groupCols(BalanceTB tb) {
        Map colTbMap = tb.getColTbMap();
        HashMap<String, List<String>> tbs = new HashMap<String, List<String>>(colTbMap.size());
        Set qtyCols = tb.getColsByDataType(new BizDataType[]{BizDataType.OCC});
        if ("realtime".equals(tb.getType())) {
            qtyCols = tb.getColsByDataType(new BizDataType[]{BizDataType.OCC});
        } else if ("period".equals(tb.getType())) {
            qtyCols = tb.getColsByDataType(new BizDataType[]{BizDataType.INIT, BizDataType.IN, BizDataType.OUT, BizDataType.BAL, BizDataType.YEAR_IN, BizDataType.YEAR_OUT});
        } else {
            return tbs;
        }
        String tbExt = null;
        ArrayList<String> cols = null;
        for (String qtyCol : qtyCols) {
            tbExt = (String)colTbMap.get(qtyCol);
            cols = (ArrayList<String>)tbs.get(tbExt);
            if (cols == null) {
                cols = new ArrayList<String>(8);
                tbs.put(tbExt, cols);
            }
            cols.add(qtyCol);
        }
        return tbs;
    }

    private static String getSqlWhere(BalanceTB tb, List<Long> costAccountIds, String tbExt, int period) {
        StringBuilder where = new StringBuilder();
        StringBuilder mainTbWhere = CalBalRecalHandle.getMainTbWhere(tb, costAccountIds, period);
        if (mainTbWhere.length() > 0) {
            if (StringUtils.isBlank((CharSequence)tbExt)) {
                where.append((CharSequence)mainTbWhere);
            } else {
                where.append(" WHERE ").append("fid").append(" IN (SELECT ").append("fid");
                where.append(" FROM ").append(tb.getTb()).append((CharSequence)mainTbWhere).append(") ");
            }
        }
        return where.toString();
    }

    private static StringBuilder getMainTbWhere(BalanceTB tb, List<Long> costAccountIds, int period) {
        StringBuilder where = CalBalRecalHandle.getMainTbNoPeriodWhere(tb, costAccountIds);
        String periodCol = tb.getPeriodCol();
        if (period > 0 && StringUtils.isNotBlank((CharSequence)periodCol)) {
            where.append(where.length() > 0 ? " AND " : " WHERE ");
            where.append((String)tb.getColFieldMap().get(periodCol)).append(" >= ").append(period);
        }
        return where;
    }

    private static StringBuilder getMainTbNoPeriodWhere(BalanceTB tb, List<Long> costAccountIds) {
        StringBuilder where = new StringBuilder();
        if (costAccountIds != null) {
            String costAccount = (String)tb.getColFieldMap().get(F_COST_ACCOUNT);
            where.append(" WHERE ").append(costAccount);
            if (costAccountIds.size() == 1) {
                where.append(" = ").append(costAccountIds.get(0));
            } else {
                where.append(" in( ").append(StringUtils.join(costAccountIds, (char)',')).append(") ");
            }
        }
        return where;
    }

    private static String getDeleteSnapDataSql(BalanceTB tb, List<Long> costAccountIds, int period) {
        StringBuilder sql = new StringBuilder(costAccountIds == null && period <= 0 ? "TRUNCATE TABLE " : "DELETE FROM ").append(tb.getSnapshotTb());
        StringBuilder whereFs = CalBalRecalHandle.getMainTbWhere(tb, costAccountIds, period);
        if (whereFs.length() > 0) {
            sql.append(" WHERE ").append("fkeycol").append(" IN (SELECT ").append("fkeycol");
            sql.append(" FROM ").append(tb.getTb()).append((CharSequence)whereFs).append(") ");
            String periodCol = tb.getPeriodCol();
            if (period > 0 && StringUtils.isNotBlank((CharSequence)periodCol)) {
                sql.append(" AND ");
                sql.append((String)tb.getColFieldMap().get(periodCol)).append(" >= ").append(period);
            }
        }
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Long> queryLastIds(QFilter fs) {
        try (DataSet data = null;){
            data = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.balance.recal.CalBalRecalHandle.queryLastIds", (String)"cal_recal_point", (String)String.join((CharSequence)",", COLS), (QFilter[])fs.toArray(), null);
            data = data.groupBy(new String[]{"rule"}).max("endid").finish();
            HashMap<String, Long> ruleStartId = new HashMap<String, Long>(64);
            for (Row row : data) {
                ruleStartId.put(row.getString("rule"), row.getLong("endid"));
            }
            HashMap<String, Long> hashMap = ruleStartId;
            return hashMap;
        }
    }

    public static void reCalByBillIds(final String bill, String[] balTBs, Set<Object> billIds) {
        StringBuilder log = new StringBuilder();
        try {
            IRuleFilter filter = new IRuleFilter(){

                public boolean filter(UpdateRule rule) {
                    return bill == null ? rule.isEnable() : bill.equals(rule.getEntityNumber()) && rule.isEnable();
                }
            };
            ArrayList rules = new ArrayList(64);
            for (String bal : balTBs) {
                rules.addAll(UpdateRuleCache.getUpdateRuleByBal((String)bal, (IRuleFilter)filter));
            }
            CalBalRecalHandle.addPercent(1, String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u91cd\u7b97\uff1a\u5355\u636e\u5b9e\u4f53\u3010%1$s\u3011\uff0cID\u6570\u3010%2$s\u3011\u4e2a\uff0c\u9700\u8ba1\u7b97\u7684\u89c4\u5219\u6570\u3010%3$s\u3011\u4e2a\u3002\u3002\u3002", (String)"CalBalRecalHandle_24", (String)"fi-cal-business", (Object[])new Object[0]), bill, billIds.size(), rules.size()), log);
            int tatal = rules.size();
            int count = 0;
            for (UpdateRule rule : rules) {
                try (TXHandle tx = TX.requiresNew();){
                    BalanceUpdateManager.doReUpdate(billIds, (UpdateRule)rule);
                }
                CalBalRecalHandle.addPercent(++count, tatal, String.format(ResManager.loadKDString((String)"\u89c4\u5219\u3010%s\u3011\u91cd\u7b97\u5b8c\u6bd5\u3002\u3002\u3002", (String)"CalBalRecalHandle_25", (String)"fi-cal-business", (Object[])new Object[0]), rule.getRuleNo()), log);
            }
            CalBalRecalHandle.addPercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6bd5\u3002\u3002\u3002", (String)"CalBalRecalHandle_21", (String)"fi-cal-business", (Object[])new Object[0]), log);
        }
        catch (Exception e) {
            log.append(CalBalRecalHandle.parseMsg(e, 2000));
            CalBalRecalHandle.addPercent(100, ResManager.loadKDString((String)"\u6267\u884c\u5f02\u5e38\u3002\u3002\u3002", (String)"CalBalRecalHandle_0", (String)"fi-cal-business", (Object[])new Object[0]), log);
        }
    }

    public static void autoUpdatePeriod() {
        block9: {
            if (CalBalRecalHandle.isNewPeriodBal()) {
                CalBalRecalHandle.disableUpdateTask();
                return;
            }
            String[] tbs = new String[]{"cal_bal", "cal_standcost_bal"};
            int count = CalBalRecalHandle.updateAndGetCount();
            boolean finalStop = false;
            if (count < 3) {
                HashSet calOrgIds = new HashSet(OrgUnitServiceHelper.getAllOrgByViewNumber((String)"10", (boolean)true));
                try {
                    new StopSyncSettingModifyHelper().modifySetting(calOrgIds, null, null, null, null, true, new Date());
                    finalStop = true;
                    CalBalRecalHandle.updateBalanceTBStatus(tbs, true);
                    CalBalRecalHandle.clearBals(tbs);
                    Calendar cd = Calendar.getInstance();
                    cd.set(14, 0);
                    Date start = cd.getTime();
                    CalBalRecalHandle.clearBeforeLogs(start, tbs);
                    CalBalRecalHandle.periodReCal(start, tbs);
                    Future<String> submit = ser.submit(new UpdatePointStatusTask(start));
                    String msg = submit.get();
                    if (msg == null) {
                        CalBalRecalHandle.updateBalanceTBStatus(tbs, false);
                        CalBalRecalHandle.periodChangeEngine(true);
                        new StopSyncSettingModifyHelper().modifySetting(calOrgIds, null, null, null, null, false, new Date());
                        finalStop = false;
                        CalBalRecalHandle.clearBeforeLogs(start, tbs);
                        CalBalRecalHandle.periodReCal(start, tbs);
                        CalBalRecalHandle.disableUpdateTask();
                        break block9;
                    }
                    throw new KDBizException(msg);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (finalStop) {
                        new StopSyncSettingModifyHelper().modifySetting(calOrgIds, null, null, null, null, false, new Date());
                    }
                }
            }
            CalBalRecalHandle.disableUpdateTask();
        }
    }

    private static void disableUpdateTask() {
        QFilter fs = new QFilter("number", "=", (Object)"CalBalAutoUpdateTask");
        DynamicObject info = BusinessDataServiceHelper.loadSingle((String)"sch_schedule", (String)"id,status", (QFilter[])fs.toArray());
        if (info != null) {
            info.set("status", (Object)"0");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
        }
    }

    private static void clearBeforeLogs(Date start, String[] tbs) {
        QFilter fs = new QFilter("start", "=", (Object)start);
        fs.and("bal", "in", (Object)tbs);
        DeleteServiceHelper.delete((String)"cal_recal_msg", (QFilter[])fs.toArray());
    }

    private static int updateAndGetCount() {
        int count = -1;
        String sql = "SELECT fvalue FROM T_IM_INVDBPARAM WHERE FKEY = 'cal_bal_update_count'";
        try (DataSet data = DB.queryDataSet((String)"kd.fi.cal.business.balance.recal.CalBalRecalHandle.updateAndGetCount", (DBRoute)DBRoute.of((String)"im"), (String)sql);){
            if (data.hasNext()) {
                Row row = data.next();
                count = Integer.parseInt(row.getString("fvalue"));
            }
        }
        sql = count == -1 ? "insert into T_IM_INVDBPARAM(fid,fkey,fvalue) values (" + DB.genGlobalLongId() + ", 'cal_bal_update_count','0')" : "update T_IM_INVDBPARAM set fvalue='" + (count + 1) + "'  WHERE FKEY = 'cal_bal_update_count'";
        DB.execute((DBRoute)DBRoute.of((String)"im"), (String)sql);
        return count + 1;
    }

    private static void updateBalanceTBStatus(String[] tbNames, boolean disable) {
        DynamicObject[] tbs;
        QFilter fs = new QFilter("number", "in", (Object)tbNames);
        for (DynamicObject dynamicObject : tbs = BusinessDataServiceHelper.load((String)"bal_balanceinfo", (String)"id,custstatus", (QFilter[])fs.toArray())) {
            dynamicObject.set("custstatus", (Object)(disable ? "1" : "0"));
        }
        SaveServiceHelper.update((DynamicObject[])tbs);
        for (String string : tbNames) {
            BalanceRuleCacheUtils.removeBalVersion((String)string);
        }
    }
}

