/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance.recal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.cal.business.balance.recal.AbstractReCalComsumer;
import kd.fi.cal.business.balance.recal.CalBalReCalCache;
import kd.fi.cal.business.balance.recal.ExceptionUtil;
import kd.fi.cal.business.balance.recal.ReCalMonitorLog;
import kd.fi.cal.business.balance.recal.UpdateByBatchId;
import kd.fi.cal.business.balance.recal.UpdateByCostAccount;
import kd.fi.cal.common.helper.WriteLogHelper;
import org.apache.commons.lang3.StringUtils;

public class CalReCalConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(CalReCalConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object param, String messageId, boolean resend, MessageAcker acker) {
        Long taskId;
        block31: {
            Date now;
            Object idData;
            DynamicObject task;
            block29: {
                block30: {
                    if (resend) {
                        acker.ack(messageId);
                        return;
                    }
                    JSONObject p = null;
                    task = null;
                    idData = null;
                    now = new Date();
                    taskId = null;
                    p = JSON.parseObject((String)((String)param));
                    taskId = p.getLong("taskid");
                    if (!CalBalReCalCache.isRunning(taskId)) break block29;
                    acker.ack(messageId);
                    if (idData == null) break block30;
                    idData.close();
                }
                CalBalReCalCache.removeRunning(taskId);
                CalBalReCalCache.clearTaskPercent(taskId);
                acker.ack(messageId);
                return;
            }
            try {
                CalBalReCalCache.setRunning(taskId);
                task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"cal_recal_msg");
                if (task == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"taskid=%s\uff0c\u4e0d\u5b58\u5728", (String)"CalReCalConsumer_0", (String)"fi-cal-business", (Object[])new Object[0]), taskId));
                }
                AbstractReCalComsumer cal = null;
                String bal = task.getString("bal");
                String ruleId = task.getString("rule");
                if (StringUtils.isNotBlank((CharSequence)bal)) {
                    Date start = task.getDate("start");
                    Long org = task.getDynamicObject("costaccount").getLong("id");
                    try (ShardingHintContext ctx = ShardingHintContext.create((String)"t_cal_bal", (ShardingHintContext.ShardingHintCondition[])new ShardingHintContext.ShardingHintCondition[]{new ShardingHintContext.ShardingHintCondition("fcostaccountid", FilterType.in_range, (Object)org)});){
                        ctx.set();
                        cal = new UpdateByCostAccount(taskId, start, bal, org);
                        cal.doUpdate();
                    }
                } else if (StringUtils.isNotBlank((CharSequence)ruleId)) {
                    String billName = task.getString("billname");
                    String fsStr = task.getString("billfs");
                    cal = new UpdateByBatchId(taskId, billName, ruleId, fsStr);
                    cal.doUpdate();
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u6d88\u606f\u672c\u8eab\u8bb0\u5f55\u6709\u8bef\uff1a\u4f59\u989d\u8868\u548c\u89c4\u5219\u540c\u65f6\u4e3a\u7a7a", (String)"CalReCalConsumer_1", (String)"fi-cal-business", (Object[])new Object[0]));
                }
                task.set("msgid", (Object)messageId);
                StringBuilder errorMsg = cal.getErrorMsg();
                if (errorMsg.length() > 0) {
                    task.set("status", (Object)"B");
                    task.set("errormsg_tag", (Object)errorMsg.toString());
                } else {
                    task.set("status", (Object)"A");
                    task.set("errormsg_tag", null);
                }
                task.set("truecount", (Object)cal.getSuccesCount());
                task.set("msgstart", (Object)now);
                task.set("msgusertime", (Object)(System.currentTimeMillis() - now.getTime()));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
                acker.ack(messageId);
                if (idData == null) break block31;
            }
            catch (Exception e) {
                block32: {
                    try {
                        try {
                            if (task == null) {
                                task = BusinessDataServiceHelper.newDynamicObject((String)"cal_recal_msg");
                                task.set("taskno", (Object)"error");
                            }
                            task.set("status", (Object)"B");
                            task.set("errormsg_tag", (Object)ExceptionUtil.parseMsg(e, 1600));
                            task.set("msgid", (Object)messageId);
                            task.set("msgstart", (Object)now);
                            task.set("msgusertime", (Object)(System.currentTimeMillis() - now.getTime()));
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
                        }
                        catch (Exception ev) {
                            ReCalMonitorLog.error(ResManager.loadKDString((String)"\u63d2\u5165\u5931\u8d25\u6d88\u606f\u5f02\u5e38", (String)"CalReCalConsumer_2", (String)"fi-cal-business", (Object[])new Object[0]), e);
                            WriteLogHelper.writeErrorLog((Log)logger, (String)"DataCheckItemSavePlugin-onAddValidators2", (Throwable)e);
                        }
                        if (idData == null) break block32;
                    }
                    catch (Throwable throwable) {
                        if (idData != null) {
                            idData.close();
                        }
                        CalBalReCalCache.removeRunning(taskId);
                        CalBalReCalCache.clearTaskPercent(taskId);
                        acker.ack(messageId);
                        throw throwable;
                    }
                    idData.close();
                }
                CalBalReCalCache.removeRunning(taskId);
                CalBalReCalCache.clearTaskPercent(taskId);
                acker.ack(messageId);
            }
            idData.close();
        }
        CalBalReCalCache.removeRunning(taskId);
        CalBalReCalCache.clearTaskPercent(taskId);
        acker.ack(messageId);
    }
}

