/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance.recal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.engine.policy.ICalPeriodPolicy;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class RulesData {
    private UpdateRule rule;
    private boolean errorStop;
    private Long pointId;
    private DataSet data;
    private Object currentId;
    private int currentPeriod;
    private boolean hasData = true;

    public Long getPointId() {
        return this.pointId;
    }

    public void setPointId(Long pointId) {
        this.pointId = pointId;
    }

    public void setErrorStop() {
        this.errorStop = true;
    }

    public RulesData initData(UpdateRule rule, QFilter fs) {
        String billName = rule.getEntityNumber();
        StringBuilder cols = new StringBuilder("id");
        Map periodColMap = rule.getPeriodColMap();
        Map srcColFullNameMap = rule.getSrcColFullNameMap();
        String colName = null;
        for (Map.Entry col : periodColMap.entrySet()) {
            colName = (String)col.getValue();
            cols.append(',').append((String)srcColFullNameMap.get(colName)).append(" AS ").append((String)col.getKey());
        }
        DataSet qData = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.balance.recal.RulesData.initData", (String)billName, (String)cols.toString(), (QFilter[])fs.toArray(), (String)"id asc");
        this.data = qData = qData.distinct();
        this.rule = rule;
        return this;
    }

    public List<Object> getBatchIds(int period, int batchCount) {
        ArrayList<Object> ids = new ArrayList<Object>(batchCount);
        if (this.currentId != null) {
            if (this.currentPeriod > period) {
                return ids;
            }
            ids.add(this.currentId);
            this.currentId = null;
            this.currentPeriod = 0;
        }
        int tempPeriod = 0;
        Number tempId = 0;
        ICalPeriodPolicy cal = this.rule.getPerCalPolicy();
        while (this.hasData = this.data.hasNext()) {
            Row row = this.data.next();
            tempPeriod = cal.calPeriodVal(row);
            tempId = row.getLong("id");
            if (tempPeriod <= period) {
                ids.add(tempId);
                if (ids.size() < batchCount) continue;
                this.currentId = null;
                this.currentPeriod = 0;
                break;
            }
            this.currentId = tempId;
            this.currentPeriod = tempPeriod;
            break;
        }
        return ids;
    }

    public boolean isEmpty() {
        return this.errorStop || this.currentId == null && !this.hasData;
    }

    public void close() {
        if (this.data != null) {
            this.data.close();
        }
    }

    public UpdateRule getRule() {
        return this.rule;
    }
}

