/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.balance.recal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.IRuleFilter;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.balance.recal.AbstractReCalComsumer;
import kd.fi.cal.business.balance.recal.CalBalReCalCache;
import kd.fi.cal.business.balance.recal.CalBalRecalHandle;
import kd.fi.cal.business.balance.recal.ExceptionUtil;
import kd.fi.cal.business.balance.recal.RulesData;

class UpdateByCostAccount
extends AbstractReCalComsumer {
    private static final String F_COST_ACCOUNT = "costaccount";
    private static final String F_BILLSTATUS = "billstatus";
    private static final String BILL_STATUS_AUDIT = "C";
    private Date start;
    private String tb;
    private Object costAccountId;
    private static final Log LOG = LogFactory.getLog(UpdateByCostAccount.class);

    public UpdateByCostAccount(Long taskId, Date start, String tb, Long costAccountId) {
        super(taskId);
        this.costAccountId = costAccountId;
        this.tb = tb;
        this.start = start;
        LOG.info("UpdateByCostAccount:costAccountId=" + costAccountId);
    }

    private Map<String, Long> queryLastIds(List<UpdateRule> rules) {
        ArrayList<String> ids = new ArrayList<String>(rules.size());
        for (UpdateRule rule : rules) {
            ids.add(rule.getId());
        }
        QFilter fs = new QFilter("rule", "in", ids).and(F_COST_ACCOUNT, "=", this.costAccountId).and("status", "=", (Object)"A");
        return CalBalRecalHandle.queryLastIds(fs);
    }

    private List<Integer> getPeriodList() {
        QFilter fs = new QFilter("entry.costaccount", "=", this.costAccountId);
        DynamicObject info = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.startperiod.periodtype,entry.startperiod.periodyear,entry.startperiod.periodnumber", (QFilter[])fs.toArray());
        if (info == null) {
            return new ArrayList<Integer>(0);
        }
        int period = 0;
        long periodTypeId = 0L;
        period = info.getInt("entry.startperiod.periodyear") * 100 + info.getInt("entry.startperiod.periodnumber");
        periodTypeId = info.getLong("entry.startperiod.periodtype");
        TreeSet<Integer> periods = new TreeSet<Integer>();
        Integer startPeriod = CalBalReCalCache.getStartPeriod(this.start);
        if (startPeriod == null || startPeriod <= 0) {
            periods.add(0);
        } else {
            period = period > startPeriod ? period : startPeriod;
        }
        fs = new QFilter("periodtype", "=", (Object)periodTypeId);
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.balance.recal.UpdateByCostAccount.getPeriodList", (String)"bd_period", (String)"periodyear,periodnumber", (QFilter[])fs.toArray(), null);){
            int tempPeriod = 0;
            for (Row row : data) {
                tempPeriod = row.getInteger("periodyear") * 100 + row.getInteger("periodnumber");
                if (tempPeriod < period) continue;
                periods.add(tempPeriod);
            }
        }
        periods.add(999999);
        return new ArrayList<Integer>(periods);
    }

    private void updateSinglePeriod(int startPer, List<RulesData> ruleDatas) {
        for (RulesData ruleData : ruleDatas) {
            this.updateSingleRule(ruleData, startPer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdate() {
        this.addPercent(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u91cd\u7b97\uff0c\u7ec4\u7ec7ID\u3010%1$s\u3011\uff0c\u6279\u91cf\u66f4\u65b0\u6570\u3010%2$s\u3011\u3002\u3002\u3002", (String)"UpdateByCostAccount_0", (String)"fi-cal-business", (Object[])new Object[0]), this.costAccountId, this.getBatch()));
        this.errorMsg = new StringBuilder();
        List<Integer> periods = this.getPeriodList();
        if (periods.isEmpty()) {
            return;
        }
        this.addPercent(String.format(ResManager.loadKDString((String)"\u5df2\u89e3\u6790\u8981\u91cd\u7b97\u7684\u671f\u95f4\uff1a%s\u3002\u3002\u3002", (String)"UpdateByCostAccount_1", (String)"fi-cal-business", (Object[])new Object[0]), periods));
        List rules = UpdateRuleCache.getUpdateRuleByBal((String)this.tb, (IRuleFilter)new IRuleFilter(){});
        Map<String, Long> lastIds = this.queryLastIds(rules);
        this.addPercent(ResManager.loadKDString((String)"\u5df2\u83b7\u53d6\u5404\u89c4\u5219\u8d77\u59cb\u5355\u636eID\u3002\u3002\u3002", (String)"UpdateByCostAccount_2", (String)"fi-cal-business", (Object[])new Object[0]));
        ArrayList<RulesData> initQtyDatas = new ArrayList<RulesData>(1);
        ArrayList<RulesData> otherQtyDatas = new ArrayList<RulesData>(rules.size());
        boolean needInitData = periods.get(0) == 0;
        try {
            QFilter fs = null;
            for (UpdateRule rule : rules) {
                fs = this.createFs(rule, lastIds);
                if ("3".equals(rule.getPeriodPolicy())) {
                    if (!needInitData) continue;
                    initQtyDatas.add(new RulesData().initData(rule, fs));
                    continue;
                }
                otherQtyDatas.add(new RulesData().initData(rule, fs));
            }
            this.setTotal(otherQtyDatas.size() * periods.size() + initQtyDatas.size());
            this.addPercent(String.format(ResManager.loadKDString((String)"\u671f\u521d\u66f4\u65b0\u89c4\u5219\u3010%1$s\u3011\u4e2a\uff0c\u5176\u4ed6\u66f4\u65b0\u89c4\u5219\u3010%2$s\u3011\u3002\u3002\u3002", (String)"UpdateByCostAccount_3", (String)"fi-cal-business", (Object[])new Object[0]), initQtyDatas.size(), otherQtyDatas.size()));
            int i = 0;
            if (needInitData) {
                i = 1;
                this.updateSinglePeriod(0, initQtyDatas);
            }
            List<RulesData> tempQtyDatas = otherQtyDatas;
            int len = periods.size();
            while (i < len) {
                this.updateSinglePeriod(periods.get(i), tempQtyDatas);
                tempQtyDatas = this.clearEmptyData(tempQtyDatas);
                if (tempQtyDatas.isEmpty()) break;
                ++i;
            }
            this.addPercent(100, ResManager.loadKDString((String)"\u91cd\u7b97\u5b8c\u6210\u3002\u3002\u3002", (String)"UpdateByCostAccount_4", (String)"fi-cal-business", (Object[])new Object[0]));
        }
        catch (Throwable throwable) {
            for (RulesData qtyData : initQtyDatas) {
                qtyData.close();
            }
            for (RulesData qtyData : otherQtyDatas) {
                qtyData.close();
            }
            throw throwable;
        }
        for (RulesData qtyData : initQtyDatas) {
            qtyData.close();
        }
        for (RulesData qtyData : otherQtyDatas) {
            qtyData.close();
        }
    }

    private List<RulesData> clearEmptyData(List<RulesData> otherQtyDatas) {
        ArrayList<RulesData> notEmptyDatas = new ArrayList<RulesData>(otherQtyDatas.size());
        for (RulesData rulesData : otherQtyDatas) {
            if (!rulesData.isEmpty()) {
                notEmptyDatas.add(rulesData);
                continue;
            }
            this.addPercent(String.format(ResManager.loadKDString((String)"\u89c4\u5219\u3010%s\u3011\u6570\u636e\u5df2\u6d88\u8d39\u5b8c\u3002\u3002\u3002", (String)"UpdateByCostAccount_5", (String)"fi-cal-business", (Object[])new Object[0]), rulesData.getRule().getId()));
        }
        return notEmptyDatas;
    }

    private QFilter createFs(UpdateRule rule, Map<String, Long> lastIds) {
        QFilter fs = new QFilter((String)rule.getTargetSrcColMap().get(F_COST_ACCOUNT), "=", this.costAccountId).and(F_BILLSTATUS, "=", (Object)BILL_STATUS_AUDIT);
        Long startId = lastIds.get(rule.getId());
        if (startId != null) {
            fs.and("id", ">", (Object)startId);
        }
        fs.and(rule.getFilter());
        return fs;
    }

    private void saveLastId2DB(RulesData ruleData, Object lastId) {
        Long pointId = ruleData.getPointId();
        if (pointId == null) {
            DynamicObject point = BusinessDataServiceHelper.newDynamicObject((String)"cal_recal_point");
            long id = DB.genGlobalLongId();
            point.set("id", (Object)id);
            point.set("rule", (Object)ruleData.getRule().getId());
            point.set(F_COST_ACCOUNT, this.costAccountId);
            point.set("createtime", (Object)this.start);
            point.set("status", (Object)"A");
            point.set("endid", lastId);
            try (TXHandle tx = TX.requiresNew((String)"kd.fi.cal.business.balance.recal.UpdateByCostAccount.saveLastId2DB");){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{point});
            }
            ruleData.setPointId(id);
        } else {
            String sql = "UPDATE t_cal_recal_point SET fendid =" + lastId + " WHERE FID = " + pointId;
            try (TXHandle tx = TX.requiresNew((String)"kd.fi.cal.business.balance.recal.UpdateByCostAccount.updateLastId2DB");){
                DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)sql);
            }
        }
    }

    @Override
    protected int getBatch() {
        return CalBalReCalCache.getBatchCount();
    }

    private void updateSingleRule(RulesData ruleData, int period) {
        this.addOverCount();
        Object lastId = null;
        int count = 0;
        int showCount = 1;
        String ruleId = ruleData.getRule().getId();
        this.addPercent(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u5904\u7406\uff0c\u671f\u95f4\u3010%1$s\u3011\uff0c\u89c4\u5219\u3010%2$s\u3011", (String)"UpdateByCostAccount_6", (String)"fi-cal-business", (Object[])new Object[0]), period, ruleId));
        try {
            List<Object> batchIds = null;
            int temp = 1;
            int batch = this.getBatch();
            while (!ruleData.isEmpty()) {
                int size;
                long time = System.currentTimeMillis();
                if (++temp % 20 == 0) {
                    batch = this.getBatch();
                }
                if ((size = (batchIds = ruleData.getBatchIds(period, batch)).size()) <= 0) break;
                this.batchUpdate(new HashSet<Object>(batchIds), ruleData.getRule());
                lastId = batchIds.get(size - 1);
                this.saveLastId2DB(ruleData, lastId);
                this.addPercent(String.format(ResManager.loadKDString((String)"\u671f\u95f4\u3010%1$s\u3011\uff0c\u89c4\u5219\u3010%2$s\u3011\uff0c\u5b9e\u65f6\u6279\u91cf\u6570\u4e3a\u3010%3$s\u3011\uff0c\u5df2\u4fdd\u5b58\u8282\u70b9\u3010%4$s\u3011\uff0c\u8017\u65f6\u3010%5$s\u3011\u6beb\u79d2\u3002\u3002\u3002", (String)"UpdateByCostAccount_7", (String)"fi-cal-business", (Object[])new Object[0]), period, ruleId, batch, lastId, System.currentTimeMillis() - time));
                if ((count += size) <= 100000 * showCount) continue;
                this.addPercent(String.format(ResManager.loadKDString((String)"\u671f\u95f4\u3010%1$s\u3011\uff0c\u89c4\u5219\u3010%2$s\u3011\uff0c\u5df2\u91cd\u7b97\u3010%3$s\u3011\u5355\u3002\u3002\u3002", (String)"UpdateByCostAccount_8", (String)"fi-cal-business", (Object[])new Object[0]), period, ruleId, count));
                ++showCount;
            }
            if (count > 0) {
                this.addPercent(String.format(ResManager.loadKDString((String)"\u671f\u95f4\u3010%1$s\u3011\uff0c\u89c4\u5219\u3010%2$s\u3011\uff0c\u4e00\u5171\u91cd\u7b97\u3010%3$s\u3011\u5355\u3002\u3002\u3002", (String)"UpdateByCostAccount_9", (String)"fi-cal-business", (Object[])new Object[0]), period, ruleId, count));
            }
        }
        catch (Exception e) {
            this.errorMsg.append(ExceptionUtil.parseMsg(e, 1200));
            this.addPercent(String.format(ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38\uff1a\u89c4\u5219\u3010%1$s\u3011\uff0c\u5355\u636e\u6570\u3010%2$s\u3011\uff0c\u8bb0\u5f55\u622a\u6b62ID\u3010%3$s\u3011\u3002\u3002\u3002", (String)"UpdateByCostAccount_10", (String)"fi-cal-business", (Object[])new Object[0]), ruleId, count, lastId));
            ruleData.setErrorStop();
        }
    }
}

