/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.bizfinint;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.cal.business.bizfinint.BizFinIntCoorTableManager;
import kd.fi.cal.business.bizfinint.BizFinIntOrderRedisLock;
import kd.fi.cal.business.process.inner.CalLockKeyHelper;
import kd.fi.cal.common.enums.ActionEnum;
import kd.fi.cal.common.helper.ScmParamsHelper;
import kd.fi.cal.common.helper.SyncSimpleDycHelper;
import kd.fi.cal.common.util.CommonUtils;

public class BizFinIntHelper {
    private static final Log logger = LogFactory.getLog(BizFinIntHelper.class);

    public void doReverseByReqId(Set<String> reqIds, Set<Long> reqBillIds) {
        for (String reqId : reqIds) {
            this.doReverseByReqId(reqId, reqBillIds);
        }
    }

    public void doReverseByReqId(String reqId, Set<Long> reqBillIds) {
        HashSet<Long> costRecIds = new HashSet<Long>(16);
        HashMap<String, Set<Long>> bizEnityBillIdsMap = new HashMap<String, Set<Long>>(16);
        DataSet costRecDs = this.getCostRecDs(reqBillIds);
        for (Row row : costRecDs) {
            costRecIds.add(row.getLong("id"));
            Set billIds = bizEnityBillIdsMap.computeIfAbsent(row.getString("bizentityobject"), k -> new HashSet(16));
            billIds.add(row.getLong("bizbillid"));
        }
        DynamicObjectCollection dapDycs = this.getHasVouCostRecIds(costRecIds);
        HashSet<Long> hasVouCostRecIds = new HashSet<Long>(16);
        HashSet<Long> vouIds = new HashSet<Long>(16);
        for (DynamicObject dapDyc : dapDycs) {
            Long billId = dapDyc.getLong("sourcebillid");
            Long vouId = dapDyc.getLong("voucherid");
            hasVouCostRecIds.add(billId);
            vouIds.add(vouId);
        }
        boolean isDelVouchSucess = this.doDelVouch(hasVouCostRecIds, vouIds);
        if (!isDelVouchSucess) {
            return;
        }
        List<String> curLockKeys = new CalLockKeyHelper().getCostRecBillLockKeyListByBizBill(reqBillIds);
        boolean isUnAuditSucess = this.doUnAuditCostRec(bizEnityBillIdsMap);
        if (!isUnAuditSucess) {
            return;
        }
        new BizFinIntOrderRedisLock().releaseLock(new HashSet<String>(curLockKeys), Collections.singleton(reqId));
        new BizFinIntCoorTableManager().doDelInvCoorTable(reqId, reqBillIds);
    }

    public Map<Long, Set<Long>> getVouIdCostRecIdsMap(Set<Long> costrecIds) {
        if (costrecIds.isEmpty()) {
            return null;
        }
        HashMap<Long, Set<Long>> vouIdCostRecIdsMap = new HashMap<Long, Set<Long>>(16);
        DynamicObjectCollection dapDycs = this.getHasVouCostRecIds(costrecIds);
        for (DynamicObject dapDyc : dapDycs) {
            Long billId = dapDyc.getLong("sourcebillid");
            Long vouId = dapDyc.getLong("voucherid");
            Set costRecIds = vouIdCostRecIdsMap.computeIfAbsent(vouId, k -> new HashSet(16));
            costRecIds.add(billId);
        }
        return vouIdCostRecIdsMap;
    }

    public void checkBizFinIntParam() {
        boolean isBizFinInt = ScmParamsHelper.isEnable((String)"INV0005");
        if (isBizFinInt) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u4e1a\u8d22\u4e00\u4f53\u5316\uff0c\u5b9e\u65f6\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u4f7f\u7528\u6b64\u529f\u80fd\u3002", (String)"BizFinIntHelper_0", (String)"fi-cal-business", (Object[])new Object[0]));
        }
    }

    private boolean doDelVouch(Set<Long> hasVouCostRecIds, Set<Long> vouIds) {
        if (hasVouCostRecIds.isEmpty()) {
            return true;
        }
        try {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("ignoreValidation", "true");
            option.setVariableValue("skipCheckSpecialDataPermission", "true");
            String glVoucherEntity = "gl_voucher";
            OperationResult result = OperationServiceHelper.executeOperate((String)"antipost", (String)glVoucherEntity, (Object[])vouIds.toArray(new Object[0]), (OperateOption)option);
            String atipostOpMsg = CommonUtils.getOpErrorMsg((OperationResult)result);
            logger.info("\u4e1a\u8d22\u4e00\u4f53\u5316\u5c1d\u8bd5\u53cd\u8fc7\u8d26\u51ed\u8bc1\uff1a" + atipostOpMsg);
            result = OperationServiceHelper.executeOperate((String)"unaudit", (String)glVoucherEntity, (Object[])vouIds.toArray(new Object[0]), (OperateOption)option);
            String unauditOpMsg = CommonUtils.getOpErrorMsg((OperationResult)result);
            logger.info("\u4e1a\u8d22\u4e00\u4f53\u5316\u5c1d\u8bd5\u53cd\u5ba1\u6838\u51ed\u8bc1\uff1a" + unauditOpMsg);
        }
        catch (Throwable e) {
            logger.error(e);
        }
        String delVoucher = "deletefivoucher";
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("skipCheckSpecialDataPermission", "true");
        try {
            OperationResult voucherResult = OperationServiceHelper.executeOperate((String)delVoucher, (String)"cal_costrecord_subentity", (Object[])hasVouCostRecIds.toArray(new Object[0]), (OperateOption)option);
            String delOpErrorMsg = CommonUtils.getOpErrorMsg((OperationResult)voucherResult);
            if (!delOpErrorMsg.isEmpty()) {
                logger.info("\u4e1a\u8d22\u4e00\u4f53\u5316\u5220\u9664\u51ed\u8bc1\u5931\u8d25" + delOpErrorMsg);
                return false;
            }
        }
        catch (Throwable e) {
            logger.error("\u4e1a\u8d22\u4e00\u4f53\u5316\u5220\u9664\u51ed\u8bc1\u5931\u8d25", e);
            return false;
        }
        return true;
    }

    private DynamicObjectCollection getHasVouCostRecIds(Set<Long> costRecIds) {
        QFilter filter = new QFilter("sourcebillid", "in", costRecIds);
        DynamicObjectCollection dapDycs = QueryServiceHelper.query((String)"ai_daptracker", (String)"voucherid,sourcebillid", (QFilter[])new QFilter[]{filter});
        return dapDycs;
    }

    private DataSet getCostRecDs(Set<Long> reqBillIds) {
        QFilter bizBillIdF = new QFilter("bizbillid", "in", reqBillIds);
        DataSet costRecDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_costrecord", (String)"id,bizentityobject,bizbillid", (QFilter[])bizBillIdF.toArray(), null);
        return costRecDs;
    }

    private boolean doUnAuditCostRec(Map<String, Set<Long>> bizEnityBillIdsMap) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("legalCheck", "false");
        for (Map.Entry<String, Set<Long>> entityBillIdEnt : bizEnityBillIdsMap.entrySet()) {
            List bizBillDycs = new SyncSimpleDycHelper().buildDelBizBillDycsByCostRecord(entityBillIdEnt.getKey(), entityBillIdEnt.getValue());
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doServiceSync", (Object[])new Object[]{ActionEnum.UN_AUDIT.getValue(), params, bizBillDycs.toArray(new DynamicObject[0])});
            if (result.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

