/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.bizfinint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.cal.business.bizfinint.BizFinIntCoorTableManager;
import kd.fi.cal.business.process.inner.CalLockKeyHelper;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.ScmParamsHelper;
import kd.fi.cal.common.helper.WriteLogHelper;

public class BizFinIntOrderRedisLock {
    private static final Log logger = LogFactory.getLog(BizFinIntOrderRedisLock.class);
    private String lockCacheKey = "BIZ_FIN_INT_ORDER_CACHE";
    private static final String scanInvTableTimeKey = "scaninvtabletime";
    private Set<Long> bizBillIds = new HashSet<Long>(16);
    private String reqId = "";

    public void tryLock(Set<Long> bizBillIds) {
        this.tryLock(bizBillIds, -1L);
    }

    public void tryLock(Set<Long> bizBillIds, long timeoutMillis) {
        try (TraceSpan span = Tracer.create((String)"BizFinIntOrderRedisLock", (String)"tryLock");){
            this.doTryLock(bizBillIds, timeoutMillis);
        }
    }

    private void doTryLock(Set<Long> bizBillIds, long timeoutMillis) {
        boolean isBizFinInt = ScmParamsHelper.isEnable((String)"INV0005");
        if (!isBizFinInt) {
            return;
        }
        if (timeoutMillis <= 0L) {
            Integer redisTimeout = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.BIZFININT_REDIS_TIMEOUT);
            timeoutMillis = redisTimeout.intValue();
        }
        this.bizBillIds = bizBillIds;
        long now = TimeServiceHelper.now().getTime();
        try (DLock dlock = DLock.createReentrant((String)(this.lockCacheKey + CacheKeyUtil.getAcctId()), (String)"BizFinIntOrderRedisLock");){
            dlock.lock();
            IAppCache cache = this.getAppCache();
            Long lastScanInvTableTime = (Long)cache.get(scanInvTableTimeKey, Long.class);
            if (lastScanInvTableTime == null || now > lastScanInvTableTime) {
                this.scanInvCoorTableOrder(lastScanInvTableTime, now);
            }
        }
        this.getLock(bizBillIds, timeoutMillis);
    }

    private void getLock(Set<Long> bizBillIds, long timeoutMillis) {
        List<String> curLockKeys = new CalLockKeyHelper().getCostRecBillLockKeyListByBizBill(bizBillIds);
        long startTime = TimeServiceHelper.now().getTime();
        while (true) {
            Map<String, List<String>> lockKeyReqIdMap = this.getLockKeyReqIdsMap();
            boolean isLockSucess = true;
            for (String lockKey : curLockKeys) {
                ArrayList reqIds = lockKeyReqIdMap.get(lockKey);
                reqIds = reqIds == null ? new ArrayList(0) : reqIds;
                if (reqIds.isEmpty() || ((String)reqIds.get(0)).equals(this.reqId) || StringUtils.isEmpty((CharSequence)this.reqId)) continue;
                isLockSucess = false;
            }
            if (isLockSucess) break;
            if (TimeServiceHelper.now().getTime() - startTime >= timeoutMillis) {
                String msg = ResManager.loadKDString((String)"\u6838\u7b97\u5355\u540c\u6b65\u83b7\u53d6\u9501\u8d85\u65f6\u3002", (String)"BizFinIntOrderRedisLock_0", (String)"fi-cal-business", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                WriteLogHelper.writeErrorLog((Log)logger, (String)"BizFinIntOrderRedisLock-getLock", (Throwable)interruptedException);
            }
        }
    }

    private void scanInvCoorTableOrder(Long lastScanInvTableTime, long now) {
        IAppCache cache = this.getAppCache();
        lastScanInvTableTime = lastScanInvTableTime == null ? Long.valueOf(0L) : lastScanInvTableTime;
        DataSet invCoorDs = new BizFinIntCoorTableManager().getInvCoorTableDs(lastScanInvTableTime, now);
        HashMap<String, Set> reqIdBizBillIdsMap = new HashMap<String, Set>(16);
        HashMap<String, Long> reqIdOpTimesMap = new HashMap<String, Long>(16);
        HashMap<String, String> entityBizBillIdReqIdMap = new HashMap<String, String>(16);
        HashMap<String, Set<Long>> entityBizBillIdsMap = new HashMap<String, Set<Long>>(16);
        for (Row row : invCoorDs) {
            String requestId = row.getString("FREQUESTID");
            String bizEntity = row.getString("FENTITYNUM");
            Long bizBillId = row.getLong("FBILLID");
            Long createTime = row.getDate("FCREATETIME").getTime();
            Set tmpBizBillIds = reqIdBizBillIdsMap.computeIfAbsent(requestId, k -> new HashSet(16));
            tmpBizBillIds.add(bizBillId);
            reqIdOpTimesMap.put(requestId, createTime);
            entityBizBillIdReqIdMap.put(bizEntity + bizBillId, requestId);
            if (StringUtils.isEmpty((CharSequence)this.reqId) && this.bizBillIds.contains(bizBillId)) {
                this.reqId = requestId;
            }
            Set tmpEntBillIds = entityBizBillIdsMap.computeIfAbsent(bizEntity, k -> new HashSet(16));
            tmpEntBillIds.add(bizBillId);
        }
        CalLockKeyHelper calLockKeyHelper = new CalLockKeyHelper();
        calLockKeyHelper.getCostRecBillLockKeyListByBizBill(entityBizBillIdsMap);
        Map<String, Set<String>> bizEntityBizBillIdDimsMap = calLockKeyHelper.getBizEntityBizBillIdDimsMap();
        Map<String, List<String>> lockKeyReqIdsMap = this.getLockKeyReqIdsMap();
        HashMap<String, Set> dimReqIdsMap = new HashMap<String, Set>(16);
        for (Map.Entry entBizIdReqIdEnt : entityBizBillIdReqIdMap.entrySet()) {
            String entBizId = (String)entBizIdReqIdEnt.getKey();
            String reqId = (String)entBizIdReqIdEnt.getValue();
            Set<String> dims = bizEntityBizBillIdDimsMap.get(entBizId);
            if (dims == null || dims.isEmpty()) continue;
            for (String string : dims) {
                Set tmpReqIds = dimReqIdsMap.computeIfAbsent(string, k -> new HashSet(16));
                tmpReqIds.add(reqId);
            }
            for (Map.Entry entry : dimReqIdsMap.entrySet()) {
                String dim = (String)entry.getKey();
                ArrayList reqIds = new ArrayList((Collection)entry.getValue());
                Comparator<String> comparator = this.getComparator(reqIdOpTimesMap);
                Collections.sort(reqIds, comparator);
                List hasReqIds = lockKeyReqIdsMap.computeIfAbsent(dim, k -> new ArrayList(16));
                hasReqIds.addAll(reqIds);
            }
        }
        cache.put(this.lockCacheKey, lockKeyReqIdsMap);
        cache.put(scanInvTableTimeKey, (Object)TimeServiceHelper.now().getTime());
    }

    private Comparator<String> getComparator(final Map<String, Long> reqIdOpTimesMap) {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Long oneOpTime = (Long)reqIdOpTimesMap.get(o1);
                Long otherOpTime = (Long)reqIdOpTimesMap.get(o2);
                oneOpTime = oneOpTime == null ? Long.valueOf(0L) : oneOpTime;
                Long l = otherOpTime = otherOpTime == null ? Long.valueOf(0L) : otherOpTime;
                if (oneOpTime > otherOpTime) {
                    return 1;
                }
                if (oneOpTime < otherOpTime) {
                    return -1;
                }
                return 0;
            }
        };
        return comparator;
    }

    private IAppCache getAppCache() {
        return AppCache.get((String)"cal");
    }

    private Map<String, List<String>> getLockKeyReqIdsMap() {
        IAppCache cache = this.getAppCache();
        Map lockKeyOpTimesMap = (Map)cache.get(this.lockCacheKey, Map.class);
        lockKeyOpTimesMap = lockKeyOpTimesMap == null ? new HashMap(16) : lockKeyOpTimesMap;
        return lockKeyOpTimesMap;
    }

    public void releaseLockByBizId(Set<String> reqIds, Set<Long> bizBillIds) {
        List<String> curLockKeys = new CalLockKeyHelper().getCostRecBillLockKeyListByBizBill(bizBillIds);
        this.releaseLock(new HashSet<String>(curLockKeys), reqIds);
    }

    public void releaseLock(Set<String> lockKeys, Set<String> reqIds) {
        if (lockKeys.isEmpty()) {
            return;
        }
        try (DLock dlock = DLock.createReentrant((String)(this.lockCacheKey + CacheKeyUtil.getAcctId()), (String)"BizFinIntOrderRedisLock-release");){
            dlock.lock();
            Map<String, List<String>> lockKeyReqIdMap = this.getLockKeyReqIdsMap();
            for (String lockKey : lockKeys) {
                List<String> curReqIds = lockKeyReqIdMap.get(lockKey);
                if (curReqIds == null || curReqIds.isEmpty()) continue;
                Iterator<String> iterator = curReqIds.iterator();
                int count = 0;
                while (iterator.hasNext()) {
                    String curReqId = iterator.next();
                    if (reqIds.contains(curReqId)) {
                        iterator.remove();
                        ++count;
                    }
                    if (count < reqIds.size()) continue;
                    break;
                }
                if (!curReqIds.isEmpty()) continue;
                lockKeyReqIdMap.remove(lockKey);
            }
            IAppCache cache = this.getAppCache();
            cache.put(this.lockCacheKey, lockKeyReqIdMap);
        }
    }
}

