/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.builder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cal.common.helper.CalBalanceModelHelper;

public class CalBalanceBuilder {
    public static Map<String, Object> createOneCalBalance(DynamicObject initBill, DynamicObject entry, long balId, boolean isStd) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        DynamicObject costAccount = initBill.getDynamicObject("costaccount");
        Date bizDate = initBill.getDate("bizdate");
        DynamicObject startPeriod = initBill.getDynamicObject("period");
        DynamicObject balanceInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance");
        balanceInfo.set("costaccount", (Object)costAccount);
        balanceInfo.set("accsys", (Object)costAccount.getDynamicObject("calsystem"));
        balanceInfo.set("calorg", initBill.get("calorg"));
        balanceInfo.set("currency", initBill.get("localcurrency"));
        DynamicObject calPolicy = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_calpolicy", (String)"id,number,currency,currency.id,periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccount.getLong("calpolicy.id"))});
        balanceInfo.set("calpolicy", (Object)calPolicy);
        balanceInfo.set("periodid", (Object)startPeriod);
        balanceInfo.set("period", (Object)0);
        balanceInfo.set("endperiod", (Object)999999);
        balanceInfo.set("year", (Object)startPeriod.getInt("periodyear"));
        balanceInfo.set("month", (Object)startPeriod.getInt("periodnumber"));
        balanceInfo.set("bizdate", (Object)bizDate);
        balanceInfo.set("isstandardcost", (Object)costAccount.getBoolean("enablestandardcost"));
        balanceInfo.set("id", (Object)balId);
        Set dimFieldSet = CalBalanceModelHelper.getDimField();
        for (String field : dimFieldSet) {
            Object value = entry.get(field);
            if (value instanceof DynamicObject) {
                value = ((DynamicObject)value).getPkValue();
                balanceInfo.set(field + "_id", value);
                continue;
            }
            balanceInfo.set(field, value);
        }
        balanceInfo.set("baseunit", entry.get("baseunit"));
        balanceInfo.set("periodbeginqty", (Object)entry.getBigDecimal("baseqty"));
        balanceInfo.set("periodendqty", (Object)entry.getBigDecimal("baseqty"));
        balanceInfo.set("yearinqty", (Object)entry.getBigDecimal("yearinqty"));
        balanceInfo.set("yearissueqty", (Object)entry.getBigDecimal("yearissueqty"));
        balanceInfo.set("calrange", entry.get("calrange"));
        balanceInfo.set("accounttype", entry.get("accounttype"));
        balanceInfo.set("caldimension", entry.get("caldimension"));
        BigDecimal amount = entry.getBigDecimal("amount");
        BigDecimal yearincost = entry.getBigDecimal("yearincost");
        BigDecimal yearissuecost = entry.getBigDecimal("yearissuecost");
        if (isStd) {
            BigDecimal costdiff = entry.getBigDecimal("costdiff");
            BigDecimal yearincostdiff = entry.getBigDecimal("yearincostdiff");
            BigDecimal yearissuecostdiff = entry.getBigDecimal("yearissuecostdiff");
            balanceInfo.set("periodbegincostdiff", (Object)costdiff);
            balanceInfo.set("beginstandardcost", (Object)amount);
            balanceInfo.set("periodbeginactualcost", (Object)amount.add(costdiff));
            balanceInfo.set("periodendcostdiff", (Object)costdiff);
            balanceInfo.set("periodendstandardcost", (Object)amount);
            balanceInfo.set("periodendactualcost", (Object)amount.add(costdiff));
            balanceInfo.set("yearincostdiff", (Object)yearincostdiff);
            balanceInfo.set("yearinstandradcost", (Object)yearincost);
            balanceInfo.set("yearinactualcost", (Object)yearincost.add(yearincostdiff));
            balanceInfo.set("yearissuecostdiff", (Object)yearissuecostdiff);
            balanceInfo.set("yearissuestandradcost", (Object)yearissuecost);
            balanceInfo.set("yearissueactualcost", (Object)yearissuecost.add(yearissuecostdiff));
        } else {
            balanceInfo.set("periodbeginactualcost", (Object)amount);
            balanceInfo.set("periodendactualcost", (Object)amount);
            balanceInfo.set("yearinactualcost", (Object)yearincost);
            balanceInfo.set("yearissueactualcost", (Object)yearissuecost);
        }
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        int subEntrySize = subEntryColl.size();
        if (subEntrySize == 0) {
            return resultMap;
        }
        ArrayList<DynamicObject> calDetailList = new ArrayList<DynamicObject>(subEntrySize);
        for (DynamicObject subEntry : subEntryColl) {
            DynamicObject calDetail = BusinessDataServiceHelper.newDynamicObject((String)"cal_balance_detail");
            calDetail.set("balid", (Object)balId);
            calDetail.set("costelement", subEntry.get("costelement"));
            calDetail.set("costsubelement", subEntry.get("costsubelement"));
            BigDecimal subBaseqty = subEntry.getBigDecimal("sub_baseqty");
            BigDecimal subAmount = subEntry.getBigDecimal("sub_amount");
            BigDecimal subYearincost = subEntry.getBigDecimal("sub_yearincost");
            BigDecimal subYearissuecost = subEntry.getBigDecimal("sub_yearissuecost");
            calDetail.set("periodbeginqty", (Object)subBaseqty);
            calDetail.set("periodendqty", (Object)subBaseqty);
            calDetail.set("yearinqty", (Object)subEntry.getBigDecimal("sub_yearinqty"));
            calDetail.set("yearissueqty", (Object)subEntry.getBigDecimal("sub_yearissueqty"));
            if (isStd) {
                BigDecimal subCostdiff = subEntry.getBigDecimal("sub_costdiff");
                BigDecimal subYearincostdiff = subEntry.getBigDecimal("sub_yearincostdiff");
                BigDecimal subYearissuecostdiff = subEntry.getBigDecimal("sub_yearissuecostdiff");
                calDetail.set("beginstandardcost", (Object)subAmount);
                calDetail.set("periodbeginactualcost", (Object)subAmount.add(subCostdiff));
                calDetail.set("periodbegincostdiff", (Object)subCostdiff);
                calDetail.set("periodendstandardcost", (Object)subAmount);
                calDetail.set("periodendactualcost", (Object)subAmount.add(subCostdiff));
                calDetail.set("periodendcostdiff", (Object)subCostdiff);
                calDetail.set("yearinstandradcost", (Object)subYearincost);
                calDetail.set("yearinactualcost", (Object)subYearincost.add(subYearincostdiff));
                calDetail.set("yearincostdiff", (Object)subYearincostdiff);
                calDetail.set("yearissuestandradcost", (Object)subYearissuecost);
                calDetail.set("yearissueactualcost", (Object)subYearissuecost.add(subYearissuecostdiff));
                calDetail.set("yearissuecostdiff", (Object)subYearissuecostdiff);
            } else {
                calDetail.set("periodbeginactualcost", (Object)subAmount);
                calDetail.set("periodendactualcost", (Object)subAmount);
                calDetail.set("yearinactualcost", (Object)subYearincost);
                calDetail.set("yearissueactualcost", (Object)subYearissuecost);
            }
            calDetailList.add(calDetail);
        }
        resultMap.put("cal_balance_detail", calDetailList);
        resultMap.put("cal_balance", balanceInfo);
        return resultMap;
    }

    public static Map<String, Object> createOneStdBalance(DynamicObject initBill, DynamicObject entry, long calId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        if (CalBalanceModelHelper.isNewBalance()) {
            return resultMap;
        }
        DynamicObject costAccount = initBill.getDynamicObject("costaccount");
        DynamicObject startPeriod = initBill.getDynamicObject("period");
        DynamicObject balanceInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_purpricediff");
        balanceInfo.set("costaccount", (Object)costAccount);
        balanceInfo.set("accsys", (Object)costAccount.getDynamicObject("calsystem"));
        balanceInfo.set("calorg", initBill.get("calorg"));
        DynamicObject calPolicy = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_calpolicy", (String)"id,number,currency,currency.id,periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccount.getLong("calpolicy.id"))});
        balanceInfo.set("calpolicy", (Object)calPolicy);
        balanceInfo.set("periodid", (Object)startPeriod);
        balanceInfo.set("period", (Object)0);
        balanceInfo.set("endperiod", (Object)999999);
        balanceInfo.set("year", (Object)startPeriod.getInt("periodyear"));
        balanceInfo.set("month", (Object)startPeriod.getInt("periodnumber"));
        balanceInfo.set("id", (Object)calId);
        Set dimFieldSet = CalBalanceModelHelper.getDimField();
        for (String field : dimFieldSet) {
            balanceInfo.set(field, entry.get(field));
        }
        balanceInfo.set("createtype", entry.get("createtype"));
        balanceInfo.set("periodbegincostdiff", entry.get("costdiff"));
        balanceInfo.set("periodendcostdiff", entry.get("costdiff"));
        resultMap.put("cal_balance", balanceInfo);
        DynamicObjectCollection subEntryColl = entry.getDynamicObjectCollection("subentryentity");
        int subEntrySize = subEntryColl.size();
        if (subEntrySize == 0) {
            return resultMap;
        }
        ArrayList<DynamicObject> stdDetailList = new ArrayList<DynamicObject>(subEntrySize);
        for (DynamicObject subEntry : subEntryColl) {
            DynamicObject stdDetail = BusinessDataServiceHelper.newDynamicObject((String)"cal_purpricediff_detail");
            stdDetail.set("balid", (Object)calId);
            BigDecimal subCostdiff = subEntry.getBigDecimal("sub_costdiff");
            stdDetail.set("periodbegincostdiff", (Object)subCostdiff);
            stdDetail.set("periodendcostdiff", (Object)subCostdiff);
            stdDetail.set("costelement", subEntry.get("costelement"));
            stdDetail.set("costsubelement", subEntry.get("costsubelement"));
            stdDetailList.add(stdDetail);
        }
        resultMap.put("cal_purpricediff_detail", stdDetailList);
        return resultMap;
    }
}

