/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.builder;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.cal.business.process.inner.CalBillInfo;
import kd.fi.cal.business.process.inner.Field;
import kd.fi.cal.business.process.inner.FieldMappingResult;

public class CreateCostRecordHelper {
    public static FieldMappingResult getFieldMapping(DynamicObject rule, String calBillNumber, MainEntityType bizbillentitytype, CalBillInfo calBillInfo, String bizbillentrykey) {
        FieldMappingResult result = new FieldMappingResult();
        for (DynamicObject ruleEntry : rule.getDynamicObjectCollection("fieldmap")) {
            String bizFieldName = ruleEntry.getString("sourcefield");
            if (StringUtils.isEmpty((String)bizFieldName)) continue;
            String calFieldName = ruleEntry.getString("calfield");
            IDataEntityProperty calEntity = calBillInfo.getType().findProperty(calFieldName);
            IDataEntityProperty bizEntity = bizbillentitytype.findProperty(bizFieldName.split("\\.")[0]);
            if (calEntity == null || bizEntity == null) continue;
            IDataEntityType parentyCalEntity = calEntity.getParent();
            IDataEntityType parentBizEntity = bizEntity.getParent();
            if (parentyCalEntity instanceof LinkEntryType || parentBizEntity instanceof LinkEntryType) continue;
            Field bizField = null;
            Field calField = parentyCalEntity instanceof EntryType ? new Field(calFieldName, true, calBillInfo.getEntrykey(), calEntity) : new Field(calFieldName, false, null, calEntity);
            bizField = parentBizEntity instanceof SubEntryType ? new Field(bizFieldName, true, bizbillentrykey + "." + parentBizEntity.getName(), bizEntity) : (parentBizEntity instanceof EntryType ? new Field(bizFieldName, true, bizbillentrykey, bizEntity) : new Field(bizFieldName, false, null, bizEntity));
            if (calField.getTotalkey().equals(calBillInfo.getEntrykey() + ".owner")) {
                result.setOwnerField(bizField);
            }
            if (calField.getTotalkey().equals(calBillInfo.getEntrykey() + ".companyorg")) {
                result.setCalOrgField(bizField);
            }
            result.addMapping(calField, bizField);
        }
        if (!result.hasOwnerField()) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u6620\u5c04\u89c4\u5219\u6ca1\u6709\u914d\u7f6e\u8d27\u4e3b\u5b57\u6bb5\u3002", (String)"SyncBizBill4AuditServiceProcess_5", (String)"fi-cal-business", (Object[])new Object[0]), calBillNumber);
            throw new KDBizException(msg);
        }
        return result;
    }

    public static String getBizBillSelector(Collection<Field> bizFields, String bizbillentrykey, String bizbillentityname) {
        StringBuilder bizSelectorsSb = new StringBuilder();
        for (Field bizField : bizFields) {
            bizSelectorsSb.append(bizField.getTotalkey()).append(',');
        }
        bizSelectorsSb.setLength(bizSelectorsSb.length() - 1);
        String fields = bizSelectorsSb.toString();
        if (!fields.contains(bizbillentrykey + ".id")) {
            fields = bizbillentrykey + ".id," + fields;
        }
        if (!"im_initbill".equals(bizbillentityname)) {
            fields = "id," + fields;
        }
        return fields;
    }
}

