/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.billgroup;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cal.common.helper.PeriodHelper;
import kd.fi.cal.common.util.CommonUtils;

public class AccGroupUpdateHelper {
    private static Log log = LogFactory.getLog(AccGroupUpdateHelper.class);
    private static final String QUERY_NOTBEFOREPERIOD_COSTACCOUNT_SQL = "select distinct fcostaccountid from t_cal_atgrouprecord_entry where fisbeforeperiod = '0' and fbookdate is null";
    private static final String GROUP_ENTRY_UPDATESQL = "update t_cal_atgrouprecord_entry set fbizbillid = ?,fcalbillid=?,fbillno=?,fbookdate=?,fownerid=?,fbaseqty=?,fislastentry=? where fentryid = ?";
    private static final String DESTBOOKDATE_UPDATESQL = "update t_cal_accountgrouprecord set fdestbookdate = ? where fid = ?";
    private static final String GROUP_VALUE_UPDATESQL = "update t_cal_accountgrouprecord set fgroupvalue = ? where fid = ?";
    private static final int BATCH_SIZE = 100000;

    public static void updateCostAccountGroupRecord() {
        try (AlgoContext context = Algo.newContext();){
            Object billno;
            HashSet<Long> costAccountIds = new HashSet<Long>(16);
            try (DataSet groupRecordPeriodDS = DB.queryDataSet((String)AccGroupUpdateHelper.class.getName(), (DBRoute)CommonUtils.getCalDBRouteKey(), (String)QUERY_NOTBEFOREPERIOD_COSTACCOUNT_SQL);){
                for (Row row : groupRecordPeriodDS) {
                    costAccountIds.add(row.getLong("fcostaccountid"));
                }
            }
            if (costAccountIds.isEmpty()) {
                return;
            }
            ArrayList<OrmInput> costRecordList = new ArrayList<OrmInput>(16);
            Map currentPeriods = PeriodHelper.getSysPeriods(costAccountIds);
            for (Map.Entry entry : currentPeriods.entrySet()) {
                QFilter filter = new QFilter("costaccount", "=", entry.getKey());
                if (entry.getValue() != null) {
                    filter.and("bookdate", ">=", (Object)((DynamicObject)entry.getValue()).getDate("begindate"));
                }
                OrmInput input = new OrmInput(AccGroupUpdateHelper.class.getName(), "cal_costrecord", "bizbillid,calbillid,billno,bookdate,entry.id as costrecordentryid,entry.owner as owner,entry.baseqty as baseqty,entry.islastentry as islastentry", filter.toArray());
                costRecordList.add(input);
                QFilter filter2 = new QFilter("costaccount", "=", entry.getKey());
                filter2.and("isinitbill", "=", (Object)true);
                OrmInput input2 = new OrmInput(AccGroupUpdateHelper.class.getName(), "cal_costrecord", "bizbillid,calbillid,billno,bookdate,entry.id as costrecordentryid,entry.owner as owner,entry.baseqty as baseqty,entry.islastentry as islastentry", filter2.toArray());
                costRecordList.add(input2);
            }
            DataSet costRecordDS = Algo.create((String)AccGroupUpdateHelper.class.getName()).createDataSet(costRecordList.toArray(new Input[costRecordList.size()]));
            QFilter gFilter = new QFilter("entryentity.isbeforeperiod", "=", (Object)"0");
            DataSet groupBillRecordDS = QueryServiceHelper.queryDataSet((String)AccGroupUpdateHelper.class.getName(), (String)"cal_account_grouprecord", (String)"entryentity.id as entryid,entryentity.costrecordentryid as costrecordentryid", (QFilter[])gFilter.toArray(), null);
            DataSet dataSet = groupBillRecordDS.join(costRecordDS, JoinType.INNER).on("costrecordentryid", "costrecordentryid").select(new String[]{"entryid"}, new String[]{"bizbillid", "calbillid", "billno", "bookdate", "owner", "baseqty", "islastentry"}).finish();
            ArrayList<Object[]> updateParamsList = new ArrayList<Object[]>(100000);
            for (Row row : dataSet) {
                Long entryid = row.getLong("entryid");
                Long bizbillid = row.getLong("bizbillid");
                Long calbillid = row.getLong("calbillid");
                billno = row.getString("billno");
                Date bookdate = row.getDate("bookdate");
                Long owner = row.getLong("owner");
                BigDecimal baseqty = row.getBigDecimal("baseqty");
                boolean islastentry = row.getBoolean("islastentry");
                updateParamsList.add(new Object[]{bizbillid, calbillid, billno, bookdate, owner, baseqty, islastentry, entryid});
            }
            Lists.partition(updateParamsList, (int)100000).forEach(list -> DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)GROUP_ENTRY_UPDATESQL, (List)list));
            QFilter atFilter = new QFilter("groupvalue", "=", (Object)" ");
            HashMap<Long, Set> biz2AtMap = new HashMap<Long, Set>(16);
            HashSet<Long> bizIds = new HashSet<Long>(16);
            ArrayList<OrmInput> inputs = new ArrayList<OrmInput>(16);
            DataSet ds = QueryServiceHelper.queryDataSet((String)AccGroupUpdateHelper.class.getName(), (String)"cal_account_grouprecord", (String)"id,bizgrouprecordid", (QFilter[])atFilter.toArray(), null);
            billno = null;
            try {
                for (Row row : ds) {
                    Long id = row.getLong("id");
                    Long bizgrouprecordid = row.getLong("bizgrouprecordid");
                    Set ids = biz2AtMap.computeIfAbsent(bizgrouprecordid, k -> new HashSet(4));
                    ids.add(id);
                    bizIds.add(bizgrouprecordid);
                    if (bizIds.size() < 100000) continue;
                    QFilter bizFilter = new QFilter("id", "in", bizIds);
                    OrmInput input = new OrmInput(AccGroupUpdateHelper.class.getName(), "cal_groupbillrecord", "id,groupvalue", bizFilter.toArray());
                    inputs.add(input);
                    bizIds = new HashSet(100000);
                }
            }
            catch (Throwable throwable) {
                billno = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (billno != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)billno).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            if (!bizIds.isEmpty()) {
                QFilter bizFilter = new QFilter("id", "in", bizIds);
                OrmInput input = new OrmInput(AccGroupUpdateHelper.class.getName(), "cal_groupbillrecord", "id,groupvalue", bizFilter.toArray());
                inputs.add(input);
            }
            if (inputs.isEmpty()) {
                return;
            }
            ArrayList<Object[]> params = new ArrayList<Object[]>(100000);
            DataSet ds2 = Algo.create((String)AccGroupUpdateHelper.class.getName()).createDataSet(inputs.toArray(new Input[0]));
            Object object = null;
            try {
                for (Row row : ds2) {
                    Long bizId = row.getLong("id");
                    String groupvalue = row.getString("groupvalue");
                    Set atIds = (Set)biz2AtMap.get(bizId);
                    if (atIds == null || atIds.isEmpty()) continue;
                    for (Long atId : atIds) {
                        params.add(new Object[]{groupvalue, atId});
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds2 != null) {
                    if (object != null) {
                        try {
                            ds2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds2.close();
                    }
                }
            }
            Lists.partition(params, (int)100000).forEach(list -> DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)GROUP_VALUE_UPDATESQL, (List)list));
        }
        catch (Throwable e) {
            log.error("\u5347\u7ea7\u8d26\u7c3f\u7ea7\u6210\u7ec4\u5173\u7cfb\u51fa\u73b0\u5f02\u5e38", e);
            throw e;
        }
    }
}

