/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.billgroup;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.calculate.billgroup.CostAccountGroupRecordHelper;
import kd.fi.cal.business.calculate.billgroup.GroupRecord;
import kd.fi.cal.common.helper.PeriodHelper;

public class AccountGroupRecordHelper {
    private Set<Long> allValidBizBillids;
    private List<DynamicObject> groupBillRecords;
    private Set<Long> isReturnBillSetting = null;
    public static final int BATCH_SIZE = 100000;

    public AccountGroupRecordHelper(Set<Long> allValidBizBillids, List<DynamicObject> groupBillRecords) {
        this.allValidBizBillids = allValidBizBillids;
        this.groupBillRecords = groupBillRecords;
        this.isReturnBillSetting = AccountGroupRecordHelper.getIsReturnBillGroupBillSetting();
    }

    public void save() {
        DataSet groupBillRecordDS = this.getGroupBillRecordDS(this.groupBillRecords);
        DataSet costRecordDS = this.getCostRecordDS(this.allValidBizBillids);
        List<DynamicObject> recordObjList = this.createCostAccountGroupRecord(groupBillRecordDS, costRecordDS);
        this.saveCostGroupRecord(recordObjList);
    }

    public static Set<Long> getIsReturnBillGroupBillSetting() {
        HashSet<Long> isReturnBillSettings = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (String)"cal_billgroupsetting", (String)"id", (QFilter[])new QFilter("isreturnbill", "=", (Object)true).toArray(), null);){
            for (Row row : dataSet) {
                isReturnBillSettings.add(row.getLong("id"));
            }
        }
        return isReturnBillSettings;
    }

    private DataSet getGroupBillRecordDS(List<DynamicObject> groupBillRecords) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DateType.LongType), new Field("groupsettingtype", (DataType)DateType.StringType), new Field("groupsetting", (DataType)DateType.LongType), new Field("costcolumn", (DataType)DateType.StringType), new Field("costfields", (DataType)DateType.StringType), new Field("groupvalue", (DataType)DateType.StringType), new Field("iscompleted", (DataType)DateType.BooleanType), new Field("updatetime", (DataType)DateType.DateType), new Field("type", (DataType)DateType.StringType), new Field("calentryid", (DataType)DateType.LongType), new Field("baseqty", (DataType)DateType.BigDecimalType), new Field("ischargeoffed", (DataType)DateType.BooleanType), new Field("occupiedqty", (DataType)DateType.BigDecimalType), new Field("weight", (DataType)DateType.BigDecimalType), new Field("groupno", (DataType)DateType.LongType)});
        DataSetBuilder groupBillRecordBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(rowMeta);
        for (DynamicObject record : groupBillRecords) {
            Long bizgrouprecordid;
            Long groupBillId = record.getLong("id");
            if (record.getDataEntityType().getName().equals("cal_account_grouprecord") && (bizgrouprecordid = Long.valueOf(record.getLong("bizgrouprecordid"))) != null && Long.compare(bizgrouprecordid, 0L) != 0) {
                groupBillId = bizgrouprecordid;
            }
            String groupsettingtype = record.getString("groupsettingtype");
            Long groupsetting = record.getLong("groupsetting_id");
            String costcolumn = record.getString("costcolumn");
            String costfields = record.getString("costfields");
            String groupvalue = record.getString("groupvalue");
            boolean iscompleted = record.getBoolean("iscompleted");
            Date updatetime = record.getDate("updatetime");
            DynamicObjectCollection entryCols = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCols) {
                String type = entry.getString("type");
                Long calEntryid = entry.getLong("calentryid");
                BigDecimal baseqty = entry.getBigDecimal("baseqty");
                Boolean ischargeoffed = entry.getBoolean("ischargeoffed");
                BigDecimal occupiedqty = entry.getBigDecimal("occupiedqty");
                BigDecimal weight = entry.getBigDecimal("weight");
                Long groupno = entry.getLong("groupno");
                groupBillRecordBuilder.append(new Object[]{groupBillId, groupsettingtype, groupsetting, costcolumn, costfields, groupvalue, iscompleted, updatetime, type, calEntryid, baseqty, ischargeoffed, occupiedqty, weight, groupno});
            }
        }
        DataSet groupBillRecordDS = groupBillRecordBuilder.build();
        return groupBillRecordDS;
    }

    private DataSet getCostRecordDS(Set<Long> allValidBizBillids) {
        QFilter recordFilter = new QFilter("issplitcreate", "=", (Object)false);
        recordFilter.and("costaccount.status", "=", (Object)Character.valueOf('C'));
        recordFilter.and("costaccount.enable", "=", (Object)true);
        recordFilter.and("bizbillid", "in", allValidBizBillids);
        DataSet costRecordDS = QueryServiceHelper.queryDataSet((String)CostAccountGroupRecordHelper.class.getName(), (String)"cal_costrecord", (String)"costaccount,billno,costaccount.booktype as booktype,costaccount.booktype.isingroup as isingroup,bookdate,period,bizbillid,calbillid,entry.id as entryid,entry.calentryid as calentryid,entry.material as materialid,entry.accounttype as accounttype,entry.owner as owner,entry.islastentry as islastentry", (QFilter[])recordFilter.toArray(), null);
        return costRecordDS;
    }

    private List<DynamicObject> createCostAccountGroupRecord(DataSet groupBillRecordDS, DataSet costRecordDS) {
        DataSet accountGroupRecordSet = groupBillRecordDS.join(costRecordDS, JoinType.INNER).on("calentryid", "calentryid").select(new String[]{"id", "groupsettingtype", "groupsetting", "costfields", "costcolumn", "iscompleted", "updatetime", "groupvalue", "type", "calentryid", "baseqty", "ischargeoffed", "weight", "occupiedqty", "groupno"}, new String[]{"costaccount", "billno", "booktype", "isingroup", "bookdate", "period", "bizbillid", "calbillid", "entryid", "materialid", "accounttype", "owner", "islastentry"}).finish().orderBy(new String[]{"id", "booktype"});
        HashMap<String, GroupRecord> recordMap = new HashMap<String, GroupRecord>();
        HashMap<Long, Long> currentPeriodCache = new HashMap<Long, Long>();
        while (accountGroupRecordSet.hasNext()) {
            Row row = accountGroupRecordSet.next();
            Long bizGroupId = row.getLong("id");
            Long booktype = row.getLong("booktype");
            Long materialid = row.getLong("materialid");
            String groupvalue = row.getString("groupvalue");
            String key = bizGroupId + "&" + booktype;
            GroupRecord record = (GroupRecord)recordMap.get(key);
            if (record == null) {
                record = new GroupRecord(bizGroupId, booktype, row.getString("groupsettingtype"), row.getLong("groupsetting"), row.getDate("updatetime"), row.getBoolean("iscompleted"), row.getBoolean("isingroup"), row.getString("costcolumn"), row.getString("costfields"), groupvalue);
                recordMap.put(key, record);
            }
            Long costAccountId = row.getLong("costaccount");
            Long period = row.getLong("period");
            Long currentPeriod = (Long)currentPeriodCache.get(costAccountId);
            if (currentPeriod == null) {
                DynamicObject currentPeriodObj = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                if (currentPeriodObj == null) {
                    currentPeriodCache.put(costAccountId, 0L);
                } else {
                    currentPeriod = currentPeriodObj.getLong("id");
                    currentPeriodCache.put(costAccountId, currentPeriod);
                }
            }
            Long calentryid = row.getLong("calentryid");
            Long entryid = row.getLong("entryid");
            String type = row.getString("type");
            BigDecimal baseqty = row.getBigDecimal("baseqty");
            Boolean ischargeoffed = row.getBoolean("ischargeoffed");
            BigDecimal weight = row.getBigDecimal("weight");
            BigDecimal occupiedqty = row.getBigDecimal("occupiedqty");
            Long groupno = row.getLong("groupno");
            String accounttype = row.getString("accounttype");
            Long groupSettingId = row.getLong("groupsetting");
            Long bizBillId = row.getLong("bizbillid");
            Long calBillid = row.getLong("calbillid");
            String billno = row.getString("billno");
            Date bookdate = row.getDate("bookdate");
            String islastentry = row.getString("islastentry");
            Long owner = row.getLong("owner");
            if ("0".equals(type)) {
                record.addSrcEntry(costAccountId, calentryid, entryid, period, materialid, period.compareTo(currentPeriod) < 0, baseqty, ischargeoffed, weight, occupiedqty, groupno, bizBillId, calBillid, billno, bookdate, islastentry, owner);
                continue;
            }
            if ("D".equals(accounttype) && this.isReturnBillSetting.contains(groupSettingId)) continue;
            record.setDestBookDate(bookdate);
            record.addTargetEntry(costAccountId, calentryid, entryid, period, materialid, period.compareTo(currentPeriod) < 0, baseqty, ischargeoffed, weight, occupiedqty, groupno, bizBillId, calBillid, billno, bookdate, islastentry, owner);
        }
        ArrayList<DynamicObject> recordObjList = new ArrayList<DynamicObject>(recordMap.size());
        for (GroupRecord record : recordMap.values()) {
            if (!record.isValid()) continue;
            recordObjList.add(record.obj);
        }
        return recordObjList;
    }

    private List<DynamicObject> saveCostGroupRecord(List<DynamicObject> recordObjList) {
        if (recordObjList == null || recordObjList.isEmpty()) {
            return recordObjList;
        }
        HashSet<Long> bizGroupIds = new HashSet<Long>(16);
        for (DynamicObject groupBillRecord : recordObjList) {
            bizGroupIds.add(groupBillRecord.getLong("bizgrouprecordid"));
        }
        QFilter deleteFilter = new QFilter("bizgrouprecordid", "in", bizGroupIds);
        DeleteServiceHelper.delete((String)"cal_account_grouprecord", (QFilter[])deleteFilter.toArray());
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(100000);
        Iterator<DynamicObject> it = recordObjList.iterator();
        while (it.hasNext()) {
            if (saveList.size() >= 100000) {
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
                saveList.clear();
            }
            saveList.add(it.next());
        }
        if (!saveList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
        }
        return recordObjList;
    }

    private Set<Long> getAllGroupCalBillIds(List<DynamicObject> recordObjList) {
        HashSet<Long> allGroupCalBillIds = new HashSet<Long>(16);
        for (DynamicObject record : recordObjList) {
            DynamicObjectCollection entryCols = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryCol : entryCols) {
                allGroupCalBillIds.add(entryCol.getLong("calbillid"));
            }
        }
        return allGroupCalBillIds;
    }
}

