/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cal.business.calculate.billgroup;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cal.business.autosort.graphmodel.GraphNodeManager;
import kd.fi.cal.common.constant.CalDbParamConstant;
import kd.fi.cal.common.helper.AccountingSysHelper;
import kd.fi.cal.common.helper.CalDbParamServiceHelper;
import kd.fi.cal.common.helper.CommonSettingHelper;
import kd.fi.cal.common.helper.IDGenerator;
import kd.fi.cal.common.lock.RedisBatchLock;
import kd.fi.cal.common.util.CommonUtils;

public class AutoSortServic {
    private static final Log logger = LogFactory.getLog(AutoSortServic.class);
    private static final String ALGOX_KEY = "kd.fi.cal.business.calculate.billgroup.AutoSortServic";
    private static final String UPDATE_SQL_BY_SRCKEY = "UPDATE T_CAL_COSTDOMAINGROUP SET FSORTID = ? WHERE FSDIMENSIONKEY = ?";
    private static final String UPDATE_SQL_BY_TARKEY = "UPDATE T_CAL_COSTDOMAINGROUP SET FSORTID = ? WHERE FTDIMENSIONKEY = ?";
    private static final String[] CONSTANT_DMS = new String[]{"id", "dimensionkey", "costaccount", "calrange", "dividebasis", "caldimension", "dividebasisval", "caldimensionval", "period", "material", "accounttype"};
    private int BATCH_SIZE = 5000;
    private static final long DEFUALT_GROUP_SEQ = 99999999L;
    private int expire_time = 30;
    private int autosort_batchsize = 300;
    private static final String REDIS_KEY = "cal_auto_sort";
    private static final String ALL_DMKEY = "all_dm_key";
    public static final String FI_REGION = "fi";
    public static final String SORT_QUEUE = "fi.cal.sortService";
    private IDGenerator idGenerator = new IDGenerator("t_cal_sortresult");
    private String[] divideBasis = CommonSettingHelper.getDivideBasis();
    private String[] calDimension = CommonSettingHelper.getCalDimension();
    private Set<Long> acctIds = null;
    private Set<Long> calOrgIds = null;

    public AutoSortServic() {
        this.BATCH_SIZE = this.getBatchSize();
        this.expire_time = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.AUTOSORT_REDIS_EXPIRE_TIME);
        this.autosort_batchsize = CalDbParamServiceHelper.getInteger((String)CalDbParamConstant.AUTOSORT_BATCHSIZE);
    }

    public void sortByAsync(Set<Long> costDomainGroupIds) {
        this.pushSortRequest(costDomainGroupIds);
    }

    public void sortByAsyncByAccountId(Set<Long> acctIds) {
        logger.info("\u6309\u8d26\u7c3f\u91cd\u5efa\u6210\u672c\u57df\u548c\u6392\u5e8f\u7ed3\u679c->{}", acctIds);
        Set allEnableAcctIds = AccountingSysHelper.getAllEnableAcctIds();
        if (allEnableAcctIds.size() <= 1) {
            logger.info("\u6309\u8d26\u7c3f\u91cd\u5efa\u6392\u5e8f\u7ed3\u679c\u4e14\u53ea\u6709\u4e00\u4e2a\u53ef\u7528\u8d26\u7c3f\uff0c\u8d70\u5168\u91cf\u6392\u5e8f->{}", acctIds);
            this.sortByAsync(null);
            return;
        }
        logger.info("AutoSortServic-\u5f00\u59cbpush\u961f\u5217-sortByAccountIdAsync");
        MessagePublisher pub = MQFactory.get().createSimplePublisher(FI_REGION, SORT_QUEUE);
        try (TXHandle txHandle = TX.required();){
            pub.publishInDbTranscation("cal", Collections.singletonMap("sortacctids", acctIds));
        }
        catch (Exception e) {
            logger.info("AutoSortServic-push\u961f\u5217-sortByAccountIdAsync\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getClass().getName());
            logger.error("AutoSortServic pushSortRequest", (Throwable)e);
            throw e;
        }
        finally {
            logger.info("AutoSortServic-\u7ed3\u675fpush\u961f\u5217-sortByAccountIdAsync");
            pub.close();
        }
    }

    public void sort(Set<Long> costDomainGroupIds) {
        logger.info("AutoSortServic_sort_costDomainGroupIds.size:" + costDomainGroupIds);
        Lists.partition(new ArrayList<Long>(costDomainGroupIds), (int)this.autosort_batchsize).forEach(list -> {
            try (RedisBatchLock batchLock = new RedisBatchLock(REDIS_KEY, this.expire_time, REDIS_KEY);){
                Set<Long> affectSortListIds = this.getAffectSortListIds(new HashSet<Long>((Collection<Long>)list));
                DataSet reSortCostDms = this.getReSortCostDms(affectSortListIds);
                reSortCostDms = reSortCostDms.union(this.getCurrSortCostDms(new HashSet<Long>((Collection<Long>)list)));
                this.doSort(reSortCostDms, Boolean.FALSE, batchLock);
            }
            catch (KDBizException kde) {
                logger.error("AutoSortServic.sort(java.util.Set<java.lang.Long>)", (Throwable)kde);
                throw kde;
            }
        });
    }

    public void sort() {
        try (RedisBatchLock batchLock = new RedisBatchLock(REDIS_KEY, this.expire_time, REDIS_KEY);){
            DataSet reSortCostDms = this.getCurrSortCostDms(null);
            this.doSort(reSortCostDms, Boolean.TRUE, batchLock);
        }
        catch (KDBizException kde) {
            logger.error("AutoSortServic sort()", (Throwable)kde);
            throw kde;
        }
    }

    public void sortByAcctIds(Set<Long> acctIds) {
        this.setAcctIds(acctIds);
        try (RedisBatchLock batchLock = new RedisBatchLock(REDIS_KEY, this.expire_time, REDIS_KEY);){
            DataSet reSortCostDms = this.getCurrSortCostDms(null);
            this.doSort(reSortCostDms, Boolean.TRUE, batchLock);
        }
        catch (KDBizException kde) {
            logger.error("AutoSortServic sortByAcctIds()", (Throwable)kde);
            throw kde;
        }
    }

    private Set<Long> getAffectSortListIds(Set<Long> costDomainGroupIds) {
        logger.info("getAffectSortListIds-begin");
        Long starTime = System.currentTimeMillis();
        HashSet<Long> affectSortListIds = new HashSet<Long>(16);
        if (costDomainGroupIds == null || costDomainGroupIds.isEmpty()) {
            return affectSortListIds;
        }
        QFilter filter = new QFilter("id", "in", costDomainGroupIds);
        DataSet costDmData = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.calculate.billgroup.AutoSortServic.getAffectSortListIds", (String)"cal_costdomaingroup", (String)"id,sdimension,tdimension", (QFilter[])filter.toArray(), null);
        HashSet<Long> dmKeys = new HashSet<Long>(16);
        dmKeys.add(1L);
        for (Row costDmInfo : costDmData) {
            dmKeys.add(costDmInfo.getLong("sdimension"));
            dmKeys.add(costDmInfo.getLong("tdimension"));
        }
        QFilter tarFilter = new QFilter("entryentity.dimension", "in", dmKeys);
        DataSet tarSortData = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.calculate.billgroup.AutoSortServic.getAffectSortListIds", (String)"cal_sortresult", (String)"sortlistid", (QFilter[])tarFilter.toArray(), null);
        for (Row tarSortInfo : tarSortData) {
            affectSortListIds.add(tarSortInfo.getLong("sortlistid"));
        }
        logger.info("getAffectSortListIds-end");
        Long endTime = System.currentTimeMillis();
        logger.info("getAffectSortListIds-time:" + (endTime - starTime) / 1000L + "s");
        return affectSortListIds;
    }

    private DataSet getReSortCostDms(Set<Long> affectSortListIds) {
        Long starTime = System.currentTimeMillis();
        logger.info("getReSortCostDms-begin");
        QFilter filter = new QFilter("sort", "in", affectSortListIds);
        DataSet tarSortData = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.calculate.billgroup.AutoSortServic.getReSortCostDms", (String)"cal_costdomaingroup", (String)"id,sdimension, tdimension,sdimensionkey, tdimensionkey,count,smaterial,tmaterial,issamematerial", (QFilter[])filter.toArray(), null);
        logger.info("getReSortCostDms-end");
        Long endTime = System.currentTimeMillis();
        logger.info("getReSortCostDms-time:" + (endTime - starTime) / 1000L + "s");
        return tarSortData;
    }

    private DataSet getCurrSortCostDms(Set<Long> costDomainGroupIds) {
        logger.info("getCurrSortCostDms-begin");
        Long starTime = System.currentTimeMillis();
        QFilter filter = null;
        if (costDomainGroupIds != null && !costDomainGroupIds.isEmpty()) {
            filter = new QFilter("id", "in", costDomainGroupIds);
        }
        if (this.isRebuildByAcctId()) {
            QFilter groupDomainAcctFilter = new QFilter("sdimension.costaccount", "in", this.acctIds);
            filter = filter == null ? groupDomainAcctFilter : filter.and(groupDomainAcctFilter);
        }
        DataSet tarSortData = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.calculate.billgroup.AutoSortServic.getReSortCostDms", (String)"cal_costdomaingroup", (String)"id,sdimension, tdimension,sdimensionkey,tdimensionkey,count,smaterial,tmaterial,issamematerial", (QFilter[])(filter == null ? null : filter.toArray()), null);
        logger.info("getCurrSortCostDms-end");
        Long endTime = System.currentTimeMillis();
        logger.info("getCurrSortCostDms-time:" + (endTime - starTime) / 1000L + "s");
        return tarSortData;
    }

    private void doSort(DataSet reSortCostDms, Boolean isAllSort, RedisBatchLock batchLock) {
        logger.info("doSort-begin");
        Long starTime = System.currentTimeMillis();
        Long maxId = 0L;
        if (isAllSort.booleanValue()) {
            QFilter sortF = null;
            if (this.isRebuildByAcctId()) {
                sortF = new QFilter("headcalorg", "in", this.calOrgIds);
                sortF.and("costaccount", "in", this.acctIds);
            }
            DynamicObject maxSort = QueryServiceHelper.queryOne((String)"cal_sortresult", (String)"max(id) as id", (QFilter[])new QFilter[]{sortF});
            maxId = maxSort.getLong("id");
        }
        DataSet sameMatDataCopy = reSortCostDms.copy().filter("issamematerial = false");
        HashSet<Long> diffMatIds = new HashSet<Long>(16);
        diffMatIds.add(1L);
        for (Row row : sameMatDataCopy) {
            diffMatIds.add(row.getLong("smaterial"));
            diffMatIds.add(row.getLong("tmaterial"));
        }
        QFilter sameMatFilter = new QFilter("smaterial", "not in", diffMatIds);
        sameMatFilter.and("tmaterial", "not in", diffMatIds);
        DataSet sameMatData = reSortCostDms.filter(sameMatFilter.toString()).orderBy(new String[]{"smaterial", "id"});
        QFilter differentMatFilter = new QFilter("smaterial", "in", diffMatIds);
        differentMatFilter.or("tmaterial", "in", diffMatIds);
        DataSet differentMatData = reSortCostDms.filter(differentMatFilter.toString()).orderBy(new String[]{"id"});
        if (isAllSort.booleanValue()) {
            HashSet<String> allSortDMKey = new HashSet<String>(1);
            if (this.isRebuildByAcctId()) {
                for (Long acctId : this.acctIds) {
                    allSortDMKey.add(String.valueOf(acctId));
                }
            } else {
                allSortDMKey.add(ALL_DMKEY);
            }
            batchLock.setLockKeys(allSortDMKey);
            batchLock.lock();
            Map lockFailIdMsgMap = batchLock.getLockFailIdMsgMap();
            if (!lockFailIdMsgMap.isEmpty()) {
                String erroMsg = ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u6392\u5e8f\u7ef4\u5ea6\uff0c\u540c\u5f53\u524d\u6392\u5e8f\u7ef4\u5ea6\u51b2\u7a81\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"AutoSortServic_1", (String)"fi-cal-business", (Object[])new Object[0]);
                ErrorCode errorCode = new ErrorCode("runingSort", erroMsg);
                throw new KDBizException(errorCode, new Object[0]);
            }
        }
        this.doSortByBatch(sameMatData, isAllSort, batchLock);
        this.doSortByNoBatch(differentMatData, isAllSort, batchLock);
        if (isAllSort.booleanValue()) {
            TXHandle tx = TX.requiresNew();
            Object object = null;
            try {
                QFilter filter = new QFilter("id", "<=", (Object)maxId);
                if (this.isRebuildByAcctId()) {
                    filter.and("headcalorg", "in", this.calOrgIds);
                    filter.and("costaccount", "in", this.acctIds);
                }
                DeleteServiceHelper.delete((String)"cal_sortresult", (QFilter[])new QFilter[]{filter});
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        logger.info("doSort-end");
        Long endTime = System.currentTimeMillis();
        logger.info("doSort-time:" + (endTime - starTime) / 1000L + "s");
    }

    private void doSortByBatch(DataSet reSortCostDms, Boolean isAllSort, RedisBatchLock batchLock) {
        logger.info("doSortByBatch-begin");
        Long starTime = System.currentTimeMillis();
        HashSet<String> sortDimensionKeys = new HashSet<String>(16);
        HashSet<Long> sortDimensionIds = new HashSet<Long>(16);
        GraphNodeManager<String> outManager = new GraphNodeManager<String>();
        int sortSize = 0;
        Long lastMatId = 0L;
        int sorMatSize = this.getBatchSize();
        for (Row costDmInfo : reSortCostDms) {
            if (lastMatId.compareTo(costDmInfo.getLong("smaterial")) != 0) {
                lastMatId = costDmInfo.getLong("smaterial");
                if (++sortSize > sorMatSize) {
                    this.doSortDetail(outManager, sortDimensionIds, sortDimensionKeys, isAllSort, batchLock);
                    outManager = new GraphNodeManager();
                    sortSize = 1;
                }
            }
            if (costDmInfo.getLong("count") > 0L) {
                outManager.addVector(costDmInfo.getString("sdimension"), costDmInfo.getString("tdimension"));
            }
            sortDimensionKeys.add(costDmInfo.getString("sdimensionkey"));
            sortDimensionKeys.add(costDmInfo.getString("tdimensionkey"));
            sortDimensionIds.add(costDmInfo.getLong("sdimension"));
            sortDimensionIds.add(costDmInfo.getLong("tdimension"));
        }
        if (sortSize > 0) {
            this.doSortDetail(outManager, sortDimensionIds, sortDimensionKeys, isAllSort, batchLock);
        }
        logger.info("doSortByBatch-end");
        Long endTime = System.currentTimeMillis();
        logger.info("doSortByBatch-time:" + (endTime - starTime) / 1000L + "s");
    }

    private void doSortByNoBatch(DataSet reSortCostDms, Boolean isAllSort, RedisBatchLock batchLock) {
        HashSet<String> sortDimensionKeys = new HashSet<String>(16);
        HashSet<Long> sortDimensionIds = new HashSet<Long>(16);
        GraphNodeManager<String> outManager = new GraphNodeManager<String>();
        for (Row costDmInfo : reSortCostDms) {
            String sdimension = costDmInfo.getString("sdimension");
            String tdimension = costDmInfo.getString("tdimension");
            if (costDmInfo.getLong("count") > 0L && !sdimension.equals(tdimension)) {
                outManager.addVector(sdimension, tdimension);
            }
            sortDimensionKeys.add(costDmInfo.getString("sdimensionkey"));
            sortDimensionKeys.add(costDmInfo.getString("tdimensionkey"));
            sortDimensionIds.add(costDmInfo.getLong("sdimension"));
            sortDimensionIds.add(costDmInfo.getLong("tdimension"));
        }
        this.doSortDetail(outManager, sortDimensionIds, sortDimensionKeys, isAllSort, batchLock);
    }

    private void doSortDetail(GraphNodeManager<String> outManager, Set<Long> sortDimensionIds, Set<String> sortDimensionKeys, Boolean isAllSort, RedisBatchLock batchLock) {
        if (sortDimensionIds == null || sortDimensionIds.isEmpty()) {
            return;
        }
        logger.info("doSortDetail-begin");
        Long starTime = System.currentTimeMillis();
        if (!isAllSort.booleanValue()) {
            batchLock.setLockKeys(sortDimensionKeys);
            batchLock.lock();
            Map lockFailIdMsgMap = batchLock.getLockFailIdMsgMap();
            if (!lockFailIdMsgMap.isEmpty()) {
                String erroMsg = ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u6392\u5e8f\u7ef4\u5ea6\uff0c\u540c\u5f53\u524d\u6392\u5e8f\u7ef4\u5ea6\u51b2\u7a81\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"AutoSortServic_1", (String)"fi-cal-business", (Object[])new Object[0]);
                ErrorCode errorCode = new ErrorCode("runingSort", erroMsg);
                throw new KDBizException(errorCode, new Object[0]);
            }
        }
        Map<Integer, List<String>> sortResultMap = outManager.groupSort();
        Map<String, Long> dmKeyAndSortListId = this.saveSort2DB(sortResultMap, isAllSort, sortDimensionIds);
        this.updateDmKey(dmKeyAndSortListId);
        sortDimensionIds.clear();
        sortDimensionKeys.clear();
        logger.info("doSortDetail-end");
        Long endTime = System.currentTimeMillis();
        logger.info("doSortDetail-time:" + (endTime - starTime) / 1000L + "s");
    }

    private Map<String, Long> saveSort2DB(Map<Integer, List<String>> sortResultMap, Boolean isAllSort, Set<Long> sortDimensionIds) {
        HashMap<String, Long> dmKeyAndSortListId = new HashMap<String, Long>(16);
        if (sortResultMap == null || sortResultMap.isEmpty()) {
            this.deleteSortResult(sortDimensionIds, "entryentity.dimension");
            return dmKeyAndSortListId;
        }
        HashSet<Long> sortKeys = new HashSet<Long>(16);
        for (Map.Entry<Integer, List<String>> sortList : sortResultMap.entrySet()) {
            for (String sortKey : sortList.getValue()) {
                sortKeys.add(Long.valueOf(sortKey));
            }
        }
        Map<String, Map<String, Object>> costDmInfoMap = this.getCostDmInfoMap(sortKeys);
        long[] sortListIds = DBServiceHelper.genLongIds((String)"cal_sortresult", (int)sortResultMap.size());
        int index = 0;
        HashSet<DynamicObject> saveSorts = new HashSet<DynamicObject>(16);
        for (Map.Entry<Integer, List<String>> sortList : sortResultMap.entrySet()) {
            ArrayList<DynamicObject> sortInfoList = new ArrayList<DynamicObject>(4);
            String lastHeadKey = null;
            DynamicObject lastSortInfo = null;
            Long groupno = this.idGenerator.getId();
            int groupseq = 1;
            Long sortId = sortListIds[index++];
            HashMap sortIdToKeys = new HashMap(16);
            for (String sortKey : sortList.getValue()) {
                Map<String, Object> currCostDmInfo = costDmInfoMap.get(sortKey);
                String headKey = this.getSortInfoKey(currCostDmInfo);
                if (lastHeadKey != null && lastHeadKey.equals(headKey)) {
                    this.addSortEntry(lastSortInfo, currCostDmInfo, dmKeyAndSortListId);
                } else {
                    DynamicObject sortInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_sortresult");
                    sortInfoList.add(sortInfo);
                    lastSortInfo = sortInfo;
                    lastHeadKey = headKey;
                    sortInfo.set("groupno", (Object)groupno);
                    sortInfo.set("groupseq", (Object)groupseq++);
                    sortInfo.set("headcalorg_id", currCostDmInfo.get("calorg"));
                    sortInfo.set("costaccount_id", currCostDmInfo.get("costaccount"));
                    sortInfo.set("calrange_id", currCostDmInfo.get("calrange"));
                    sortInfo.set("material_id", currCostDmInfo.get("material"));
                    sortInfo.set("period_id", currCostDmInfo.get("period"));
                    sortInfo.set("accounttype", currCostDmInfo.get("accounttype"));
                    sortInfo.set("sortlistid", (Object)sortId);
                    sortInfo.set("isloop", (Object)Character.valueOf('0'));
                    this.addSortEntry(sortInfo, currCostDmInfo, dmKeyAndSortListId);
                }
                if (sortIdToKeys.containsKey(sortId)) {
                    ((Set)sortIdToKeys.get(sortId)).add(headKey);
                    continue;
                }
                HashSet<String> headKeys = new HashSet<String>();
                headKeys.add(headKey);
                sortIdToKeys.put(sortId, headKeys);
            }
            for (DynamicObject sortInfo : sortInfoList) {
                if (((Set)sortIdToKeys.get(sortInfo.getLong("sortlistid"))).size() != 1) continue;
                sortInfo.set("groupno", (Object)-1);
                sortInfo.set("groupseq", (Object)99999999L);
            }
            saveSorts.addAll(sortInfoList);
        }
        if (saveSorts.size() > 0) {
            try (TXHandle tx = TX.requiresNew();){
                this.deleteOldSortResult(saveSorts, isAllSort, sortDimensionIds);
                Lists.partition(Arrays.asList(saveSorts.toArray(new DynamicObject[0])), (int)this.BATCH_SIZE).forEach(list -> SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0])));
            }
            saveSorts.clear();
        } else if (!sortDimensionIds.isEmpty()) {
            this.deleteSortResult(sortDimensionIds, "entryentity.dimension");
        }
        return dmKeyAndSortListId;
    }

    private void deleteOldSortResult(Set<DynamicObject> saveSorts, Boolean isAllSort, Set<Long> sortDimensionIds) {
        HashSet<Long> delDimIds = new HashSet<Long>(16);
        for (DynamicObject saveSort : saveSorts) {
            DynamicObjectCollection entryDycs = saveSort.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDyc : entryDycs) {
                Long dimId = entryDyc.getLong("dimension");
                delDimIds.add(dimId);
            }
        }
        delDimIds.addAll(sortDimensionIds);
        this.deleteSortResult(delDimIds, "entryentity.dimension");
    }

    private Map<String, Map<String, Object>> getCostDmInfoMap(Set<Long> sortKeys) {
        HashMap<String, Map<String, Object>> costDmInfoMap = new HashMap<String, Map<String, Object>>(16);
        QFilter srcFilter = new QFilter("id", "in", sortKeys);
        DataSet costDmData = QueryServiceHelper.queryDataSet((String)"kd.fi.cal.business.calculate.billgroup.AutoSortServic.saveSort2DB", (String)"cal_costdomain", (String)this.getCostDmFieldsStr(), (QFilter[])srcFilter.toArray(), null);
        for (Row row : costDmData) {
            if (costDmInfoMap.containsKey(row.getString("id"))) continue;
            HashMap<String, Object> costDomainGroupInfo = new HashMap<String, Object>(16);
            for (String field : this.getCostDmFields()) {
                costDomainGroupInfo.put(field, row.get(field));
            }
            costDmInfoMap.put(row.getString("id"), costDomainGroupInfo);
        }
        return costDmInfoMap;
    }

    private String getSortInfoKey(Map<String, Object> currCostDmInfo) {
        StringBuilder sortInfoKey = new StringBuilder();
        sortInfoKey.append(currCostDmInfo.get("costaccount")).append("@");
        sortInfoKey.append(currCostDmInfo.get("calorg")).append("@");
        sortInfoKey.append(currCostDmInfo.get("calrange")).append("@");
        sortInfoKey.append(currCostDmInfo.get("material")).append("@");
        sortInfoKey.append(currCostDmInfo.get("accounttype")).append("@");
        sortInfoKey.append(currCostDmInfo.get("period"));
        return sortInfoKey.toString();
    }

    private void addSortEntry(DynamicObject sortInfo, Map<String, Object> currCostDmInfo, Map<String, Long> dmKeyAndSortListId) {
        String dmField;
        int index;
        DynamicObjectCollection entrys = sortInfo.getDynamicObjectCollection("entryentity");
        int seq = entrys.size() + 1;
        DynamicObject entry = entrys.addNew();
        for (index = 0; index < this.divideBasis.length; ++index) {
            dmField = this.divideBasis[index];
            entry.set(dmField, currCostDmInfo.get(dmField));
        }
        for (index = 0; index < this.calDimension.length; ++index) {
            dmField = this.calDimension[index];
            entry.set(dmField, currCostDmInfo.get(dmField));
        }
        entry.set("dividebasis", currCostDmInfo.get("dividebasis"));
        entry.set("caldimension", currCostDmInfo.get("caldimension"));
        entry.set("dividebasisvalue", currCostDmInfo.get("dividebasisval"));
        entry.set("caldimensionvalue", currCostDmInfo.get("caldimensionval"));
        entry.set("dimension", currCostDmInfo.get("id"));
        entry.set("seq", (Object)seq);
        if (!dmKeyAndSortListId.containsKey(currCostDmInfo.get("dimensionkey"))) {
            dmKeyAndSortListId.put(currCostDmInfo.get("dimensionkey").toString(), sortInfo.getLong("sortlistid"));
        }
    }

    private void updateDmKey(Map<String, Long> dmKeyAndSortListId) {
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        for (Map.Entry<String, Long> dmKeyAndSortIdInfo : dmKeyAndSortListId.entrySet()) {
            updateParams.add(new Object[]{dmKeyAndSortIdInfo.getValue(), dmKeyAndSortIdInfo.getKey()});
        }
        if (updateParams.size() > 0) {
            Lists.partition(updateParams, (int)this.BATCH_SIZE).forEach(list -> {
                list.sort(new Comparator<Object[]>(){

                    @Override
                    public int compare(Object[] row1, Object[] row2) {
                        return ((String)row1[1]).compareTo((String)row2[1]);
                    }
                });
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)UPDATE_SQL_BY_SRCKEY, (List)list);
                DB.executeBatch((DBRoute)CommonUtils.getCalDBRouteKey(), (String)UPDATE_SQL_BY_TARKEY, (List)list);
            });
        }
    }

    private void deleteSortResult(Set<Long> sortDimensionIds, String conditionField) {
        HashSet<Long> tempSortDmIds = new HashSet<Long>(16);
        for (Long dmId : sortDimensionIds) {
            tempSortDmIds.add(dmId);
            if (tempSortDmIds.size() <= this.BATCH_SIZE) continue;
            QFilter filter = new QFilter(conditionField, "in", tempSortDmIds);
            DeleteServiceHelper.delete((String)"cal_sortresult", (QFilter[])filter.toArray());
            tempSortDmIds.clear();
        }
        if (!tempSortDmIds.isEmpty()) {
            QFilter filter = new QFilter(conditionField, "in", sortDimensionIds);
            DeleteServiceHelper.delete((String)"cal_sortresult", (QFilter[])filter.toArray());
            sortDimensionIds.clear();
        }
    }

    private String getCostDmFieldsStr() {
        int index;
        StringBuilder costDmFieldsStr = new StringBuilder();
        for (index = 0; index < CONSTANT_DMS.length; ++index) {
            costDmFieldsStr.append(CONSTANT_DMS[index]).append(",");
        }
        for (index = 0; index < this.divideBasis.length; ++index) {
            costDmFieldsStr.append(this.divideBasis[index]).append(",");
        }
        for (index = 0; index < this.calDimension.length; ++index) {
            costDmFieldsStr.append(this.calDimension[index]).append(",");
        }
        if (costDmFieldsStr.toString().endsWith(",")) {
            return costDmFieldsStr.substring(0, costDmFieldsStr.length() - 1);
        }
        return costDmFieldsStr.toString();
    }

    private String[] getCostDmFields() {
        return this.getCostDmFieldsStr().split(",");
    }

    private void pushSortRequest(Set<Long> costDomainGroupIds) {
        logger.info("AutoSortServic-\u5f00\u59cbpush\u961f\u5217");
        MessagePublisher pub = MQFactory.get().createSimplePublisher(FI_REGION, SORT_QUEUE);
        try (TXHandle txHandle = TX.required();){
            pub.publishInDbTranscation("cal", costDomainGroupIds);
        }
        catch (Exception e) {
            logger.info("AutoSortServic-push\u961f\u5217\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getClass().getName());
            logger.error("AutoSortServic pushSortRequest", (Throwable)e);
            throw e;
        }
        finally {
            logger.info("AutoSortServic-\u7ed3\u675fpush\u961f\u5217");
            pub.close();
        }
    }

    private int getBatchSize() {
        DBRoute dbRoute = new DBRoute("scm");
        int defaultSize = 5000;
        String strSql = "SELECT FVALUE FROM T_IM_INVDBPARAM WHERE FID = 987514040806803560 AND FKEY = 'sortMatSize'";
        DataSet batSizeData = DB.queryDataSet((String)"kd.fi.calx.mservice.DiffAllocServiceImpl.getBatchSize", (DBRoute)dbRoute, (String)strSql);
        Iterator it = batSizeData.iterator();
        if (batSizeData != null && it.hasNext()) {
            defaultSize = Integer.parseInt(((Row)it.next()).get("FVALUE").toString());
        }
        return defaultSize;
    }

    public void setAcctIds(Set<Long> acctIds) {
        Map associationCostAccountNameMap = AccountingSysHelper.getAssociationCostAccountNameMap(acctIds);
        acctIds = associationCostAccountNameMap.keySet();
        this.acctIds = acctIds;
        QFilter acctIdsF = new QFilter("id", "in", acctIds);
        DataSet acctDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cal_bd_costaccount", (String)"calorg", (QFilter[])acctIdsF.toArray(), null);
        this.calOrgIds = new HashSet<Long>(16);
        for (Row row : acctDs) {
            this.calOrgIds.add(row.getLong("calorg"));
        }
    }

    private boolean isRebuildByAcctId() {
        return this.acctIds != null;
    }
}

